/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.creator;

import android.app.Activity;
import android.content.Context;
import android.os.Message;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.notify.notifyobj.ChannelCreateSuccessObj;
import com.yy.appbase.service.IOOSService;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.oos.IUploadObjectCallBack;
import com.yy.appbase.service.oos.UploadObjectRequest;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.appbase.unifyconfig.config.GroupChatClassificationData;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.ImeUtil;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.BasePanel;
import com.yy.framework.core.ui.StatusBarManager;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.camera.base.ICameraService;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.FamilyGateInfo;
import com.yy.hiyo.channel.base.bean.SameCityInfo;
import com.yy.hiyo.channel.base.bean.create.CreateChannelParams;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.module.creator.ChannelCreateManager;
import com.yy.hiyo.channel.module.creator.IChannelCreateCallback;
import com.yy.hiyo.channel.module.creator.page.ChannelCreatePage;
import com.yy.hiyo.channel.module.creator.widget.LevelPickerPanel;
import com.yy.hiyo.channel.module.creator.window.ChannelCreateWindow;
import com.yy.hiyo.channel.service.family.FamilyService;
import com.yy.hiyo.mvp.base.MvpController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ChannelCreatorController
extends MvpController
implements IChannelCreateCallback {
    private static final String TAG = "ChannelCreatorController";
    private ChannelCreateManager mChannelCreateManager = new ChannelCreateManager(this.getServiceManager());
    private IChannelCenterService mChannelCenterService = (IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class);
    private ChannelCreateWindow mWindow;
    private String parentCid;
    private int from;
    private long cardId = -1L;
    private boolean isSameCity;
    private SameCityInfo mSameCityInfo;
    private FamilyGateInfo mFamilyGateInfo = new FamilyGateInfo(1L, 3L);
    protected DialogLinkManager mDialogLinkManager;
    private int createFrom;
    private boolean isFamily;
    private boolean enterChannelWhenCreated;
    private int type;
    private String gameId = "";
    private String source = "";

    public ChannelCreatorController(Environment env) {
        super(env);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == AppbaseMsgDef.ChannelMsgDef.OPEN_CHANNEL_CREATE) {
            this.isSameCity = false;
            if (msg.obj instanceof CreateChannelParams) {
                CreateChannelParams params = (CreateChannelParams)msg.obj;
                this.from = params.from;
                this.cardId = params.cardId;
                this.isSameCity = params.isSameCity;
                this.mSameCityInfo = params.sameCityInfo;
                this.createFrom = params.createFrom;
                this.enterChannelWhenCreated = params.enterChannelWhenCreated;
                this.source = params.source;
                this.isFamily = "hago.family".equals(params.source);
                this.type = params.type;
                this.gameId = "";
                if (StringUtils.isNotEmpty((String)params.gameId)) {
                    this.gameId = params.gameId;
                }
                this.showCreateWindow(params.parentCid);
                if (this.createFrom != 0) {
                    RoomTrack.INSTANCE.reportNewChannelClick(String.valueOf(this.createFrom));
                }
            }
        } else if (msg.what == AppbaseMsgDef.ChannelMsgDef.CLOSE_CHANNEL_CREATE_WINDOW && this.mWindow != null) {
            this.mWindow.getPage().hideLoading();
            this.mWindowMgr.popWindow(false, (AbstractWindow)this.mWindow);
            this.mWindow = null;
        }
    }

    private void showCreateWindow(String parentCid) {
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.dismissDialog();
        }
        this.mDialogLinkManager = new DialogLinkManager((Context)this.mContext);
        if (this.mWindow != null) {
            this.mWindowMgr.popWindow(false, (AbstractWindow)this.mWindow);
        }
        this.parentCid = parentCid;
        this.mWindow = new ChannelCreateWindow(this.mContext, this);
        if (this.isSameCity) {
            this.mWindow.getPage().selectPublicType();
        } else if (this.type == 0) {
            if (NAB.A.equals((Object)NewABDefine.CHANNEL_TYPE.getTest())) {
                this.mWindow.getPage().selectPrivateType();
            } else {
                this.mWindow.getPage().selectPublicType();
            }
        } else if (this.type == 2) {
            this.mWindow.getPage().selectPrivateType();
        } else {
            this.mWindow.getPage().selectPublicType();
        }
        if (this.isFamily) {
            this.mWindow.getPage().showOnlyFamilyLayout();
            this.mWindow.getPage().setDurationLevel(this.mFamilyGateInfo.getDuration());
            this.mWindow.getPage().setWealthLevel(this.mFamilyGateInfo.getWeath());
        } else if (NetworkUtils.isNetworkAvailable((Context)this.getContext()) && this.from != 19) {
            this.mChannelCenterService.canCreteFamilyGroup((ICommonCallback)new ICommonCallback<Boolean>(){

                public void onSuccess(Boolean showFamily, Object ... ext) {
                    ChannelCreatorController.this.configClassification(showFamily);
                }

                public void onFail(int errCode, String msg, Object ... ext) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)ChannelCreatorController.TAG, (String)"canBeCreateFamilyGroup return false", (Object[])new Object[0]);
                    }
                    ChannelCreatorController.this.configClassification(false);
                }
            });
        } else {
            this.configClassification(false);
        }
        RoomTrack.INSTANCE.reportNewChannelPageShow();
        this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
        YYTaskExecutor.postToMainThread(() -> {
            if (this.mWindow != null) {
                this.mWindow.getPage().forceInputViewGetFocus();
            }
        }, (long)300L);
    }

    private void configClassification(final boolean showFamilyType) {
        this.mChannelCenterService.getAllGroupCategory((ICommonCallback)new ICommonCallback<List<GroupChatClassificationData>>(){

            public void onSuccess(List<GroupChatClassificationData> groupChatClassificationData, Object ... ext) {
                if (ChannelCreatorController.this.mWindow == null) {
                    return;
                }
                if (groupChatClassificationData == null) {
                    ChannelCreatorController.this.mWindow.getPage().initGroupClassification((List<GroupChatClassificationData>)null, null);
                    return;
                }
                if (ChannelCreatorController.this.from == 19) {
                    if (StringUtils.isEmpty((String)ChannelCreatorController.this.gameId)) {
                        MLog.error((Object)ChannelCreatorController.TAG, (String)"gameId empty error!!!", (Object[])new Object[0]);
                        return;
                    }
                    for (GroupChatClassificationData first : groupChatClassificationData) {
                        if (first.getId() == 3) {
                            List subClassification = first.getSubClassification();
                            if (subClassification == null || subClassification.isEmpty()) {
                                MLog.error((Object)ChannelCreatorController.TAG, (String)"subClassification null or empty!!!", (Object[])new Object[0]);
                                return;
                            }
                            for (GroupChatClassificationData second : subClassification) {
                                if (second == null || FP.empty((Collection)second.getGameIds()) || !second.getGameIds().contains(ChannelCreatorController.this.gameId)) continue;
                                ChannelCreatorController.this.mWindow.getPage().initGroupClassification(first, second);
                                return;
                            }
                        }
                        MLog.error((Object)ChannelCreatorController.TAG, (String)"no match game, please check boss config!!! gid:%s, ", (Object[])new Object[]{ChannelCreatorController.this.gameId});
                    }
                } else {
                    if (showFamilyType) {
                        Comparator groupSortComparator = (o1, o2) -> o1.isFamily() == o2.isFamily() ? 0 : (o1.isFamily() ? 1 : -1);
                        Collections.sort(groupChatClassificationData, groupSortComparator);
                    } else {
                        Iterator<GroupChatClassificationData> classificationDataIterator = groupChatClassificationData.iterator();
                        while (classificationDataIterator.hasNext()) {
                            GroupChatClassificationData classificationData = classificationDataIterator.next();
                            if (!classificationData.isFamily()) continue;
                            classificationDataIterator.remove();
                        }
                    }
                    int oldId = SettingFlags.getIntValue((String)"key_channel_create_classification", (int)0);
                    GroupChatClassificationData oldClassification = null;
                    for (GroupChatClassificationData classification : groupChatClassificationData) {
                        if (classification.getId() != oldId) continue;
                        oldClassification = classification;
                        break;
                    }
                    ChannelCreatorController.this.mWindow.getPage().initGroupClassification(groupChatClassificationData, oldClassification);
                }
            }

            public void onFail(int errCode, String msg, Object ... ext) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)ChannelCreatorController.TAG, (String)("request configClassification failed " + errCode + " " + msg), (Object[])new Object[0]);
                }
            }
        });
    }

    @Override
    public void onBack() {
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.dismissDialog();
        }
        if (this.mWindow != null) {
            this.mWindow.getPage().hideLoading();
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mWindow);
            this.mWindow = null;
        }
    }

    @Override
    public void createChannel(int channelType, @NonNull String channelName, @Nullable GroupChatClassificationData tab, @Nullable GroupChatClassificationData secondTab, String avatar2) {
        if (channelName.isEmpty()) {
            ToastUtils.showToast((Context)this.mContext, (int)R.string.toast_nick_all_white);
        } else {
            if (this.mWindow != null) {
                this.mWindow.getPage().showLoading();
            }
            final CreateChannelParams params = CreateChannelParams.obtain((String)this.parentCid, (int)channelType, (String)channelName, (String)"", (int)this.from, (long)this.cardId, (boolean)this.isSameCity, (SameCityInfo)this.mSameCityInfo, (String)avatar2);
            if (tab != null) {
                params.firstType = tab.getId();
            }
            if (secondTab != null) {
                params.secondType = secondTab.getId();
            }
            if (this.isFamily || tab != null && tab.isFamily()) {
                params.source = "hago.family";
                params.joinPayLevel = this.mFamilyGateInfo.getWeath();
                params.joinActiveTime = this.mFamilyGateInfo.getDuration();
            }
            if (StringUtils.isNotEmpty((String)this.source)) {
                params.source = this.source;
            }
            if (StringUtils.isNotEmpty((String)this.gameId)) {
                params.gameId = this.gameId;
            }
            params.createType = 1;
            params.channelPluginData = new ChannelPluginData(1, "base");
            params.createFrom = this.createFrom;
            params.enterChannelWhenCreated = this.enterChannelWhenCreated;
            this.mChannelCreateManager.createChannel((Context)this.mContext, params, new ICommonCallback<Boolean>(){

                public void onSuccess(Boolean aBoolean, Object ... ext) {
                    String channelId = "";
                    if (ext != null && ext.length > 0 && ext[0] instanceof String) {
                        RoomTrack.INSTANCE.reportNewChannelSuccess((String)ext[0], "", String.valueOf(AccountUtil.getUid()), String.valueOf(ChannelCreatorController.this.createFrom), String.valueOf(params.firstType));
                        channelId = (String)ext[0];
                    }
                    if (ChannelCreatorController.this.isSameCity) {
                        Message message = Message.obtain();
                        message.what = AppbaseMsgDef.ChannelMsgDef.CLOSE_SAME_CITY_CHANNEL_CREATE;
                        ChannelCreatorController.this.sendMessage(message);
                    }
                    if (ChannelCreatorController.this.mWindow != null) {
                        ChannelCreatorController.this.mWindow.getPage().hideLoading();
                    }
                    if (ChannelCreatorController.this.mWindow != null) {
                        ChannelCreatorController.this.mWindow.getPage().hideLoading();
                        ChannelCreatorController.this.mWindowMgr.popWindow(true, (AbstractWindow)ChannelCreatorController.this.mWindow);
                        ChannelCreatorController.this.mWindow = null;
                    }
                    NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_CREATE_SUCCESS, (Object)new ChannelCreateSuccessObj(channelId, ChannelCreatorController.this.createFrom)));
                }

                public void onFail(int errCode, String msg, Object ... ext) {
                    if (ChannelCreatorController.this.mWindow != null) {
                        ChannelCreatorController.this.mWindow.getPage().hideLoading();
                    }
                }
            });
        }
    }

    private String getDefaultChannelName() {
        String nickName = ((IUserInfoService)ServiceManagerProxy.getInstance().getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid(), null).getNick();
        String defaultName = ResourceUtils.getString((int)R.string.modify_default_channel_name, (Object[])new Object[]{nickName});
        return defaultName;
    }

    @Override
    public void onCameraClick() {
        RoomTrack.INSTANCE.reportNewChannelPicClick();
        ((ICameraService)ServiceManagerProxy.getService(ICameraService.class)).pickPhotoWithClip("FTChannel", path -> {
            if (FP.empty((CharSequence)path)) {
                ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.upload_failed), (int)0);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"upload failed", (Object[])new Object[0]);
                }
                if (this.mDialogLinkManager != null) {
                    this.mDialogLinkManager.dismissDialog();
                }
                return;
            }
            String ext = YYFileUtils.getFileExtension((String)path);
            if (FP.empty((CharSequence)ext)) {
                ext = ".jpg";
            }
            ProgressDialog progressDialog2 = new ProgressDialog();
            if (this.mDialogLinkManager != null) {
                this.mDialogLinkManager.showDialog((BaseDialog)progressDialog2);
            }
            String keyMapBuilder = "cavatar/" + AccountUtil.getUid() + "_" + System.currentTimeMillis() / 1000L + ext;
            ((IOOSService)ServiceManagerProxy.getService(IOOSService.class)).uploadFile(keyMapBuilder, path, new IUploadObjectCallBack(){

                public void onSuccess(UploadObjectRequest request) {
                    String imgUrl = request.mUrl;
                    YYTaskExecutor.postToMainThread(() -> {
                        if (ChannelCreatorController.this.mDialogLinkManager != null) {
                            ChannelCreatorController.this.mDialogLinkManager.dismissDialog();
                        }
                        if (ChannelCreatorController.this.mWindow != null) {
                            ChannelCreatorController.this.mWindow.getPage().updateHeader(imgUrl);
                        }
                    });
                }

                public void onFailure(UploadObjectRequest request, int errorCode, Exception exception) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)ChannelCreatorController.TAG, (String)"createChannel failed, code:%s", (Object[])new Object[]{errorCode});
                    }
                    YYTaskExecutor.postToMainThread(() -> {
                        if (ChannelCreatorController.this.mDialogLinkManager != null) {
                            ChannelCreatorController.this.mDialogLinkManager.dismissDialog();
                        }
                        ToastUtils.showToast((Context)ChannelCreatorController.this.mContext, (int)R.string.upload_failed);
                    });
                }
            });
        }, 8);
    }

    public boolean onWindowBackKeyEvent() {
        if (this.mWindow != null) {
            this.mWindow.getPage().hideLoading();
        }
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.dismissDialog();
        }
        return super.onWindowBackKeyEvent();
    }

    public void onWindowShown(AbstractWindow abstractWindow) {
        StatusBarManager.INSTANCE.setStatusBarColor((Activity)this.mContext, ColorUtils.parseColor((String)"#f2f2f2"));
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.dismissDialog();
        }
        this.getMvpContext().getLifecycleOwner().onEvent(Lifecycle.Event.ON_DESTROY);
    }

    @Override
    public void onClassificationClick(GroupChatClassificationData classificationData) {
        if (this.mWindow == null) {
            return;
        }
        ChannelCreatePage page = this.mWindow.getPage();
        if (classificationData.isFamily()) {
            page.setFamilyViewVisible(true);
            page.setDurationLevel(this.mFamilyGateInfo.getDuration());
            page.setWealthLevel(this.mFamilyGateInfo.getWeath());
        } else {
            page.setFamilyViewVisible(false);
        }
    }

    @Override
    public void onDurationLevelClick() {
        LevelPickerPanel gateListPanel = new LevelPickerPanel((Context)this.getContext());
        gateListPanel.showBalckMask(true);
        ArrayList<Long> list2 = FamilyService.Companion.getGateDurationList();
        gateListPanel.setMCallback(selectedIndex -> {
            this.mFamilyGateInfo.setDuration(((Long)list2.get(selectedIndex)).longValue());
            if (this.mWindow != null) {
                this.mWindow.getPage().setDurationLevel(this.mFamilyGateInfo.getDuration());
            }
        });
        gateListPanel.setTitle(ResourceUtils.getString((int)R.string.tips_duration_level));
        gateListPanel.setData(list2);
        gateListPanel.setSelection(this.mFamilyGateInfo.getDuration());
        if (this.mWindow != null) {
            ImeUtil.hideIME((Context)this.getContext(), (View)this.mWindow);
            this.mWindow.getPanelLayer().showPanel((BasePanel)gateListPanel, false);
        }
    }

    @Override
    public void onWealthLevelClick() {
        LevelPickerPanel gateListPanel = new LevelPickerPanel((Context)this.getContext());
        gateListPanel.showBalckMask(true);
        ArrayList<Long> list2 = FamilyService.Companion.getGateLvList();
        gateListPanel.setMCallback(selectedIndex -> {
            this.mFamilyGateInfo.setWeath(((Long)list2.get(selectedIndex)).longValue());
            if (this.mWindow != null) {
                this.mWindow.getPage().setWealthLevel(this.mFamilyGateInfo.getWeath());
            }
        });
        gateListPanel.setTitle(ResourceUtils.getString((int)R.string.tips_vip_msg));
        gateListPanel.setData(list2);
        gateListPanel.setSelection(this.mFamilyGateInfo.getWeath());
        gateListPanel.setStringId(R.string.level);
        if (this.mWindow != null) {
            ImeUtil.hideIME((Context)this.getContext(), (View)this.mWindow);
            this.mWindow.getPanelLayer().showPanel((BasePanel)gateListPanel, false);
        }
    }
}

