/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.growth;

import android.os.Bundle;
import android.os.Message;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.abtest.ABConfig;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.account.AccountRelatedSetting;
import com.yy.appbase.growth.AbsExperiment;
import com.yy.appbase.growth.AbsExperimentCreator;
import com.yy.appbase.growth.GrowthMsgDef;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.GrowthBusinessConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Notification;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.annotations.GrowthExperimentCreator;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.IRoomService;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.service.growth.ExitRecommendData;
import com.yy.hiyo.channel.service.growth.ExitRecommendDialog;
import com.yy.hiyo.channel.service.growth.ExitRecommendItemData;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.ihago.act.api.lowactive.GetGoodRoomsReq;
import net.ihago.act.api.lowactive.GetGoodRoomsRsp;
import net.ihago.act.api.lowactive.OrderType;
import net.ihago.room.api.rrec.RoomTabItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001:\u00014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0004H\u0002J\u0017\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u000fH\u0002J\u0012\u0010\u001d\u001a\u00020\u00122\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&H\u0016J\u001a\u0010'\u001a\u00020\u00122\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010(\u001a\u00020\u0004H\u0002J\u001c\u0010)\u001a\u00020\u00122\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\b\u0010*\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010+\u001a\u00020\u00122\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0002J\u001c\u0010,\u001a\u00020\u00122\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\b\u0010-\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010.\u001a\u00020\u0012H\u0002J\b\u0010/\u001a\u00020\u0012H\u0002J!\u00100\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0002\u00101J\u0012\u00102\u001a\u00020\u00122\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u00103\u001a\u00020\u00122\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/yy/hiyo/channel/growth/RoomExitRecomdExperiment;", "Lcom/yy/appbase/growth/AbsExperiment;", "()V", "mChannelId", "", "mConfigStayDuration", "", "mExitRecommendConfig", "Lcom/yy/appbase/unifyconfig/config/GrowthBusinessConfig$RoomExitRecommend;", "mLoadRecommendTask", "Ljava/lang/Runnable;", "mRecomdChannelRecord", "mRecomdData", "Lcom/yy/hiyo/channel/service/growth/ExitRecommendData;", "channelShouldRecommend", "", "channelId", "doLoadRecommendRooms", "", "getRecomdConfig", "getRecomdedChannelRecord", "getStayDuration", "", "enterStartTime", "(Ljava/lang/Long;)J", "handleInterceptMinimize", "msg", "Landroid/os/Message;", "hasRecomdedAllTimes", "onEnterChannel", "onLoadResponse", "res", "Lnet/ihago/act/api/lowactive/GetGoodRoomsRsp;", "onMessage", "onMessageSync", "", "onNotify", "notification", "Lcom/yy/framework/core/Notification;", "reportDialogEvent", "functionId", "reportEnterEvent", "otherId", "resetRecomdData", "showRecomdDialog", "callback", "startLoadRecommendTask", "stopLoadRecommendTask", "toShowRecommendDialog", "(Ljava/lang/String;Ljava/lang/Long;)Z", "tryLoadRecomdData", "updateRecomdedChannelRecord", "RoomExitRecomdExperimentCreator", "channel-components_release"})
public final class RoomExitRecomdExperiment
extends AbsExperiment {
    private String mRecomdChannelRecord;
    private GrowthBusinessConfig.RoomExitRecommend mExitRecommendConfig;
    private String mChannelId;
    private int mConfigStayDuration = 60;
    private Runnable mLoadRecommendTask;
    private ExitRecommendData mRecomdData;

    public void onNotify(@NotNull Notification notification) {
        Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
    }

    private final void onEnterChannel(String channelId) {
        MLog.debug((Object)"RoomExitRecomdExperiment", (String)("enterChannel channelId:" + channelId), (Object[])new Object[0]);
        this.resetRecomdData(null);
        this.tryLoadRecomdData(channelId);
    }

    private final void tryLoadRecomdData(String channelId) {
        if (!this.channelShouldRecommend(channelId)) {
            MLog.debug((Object)"RoomExitRecomdExperiment", (String)("tryLoadExperiment() but cur channel not has recommed channelId: " + channelId), (Object[])new Object[0]);
            return;
        }
        if (this.hasRecomdedAllTimes()) {
            MLog.debug((Object)"RoomExitRecomdExperiment", (String)("tryLoadExperiment() but hasRecomdedAllTimes channelId: " + channelId), (Object[])new Object[0]);
            return;
        }
        this.mChannelId = channelId;
        GrowthBusinessConfig.RoomExitRecommend roomExitRecommend = this.mExitRecommendConfig;
        this.mConfigStayDuration = roomExitRecommend != null ? roomExitRecommend.getStayDuration() : 60;
        MLog.debug((Object)"RoomExitRecomdExperiment", (String)("tryLoadExperiment() mChannelId: " + this.mChannelId + " mConfigStayDuration:" + this.mConfigStayDuration), (Object[])new Object[0]);
        this.stopLoadRecommendTask();
        this.startLoadRecommendTask();
    }

    private final void startLoadRecommendTask() {
        block1: {
            MLog.debug((Object)"RoomExitRecomdExperiment", (String)"startLoadRecommendTask()", (Object[])new Object[0]);
            if (this.mLoadRecommendTask != null) break block1;
            Runnable runnable2 = this.mLoadRecommendTask = (Runnable)new Runnable(this){
                final /* synthetic */ RoomExitRecomdExperiment this$0;

                public final void run() {
                    if (RoomExitRecomdExperiment.access$getMLoadRecommendTask$p(this.this$0) != null) {
                        RoomExitRecomdExperiment.access$doLoadRecommendRooms(this.this$0);
                    }
                }
                {
                    this.this$0 = roomExitRecomdExperiment;
                }
            };
            if (runnable2 != null) {
                Runnable runnable3 = runnable2;
                boolean bl = false;
                boolean bl2 = false;
                Runnable it = runnable3;
                boolean bl3 = false;
                YYTaskExecutor.postToMainThread((Runnable)it, (long)3000L);
            }
        }
    }

    private final void doLoadRecommendRooms() {
        GetGoodRoomsReq req = new GetGoodRoomsReq.Builder().limit(Long.valueOf(3L)).orderType(OrderType.TRandFromTwo2Ten).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetGoodRoomsRsp>(this){
            final /* synthetic */ RoomExitRecomdExperiment this$0;

            public void onResponse(@NotNull GetGoodRoomsRsp res, long code, @Nullable String msgTip) {
                Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
                super.onResponse((AndroidMessage)res, code, msgTip);
                if (ProtoManager.isSuccessCode((long)code)) {
                    RoomExitRecomdExperiment.access$onLoadResponse(this.this$0, res);
                    MLog.debug((Object)"RoomExitRecomdExperiment", (String)("fetchRecommendGoodRooms onSuccess: " + code + ", res: " + res), (Object[])new Object[0]);
                } else {
                    MLog.debug((Object)"RoomExitRecomdExperiment", (String)("fetchRecommendGoodRooms onError: " + code + ", reason: " + msgTip), (Object[])new Object[0]);
                }
            }

            public void onError(@Nullable String reason, int code) {
                super.onError(reason, code);
                MLog.debug((Object)"RoomExitRecomdExperiment", (String)("fetchRecommendGoodRooms onError: " + code + ", reason: " + reason), (Object[])new Object[0]);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void onLoadResponse(GetGoodRoomsRsp res) {
        if (res.rooms_info == null || res.rooms_info.isEmpty()) {
            MLog.debug((Object)"RoomExitRecomdExperiment", (String)"onRecommendResponse but rooms_info is empty", (Object[])new Object[0]);
            return;
        }
        boolean bl = false;
        List dataList = new ArrayList();
        for (RoomTabItem roomItem : res.rooms_info) {
            String string2 = roomItem.url;
            String string3 = roomItem.id;
            Long l = roomItem.sex;
            Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"roomItem.sex");
            dataList.add(new ExitRecommendItemData(string2, string3, l));
        }
        this.mRecomdData = new ExitRecommendData(this.mChannelId, dataList);
    }

    private final void stopLoadRecommendTask() {
        if (this.mLoadRecommendTask != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mLoadRecommendTask);
            this.mLoadRecommendTask = null;
        }
    }

    private final void getRecomdConfig() {
        if (this.mExitRecommendConfig == null) {
            GrowthBusinessConfig growthBusinessConfig;
            AConfigData aConfigData = UnifyConfig.INSTANCE.getConfigData(BssCode.GROWTH_BUSINESS);
            if (!(aConfigData instanceof GrowthBusinessConfig)) {
                aConfigData = null;
            }
            if ((growthBusinessConfig = (GrowthBusinessConfig)aConfigData) != null) {
                GrowthBusinessConfig.GrowthBusinessData growthBusinessData = growthBusinessConfig.getData();
                this.mExitRecommendConfig = growthBusinessData != null ? growthBusinessData.getRoomExitRecommend() : null;
            }
            MLog.debug((Object)"RoomExitRecomdExperiment", (String)"getRecomdConfig -> mConfig is %s", (Object[])new Object[]{this.mExitRecommendConfig});
        }
    }

    private final boolean hasRecomdedAllTimes() {
        this.getRecomdConfig();
        GrowthBusinessConfig.RoomExitRecommend roomExitRecommend = this.mExitRecommendConfig;
        int configTotalTimes = roomExitRecommend != null ? roomExitRecommend.getTotalTimes() : 3;
        MLog.debug((Object)"RoomExitRecomdExperiment", (String)("hasRecommendedConfigTimes config recommend Total Times: " + configTotalTimes), (Object[])new Object[0]);
        String recomded = this.getRecomdedChannelRecord();
        if (configTotalTimes > 0) {
            if (StringUtils.isEmpty((String)recomded)) {
                return false;
            }
            MLog.debug((Object)"RoomExitRecomdExperiment", (String)("hasFinishConfigTimes has record recomdedRecord: " + recomded), (Object[])new Object[0]);
            String string2 = recomded;
            List channels = string2 != null ? StringsKt.split$default((CharSequence)string2, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null) : null;
            return channels != null && channels.size() >= configTotalTimes;
        }
        return true;
    }

    private final boolean channelShouldRecommend(String channelId) {
        if (channelId == null) {
            return false;
        }
        if (this.mRecomdChannelRecord == null) {
            this.getRecomdedChannelRecord();
        }
        if (this.mRecomdChannelRecord == null) {
            return true;
        }
        String string2 = this.mRecomdChannelRecord;
        List channels = string2 != null ? StringsKt.split$default((CharSequence)string2, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null) : null;
        boolean shouldRecommend = channels == null || !channels.contains(channelId);
        MLog.debug((Object)"RoomExitRecomdExperiment", (String)("channelShouldRecommend channelId:" + channelId + " shouldRecommend:" + shouldRecommend), (Object[])new Object[0]);
        return shouldRecommend;
    }

    private final String getRecomdedChannelRecord() {
        if (this.mRecomdChannelRecord == null) {
            this.mRecomdChannelRecord = AccountRelatedSetting.getInstance().getString("key_exit_recommend_channel_records", null);
        }
        MLog.debug((Object)"RoomExitRecomdExperiment", (String)("getRecomdedChannelRecord mRecomdChannelRecord: " + this.mRecomdChannelRecord), (Object[])new Object[0]);
        return this.mRecomdChannelRecord;
    }

    private final void updateRecomdedChannelRecord(String channelId) {
        this.getRecomdedChannelRecord();
        this.mRecomdChannelRecord = this.mRecomdChannelRecord == null ? channelId : this.mRecomdChannelRecord + "," + channelId;
        YYTaskExecutor.execute((Runnable)new Runnable(this){
            final /* synthetic */ RoomExitRecomdExperiment this$0;

            public final void run() {
                AccountRelatedSetting.getInstance().putString("key_exit_recommend_channel_records", RoomExitRecomdExperiment.access$getMRecomdChannelRecord$p(this.this$0));
            }
            {
                this.this$0 = roomExitRecomdExperiment;
            }
        });
    }

    private final long getStayDuration(Long enterStartTime) {
        if (enterStartTime == null) {
            return System.currentTimeMillis();
        }
        return System.currentTimeMillis() - enterStartTime;
    }

    private final void showRecomdDialog(String channelId, Runnable callback2) {
        DialogLinkManager dialogLinkManager = this.getDialogLinkManager();
        if (dialogLinkManager != null) {
            dialogLinkManager.showDialog((BaseDialog)new ExitRecommendDialog(this.getContext(), this.mRecomdData, new ExitRecommendDialog.OnDialogListener(this, callback2, channelId){
                final /* synthetic */ RoomExitRecomdExperiment this$0;
                final /* synthetic */ Runnable $callback;
                final /* synthetic */ String $channelId;

                public void onCloseRecommend() {
                    Runnable runnable2 = this.$callback;
                    if (runnable2 != null) {
                        runnable2.run();
                    }
                    RoomExitRecomdExperiment.access$reportDialogEvent(this.this$0, this.$channelId, "newuser_back_rcm_no_click");
                    RoomExitRecomdExperiment.access$resetRecomdData(this.this$0, RoomExitRecomdExperiment.access$getMChannelId$p(this.this$0));
                }

                public void onEnterRoom(@NotNull String toChannelId) {
                    IRoomService roomService;
                    Intrinsics.checkParameterIsNotNull((Object)toChannelId, (String)"toChannelId");
                    MLog.debug((Object)"RoomExitRecomdExperiment", (String)("showRecomdDialog() -> onEnterRoom->toChannelId " + toChannelId), (Object[])new Object[0]);
                    IRoomService iRoomService = roomService = (IRoomService)ServiceManagerProxy.getService(IRoomService.class);
                    if (iRoomService != null) {
                        iRoomService.enterRoom(144, toChannelId);
                    }
                    RoomExitRecomdExperiment.access$resetRecomdData(this.this$0, RoomExitRecomdExperiment.access$getMChannelId$p(this.this$0));
                    RoomExitRecomdExperiment.access$reportEnterEvent(this.this$0, RoomExitRecomdExperiment.access$getMChannelId$p(this.this$0), toChannelId);
                }
                {
                    this.this$0 = $outer;
                    this.$callback = $captured_local_variable$1;
                    this.$channelId = $captured_local_variable$2;
                }
            }));
        }
        this.updateRecomdedChannelRecord(channelId);
        this.reportDialogEvent(channelId, "newuser_back_rcm_show");
    }

    private final void resetRecomdData(String channelId) {
        this.mRecomdData = null;
        this.stopLoadRecommendTask();
        MLog.debug((Object)"RoomExitRecomdExperiment", (String)("resetRecomdData() channelId " + channelId), (Object[])new Object[0]);
    }

    private final boolean toShowRecommendDialog(String channelId, Long enterStartTime) {
        block3: {
            block2: {
                long currentStayDuration = this.getStayDuration(enterStartTime) / (long)1000;
                MLog.debug((Object)"RoomExitRecomdExperiment", (String)("toShowRecommendDialog currentStayDuration " + currentStayDuration + ' ' + "mConfigStayDuration " + this.mConfigStayDuration), (Object[])new Object[0]);
                if (currentStayDuration > (long)this.mConfigStayDuration || this.hasRecomdedAllTimes() || !this.channelShouldRecommend(channelId) || this.mRecomdData == null) break block2;
                ExitRecommendData exitRecommendData = this.mRecomdData;
                if ((exitRecommendData != null ? exitRecommendData.getDataList() : null) != null) break block3;
            }
            return false;
        }
        Object object = this.mRecomdData;
        int dataSize = object != null && (object = ((ExitRecommendData)object).getDataList()) != null ? object.size() : 0;
        MLog.debug((Object)"RoomExitRecomdExperiment", (String)("shouldStartExitRecommend->server recommend dataSize " + dataSize), (Object[])new Object[0]);
        return dataSize > 0;
    }

    public void onMessage(@NotNull Message msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        if (msg.what == GrowthMsgDef.ROOM_EXIT_RECOMD_JOIN_CHANNEL) {
            MLog.debug((Object)"RoomExitRecomdExperiment", (String)"onMessage ROOM_EXIT_RECOMD_JOIN_CHANNEL", (Object[])new Object[0]);
            Object channelId = msg.obj;
            if (channelId instanceof String) {
                this.onEnterChannel((String)channelId);
            }
        }
    }

    @Nullable
    public Object onMessageSync(@NotNull Message msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        if (msg.what == GrowthMsgDef.ROOM_EXIT_RECOMD_INTERCEPT_MINIMIZE) {
            boolean handleInterceptMinimize = this.handleInterceptMinimize(msg);
            MLog.debug((Object)"RoomExitRecomdExperiment", (String)("onMessageSync handleInterceptMinimize:" + handleInterceptMinimize), (Object[])new Object[0]);
            return handleInterceptMinimize;
        }
        return null;
    }

    private final boolean handleInterceptMinimize(Message msg) {
        ChannelDetailInfo channelDetailInfo;
        Object object = msg.obj;
        if (!(object instanceof Runnable)) {
            object = null;
        }
        Runnable callback2 = (Runnable)object;
        Bundle data = msg.getData();
        if (callback2 == null || data == null) {
            MLog.debug((Object)"RoomExitRecomdExperiment", (String)"callback or data is null", (Object[])new Object[0]);
            this.resetRecomdData(null);
            return false;
        }
        long enterStartTime = data.getLong("enterStartTime");
        String channelId = data.getString("channelId");
        if (channelId == null) {
            MLog.debug((Object)"RoomExitRecomdExperiment", (String)"enterStartTime or channelId is null", (Object[])new Object[0]);
            this.resetRecomdData(null);
            return false;
        }
        if (!this.toShowRecommendDialog(channelId, enterStartTime)) {
            this.resetRecomdData(null);
            return false;
        }
        IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
        IChannel channel = iServiceManager != null && (iServiceManager = (IChannelCenterService)iServiceManager.getService(IChannelCenterService.class)) != null ? iServiceManager.getChannel(channelId) : null;
        IChannel iChannel = channel;
        ChannelDetailInfo channelDetailInfo2 = iChannel != null && (iChannel = iChannel.getDataService()) != null ? iChannel.getCacheDetail() : (channelDetailInfo = null);
        if (channelDetailInfo != null && Intrinsics.areEqual((Object)"hago.amongus", (Object)channelDetailInfo.baseInfo.source)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"RoomExitRecomdExperiment", (String)"handleInterceptMinimize ExitRecommend cancel among us", (Object[])new Object[0]);
            }
            return true;
        }
        this.showRecomdDialog(channelId, callback2);
        return true;
    }

    private final void reportEnterEvent(String channelId, String otherId) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "newuser_back_rcm_yes_click").put("room_id", channelId).put("other_uid", otherId));
    }

    private final void reportDialogEvent(String channelId, String functionId) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", functionId).put("room_id", channelId));
    }

    public static final /* synthetic */ Runnable access$getMLoadRecommendTask$p(RoomExitRecomdExperiment $this) {
        return $this.mLoadRecommendTask;
    }

    public static final /* synthetic */ void access$setMLoadRecommendTask$p(RoomExitRecomdExperiment $this, Runnable runnable2) {
        $this.mLoadRecommendTask = runnable2;
    }

    public static final /* synthetic */ void access$doLoadRecommendRooms(RoomExitRecomdExperiment $this) {
        $this.doLoadRecommendRooms();
    }

    public static final /* synthetic */ void access$onLoadResponse(RoomExitRecomdExperiment $this, GetGoodRoomsRsp res) {
        $this.onLoadResponse(res);
    }

    public static final /* synthetic */ String access$getMRecomdChannelRecord$p(RoomExitRecomdExperiment $this) {
        return $this.mRecomdChannelRecord;
    }

    public static final /* synthetic */ void access$setMRecomdChannelRecord$p(RoomExitRecomdExperiment $this, String string2) {
        $this.mRecomdChannelRecord = string2;
    }

    public static final /* synthetic */ void access$reportDialogEvent(RoomExitRecomdExperiment $this, String channelId, String functionId) {
        $this.reportDialogEvent(channelId, functionId);
    }

    public static final /* synthetic */ void access$resetRecomdData(RoomExitRecomdExperiment $this, String channelId) {
        $this.resetRecomdData(channelId);
    }

    public static final /* synthetic */ String access$getMChannelId$p(RoomExitRecomdExperiment $this) {
        return $this.mChannelId;
    }

    public static final /* synthetic */ void access$setMChannelId$p(RoomExitRecomdExperiment $this, String string2) {
        $this.mChannelId = string2;
    }

    public static final /* synthetic */ void access$reportEnterEvent(RoomExitRecomdExperiment $this, String channelId, String otherId) {
        $this.reportEnterEvent(channelId, otherId);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\b\u0010\u0007\u001a\u00020\u0006H\u0014J\u0010\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u0014J\u0010\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u0014J \u0010\f\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0018\u00010\rH\u0014\u00a8\u0006\u0011"}, d2={"Lcom/yy/hiyo/channel/growth/RoomExitRecomdExperiment$RoomExitRecomdExperimentCreator;", "Lcom/yy/appbase/growth/AbsExperimentCreator;", "()V", "createExperiment", "Lcom/yy/appbase/growth/AbsExperiment;", "isAppSupport", "", "precondition", "subscribeMessage", "", "", "subscribeNotification", "targetABGroup", "Lkotlin/Pair;", "Lcom/yy/appbase/abtest/ABConfig;", "", "", "channel-components_release"})
    @GrowthExperimentCreator(msgIds={"com.yy.appbase.growth.GrowthMsgDef.ROOM_EXIT_RECOMD_INTERCEPT_MINIMIZE", "com.yy.appbase.growth.GrowthMsgDef.ROOM_EXIT_RECOMD_JOIN_CHANNEL"}, notificationIds={})
    public static final class RoomExitRecomdExperimentCreator
    extends AbsExperimentCreator {
        @NotNull
        protected AbsExperiment createExperiment() {
            return new RoomExitRecomdExperiment();
        }

        protected boolean precondition() {
            return this.isNewUser();
        }

        @Nullable
        protected Pair<ABConfig<?>, String[]> targetABGroup() {
            return new Pair((Object)NewABDefine.HAGO_ROOM_EXIT_RECOMMEND, (Object)new String[]{"B"});
        }

        @Nullable
        protected List<Integer> subscribeNotification() {
            return null;
        }

        @Nullable
        protected List<Integer> subscribeMessage() {
            return CollectionsKt.listOf((Object[])new Integer[]{GrowthMsgDef.ROOM_EXIT_RECOMD_INTERCEPT_MINIMIZE, GrowthMsgDef.ROOM_EXIT_RECOMD_JOIN_CHANNEL});
        }

        protected boolean isAppSupport() {
            return RuntimeContext.sIsHagoApp;
        }
    }
}

