/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.growth;

import android.os.Message;
import com.yy.appbase.abtest.ABConfig;
import com.yy.appbase.growth.AbsExperiment;
import com.yy.appbase.growth.AbsExperimentCreator;
import com.yy.appbase.growth.GrowthMsgDef;
import com.yy.appbase.service.home.PageType;
import com.yy.base.logger.MLog;
import com.yy.framework.core.Notification;
import com.yy.hiyo.annotations.GrowthExperimentCreator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002J\b\u0010\n\u001a\u00020\bH\u0002J\b\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J0\u0010\u0014\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/yy/hiyo/channel/growth/PushTrackExperiment;", "Lcom/yy/appbase/growth/AbsExperiment;", "()V", "mHasEnterChannelList", "", "mPushTrackSource", "", "checkTrackLose", "", "inChannelList", "exit", "handleTrackRecycle", "onMessage", "msg", "Landroid/os/Message;", "onMessageSync", "", "onNotify", "notification", "Lcom/yy/framework/core/Notification;", "onWindowPageChanged", "lastWindow", "newWindow", "lastPage", "Lcom/yy/appbase/service/home/PageType;", "newPage", "Companion", "PushTrackExperimentCreator", "channel-components_release"})
public final class PushTrackExperiment
extends AbsExperiment {
    private boolean mHasEnterChannelList;
    private String mPushTrackSource;
    private static final String TAG = "PushTrackExperiment";
    public static final Companion Companion = new Companion(null);

    public void onNotify(@NotNull Notification notification) {
        Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
    }

    public void onMessage(@NotNull Message msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        if (msg.what == GrowthMsgDef.PUSH_CHANNEL_TRACK_ENTER) {
            Object pushId = msg.obj;
            if (pushId instanceof String) {
                MLog.debug((Object)TAG, (String)("enter pushId: " + pushId), (Object[])new Object[0]);
                if (StringsKt.startsWith$default((String)((String)pushId), (String)"718", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)((String)pushId), (String)"720", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)((String)pushId), (String)"740", (boolean)false, (int)2, null)) {
                    this.mPushTrackSource = String.valueOf(143);
                    this.registerWindowChange();
                    this.checkTrackLose(this.isHomeChannel());
                }
            } else {
                MLog.warn((Object)TAG, (String)"enter no pushId", (Object[])new Object[0]);
            }
        }
    }

    @Nullable
    public Object onMessageSync(@NotNull Message msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        if (msg.what == GrowthMsgDef.PUSH_CHANNEL_TRACK_GET) {
            String result = this.mPushTrackSource;
            MLog.debug((Object)TAG, (String)("PUSH_CHANNEL_TRACK_GET trackSource: " + result), (Object[])new Object[0]);
            this.handleTrackRecycle();
            return result;
        }
        return null;
    }

    protected void onWindowPageChanged(@Nullable String lastWindow, @Nullable String newWindow, @Nullable PageType lastPage, @Nullable PageType newPage) {
        super.onWindowPageChanged(lastWindow, newWindow, lastPage, newPage);
        this.checkTrackLose(this.isHomeChannel());
    }

    private final void exit() {
        MLog.debug((Object)TAG, (String)"exit", (Object[])new Object[0]);
        this.mHasEnterChannelList = false;
        this.recycle();
    }

    private final void checkTrackLose(boolean inChannelList) {
        MLog.debug((Object)TAG, (String)("checkTrackLose hasEnterChannelList: " + this.mHasEnterChannelList + ", currentInChannelList: " + inChannelList), (Object[])new Object[0]);
        if (!this.mHasEnterChannelList) {
            this.mHasEnterChannelList = inChannelList;
        } else if (!inChannelList) {
            this.handleTrackRecycle();
        }
    }

    private final void handleTrackRecycle() {
        MLog.debug((Object)TAG, (String)"handleTrackRecycle", (Object[])new Object[0]);
        this.mPushTrackSource = null;
        this.unregisterWindowChange();
        this.exit();
    }

    public PushTrackExperiment() {
        this.setTag(TAG);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\b\u0010\u0007\u001a\u00020\u0006H\u0014J\u0010\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u0014J\u0010\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u0014J \u0010\f\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0018\u00010\rH\u0014\u00a8\u0006\u0011"}, d2={"Lcom/yy/hiyo/channel/growth/PushTrackExperiment$PushTrackExperimentCreator;", "Lcom/yy/appbase/growth/AbsExperimentCreator;", "()V", "createExperiment", "Lcom/yy/appbase/growth/AbsExperiment;", "isAppSupport", "", "precondition", "subscribeMessage", "", "", "subscribeNotification", "targetABGroup", "Lkotlin/Pair;", "Lcom/yy/appbase/abtest/ABConfig;", "", "", "channel-components_release"})
    @GrowthExperimentCreator(msgIds={"com.yy.appbase.growth.GrowthMsgDef.PUSH_CHANNEL_TRACK_ENTER", "com.yy.appbase.growth.GrowthMsgDef.PUSH_CHANNEL_TRACK_GET"}, notificationIds={})
    public static final class PushTrackExperimentCreator
    extends AbsExperimentCreator {
        @NotNull
        protected AbsExperiment createExperiment() {
            return new PushTrackExperiment();
        }

        protected boolean precondition() {
            return this.isLogin();
        }

        @Nullable
        protected Pair<ABConfig<?>, String[]> targetABGroup() {
            return null;
        }

        @Nullable
        protected List<Integer> subscribeNotification() {
            return null;
        }

        @Nullable
        protected List<Integer> subscribeMessage() {
            return CollectionsKt.listOf((Object[])new Integer[]{GrowthMsgDef.PUSH_CHANNEL_TRACK_ENTER, GrowthMsgDef.PUSH_CHANNEL_TRACK_GET});
        }

        protected boolean isAppSupport() {
            return true;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/hiyo/channel/growth/PushTrackExperiment$Companion;", "", "()V", "TAG", "", "channel-components_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

