/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.theme;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.ImageUtil;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.bean.ThemeItemBean;
import com.yy.hiyo.channel.component.theme.model.DrawableResThemeBean;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.dyres.api.IDRCallback;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import org.jetbrains.annotations.NotNull;

public class VoiceRoomThemeHandler {
    @DrawableRes
    private static final int DEFAULT_BG = R.drawable.voice_room_bg;
    private static final String BG_NULL_URL = "";
    private FrameLayout mBgContainer;
    private SVGAImageView mWindowBg;
    private ThemeItemBean mCurrentTheme;
    private Activity mContextActivity;
    private String mBgUrl;
    private DrawableResThemeBean mCurGameTheme;

    public VoiceRoomThemeHandler(Activity contextActivity) {
        this.mContextActivity = contextActivity;
    }

    public void init(FrameLayout bgContainer, SVGAImageView originBgView) {
        this.mBgContainer = bgContainer;
        this.mWindowBg = originBgView == null ? this.createBgView() : originBgView;
        this.replaceBgView((ImageView)this.mWindowBg);
    }

    private SVGAImageView createBgView() {
        SVGAImageView bgView = new SVGAImageView((Context)this.mContextActivity);
        bgView.setImageResource(DEFAULT_BG);
        bgView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        return bgView;
    }

    public void setTheme(ThemeItemBean theme, boolean needChangeStatus) {
        if (this.mWindowBg != null) {
            if (theme == null) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTVoiceRoomTheme", (String)"setTheme, change bg, but theme null", (Object[])new Object[0]);
                }
                this.updateBgImage(BG_NULL_URL);
            } else {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTVoiceRoomTheme", (String)"setTheme themeId:%s, url:%s", (Object[])new Object[]{theme.getThemeId(), theme.getUrl()});
                }
                this.updateBgImage(TextUtils.isEmpty((CharSequence)theme.getSvgaUrl()) ? theme.getUrl() : theme.getSvgaUrl());
            }
        }
        this.mCurrentTheme = theme;
    }

    private void updateBgImage(String url) {
        if (FP.eq((Object)this.mBgUrl, (Object)url)) {
            return;
        }
        if (FP.empty((CharSequence)url)) {
            this.mWindowBg.setImageResource(DEFAULT_BG);
        } else {
            String realUrl = this.getRealUrl(url);
            Drawable oldDrawable = this.mWindowBg.getDrawable();
            if (oldDrawable != null) {
                SvgaLoader.load((SVGAImageView)this.mWindowBg, (String)realUrl, (!RuntimeContext.isPhoneSuperLow() ? 1 : 0) != 0, (int)0, (int)0, (Drawable)oldDrawable, (Drawable)oldDrawable, (ISvgaLoadCallback)new ISvgaLoadCallback(){

                    public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                        if (RuntimeContext.isPhoneSuperLow()) {
                            VoiceRoomThemeHandler.this.mWindowBg.stepToFrame(0, false);
                        }
                    }

                    public void onFailed(Exception e) {
                    }
                });
            } else {
                SvgaLoader.load((SVGAImageView)this.mWindowBg, (String)realUrl, (!RuntimeContext.isPhoneSuperLow() ? 1 : 0) != 0, (int)DEFAULT_BG, (int)DEFAULT_BG, null, null, (ISvgaLoadCallback)new ISvgaLoadCallback(){

                    public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                        if (RuntimeContext.isPhoneSuperLow()) {
                            VoiceRoomThemeHandler.this.mWindowBg.stepToFrame(0, false);
                        }
                    }

                    public void onFailed(Exception e) {
                    }
                });
            }
        }
        this.mBgUrl = url;
    }

    public void setTempTheme(DrawableResThemeBean theme) {
        if (this.mBgContainer == null || theme == null) {
            return;
        }
        if (theme.equals(this.mCurGameTheme)) {
            return;
        }
        SVGAImageView tempBgView = this.createBgView();
        if (theme.isRotationX() && LanguageUtils.isRtl()) {
            tempBgView.setRotationY(180.0f);
        }
        this.replaceBgView((ImageView)tempBgView);
        if (!StringUtils.isEmpty((String)theme.getBgUrl())) {
            this.updateModeTheme(tempBgView, theme.getBgUrl());
        } else {
            this.handleDrawableTheme(tempBgView, theme);
        }
        this.mCurGameTheme = theme;
    }

    private void updateModeTheme(final SVGAImageView tempBgView, String bgUrl) {
        SvgaLoader.load((SVGAImageView)tempBgView, (String)this.getRealUrl(bgUrl), (!RuntimeContext.isPhoneSuperLow() ? 1 : 0) != 0, (int)DEFAULT_BG, (int)DEFAULT_BG, null, null, (ISvgaLoadCallback)new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                if (RuntimeContext.isPhoneSuperLow()) {
                    tempBgView.stepToFrame(0, false);
                }
            }

            public void onFailed(Exception e) {
            }
        });
    }

    private void handleDrawableTheme(final SVGAImageView tempBgView, final DrawableResThemeBean theme) {
        long curTime = System.currentTimeMillis();
        try {
            tempBgView.setImageResource(theme.getBgDrawableRes());
        }
        catch (OutOfMemoryError error) {
            tempBgView.setBackgroundColor(ColorUtils.parseColor((String)"#026e5c"));
            StatisContent statContent = new StatisContent();
            statContent.put("act", "hagoperf");
            statContent.put("ifield", (int)(System.currentTimeMillis() - curTime));
            statContent.put("ifieldtwo", 1);
            statContent.put("perftype", "oomexc");
            HiidoStatis.reportContent((StatisContent)statContent);
        }
        if (theme.getRemoteBgDrawableRes() != null) {
            DyResLoader.INSTANCE.getResFilePath(theme.getRemoteBgDrawableRes(), new IDRCallback(){

                public void onSucceed(@NotNull String filePath) {
                    tempBgView.setScaleType(ImageView.ScaleType.FIT_XY);
                    if (VoiceRoomThemeHandler.this.isImage(filePath)) {
                        ImageLoader.loadBitmap((Context)tempBgView.getContext(), (String)filePath, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                            public void onLoadFailed(Exception e) {
                                tempBgView.setImageResource(theme.getBgDrawableRes());
                            }

                            public void onResourceReady(Bitmap bitmap) {
                                BitmapDrawable drawable2 = new BitmapDrawable(bitmap);
                                if (YYTaskExecutor.isMainThread()) {
                                    tempBgView.setImageDrawable((Drawable)drawable2);
                                } else {
                                    YYTaskExecutor.postToMainThread((Runnable)new Runnable((Drawable)drawable2){
                                        final /* synthetic */ Drawable val$drawable;
                                        {
                                            this.val$drawable = drawable2;
                                        }

                                        @Override
                                        public void run() {
                                            tempBgView.setImageDrawable(this.val$drawable);
                                        }
                                    });
                                }
                            }
                        });
                    } else {
                        SvgaLoader.load((SVGAImageView)tempBgView, (String)filePath, (!RuntimeContext.isPhoneSuperLow() ? 1 : 0) != 0, (int)theme.getBgDrawableRes(), (int)theme.getBgDrawableRes(), null, null, (ISvgaLoadCallback)new ISvgaLoadCallback(){

                            public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                                if (RuntimeContext.isPhoneSuperLow()) {
                                    tempBgView.stepToFrame(0, false);
                                }
                            }

                            public void onFailed(Exception e) {
                            }
                        });
                    }
                }

                public void onFailed(@NotNull String msg) {
                }
            });
        }
    }

    public void restoreTheme() {
        if (null == this.mCurGameTheme) {
            return;
        }
        this.mCurGameTheme = null;
        if (this.mBgContainer == null) {
            return;
        }
        this.replaceBgView((ImageView)this.mWindowBg);
        this.setTheme(this.mCurrentTheme, true);
    }

    private void replaceBgView(ImageView bgView) {
        if (this.mBgContainer == null) {
            return;
        }
        if (bgView.getParent() instanceof ViewGroup && bgView.getParent() != this.mBgContainer) {
            ((ViewGroup)bgView.getParent()).removeView((View)bgView);
        }
        this.mBgContainer.removeAllViews();
        this.mBgContainer.addView((View)bgView, -1, -1);
    }

    private String getRealUrl(String rawUrl) {
        if (rawUrl.endsWith(".svga")) {
            return rawUrl;
        }
        return rawUrl + YYImageUtils.getThumbnailPostfixPx((int)ScreenUtils.getInstance().getWidthPixels(), (int)ScreenUtils.getInstance().getHeightPixels(), (boolean)false);
    }

    private boolean isImage(String filePath) {
        return ImageUtil.isJpg((String)filePath) || ImageUtil.isPng((String)filePath) || ImageUtil.isGif((String)filePath);
    }
}

