/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.theme;

import android.app.Activity;
import android.content.Context;
import android.widget.FrameLayout;
import androidx.lifecycle.LifecycleOwner;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.hiyo.channel.base.bean.ThemeItemBean;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.component.theme.ThemeMvp;
import com.yy.hiyo.channel.component.theme.VoiceRoomThemeHandler;
import com.yy.hiyo.channel.component.theme.model.DrawableResThemeBean;

public class ThemeView
implements ThemeMvp.IView {
    public static final String BG_TAG = "room_theme_bg_view_tag";
    private VoiceRoomThemeHandler mThemeHandler;
    private FrameLayout mBgContainer;
    private AbsPage mRoomPage;
    private ThemeMvp.IPresenter mRoomPresenter;

    public ThemeView(Context context) {
        this.mBgContainer = new YYFrameLayout(context);
    }

    public FrameLayout getContainer() {
        return this.mBgContainer;
    }

    public void setRoomPage(AbsPage roomPage) {
        this.mRoomPage = roomPage;
    }

    public void setPresenter(ThemeMvp.IPresenter presenter) {
        this.mRoomPresenter = presenter;
        this.initThemeHandler();
        this.initModeThemeObserve();
        this.initThemeObserve();
    }

    private void initThemeHandler() {
        if (this.mRoomPage == null) {
            return;
        }
        this.mThemeHandler = new VoiceRoomThemeHandler((Activity)this.mRoomPage.getWindow().getContext());
        this.mThemeHandler.init(this.mBgContainer, null);
    }

    private void initModeThemeObserve() {
        this.mRoomPresenter.getModeTheme().observe((LifecycleOwner)this.mRoomPresenter.getMvpContext().getLifecycleOwner(), modeTheme -> {
            if (modeTheme == null) {
                this.mThemeHandler.restoreTheme();
            } else {
                this.mThemeHandler.setTempTheme((DrawableResThemeBean)modeTheme);
            }
        });
    }

    private void initThemeObserve() {
        this.mRoomPresenter.getTheme().observe((LifecycleOwner)this.mRoomPresenter.getMvpContext().getLifecycleOwner(), theme -> {
            if (this.mRoomPage != null) {
                this.mThemeHandler.setTheme((ThemeItemBean)theme, this.mRoomPage.isPageVisible());
            }
        });
    }
}

