/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.theme;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.OnLifecycleEvent;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.base.bean.ChannelNotify;
import com.yy.hiyo.channel.base.bean.ThemeItemBean;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.context.IHolderPresenter;
import com.yy.hiyo.channel.cbase.context.pagelifecycle.IPageLifeCycle;
import com.yy.hiyo.channel.component.theme.ThemeMvp;
import com.yy.hiyo.channel.component.theme.ThemeResManager;
import com.yy.hiyo.channel.component.theme.ThemeView;
import com.yy.hiyo.channel.component.theme.model.DrawableResThemeBean;
import com.yy.hiyo.channel.component.topbar.TopPresenter;
import com.yy.hiyo.mvp.base.INotifyDispatchService;
import org.jetbrains.annotations.NotNull;

public class ThemePresenter
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>>
implements ThemeMvp.IPresenter,
IHolderPresenter {
    private static final String TAG = "FTVoiceRoom ThemePresenter";
    private MutableLiveData<ThemeItemBean> mTheme = new MutableLiveData();
    private MutableLiveData<ThemeItemBean> mPartyTheme = new MutableLiveData();
    private MutableLiveData<DrawableResThemeBean> mModeTheme = new MutableLiveData();
    private ThemeView themeView;
    private IPageLifeCycle mPageLifeCycle = new IPageLifeCycle(){

        public void onShown() {
            ThemePresenter.this.updateStatusBarTransparent();
        }
    };
    private INotifyDispatchService.INotifyHandler<ChannelNotify> mChannelNotify = notify2 -> {
        if (notify2 != null && StringUtils.equal((String)notify2.cid, (String)this.getChannel().getChannelId()) && notify2.uri == ChannelNotify.Uri.UriSetThemeNotify) {
            this.setTheme(notify2.notify.setTheme.theme);
        }
        if (notify2 != null && notify2.uri == ChannelNotify.Uri.UriNewThemeNotify) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"UriNewThemeNotify", (Object[])new Object[0]);
            }
            if (this.getPage().isPageVisible()) {
                ((TopPresenter)this.getPresenter(TopPresenter.class)).showNewBackgroundGuide();
                ((TopPresenter)this.getPresenter(TopPresenter.class)).showNewBackgroundPoint();
            }
        }
    };

    public void onInit(IChannelPageContext mvpContext) {
        super.onInit(mvpContext);
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTVoiceRoomTheme", (String)"onInit", (Object[])new Object[0]);
        }
        this.setTheme(this.getChannelDetailInfo().baseInfo.theme);
        this.getNotifyDispatcher().addHandler(this.mChannelNotify);
        ((IChannelPageContext)this.getMvpContext()).getPageLifeDispatcher().addLifeListener(this.mPageLifeCycle);
        this.updateStatusBarTransparent();
    }

    public void onPageAttach(AbsPage page, boolean isReAttach) {
        super.onPageAttach(page, isReAttach);
        if (isReAttach && this.mModeTheme.getValue() != null) {
            this.mModeTheme.setValue(this.mModeTheme.getValue());
        } else if (isReAttach && this.mTheme.getValue() != null) {
            this.mTheme.setValue(this.mTheme.getValue());
        }
    }

    @Override
    public void setTheme(ThemeItemBean theme) {
        if (this.getChannelDetailInfo() != null) {
            this.getChannelDetailInfo().baseInfo.theme = theme;
        }
        this.mTheme.setValue((Object)theme);
    }

    @Override
    public LiveData<ThemeItemBean> getTheme() {
        return this.mTheme;
    }

    @Override
    public MutableLiveData<DrawableResThemeBean> getModeTheme() {
        return this.mModeTheme;
    }

    @Override
    public String getRoomId() {
        return this.getChannel().getChannelId();
    }

    @Override
    public void setPartyTheme(ThemeItemBean theme) {
        if (this.getChannelDetailInfo() != null) {
            this.getChannelDetailInfo().baseInfo.partyTheme = theme;
        }
        ThemeResManager.INSTANCE.setPartyTheme(this.getChannel().getTopChannelId(), theme);
        this.mPartyTheme.setValue((Object)theme);
    }

    @Override
    public LiveData<ThemeItemBean> getPartyTheme() {
        return this.mPartyTheme;
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_RESUME)
    public void onPageResume() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onPageResume theme %s", (Object[])new Object[]{this.getTheme().getValue()});
        }
        if (this.getTheme().getValue() != null) {
            this.setTheme((ThemeItemBean)this.getTheme().getValue());
        }
    }

    public void onDestroy() {
        this.getNotifyDispatcher().removeHandler(this.mChannelNotify);
        ((IChannelPageContext)this.getMvpContext()).getPageLifeDispatcher().removeLifeListener(this.mPageLifeCycle);
        super.onDestroy();
    }

    @NotNull
    public void setContainer(@NonNull YYPlaceHolderView container) {
        this.themeView = new ThemeView((Context)((IChannelPageContext)this.getMvpContext()).getContext());
        container.inflate((View)this.themeView.getContainer());
        this.themeView.setRoomPage(this.getPage());
        this.themeView.setPresenter(this);
    }

    private void updateStatusBarTransparent() {
    }

    public Drawable getBgDrawable() {
        View bgView = this.themeView.getContainer().getChildAt(0);
        if (bgView instanceof ImageView) {
            return ((ImageView)bgView).getDrawable();
        }
        return null;
    }

    public static interface IThemeChangeListener {
        public void onSuccess(String var1, ThemeItemBean var2);

        public void onFailed(long var1, String var3);
    }
}

