/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.setting.report;

import android.content.Context;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.appbase.screenshot.ScreenShotManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.context.pagelifecycle.IPageLifeCycle;
import com.yy.hiyo.channel.cbase.publicscreen.IPublicScreenService;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IPublicScreenModulePresenter;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IPublicScreenPresenter;
import com.yy.hiyo.channel.cbase.publicscreen.msg.SysTextMsg;
import com.yy.hiyo.channel.component.invite.PlatFormInvitePresenter;
import com.yy.hiyo.channel.component.setting.report.ChannelReportManager;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import java.lang.ref.WeakReference;

public class ChannelReportPresenter
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>>
implements ScreenShotManager.IScreenShotListener {
    private static final long OFFICIAL_DELAY_TIME = 60000L;
    private ScreenShotManager mScreenShotHelper;
    private static final String TAG = "ChannelReportPresenter";
    private ChannelReportManager mChannelReportManager;
    private boolean hasSendReportTips = false;
    private Runnable officialTipsRunnable = new Runnable(){

        @Override
        public void run() {
            if (ChannelReportPresenter.this.getChannelDetailInfo() == null || ChannelReportPresenter.this.isDestroyed()) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)ChannelReportPresenter.TAG, (String)"officialTipsRunnable roomData null or destory:%d", (Object[])new Object[]{ChannelReportPresenter.this.isDestroyed()});
                }
                return;
            }
            ChannelReportPresenter.this.hasSendReportTips = true;
            IPublicScreenPresenter publicScreenPresenter = ((IPublicScreenModulePresenter)ChannelReportPresenter.this.getPresenter(IPublicScreenModulePresenter.class)).getPublicScreenPresenter();
            IPublicScreenService service = (IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class);
            if (publicScreenPresenter != null && service != null) {
                String tips = ResourceUtils.getString((int)R.string.tips_channel_official_report_tips);
                if (ChannelReportPresenter.this.getChannel().getPluginService().getCurPluginData().mode != 1) {
                    tips = ResourceUtils.getString((int)R.string.tips_room_official_report_tips);
                }
                SysTextMsg sysTextMsg = service.getMsgItemFactory().generateSysTextMsg(ChannelReportPresenter.this.getChannel().getChannelId(), tips);
                sysTextMsg.setMsgState(1);
                publicScreenPresenter.appendLocalMsg((BaseImMsg)sysTextMsg);
            } else if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)ChannelReportPresenter.TAG, (String)"officialTipsRunnable publicScreenPresenter null", (Object[])new Object[0]);
            }
        }
    };
    private IPageLifeCycle mPageLifeCycle = new IPageLifeCycle(){

        public void onShown() {
            ChannelReportPresenter.this.initScreenShot(ChannelReportPresenter.this.getChannelId());
        }

        public void onHidden() {
            ChannelReportPresenter.this.removeOfficialRunnable();
            if (ChannelReportPresenter.this.mScreenShotHelper != null) {
                ChannelReportPresenter.this.mScreenShotHelper.stop();
            }
        }
    };

    public void onInit(IChannelPageContext mvpContext) {
        super.onInit(mvpContext);
        this.mChannelReportManager = new ChannelReportManager((IChannel)this.getChannel());
        this.hasSendReportTips = false;
    }

    public void reportImage(Context context, long targetUid, String msgId, String imgUrl, int urlFrom) {
        if (this.getChannel().getDataService() == null) {
            return;
        }
        this.mChannelReportManager.reportChannelImage(context, this.getChannel().getDataService().getChannelDetailInfo(null).baseInfo, targetUid, msgId, imgUrl, urlFrom);
    }

    public void reportVideo(Context context, long targetUid, String msgId, String url) {
        if (this.getChannel().getDataService() == null) {
            return;
        }
        this.mChannelReportManager.reportChannelVideo(context, this.getChannel().getDataService().getChannelDetailInfo(null).baseInfo, targetUid, msgId, url);
    }

    public void reportTextImage(Context context, long targetUid, String msgId, String imgUrl, int urlFrom, CharSequence content) {
        if (this.getChannel().getDataService() == null) {
            return;
        }
        this.mChannelReportManager.reportChannelTextImage(context, this.getChannel().getDataService().getChannelDetailInfo(null).baseInfo, targetUid, msgId, imgUrl, urlFrom, content);
    }

    public void reportAudio(Context context, long targetUid, String msgId, String url) {
        if (this.getChannel().getDataService() == null) {
            return;
        }
        this.mChannelReportManager.reportChannelAudio(context, this.getChannel().getDataService().getChannelDetailInfo(null).baseInfo, targetUid, msgId, url);
    }

    public void reportPureText(Context context, long targetUid, String msgId, CharSequence content) {
        if (this.getChannel().getDataService() == null) {
            return;
        }
        this.mChannelReportManager.reportChannelText(context, this.getChannel().getDataService().getChannelDetailInfo(null).baseInfo, targetUid, msgId, content);
    }

    public void reportShareLink(Context context, long targetUid, String msgId, String url) {
        if (this.getChannel().getDataService() == null) {
            return;
        }
        this.mChannelReportManager.reportChannelShareLink(context, this.getChannel().getDataService().getChannelDetailInfo(null).baseInfo, targetUid, msgId, url);
    }

    public void showUserReportPopup(Context context, long uid, String targetChannelId, long targetChannelOwnerId) {
        if (this.mChannelReportManager != null && this.getChannelDetailInfo() != null) {
            this.mChannelReportManager.showUserReportPopup(context, uid, this.getChannelDetailInfo().baseInfo, targetChannelId, targetChannelOwnerId);
        }
    }

    public void showGetOutConfirmDialog(DialogLinkManager dialogLinkManager, long uid, final Callback<Boolean> callback2) {
        dialogLinkManager.showDialog((BaseDialog)new OkCancelDialog.Builder().message((CharSequence)ResourceUtils.getString((int)R.string.tips_voice_room_get_out_tips)).okLabel((CharSequence)ResourceUtils.getString((int)R.string.contact_dialog_ok)).setCancelLabel((CharSequence)ResourceUtils.getString((int)R.string.contact_dialog_cancel)).cancelable(true).listener(new OkCancelDialogListener(){

            public void onCancel() {
                if (callback2 != null) {
                    callback2.onResponse((Object)false);
                }
            }

            public void onOk() {
                if (callback2 != null) {
                    callback2.onResponse((Object)true);
                }
            }
        }).build());
    }

    public void startOfficialRunnable(boolean isOwner) {
        if (this.getChannelDetailInfo() == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"startOfficialRunnable roomData null", (Object[])new Object[0]);
            }
            return;
        }
        if (!isOwner) {
            this.removeOfficialRunnable();
            YYTaskExecutor.postToMainThread((Runnable)this.officialTipsRunnable, (long)60000L);
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"startOfficialRunnable", (Object[])new Object[0]);
            }
        } else if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"startOfficialRunnable self", (Object[])new Object[0]);
        }
    }

    public void removeOfficialRunnable() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"removeOfficialRunnable", (Object[])new Object[0]);
        }
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.officialTipsRunnable);
    }

    public void onPageAttach(AbsPage page, boolean isReAttach) {
        super.onPageAttach(page, isReAttach);
        if (this.getChannelDetailInfo() == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"roomData null", (Object[])new Object[0]);
            }
            return;
        }
        this.initScreenShot(this.getChannel().getChannelId());
        ((IChannelPageContext)this.getMvpContext()).getPageLifeDispatcher().addLifeListener(this.mPageLifeCycle);
        if (!this.hasSendReportTips) {
            this.startOfficialRunnable(this.getChannelDetailInfo().baseInfo.ownerUid == AccountUtil.getUid());
        }
    }

    public void onPageDetach(AbsPage page) {
        super.onPageDetach(page);
        if (this.mScreenShotHelper != null) {
            this.mScreenShotHelper.stop();
        }
    }

    private void initScreenShot(String roomId) {
        if (this.mScreenShotHelper == null) {
            this.mScreenShotHelper = new ScreenShotManager((Context)((IChannelPageContext)this.getMvpContext()).getContext(), 2, roomId);
            this.mScreenShotHelper.isShowScreenShotView(false);
        }
        if (this.getChannelDetailInfo() == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"initScreenShot roomData null", (Object[])new Object[0]);
            }
            return;
        }
        if (this.getChannelDetailInfo().baseInfo != null && this.getChannelDetailInfo().baseInfo.ownerUid != AccountUtil.getUid()) {
            this.mScreenShotHelper.setScreenShotListener((ScreenShotManager.IScreenShotListener)new MyScreenShotListener(this));
            this.mScreenShotHelper.start(((IChannelPageContext)this.getMvpContext()).getEnv().getWindowManager());
        }
    }

    public void onScreenShotSuccess(int type) {
    }

    public void onScreenShotImage(int type, String imagePath) {
        if (this.getChannelDetailInfo() == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"onScreenShotImage roomData null", (Object[])new Object[0]);
            }
            return;
        }
        if (this.getChannelDetailInfo().baseInfo == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"onScreenShotImage roomInfo null", (Object[])new Object[0]);
            }
            return;
        }
        ((PlatFormInvitePresenter)this.getPresenter(PlatFormInvitePresenter.class)).showInvitePanel(imagePath);
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mScreenShotHelper != null) {
            this.mScreenShotHelper.stop();
            this.mScreenShotHelper.setScreenShotListener(null);
        }
        ((IChannelPageContext)this.getMvpContext()).getPageLifeDispatcher().removeLifeListener(this.mPageLifeCycle);
        this.removeOfficialRunnable();
    }

    public static class MyScreenShotListener
    implements ScreenShotManager.IScreenShotListener {
        private WeakReference<ScreenShotManager.IScreenShotListener> callback;

        public MyScreenShotListener(ScreenShotManager.IScreenShotListener listener) {
            this.callback = new WeakReference<ScreenShotManager.IScreenShotListener>(listener);
        }

        public void onScreenShotSuccess(int type) {
            ScreenShotManager.IScreenShotListener realCallBack;
            if (this.callback != null && (realCallBack = (ScreenShotManager.IScreenShotListener)this.callback.get()) != null) {
                realCallBack.onScreenShotSuccess(type);
            }
        }

        public void onScreenShotImage(int type, String imagePath) {
            ScreenShotManager.IScreenShotListener realCallBack;
            if (this.callback != null && (realCallBack = (ScreenShotManager.IScreenShotListener)this.callback.get()) != null) {
                realCallBack.onScreenShotImage(type, imagePath);
            }
        }
    }
}

