/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.setting.report;

import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.IOOSService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.oos.IUploadObjectCallBack;
import com.yy.appbase.service.oos.UploadObjectRequest;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import java.util.HashMap;
import java.util.Map;

public class AudioUploadService {
    public static long mUploadDuration = 20000L;

    public static HashMap<Long, byte[]> getRoomAudioToUpload(String roomId) {
        long curTime = System.currentTimeMillis();
        return ((IKtvLiveServiceExtend)ServiceManagerProxy.getService(IKtvLiveServiceExtend.class)).getRoomCachedAudio(roomId, curTime - mUploadDuration);
    }

    public static long[] uploadRoomAudio(final String roomId, HashMap<Long, byte[]> roomAudio, final AudioUploadCallback callBack) {
        if (FP.empty(roomAudio)) {
            return null;
        }
        final long curTime = System.currentTimeMillis();
        long[] uids = new long[roomAudio.size()];
        int i = 0;
        for (final Map.Entry<Long, byte[]> entry : roomAudio.entrySet()) {
            long uid = entry.getKey();
            if (0L == uid) {
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        byte[] aacData = ((IKtvLiveServiceExtend)ServiceManagerProxy.getService(IKtvLiveServiceExtend.class)).transPCM2AAC((byte[])entry.getValue(), 8000, 1);
                        AudioUploadService.uploadUserAudio(aacData, roomId, 0L, callBack, curTime);
                    }
                });
            } else {
                AudioUploadService.uploadUserAudio(entry.getValue(), roomId, uid, callBack, curTime);
            }
            uids[i] = uid;
            ++i;
        }
        return uids;
    }

    public static int uploadUserAudio(String roomId, long uid, AudioUploadCallback callBack) {
        long curTime = System.currentTimeMillis();
        byte[] data = ((IKtvLiveServiceExtend)ServiceManagerProxy.getService(IKtvLiveServiceExtend.class)).getCachedUserAudio(roomId, uid, curTime - mUploadDuration);
        return AudioUploadService.uploadUserAudio(data, roomId, uid, callBack, curTime);
    }

    private static int uploadUserAudio(byte[] data, String roomId, final long uid, final AudioUploadCallback callBack, long uploadTime) {
        if (data != null && data.length > 0) {
            String suffix = uid == 0L ? "aac" : "audio";
            String uploadKey = StringUtils.formatWitUSLocal((String)"report_voice_room/%s_%s_%s_%s.%s", (Object[])new Object[]{String.valueOf(uploadTime), roomId, String.valueOf(AccountUtil.getUid()), String.valueOf(uid), suffix});
            ((IOOSService)ServiceManagerProxy.getServiceManager().getService(IOOSService.class)).uploadData(uploadKey, data, new IUploadObjectCallBack(){

                public void onSuccess(UploadObjectRequest request) {
                    if (callBack != null) {
                        String audioUrl = request.mUrl;
                        callBack.onUploadSuccess(uid, audioUrl);
                    }
                }

                public void onFailure(UploadObjectRequest request, int errorCode, Exception exception) {
                    if (callBack != null) {
                        callBack.onUploadFail(uid, errorCode, exception);
                    }
                }
            });
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTVoiceRoom", (String)("upload user audio, roomId: " + roomId + ", uid: " + uid + ", size: " + data.length), (Object[])new Object[0]);
            }
            return data.length;
        }
        FeatureLog.w((String)"FTVoiceRoom", (String)"uploadUserAudio but audio data empty", (Object[])new Object[0]);
        return 0;
    }

    public static interface AudioUploadCallback {
        public void onUploadSuccess(long var1, String var3);

        public void onUploadFail(long var1, int var3, Exception var4);
    }
}

