/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.setting.report;

import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetOriginRespCallback;
import com.yy.appbase.http.INetRespCallback;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.channel.component.setting.report.AudioUploadService;
import com.yy.hiyo.report.base.IReportReqCallback;
import com.yy.hiyo.report.base.IVoiceReportReqCallback;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AudioReportService
implements AudioUploadService.AudioUploadCallback,
IVoiceReportReqCallback {
    private String mServerSessionId;
    private HashMap<Long, String> mToReportInfos = new HashMap();
    private static final String TAG = "AudioReportService";
    private int mAudioCntPendingUpload;

    public long[] reportRoomAudio(String roomId) {
        if (StringUtils.isEmpty((String)roomId)) {
            return null;
        }
        HashMap<Long, byte[]> audio = AudioUploadService.getRoomAudioToUpload(roomId);
        if (audio != null) {
            this.mAudioCntPendingUpload = audio.size();
        }
        return AudioUploadService.uploadRoomAudio(roomId, audio, this);
    }

    public void reportUserAudio(String roomId, long uid) {
        if (!StringUtils.isEmpty((String)roomId)) {
            this.mAudioCntPendingUpload = 1;
            AudioUploadService.uploadUserAudio(roomId, uid, this);
        }
    }

    @Override
    public void onUploadSuccess(long uid, String url) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("onUploadSuccess, uid: " + uid + ", url: " + url), (Object[])new Object[0]);
        }
        this.onUploadEnd(uid, url);
    }

    @Override
    public void onUploadFail(long uid, int errorCode, Exception exception) {
        String exceptionInfo = exception != null ? exception.toString() : "";
        MLog.error((Object)TAG, (String)("onUploadFail, uid: " + uid + ", errorCode: " + errorCode + ", exception: " + exceptionInfo), (Object[])new Object[0]);
        this.onUploadEnd(uid, "");
    }

    public void onReportError(int errorType, Exception e) {
    }

    public void onReportSuccess(String sessionId) {
        this.mServerSessionId = sessionId;
        this.checkSubmitAudioInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUploadEnd(long uid, String url) {
        AudioReportService audioReportService = this;
        synchronized (audioReportService) {
            this.mToReportInfos.put(uid, url);
            --this.mAudioCntPendingUpload;
        }
        this.checkSubmitAudioInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void checkSubmitAudioInfo() {
        JSONObject voiceJson;
        AudioReportService audioReportService = this;
        synchronized (audioReportService) {
            block7: {
                if (StringUtils.isEmpty((String)this.mServerSessionId) || this.mToReportInfos.isEmpty() || this.mAudioCntPendingUpload > 0) {
                    return;
                }
                voiceJson = JsonParser.obtainJSONObject();
                try {
                    voiceJson.put("session_id", (Object)this.mServerSessionId);
                    JSONArray voiceArray = new JSONArray();
                    for (Map.Entry<Long, String> entry : this.mToReportInfos.entrySet()) {
                        JSONObject audioJson = JsonParser.obtainJSONObject();
                        audioJson.put("uid", (Object)entry.getKey());
                        audioJson.put("url", (Object)entry.getValue());
                        voiceArray.put((Object)audioJson);
                    }
                    this.mToReportInfos.clear();
                    voiceJson.put("files", (Object)voiceArray);
                }
                catch (JSONException e) {
                    if (!MLog.isLogLevelBlowInfo()) break block7;
                    MLog.info((Object)TAG, (String)("checkSubmitAudioInfo: " + (e != null ? e.toString() : "")), (Object[])new Object[0]);
                }
            }
        }
        this.submitAudioInfo(voiceJson.toString(), null);
    }

    private void submitAudioInfo(String content, final IReportReqCallback callBack) {
        YYTaskExecutor.execute(() -> {
            String url = UriProvider.getIkxdSvrHost() + "/inform_against/submit_voice";
            HttpUtil.httpReqPostString((String)url, (String)content, null, (INetRespCallback)new INetOriginRespCallback(){

                public void onError(Call call, Exception e, int id) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)AudioReportService.TAG, (String)("submitAudioInfo error: " + (e != null ? e.toString() : "")), (Object[])new Object[0]);
                    }
                    if (callBack != null) {
                        callBack.onError(1, e);
                    }
                }

                public void onResponse(String response, BaseResponseBean<String> res, int id) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)AudioReportService.TAG, (String)"submitAudioInfo success!", (Object[])new Object[0]);
                    }
                    if (callBack != null) {
                        callBack.onSuccess(response);
                    }
                }
            });
        });
    }
}

