/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.setting.controller;

import android.content.Context;
import android.os.Message;
import androidx.fragment.app.FragmentActivity;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.channel.ChannelBaseMsgDef;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.ChannelInfo;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IDataService;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.component.setting.callback.IChannelPermissionCallback;
import com.yy.hiyo.channel.component.setting.viewmodel.GroupSettingViewModel;
import com.yy.hiyo.channel.component.setting.window.ChannelPermissionWindow;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.mvp.base.MvpController;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000e\u001a\u00020\tH\u0002J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/yy/hiyo/channel/component/setting/controller/ChannelPermissionController;", "Lcom/yy/hiyo/mvp/base/MvpController;", "Lcom/yy/hiyo/channel/component/setting/callback/IChannelPermissionCallback;", "env", "Lcom/yy/framework/core/Environment;", "(Lcom/yy/framework/core/Environment;)V", "mChannelId", "", "mDataUpdateListener", "Lcom/yy/hiyo/channel/base/service/IDataService$IDataUpdateListener;", "mWindow", "Lcom/yy/hiyo/channel/component/setting/window/ChannelPermissionWindow;", "settingViewModel", "Lcom/yy/hiyo/channel/component/setting/viewmodel/GroupSettingViewModel;", "getGroupDataListener", "handleMessage", "", "msg", "Landroid/os/Message;", "onBlackListClick", "onOpenPartySettingSwitch", "isChecked", "", "onWindowDetach", "abstractWindow", "Lcom/yy/framework/core/ui/AbstractWindow;", "Companion", "channel-components_release"})
public final class ChannelPermissionController
extends MvpController
implements IChannelPermissionCallback {
    private ChannelPermissionWindow mWindow;
    private String mChannelId;
    private GroupSettingViewModel settingViewModel;
    private IDataService.IDataUpdateListener mDataUpdateListener;
    private static final String TAG = "ChannelPermissionController";
    public static final Companion Companion = new Companion(null);

    public void handleMessage(@Nullable Message msg) {
        block5: {
            super.handleMessage(msg);
            Message message = msg;
            if (message == null) break block5;
            if (message.what == ChannelBaseMsgDef.OPEN_CHANNEL_PERMISSION) {
                IMvpContext iMvpContext = this.getMvpContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)iMvpContext, (String)"mvpContext");
                this.mWindow = new ChannelPermissionWindow(iMvpContext, (UICallBacks)this, this);
                this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
                if (msg.obj instanceof String) {
                    Object object = msg.obj;
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                    }
                    this.mChannelId = (String)object;
                    GroupSettingViewModel groupSettingViewModel = this.settingViewModel = new GroupSettingViewModel(this.mChannelId);
                    if (groupSettingViewModel != null) {
                        groupSettingViewModel.addGroupDataListener(this.getGroupDataListener());
                    }
                    GroupSettingViewModel groupSettingViewModel2 = this.settingViewModel;
                    if (groupSettingViewModel2 != null) {
                        groupSettingViewModel2.fetchGroupDetailInfo(new IDataService.IGetDetailInfoCallBack(this){
                            final /* synthetic */ ChannelPermissionController this$0;

                            public void onSuccess(@Nullable String channelId, @Nullable ChannelDetailInfo info) {
                                block2: {
                                    ChannelDetailInfo channelDetailInfo = info;
                                    if (channelDetailInfo == null) break block2;
                                    ChannelDetailInfo channelDetailInfo2 = channelDetailInfo;
                                    boolean bl = false;
                                    boolean bl2 = false;
                                    ChannelDetailInfo it = channelDetailInfo2;
                                    boolean bl3 = false;
                                    if (MLog.isLogLevelBlowInfo()) {
                                        MLog.info((Object)"ChannelPermissionController", (String)("get groupInfo success, channelId: " + channelId + ", info:" + info), (Object[])new Object[0]);
                                    }
                                    ChannelPermissionWindow channelPermissionWindow = ChannelPermissionController.access$getMWindow$p(this.this$0);
                                    if (channelPermissionWindow != null) {
                                        channelPermissionWindow.updateChannelShowPermis(info);
                                    }
                                }
                            }

                            public void onError(@Nullable String channelId, int errorCode, @Nullable String errorTips, @Nullable Exception e) {
                                if (MLog.isLogLevelBlowInfo()) {
                                    MLog.info((Object)"ChannelPermissionController", (String)("get groupInfo failed, channelId: " + channelId + " errorCode: " + errorCode), (Object[])new Object[0]);
                                }
                            }
                            {
                                this.this$0 = $outer;
                            }
                        }, false);
                    }
                }
            }
        }
    }

    private final IDataService.IDataUpdateListener getGroupDataListener() {
        if (this.mDataUpdateListener != null) {
            IDataService.IDataUpdateListener iDataUpdateListener = this.mDataUpdateListener;
            if (iDataUpdateListener == null) {
                Intrinsics.throwNpe();
            }
            return iDataUpdateListener;
        }
        IDataService.IDataUpdateListener iDataUpdateListener = this.mDataUpdateListener = (IDataService.IDataUpdateListener)new IDataService.IDataUpdateListener(this){
            final /* synthetic */ ChannelPermissionController this$0;

            public void onDataUpdate(@Nullable String channelId, @Nullable ChannelDetailInfo info) {
                block4: {
                    if (!Intrinsics.areEqual((Object)channelId, (Object)ChannelPermissionController.access$getMChannelId$p(this.this$0))) break block4;
                    ChannelDetailInfo channelDetailInfo = info;
                    if ((channelDetailInfo != null ? channelDetailInfo.baseInfo : null) != null) {
                        ChannelInfo channelInfo = info.baseInfo;
                        if (channelInfo != null) {
                            ChannelInfo channelInfo2 = channelInfo;
                            boolean bl = false;
                            boolean bl2 = false;
                            ChannelInfo it = channelInfo2;
                            boolean bl3 = false;
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)"ChannelPermissionController", (String)("get groupInfo success, channelId: " + channelId + ", info:" + info), (Object[])new Object[0]);
                            }
                            ChannelPermissionWindow channelPermissionWindow = ChannelPermissionController.access$getMWindow$p(this.this$0);
                            if (channelPermissionWindow != null) {
                                channelPermissionWindow.updateChannelShowPermis(info);
                            }
                        }
                    }
                }
            }
            {
                this.this$0 = $outer;
            }
        };
        if (iDataUpdateListener == null) {
            Intrinsics.throwNpe();
        }
        return iDataUpdateListener;
    }

    @Override
    public void onOpenPartySettingSwitch(boolean isChecked) {
        block0: {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "group_ban_creat_voice").put("create_goup_voice_switch", isChecked ? "1" : "2").put("room_id", this.mChannelId));
            GroupSettingViewModel groupSettingViewModel = this.settingViewModel;
            if (groupSettingViewModel == null) break block0;
            groupSettingViewModel.setOpenPartyPermission(isChecked, new IDataService.IUpdateInfoCallBack(this){
                final /* synthetic */ ChannelPermissionController this$0;

                public void onSuccess(@Nullable IChannel group) {
                }

                public void onContainSensitiveWord() {
                }

                public void onFailUnauthorized() {
                }

                public void onError(@Nullable String channelId, int errorCode, @Nullable String errorTips, @Nullable Exception e) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"ChannelPermissionController", (String)("onOpenPartySettingSwitch, channelId: " + channelId + " errorCode: " + errorCode + ", tips: " + errorTips), (Object[])new Object[0]);
                    }
                    ToastUtils.showToast((Context)((Context)ChannelPermissionController.access$getMContext$p(this.this$0)), (int)R.string.tips_channel_join_net_error);
                }
                {
                    this.this$0 = $outer;
                }
            });
        }
    }

    @Override
    public void onBlackListClick() {
        int roleType = RoomTrack.INSTANCE.getUserRole(this.mChannelId);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("30011901").put("function_id", "black_list_enter_click").put("room_id", this.mChannelId).put("user_role", String.valueOf(roleType)));
        MsgDispatcher.getInstance().sendMessage(ChannelBaseMsgDef.OPEN_CHANNEL_BLACK_LIST, (Object)this.mChannelId);
    }

    public void onWindowDetach(@Nullable AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        this.mWindow = null;
        this.mDataUpdateListener = null;
    }

    public ChannelPermissionController(@NotNull Environment env) {
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        super(env);
        this.mChannelId = "";
    }

    public static final /* synthetic */ ChannelPermissionWindow access$getMWindow$p(ChannelPermissionController $this) {
        return $this.mWindow;
    }

    public static final /* synthetic */ void access$setMWindow$p(ChannelPermissionController $this, ChannelPermissionWindow channelPermissionWindow) {
        $this.mWindow = channelPermissionWindow;
    }

    public static final /* synthetic */ String access$getMChannelId$p(ChannelPermissionController $this) {
        return $this.mChannelId;
    }

    public static final /* synthetic */ void access$setMChannelId$p(ChannelPermissionController $this, String string) {
        $this.mChannelId = string;
    }

    public static final /* synthetic */ FragmentActivity access$getMContext$p(ChannelPermissionController $this) {
        return $this.mContext;
    }

    public static final /* synthetic */ void access$setMContext$p(ChannelPermissionController $this, FragmentActivity fragmentActivity) {
        $this.mContext = fragmentActivity;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/hiyo/channel/component/setting/controller/ChannelPermissionController$Companion;", "", "()V", "TAG", "", "channel-components_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

