/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.setting.controller;

import android.os.Bundle;
import android.os.Message;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.framework.core.Environment;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.ChannelBaseMsgDef;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.component.setting.callback.IChannelBlackListCallback;
import com.yy.hiyo.channel.component.setting.callback.IChannelBlackResetCallback;
import com.yy.hiyo.channel.component.setting.controller.ChannelBlackListController;
import com.yy.hiyo.channel.component.setting.data.BlackMember;
import com.yy.hiyo.channel.component.setting.viewmodel.ChannelBlackListViewModel;
import com.yy.hiyo.channel.component.setting.window.ChannelBlackListWindow;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.mvp.base.MvpController;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0002J\b\u0010\u0017\u001a\u00020\u0013H\u0016J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0012\u0010\u001d\u001a\u00020\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0012\u0010 \u001a\u00020\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lcom/yy/hiyo/channel/component/setting/controller/ChannelBlackListController;", "Lcom/yy/hiyo/mvp/base/MvpController;", "Lcom/yy/hiyo/channel/component/setting/callback/IChannelBlackListCallback;", "env", "Lcom/yy/framework/core/Environment;", "(Lcom/yy/framework/core/Environment;)V", "mChannelId", "", "mViewModel", "Lcom/yy/hiyo/channel/component/setting/viewmodel/ChannelBlackListViewModel;", "mWindow", "Lcom/yy/hiyo/channel/component/setting/window/ChannelBlackListWindow;", "progressDialog", "Lcom/yy/appbase/ui/dialog/ProgressDialog;", "getProgressDialog", "()Lcom/yy/appbase/ui/dialog/ProgressDialog;", "progressDialog$delegate", "Lkotlin/Lazy;", "handleMessage", "", "msg", "Landroid/os/Message;", "initObserver", "onAdd", "onRemove", "item", "Lcom/yy/hiyo/channel/component/setting/data/BlackMember;", "index", "", "onWindowDetach", "abstractWindow", "Lcom/yy/framework/core/ui/AbstractWindow;", "onWindowShown", "Companion", "channel-components_release"})
public final class ChannelBlackListController
extends MvpController
implements IChannelBlackListCallback {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Lazy progressDialog$delegate;
    private ChannelBlackListWindow mWindow;
    private String mChannelId;
    private ChannelBlackListViewModel mViewModel;
    private static final String TAG = "ChannelBlackListController";
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ChannelBlackListController.class), "progressDialog", "getProgressDialog()Lcom/yy/appbase/ui/dialog/ProgressDialog;"))};
        Companion = new Companion(null);
    }

    private final ProgressDialog getProgressDialog() {
        Lazy lazy = this.progressDialog$delegate;
        ChannelBlackListController channelBlackListController = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (ProgressDialog)lazy.getValue();
    }

    public void handleMessage(@Nullable Message msg) {
        super.handleMessage(msg);
        Message message = msg;
        if (message != null) {
            if (message.what == ChannelBaseMsgDef.OPEN_CHANNEL_BLACK_LIST) {
                IMvpContext iMvpContext = this.getMvpContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)iMvpContext, (String)"mvpContext");
                this.mWindow = new ChannelBlackListWindow(iMvpContext, (UICallBacks)this, this);
                this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
                if (msg.obj instanceof String) {
                    Object object = msg.obj;
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                    }
                    this.mChannelId = (String)object;
                    this.mViewModel.getBlackListData(this.mChannelId);
                    this.initObserver();
                }
            }
        }
    }

    private final void initObserver() {
        this.mViewModel.getBlackLiveData().observe((LifecycleOwner)this.getMvpContext().getLifecycleOwner(), (Observer)new Observer<List<BlackMember>>(this){
            final /* synthetic */ ChannelBlackListController this$0;

            public final void onChanged(List<BlackMember> it) {
                block1: {
                    List<BlackMember> list2 = it;
                    if (list2 == null) break block1;
                    List<BlackMember> list3 = list2;
                    boolean bl = false;
                    boolean bl2 = false;
                    List<BlackMember> it2 = list3;
                    boolean bl3 = false;
                    ChannelBlackListWindow channelBlackListWindow = ChannelBlackListController.access$getMWindow$p(this.this$0);
                    if (channelBlackListWindow != null) {
                        channelBlackListWindow.updateData(it2);
                    }
                }
            }
            {
                this.this$0 = channelBlackListController;
            }
        });
        this.mViewModel.getNetErrorStatus().observe((LifecycleOwner)this.getMvpContext().getLifecycleOwner(), (Observer)new Observer<Boolean>(this){
            final /* synthetic */ ChannelBlackListController this$0;

            public final void onChanged(Boolean it) {
                block1: {
                    Boolean bl = it;
                    if (bl == null) break block1;
                    Boolean bl2 = bl;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    boolean it2 = bl2;
                    boolean bl5 = false;
                    ChannelBlackListWindow channelBlackListWindow = ChannelBlackListController.access$getMWindow$p(this.this$0);
                    if (channelBlackListWindow != null) {
                        channelBlackListWindow.showError();
                    }
                }
            }
            {
                this.this$0 = channelBlackListController;
            }
        });
    }

    public void onWindowDetach(@Nullable AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onWindowDetach", (Object[])new Object[0]);
        }
        this.mWindow = null;
        this.mChannelId = "";
    }

    @Override
    public void onAdd() {
        int roleType = RoomTrack.INSTANCE.getUserRole(this.mChannelId);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("30011901").put("function_id", "black_list_add_click").put("room_id", this.mChannelId).put("user_role", String.valueOf(roleType)));
        Bundle bundle = new Bundle();
        bundle.putString("channelId", this.mChannelId);
        ArrayList<Long> blackList = new ArrayList<Long>();
        Object object = this.mWindow;
        if (object != null && (object = object.getData()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                long it = ((Number)element$iv).longValue();
                boolean bl = false;
                blackList.add(it);
            }
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onAdd, channelId:%ds, blackList:%s", (Object[])new Object[]{this.mChannelId, blackList});
        }
        bundle.putSerializable("blackList", (Serializable)blackList);
        Message message = Message.obtain();
        message.what = ChannelBaseMsgDef.OPEN_CHANNEL_ADD_BLACK;
        Message message2 = message;
        Intrinsics.checkExpressionValueIsNotNull((Object)message2, (String)"message");
        message2.setData(bundle);
        MsgDispatcher.getInstance().sendMessage(message);
    }

    @Override
    public void onRemove(@NotNull BlackMember item, int index) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        if (FP.empty((CharSequence)this.mChannelId)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"onRemove, channelId null", (Object[])new Object[0]);
            }
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onRemove, channelId:%s", (Object[])new Object[]{this.mChannelId});
        }
        this.mDialogLinkManager.showDialog((BaseDialog)this.getProgressDialog());
        this.mViewModel.removeBlack(index, this.mChannelId, item.getUid(), new IChannelBlackResetCallback(this){
            final /* synthetic */ ChannelBlackListController this$0;

            public void onSuccess(int index) {
                block1: {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"ChannelBlackListController", (String)"onRemove success, channelId:%s", (Object[])new Object[]{ChannelBlackListController.access$getMChannelId$p(this.this$0)});
                    }
                    int roleType = RoomTrack.INSTANCE.getUserRole(ChannelBlackListController.access$getMChannelId$p(this.this$0));
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("30011901").put("function_id", "black_list_remove_click").put("room_id", ChannelBlackListController.access$getMChannelId$p(this.this$0)).put("user_role", String.valueOf(roleType)));
                    ChannelBlackListController.access$getMDialogLinkManager$p(this.this$0).dismissDialog();
                    ChannelBlackListWindow channelBlackListWindow = ChannelBlackListController.access$getMWindow$p(this.this$0);
                    if (channelBlackListWindow == null) break block1;
                    channelBlackListWindow.removeData(index);
                }
            }

            public void onFail(long code, @Nullable String reason) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"ChannelBlackListController", (String)"onRemove fail, channelId:%s, errorCode:%s", (Object[])new Object[]{ChannelBlackListController.access$getMChannelId$p(this.this$0), code});
                }
                ChannelBlackListController.access$getMDialogLinkManager$p(this.this$0).dismissDialog();
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public void onWindowShown(@Nullable AbstractWindow abstractWindow) {
        super.onWindowShown(abstractWindow);
        if (FP.empty((CharSequence)this.mChannelId)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"onWindowShown channelId null", (Object[])new Object[0]);
            }
            return;
        }
        this.mViewModel.getBlackListData(this.mChannelId);
    }

    public ChannelBlackListController(@NotNull Environment env) {
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        super(env);
        this.progressDialog$delegate = LazyKt.lazy((Function0)progressDialog.2.INSTANCE);
        this.mChannelId = "";
        this.mViewModel = new ChannelBlackListViewModel();
    }

    public static final /* synthetic */ ChannelBlackListWindow access$getMWindow$p(ChannelBlackListController $this) {
        return $this.mWindow;
    }

    public static final /* synthetic */ void access$setMWindow$p(ChannelBlackListController $this, ChannelBlackListWindow channelBlackListWindow) {
        $this.mWindow = channelBlackListWindow;
    }

    public static final /* synthetic */ String access$getMChannelId$p(ChannelBlackListController $this) {
        return $this.mChannelId;
    }

    public static final /* synthetic */ void access$setMChannelId$p(ChannelBlackListController $this, String string2) {
        $this.mChannelId = string2;
    }

    public static final /* synthetic */ DialogLinkManager access$getMDialogLinkManager$p(ChannelBlackListController $this) {
        return $this.mDialogLinkManager;
    }

    public static final /* synthetic */ void access$setMDialogLinkManager$p(ChannelBlackListController $this, DialogLinkManager dialogLinkManager) {
        $this.mDialogLinkManager = dialogLinkManager;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/hiyo/channel/component/setting/controller/ChannelBlackListController$Companion;", "", "()V", "TAG", "", "channel-components_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

