/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.seat.seattip;

import androidx.annotation.NonNull;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.SeatStatusUtils;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.base.service.ISeatService;
import com.yy.hiyo.channel.cbase.ChannelSettingFlag;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.component.seat.seattip.AbsSeatTipStrategy;
import com.yy.hiyo.channel.component.seat.seattip.SeatTipsPresenter;
import java.util.List;

class FirstTimeInviteBubbleStrategy
extends AbsSeatTipStrategy {
    public FirstTimeInviteBubbleStrategy(@NonNull SeatTipsPresenter seatPresenter) {
        super(seatPresenter);
    }

    @Override
    public boolean resolve() {
        return this.showGuideTip();
    }

    private boolean showGuideTip() {
        int index;
        boolean showed = ChannelSettingFlag.INSTANCE.getBoolean("key_showed_tips_when_first_enter_voice_room", false);
        if (!showed && (index = this.getFirstEmptySeat()) >= 0 && this.showTipsByIndexNow(index, ResourceUtils.getString((int)R.string.tips_seat_guide))) {
            ChannelSettingFlag.INSTANCE.putBoolean("key_showed_tips_when_first_enter_voice_room", true);
            return true;
        }
        return false;
    }

    private int getFirstEmptySeat() {
        ISeatService seatService = ((IChannelPageContext)this.getHost().getMvpContext()).getChannel().getSeatService();
        if (seatService.isMeInSeat()) {
            return -1;
        }
        IRoleService roleService = ((IChannelPageContext)this.getHost().getMvpContext()).getChannel().getRoleService();
        List seatList = seatService.getSeatList();
        for (int i = 0; i < seatList.size(); ++i) {
            SeatUser seat = (SeatUser)seatList.get(i);
            if (seat.index == 1 && !roleService.isOwnerOrMaster(AccountUtil.getUid()) || 0L != seat.uid || SeatStatusUtils.isLocked((long)seat.status)) continue;
            return i;
        }
        return -1;
    }
}

