/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.seat.holder;

import androidx.core.util.Pair;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.logger.MLog;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.cbase.channelhiido.ChannelTrack;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.component.seat.SafeLiveData;
import com.yy.hiyo.channel.component.seat.SeatPresenter;
import com.yy.hiyo.channel.component.seat.SeatTrack;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import com.yy.hiyo.channel.component.seat.holder.SeatMenu;
import com.yy.hiyo.channel.plugins.voiceroom.AbsRoomPage;
import com.yy.hiyo.channel.plugins.voiceroom.RoomPageContext;
import java.util.ArrayList;
import java.util.List;

public class SeatMenuPresenter
extends BaseChannelPresenter<AbsRoomPage, RoomPageContext> {
    private static final String TAG = "SeatMenuPresenter";
    protected MutableLiveData<Pair<Boolean, List<SeatMenu>>> mMenuData = new SafeLiveData();
    protected SeatItem mSeatItem;

    public void show(SeatItem data) {
        this.mSeatItem = data;
        this.mMenuData.setValue((Object)new Pair((Object)true, this.createMenu(data)));
    }

    public void hide() {
        this.mMenuData.setValue((Object)new Pair((Object)false, null));
    }

    private List<SeatMenu> createMenu(SeatItem data) {
        ArrayList<SeatMenu> list2 = new ArrayList<SeatMenu>();
        if (data.isLocked()) {
            SeatMenu menu;
            if (data.index != 1) {
                menu = new SeatMenu();
                menu.type = SeatMenu.MenuType.INVITE;
                menu.mTextId = R.string.short_tips_seat_menu_invite;
                menu.mDrawable = R.drawable.icon_seat_invit;
                list2.add(menu);
            }
            menu = new SeatMenu();
            menu.type = SeatMenu.MenuType.UNLOCK;
            menu.mTextId = R.string.short_tips_seat_menu_unlock;
            menu.mDrawable = R.drawable.icon_seat_unlock;
            list2.add(menu);
        } else {
            SeatMenu menu;
            if (data.index != 1) {
                menu = new SeatMenu();
                menu.type = SeatMenu.MenuType.INVITE;
                menu.mTextId = R.string.short_tips_seat_menu_invite;
                menu.mDrawable = R.drawable.icon_seat_invit;
                list2.add(menu);
            }
            if (data.index != 1) {
                menu = new SeatMenu();
                menu.type = SeatMenu.MenuType.LOCK;
                menu.mTextId = R.string.short_tips_seat_menu_lock;
                menu.mDrawable = R.drawable.icon_seat_lock_white;
                list2.add(menu);
            }
            menu = new SeatMenu();
            menu.type = SeatMenu.MenuType.SEAT;
            menu.mDrawable = R.drawable.icon_seat;
            menu.mTextId = this.getChannel().getSeatService().isInSeat(AccountUtil.getUid()) ? R.string.btn_change_seat : R.string.btn_profile_card_sit;
            list2.add(menu);
        }
        return list2;
    }

    public LiveData<Pair<Boolean, List<SeatMenu>>> getMenuData() {
        return this.mMenuData;
    }

    public void onMenuItemClick(SeatMenu item) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onMenuItemClick %s", (Object[])new Object[]{item});
        }
        this.hide();
        switch (item.type) {
            case LOCK: {
                ((SeatPresenter)this.getPresenter(SeatPresenter.class)).onLockClick(this.mSeatItem);
                SeatTrack.INSTANCE.hostLockClick(this.getChannel().getChannelId());
                break;
            }
            case SEAT: {
                ((SeatPresenter)this.getPresenter(SeatPresenter.class)).onSitDown(this.mSeatItem.index, null);
                ChannelTrack.INSTANCE.onChangeSeatClick();
                break;
            }
            case INVITE: {
                ((SeatPresenter)this.getPresenter(SeatPresenter.class)).onOpenInviteList(this.mSeatItem);
                SeatTrack.INSTANCE.onHostClickInvite(this.getChannel().getChannelId(), this.getChannel().getPluginService().getCurPluginData().getPluginId());
                break;
            }
            case UNLOCK: {
                ((SeatPresenter)this.getPresenter(SeatPresenter.class)).onUnLockClick(this.mSeatItem);
                SeatTrack.INSTANCE.onHostClickUnlock(this.getChannel().getChannelId(), this.getChannel().getPluginService().getCurPluginData().getPluginId());
                break;
            }
        }
    }

    public void clearData() {
        this.mMenuData.setValue(null);
    }
}

