/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.seat.holder;

import android.content.Context;
import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import androidx.lifecycle.LifecycleOwner;
import com.yy.appbase.ui.widget.bubble.BubbleLinearLayout;
import com.yy.appbase.ui.widget.bubble.BubblePopupWindow;
import com.yy.appbase.ui.widget.bubble.BubbleStyle;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.component.seat.holder.SeatMenu;
import com.yy.hiyo.channel.component.seat.holder.SeatMenuItemView;
import com.yy.hiyo.channel.component.seat.holder.SeatMenuPresenter;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SeatMenuContainer
extends YYFrameLayout {
    private BubblePopupWindow mPopupWindow;
    private View mAnchorView;
    private SeatMenuPresenter mPresenter;

    public SeatMenuContainer(Context context) {
        super(context);
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
    }

    public void setPresenter(View anchorView, SeatMenuPresenter presenter) {
        this.mAnchorView = anchorView;
        this.mPresenter = presenter;
        presenter.getMenuData().observe((LifecycleOwner)presenter.getLifeCycleOwner(), data -> {
            if (data != null && Boolean.TRUE.equals(data.first)) {
                this.showMenu((List)data.second);
            } else {
                this.hideMenu();
            }
        });
    }

    public void destroy() {
        this.hideMenu();
    }

    private void hideMenu() {
        if (this.mPopupWindow != null) {
            this.mPopupWindow.dismiss();
            this.mPopupWindow = null;
            this.mPresenter.getMenuData().removeObservers((LifecycleOwner)this.mPresenter.getLifeCycleOwner());
            this.mPresenter.clearData();
        }
    }

    private void showMenu(List<SeatMenu> menus) {
        if (this.mPopupWindow == null) {
            if (this.getParent() instanceof ViewGroup) {
                ((ViewGroup)this.getParent()).removeView((View)this);
            }
            View contentView = this.createMenuLayout(menus);
            BubbleLinearLayout bubbleStyle = (BubbleLinearLayout)contentView.findViewById(R.id.seat_bubble);
            this.mPopupWindow = new BubblePopupWindow((View)this, (BubbleStyle)bubbleStyle);
            this.mPopupWindow.setOnDismissListener(this::hideMenu);
            this.setVisibility(4);
            this.addView(contentView, -2, -2);
            this.mPopupWindow.showArrowTo(this.mAnchorView, BubbleStyle.ArrowDirection.Up);
            this.postDelayed(() -> {
                this.setVisibility(0);
                this.invalidate();
            }, 100L);
        }
    }

    @NotNull
    private View createMenuLayout(List<SeatMenu> menus) {
        View contentView = View.inflate((Context)this.getContext(), (int)R.layout.seat_menu_new_channel, null);
        BubbleLinearLayout bubbleStyle = (BubbleLinearLayout)contentView.findViewById(R.id.seat_bubble);
        bubbleStyle.setFillColor(Color.parseColor((String)"#e6272735"));
        bubbleStyle.setCornerRadius((float)ResolutionUtils.dip2Px((float)10.0f));
        for (SeatMenu item : menus) {
            SeatMenuItemView itemView = new SeatMenuItemView(this.getContext());
            itemView.setData(item);
            itemView.setOnClickListener(v -> this.mPresenter.onMenuItemClick(item));
            bubbleStyle.addView((View)itemView, -1, ResolutionUtils.dip2Px((float)40.0f));
        }
        return contentView;
    }
}

