/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.seat.holder;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Paint;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import androidx.annotation.ColorInt;
import androidx.interpolator.view.animation.LinearOutSlowInInterpolator;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import com.bumptech.glide.load.DataSource;
import com.opensource.svgaplayer.SVGAImageView;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.appbase.degrade.ISceneDegradedService;
import com.yy.appbase.degrade.ISceneOptLimiter;
import com.yy.appbase.degrade.ISceneOptLimiterCallback;
import com.yy.appbase.degrade.SimpleSceneOptLimiterCallback;
import com.yy.appbase.kvo.HeadFrameType;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IHonorService;
import com.yy.appbase.service.OnGetHeadFrameCallback;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.appbase.ui.press.PressAlpha;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.appbase.ui.widget.headframe.HeadFrameImageView;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.ui.widget.waveview.WaveView;
import com.yy.appbase.unifyconfig.config.SceneOptConfigItem;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.hiyo.channel.DR;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.callback.ICalculatorCallback;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.tools.ICalculatorView;
import com.yy.hiyo.channel.cbase.tools.IRevenueToolsModulePresenter;
import com.yy.hiyo.channel.component.base.util.PrivilegeHelper;
import com.yy.hiyo.channel.component.seat.SeatMvp;
import com.yy.hiyo.channel.component.seat.SeatPresenter;
import com.yy.hiyo.channel.component.seat.SeatTrack;
import com.yy.hiyo.channel.component.seat.bean.SeatGoldenAnimInfo;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import com.yy.hiyo.channel.component.seat.holder.SeatMenuContainer;
import com.yy.hiyo.channel.component.seat.holder.SeatMenuPresenter;
import com.yy.hiyo.channel.component.seat.widget.StrokeTextView;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.dyres.api.IDRCallback;
import com.yy.hiyo.mvp.base.callback.IDestroyable;
import com.yy.hiyo.mvp.base.callback.WeakCallback;
import java.util.List;
import okhttp3.Call;
import org.jetbrains.annotations.NotNull;

public class SeatItemHolder<T extends SeatItem>
extends BaseItemBinder.ViewHolder<T> {
    private static final String IMAGE_POSTFIX = YYImageUtils.getThumbnailPostfix((int)75);
    private IChannelPageContext mRoomPageContext;
    private static final String TAG = "FTVoiceRoomSeat_SeatItemHolder";
    private static final int LEAVE_COLOR = Color.parseColor((String)"#cccccc");
    private static final int NORMAL_COLOR = Color.parseColor((String)"#ffc102");
    @ColorInt
    private static final int SPEAK_COLOR = Color.parseColor((String)"#28d5a5");
    @ColorInt
    private static final int HOST_SPEAK_COLOR = Color.parseColor((String)"#ffc102");
    private static final int INDEX_SIZE = ResolutionUtils.dip2Px((float)15.0f);
    protected RecycleImageView mMicIcon;
    protected StrokeTextView mNickName;
    protected YYTextView mSeatIndexView;
    protected HeadFrameImageView mAvatar;
    protected RecycleImageView mReadyIcon;
    private SeatMvp.IView.OnSeatItemListener mOnSeatItemListener;
    private String mRoomId;
    protected WaveView mSpeakAnimView;
    private SVGAImageView mGoldenBeanSvga;
    private Animation mLightAnim;
    private static int SEAT_FIRST = 0;
    private static final int SEAT_NORMAL = 1;
    private int seatCalculator = 1;
    private HeadFrameType mHeadFrameType;
    private SVGAImageView mLevelUpView;
    private String mAvatarUrl = null;
    protected ICalculatorView mCalculatorView;
    private YYPlaceHolderView mPlaceHolderView;
    private SeatMenuContainer menuContainer;
    private ISceneOptLimiter<Boolean> mSceneOptLimiter = null;
    private Observer<String> nickNameColorObserver = color2 -> {
        if (StringUtils.isNotEmpty((String)color2) && null != this.mNickName) {
            this.mNickName.setTextColor(ColorUtils.parseColor((String)color2));
        }
    };
    private Observer<Boolean> nobleNickNameColorObserver = isNoble -> {
        if (this.mNickName != null) {
            if (isNoble.booleanValue()) {
                this.mNickName.setStrokeWidth(ResolutionUtils.dip2Px((float)1.0f));
                this.mNickName.setTextColor(ColorUtils.parseColor((String)"#FF4A6D"));
                this.mNickName.setStrokeColor(-1);
                this.mNickName.setNeedStroke(true);
            } else {
                this.mNickName.setTextColor(-1);
                this.mNickName.setNeedStroke(false);
            }
        }
    };

    private void initSceneOptLimiter() {
        if (this.mSceneOptLimiter == null && ServiceManagerProxy.getService(ISceneDegradedService.class) != null) {
            this.mSceneOptLimiter = ((ISceneDegradedService)ServiceManagerProxy.getService(ISceneDegradedService.class)).createLimiter("seat", (ISceneOptLimiterCallback)new SimpleSceneOptLimiterCallback<Boolean>(){

                public void onAppendItem(Boolean item) {
                }

                public void onStopAnimate() {
                    if (SeatItemHolder.this.staticImgSvgaSwitch()) {
                        SeatItemHolder.this.mAvatar.getFrameSvga().stepToPercentage(0.5, false);
                    }
                }

                public void onRecoverAnimate() {
                    if (SeatItemHolder.this.staticImgSvgaSwitch()) {
                        SeatItemHolder.this.mAvatar.getFrameSvga().stepToPercentage(-1.0, false);
                        SeatItemHolder.this.mAvatar.getFrameSvga().startAnimation();
                    }
                }
            });
        }
    }

    public SeatItemHolder(View itemView, IChannelPageContext context) {
        super(itemView);
        this.initView();
        this.mRoomPageContext = context;
    }

    private void initView() {
        this.mSpeakAnimView = (WaveView)this.itemView.findViewById(R.id.speak_anim);
        this.mSpeakAnimView.setDuration(2000L);
        this.mSpeakAnimView.setStyle(Paint.Style.FILL);
        this.mSpeakAnimView.setMaxRadiusRate(1.4f);
        this.mSpeakAnimView.setInterpolator((Interpolator)new LinearOutSlowInInterpolator());
        this.mSpeakAnimView.setInitialRadius((float)(ResourceUtils.getDimen((int)R.dimen.seat_item_size) / 2));
        this.mPlaceHolderView = (YYPlaceHolderView)this.itemView.findViewById(R.id.ll_calculator);
        this.mAvatar = (HeadFrameImageView)this.itemView.findViewById(R.id.avatar);
        this.mSeatIndexView = (YYTextView)this.itemView.findViewById(R.id.seat_index);
        this.mNickName = (StrokeTextView)this.itemView.findViewById(R.id.nick_name);
        this.mMicIcon = (RecycleImageView)this.itemView.findViewById(R.id.micIcon);
        this.mReadyIcon = (RecycleImageView)this.itemView.findViewById(R.id.ready_icon);
        this.mGoldenBeanSvga = (SVGAImageView)this.itemView.findViewById(R.id.golden_bean_svga);
        this.mLevelUpView = (SVGAImageView)this.itemView.findViewById(R.id.level_up_svga);
        this.mAvatar.setOnClickListener(v -> {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"item on click %s", (Object[])new Object[]{this.getData()});
            }
            if (((SeatItem)this.getData()).hasUser()) {
                this.mOnSeatItemListener.onAvatarClick((SeatItem)this.getData());
            } else {
                ((SeatPresenter)this.mRoomPageContext.getPresenter(SeatPresenter.class)).checkManagerPermission((Callback<Boolean>)WeakCallback.of((IDestroyable)this.mRoomPageContext, hasPermission -> {
                    if (Boolean.TRUE.equals(hasPermission)) {
                        this.showMenu();
                        SeatTrack.INSTANCE.hostBlankClick(this.mRoomId);
                    } else if (!((SeatItem)this.getData()).isLocked()) {
                        this.mOnSeatItemListener.onSitDown(((SeatItem)this.getData()).index, null);
                    } else {
                        ToastUtils.showToast((Context)this.itemView.getContext(), (int)(((SeatItem)this.getData()).index == 1 ? R.string.tips_seat_locked_sub_group : R.string.tips_room_bean_locked));
                    }
                }));
            }
        });
        this.mHeadFrameType = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getHeadFrameType();
        Kvo.addKvoBinding((KvoSource)this.mHeadFrameType, (Object)((Object)this), (String)"onMyHeadFrameTypeUpdate");
        this.initSceneOptLimiter();
    }

    private boolean staticImgSvgaSwitch() {
        if (ServiceManagerProxy.getService(ISceneDegradedService.class) == null) {
            return false;
        }
        SceneOptConfigItem sceneConfig = ((ISceneDegradedService)ServiceManagerProxy.getService(ISceneDegradedService.class)).getConfigItem("seat");
        if (sceneConfig != null) {
            return sceneConfig.unconventionalSwitchOn;
        }
        return false;
    }

    private void showMenu() {
        SeatMenuPresenter presenter = (SeatMenuPresenter)this.mRoomPageContext.getPresenter(SeatMenuPresenter.class);
        SeatMenuContainer menuContainer = new SeatMenuContainer(this.mSeatIndexView.getContext());
        menuContainer.setPresenter((View)this.mSeatIndexView, presenter);
        presenter.show((SeatItem)this.getData());
        this.menuContainer = menuContainer;
    }

    @KvoMethodAnnotation(name="headFrameType", sourceClass=HeadFrameType.class)
    public void onMyHeadFrameTypeUpdate(KvoEventIntent event) {
        if (this.getData() == null) {
            return;
        }
        if (((SeatItem)this.getData()).uid != AccountUtil.getUid()) {
            return;
        }
        if (this.mAvatar != null) {
            IHonorService.HeadFrame headFrameUrlFromCache;
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTHeadFrame", (String)"SeatItemHolder onMyHeadFrameTypeUpdate:%s", (Object[])new Object[]{(int)((HeadFrameType)event.source()).headFrameType});
            }
            if ((headFrameUrlFromCache = ((IHonorService)ServiceManagerProxy.getServiceManager().getService(IHonorService.class)).getHeadFrameFromCache((int)((HeadFrameType)event.source()).headFrameType)) != null && StringUtils.isNotEmpty((String)headFrameUrlFromCache.url) && !headFrameUrlFromCache.onlyBBS) {
                this.mAvatar.setHeadFrame(headFrameUrlFromCache.url, 0.9f);
            } else {
                this.mAvatar.setHeadFrame("");
            }
        }
    }

    public void setRoomId(String roomId) {
        this.mRoomId = roomId;
        if (this.mCalculatorView != null) {
            this.mCalculatorView.setRoomId(roomId);
        }
    }

    public void setData(T data) {
        super.setData(data);
        if (this.mCalculatorView == null) {
            this.mCalculatorView = ((IRevenueToolsModulePresenter)this.mRoomPageContext.getPresenter(IRevenueToolsModulePresenter.class)).setPlaceView(this.mPlaceHolderView);
        }
        if (RuntimeContext.sIsDebuggable && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"setData holder hasUser %b, %s, item view %s, %s", (Object[])new Object[]{((SeatItem)data).hasUser(), this, this.itemView, data});
        }
        boolean isAvatarChanged = FP.empty((CharSequence)this.mAvatarUrl) || !StringUtils.equals((String)this.mAvatarUrl, (String)((SeatItem)data).userInfo.avatar);
        MLog.debug((Object)TAG, (String)"hashCode %s, mAvatarUrl %s, data.userInfo.avatar %s", (Object[])new Object[]{((Object)((Object)this)).hashCode(), this.mAvatarUrl, ((SeatItem)data).userInfo.avatar});
        this.mAvatarUrl = ((SeatItem)data).userInfo.avatar;
        if (RuntimeContext.sIsDebuggable && ((SeatItem)data).uid > 0L && !((SeatItem)data).hasUser()) {
            throw new RuntimeException("SeatItemHolder user data error data:" + ((SeatItem)data).toString());
        }
        if (((SeatItem)data).hasUser()) {
            if (isAvatarChanged || !StringUtils.equal((String)String.valueOf(this.mAvatar.getTag(R.id.avatar)), (String)this.mAvatarUrl)) {
                int defaultAvatar = ((SeatItem)data).userInfo.isFemale() ? R.drawable.icon_avatar_default_female_medium : R.drawable.icon_avatar_default_male_medium;
                this.setHeadFrame(((SeatItem)data).uid);
                ImageLoader.Builder.obtain((RecycleImageView)this.mAvatar.getCircleImageView(), (String)(((SeatItem)data).userInfo.avatar + IMAGE_POSTFIX)).placeholder(ResourceUtils.getDrawable((int)defaultAvatar)).error(defaultAvatar).setListener(new ImageLoader.ImageLoadListener(){

                    public void onLoadFailed(Exception e) {
                        SeatItemHolder.this.mAvatar.setTag(R.id.avatar, (Object)"");
                    }

                    public void onResourceReady(Object resource, boolean isFromMemoryCache, DataSource dataSource) {
                        SeatItemHolder.this.mAvatar.setTag(R.id.avatar, (Object)SeatItemHolder.this.mAvatarUrl);
                    }
                }).load();
            }
            PressAlpha.of((View)this.mAvatar.getCircleImageView(), (float)1.0f);
            this.mSeatIndexView.getLayoutParams().width = INDEX_SIZE;
            this.mSeatIndexView.getLayoutParams().height = INDEX_SIZE;
            if (this.isHostSeat()) {
                this.updateHost((SeatItem)data);
            } else {
                this.mAvatar.setLeaveViewVisibility(false);
                this.mAvatar.getCircleImageView().setBorderColor(((SeatItem)data).isSpeaking ? SPEAK_COLOR : 0);
                this.updateIndex();
            }
            this.updateReadyIcon();
            this.mNickName.setVisibility(0);
            this.mNickName.setText(((SeatItem)data).userInfo.nick);
            if (PrivilegeHelper.INSTANCE.getNickColorConfig(((SeatItem)data).uid) != null && StringUtils.isNotEmpty((String)PrivilegeHelper.INSTANCE.getNickColorConfig(((SeatItem)data).uid).getColor())) {
                this.mNickName.setTextColor(ColorUtils.parseColor((String)PrivilegeHelper.INSTANCE.getNickColorConfig(((SeatItem)data).uid).getColor()));
            }
            SeatPresenter presenter = (SeatPresenter)this.mRoomPageContext.getPresenter(SeatPresenter.class);
            ((SeatItem)data).nickNameColor.removeObserver(this.nickNameColorObserver);
            ((SeatItem)data).nickNameColor.observe((LifecycleOwner)presenter.getMvpContext().getLifecycleOwner(), this.nickNameColorObserver);
            ((SeatItem)data).isNoble.removeObserver(this.nobleNickNameColorObserver);
            ((SeatItem)data).isNoble.observe((LifecycleOwner)presenter.getMvpContext().getLifecycleOwner(), this.nobleNickNameColorObserver);
            this.updateMic((SeatItem)data);
        } else {
            this.mNickName.setTextColor(-1);
            this.mAvatar.setHeadFrame("", 0.9f);
            this.mAvatar.setLeaveViewVisibility(false);
            this.mAvatar.getCircleImageView().setBorderColor(0);
            this.updateLock((SeatItem)data);
            PressAlpha.of((View)this.mAvatar, (float)0.2f);
            this.mNickName.setVisibility(this.isHostSeat() ? 0 : 8);
            if (this.isHostSeat()) {
                this.mNickName.setNeedStroke(false);
                this.mNickName.setText(ResourceUtils.getString((int)R.string.short_tips_channel_host));
            }
            this.mMicIcon.setVisibility(8);
            this.mReadyIcon.setVisibility(8);
            this.updateIndex();
        }
        this.initSeatHeight((SeatItem)data);
        boolean isHatOpen = false;
        if (this.mCalculatorView != null) {
            if (this.mRoomPageContext != null) {
                isHatOpen = this.mRoomPageContext.getChannel().getCalculatorService().isHatOpen();
                this.mCalculatorView.setHatOpen(isHatOpen);
            }
            this.mCalculatorView.initData(data);
        }
        if (((SeatItem)data).payLoad != null) {
            this.updatePayload(((SeatItem)data).payLoad);
        }
        if (((SeatItem)data).isSpeaking) {
            this.startSpeakAnim();
        } else {
            this.stopSpeakAnim();
        }
        if (!isHatOpen && ((SeatItem)data).mCalculatorData.isUp() || isHatOpen && ((SeatItem)data).mCalculatorData.isHatUp()) {
            ((SeatItem)data).mCalculatorData.setUp(false);
            ((SeatItem)data).mCalculatorData.setHatUp(false);
            if (this.mLevelUpView != null) {
                DyResLoader.INSTANCE.loadSvga(this.mLevelUpView, DR.calculator_level_up, true);
            }
        }
    }

    protected boolean isHostSeat() {
        return ((SeatItem)this.getData()).index == 1;
    }

    private void setHeadFrame(final long headUid) {
        ((IHonorService)ServiceManagerProxy.getServiceManager().getService(IHonorService.class)).getSingleHeadFrame(headUid, new OnGetHeadFrameCallback(){
            long uid;
            {
                this.uid = headUid;
            }

            public void onGetHeadFrameSuccess(List<Integer> list2) {
                if (list2 == null) {
                    FeatureLog.i((String)"FTHeadFrame", (String)"SeatItemHolder getSingleHeadFrame list null", (Object[])new Object[0]);
                    return;
                }
                if (list2.size() == 0) {
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTHeadFrame", (String)"SeatItemHolder getSingleHeadFrame list size 0", (Object[])new Object[0]);
                    }
                    return;
                }
                if (SeatItemHolder.this.mAvatar != null) {
                    IHonorService.HeadFrame headFrameFromCache;
                    if (RuntimeContext.sIsDebuggable && FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTHeadFrame", (String)"SeatItemHolder getSingleHeadFrame uid:%s, headFrame:%s", (Object[])new Object[]{this.uid, list2.get(0)});
                    }
                    if ((headFrameFromCache = ((IHonorService)ServiceManagerProxy.getServiceManager().getService(IHonorService.class)).getHeadFrameFromCache(list2.get(0).intValue())) != null && StringUtils.isNotEmpty((String)headFrameFromCache.url) && !headFrameFromCache.onlyBBS) {
                        SeatItemHolder.this.mAvatar.setHeadFrame(headFrameFromCache.url, 0.9f);
                    } else {
                        SeatItemHolder.this.mAvatar.setHeadFrame("");
                    }
                }
            }

            public void onError(Call call, Exception e, int id2) {
                FeatureLog.e((String)"FTHeadFrame", (String)"SeatItemHolder getSingleHeadFrame exception:%s", (Object[])new Object[]{e});
            }

            public void onResponseError(int id2, String message, String response) {
                FeatureLog.e((String)"FTHeadFrame", (String)"SeatItemHolder getSingleHeadFrame message:%s", (Object[])new Object[]{message});
            }
        });
    }

    private void updatePayload(Object payLoad) {
        if (payLoad instanceof SeatGoldenAnimInfo) {
            this.startGoldenBeanSvgaAnim();
        }
        ((SeatItem)this.getData()).payLoad = null;
    }

    private void initSeatHeight(SeatItem data) {
        if (this.getBaseItemView() == null) {
            return;
        }
        ViewGroup.LayoutParams layoutParams = this.getBaseItemView().getLayoutParams();
        layoutParams.height = this.getSeatHeight(data);
    }

    protected int getSeatHeight(SeatItem data) {
        return data.mCalculatorData.isNeedLarge() ? ResolutionUtils.dip2Px((float)96.0f) : ResolutionUtils.dip2Px((float)76.0f);
    }

    protected View getBaseItemView() {
        return this.itemView;
    }

    private void updateLock(SeatItem data) {
        int lockDrawable = R.drawable.bg_seat_lock;
        ImageLoader.Builder.obtain((RecycleImageView)this.mAvatar.getCircleImageView(), (String)"", (int)(data.isLocked() ? lockDrawable : R.drawable.room_seat_add)).load();
    }

    private void updateMic(SeatItem data) {
        if (data.isMicForbidden()) {
            this.mMicIcon.setVisibility(0);
            this.mMicIcon.setImageResource(R.drawable.icon_voiceforbid);
        } else if (!data.isMicOpen()) {
            this.mMicIcon.setImageResource(R.drawable.icon_voiceoff);
            this.mMicIcon.setVisibility(0);
        } else {
            this.mMicIcon.setVisibility(8);
        }
    }

    protected void updateReadyIcon() {
        boolean isReady = ((SeatItem)this.getData()).isGameReady();
        if (isReady) {
            this.mReadyIcon.setVisibility(0);
            this.mReadyIcon.setImageResource(R.drawable.icon_seat_ready);
        } else {
            this.mReadyIcon.setVisibility(8);
        }
    }

    private void updateHost(SeatItem data) {
        this.mAvatar.setLeaveViewVisibility(false);
        this.mAvatar.getCircleImageView().setBorderColor(NORMAL_COLOR);
        if (data.roleType == 15) {
            this.mSeatIndexView.setVisibility(this.getData() != null && ((SeatItem)this.getData()).hasUser() ? 0 : 4);
            this.mSeatIndexView.setBackgroundResource(R.drawable.icon_seat_host);
        } else if (data.roleType == 10) {
            this.mSeatIndexView.setVisibility(0);
            this.mSeatIndexView.setBackgroundResource(R.drawable.icon_seat_administorter);
        } else {
            this.mSeatIndexView.setVisibility(this.getData() != null && ((SeatItem)this.getData()).hasUser() ? 0 : 4);
            this.mSeatIndexView.setBackgroundResource(R.drawable.icon_room_host);
        }
        if (this.mSeatIndexView.getVisibility() == 4) {
            this.mSeatIndexView.getLayoutParams().width = -2;
            this.mSeatIndexView.getLayoutParams().height = -2;
            this.mSeatIndexView.setBackgroundResource(0);
        } else {
            this.mSeatIndexView.getLayoutParams().width = INDEX_SIZE;
            this.mSeatIndexView.getLayoutParams().height = INDEX_SIZE;
        }
        this.mSeatIndexView.setText(null);
    }

    public void setOnSeatItemListener(SeatMvp.IView.OnSeatItemListener onSeatItemListener) {
        this.mOnSeatItemListener = onSeatItemListener;
        if (this.mCalculatorView != null) {
            this.mCalculatorView.setOnSeatItemListener((ICalculatorCallback)this.mOnSeatItemListener);
        }
    }

    public void startSpeakAnim() {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"startSpeakAnim %d", (Object[])new Object[]{((SeatItem)this.getData()).index});
        }
        this.mSpeakAnimView.setColor(this.isHostSeat() ? HOST_SPEAK_COLOR : SPEAK_COLOR);
        this.mSpeakAnimView.start();
        this.mAvatar.getCircleImageView().setBorderColor(this.isHostSeat() ? HOST_SPEAK_COLOR : SPEAK_COLOR);
    }

    public void stopSpeakAnim() {
        if (!MLog.isLogLevelAboveDebug() && this.getData() != null) {
            MLog.debug((Object)TAG, (String)"stopSpeakAnim %d", (Object[])new Object[]{((SeatItem)this.getData()).index});
        }
        this.mSpeakAnimView.stop();
    }

    private void updateIndex() {
        SeatItem data = (SeatItem)this.getData();
        if (this.isHostSeat()) {
            this.updateHost((SeatItem)this.getData());
        } else {
            this.mSeatIndexView.setVisibility(0);
            if (((SeatItem)this.getData()).hasUser()) {
                this.mSeatIndexView.setTextSize(10.0f);
                this.mSeatIndexView.setBackgroundResource(R.drawable.room_seat_index);
                this.mSeatIndexView.getBackground().setLevel(data.userInfo.isFemale() ? 0 : 1);
                this.mSeatIndexView.setText((CharSequence)String.valueOf(data.index));
            } else {
                this.mSeatIndexView.setTextSize(12.0f);
                this.mSeatIndexView.getLayoutParams().width = -2;
                this.mSeatIndexView.getLayoutParams().height = -2;
                this.mSeatIndexView.setBackgroundResource(0);
                this.mSeatIndexView.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_seat_index, (Object[])new Object[]{data.index}));
            }
        }
    }

    public void onViewDetach() {
        super.onViewDetach();
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"onPageDetach %s", (Object[])new Object[]{this});
        }
        this.mSpeakAnimView.stopImmediately();
        if (this.mHeadFrameType != null) {
            Kvo.removeKvoBinding((KvoSource)this.mHeadFrameType, (Object)((Object)this), (String)"onMyHeadFrameTypeUpdate");
        }
    }

    public CircleImageView getAvatar() {
        return this.mAvatar.getCircleImageView();
    }

    public void startGoldenBeanSvgaAnim() {
        DyResLoader.INSTANCE.getResFilePath(DR.gift_golden_bean_guide, new IDRCallback(){

            public void onFailed(@NotNull String msg) {
            }

            public void onSucceed(@NotNull String filePath) {
                if (SeatItemHolder.this.mGoldenBeanSvga != null) {
                    SeatItemHolder.this.mGoldenBeanSvga.setLoopCount(1);
                    SvgaLoader.load((SVGAImageView)SeatItemHolder.this.mGoldenBeanSvga, (String)filePath, (boolean)true);
                    SettingFlags.setBoolean((String)"key_show_goden_beans_svga", (boolean)true);
                }
            }
        });
    }

    public void destroy() {
        if (this.menuContainer != null) {
            this.menuContainer.destroy();
        }
        if (this.mCalculatorView != null) {
            this.mCalculatorView.setOnSeatItemListener(null);
            this.mCalculatorView.destroy();
            this.mCalculatorView = null;
        }
        if (this.mSceneOptLimiter != null) {
            this.mSceneOptLimiter.destroy();
            this.mSceneOptLimiter = null;
        }
    }
}

