/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.seat;

import android.content.Context;
import android.graphics.Point;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.hiyo.channel.component.seat.ISeatViewWrapper;
import com.yy.hiyo.channel.component.seat.SeatMvp;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SeatViewContainer
extends YYLinearLayout
implements SeatMvp.IView {
    private static final String TAG = "FTVoiceRoomSeat_SeatView";
    private Handler mMainHandler = new Handler();
    private Object updateSeatPostToken = new Object();
    private SeatMvp.IPresenter mPresenter;
    private int[] mViewPosition = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE};
    private Runnable mCheckLocationRunnable;
    private ISeatViewWrapper mSeatViewWrapper;

    public SeatViewContainer(Context context) {
        super(context);
    }

    public SeatViewContainer(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public SeatViewContainer(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setSeatView(ISeatViewWrapper seatViewWrapper) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"setSeatViewsetSeatView mSeatViewWrapper %s, realSeatView %s, mPresenter %s", (Object[])new Object[]{this.mSeatViewWrapper, seatViewWrapper, this.mPresenter});
        }
        if (this.mSeatViewWrapper != seatViewWrapper && seatViewWrapper != null) {
            this.mSeatViewWrapper = seatViewWrapper;
            this.removeAllViews();
            this.mSeatViewWrapper.createView(this.getContext(), (ViewGroup)this);
            this.mSeatViewWrapper.setOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    SeatViewContainer.this.updateSeatViewLocation();
                }
            });
            if (this.mPresenter != null) {
                this.mSeatViewWrapper.setPresenter(this.mPresenter);
            }
        }
    }

    public void setPresenter(SeatMvp.IPresenter presenter) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"setPresenter presenter %s, SeatViewWrapper %s", (Object[])new Object[]{presenter, this.mSeatViewWrapper});
        }
        this.mPresenter = presenter;
        if (this.mSeatViewWrapper != null) {
            this.mSeatViewWrapper.setPresenter(presenter);
        }
        this.initObserver(presenter);
    }

    @Override
    public int getSeatFaceSize() {
        if (this.mSeatViewWrapper != null) {
            return this.mSeatViewWrapper.getSeatFaceSize();
        }
        return 0;
    }

    @Override
    public int[] getSeatViewPosition() {
        return this.mViewPosition;
    }

    private void initObserver(final SeatMvp.IPresenter presenter) {
        presenter.canCalculateSeatLocation().observe((LifecycleOwner)presenter.getMvpContext().getLifecycleOwner(), canCalculate -> {
            if (canCalculate == null) {
                return;
            }
            if (Boolean.TRUE.equals(canCalculate)) {
                this.updateSeatViewLocation();
            } else {
                presenter.updateSeatViewLocation(null, null);
            }
        });
        presenter.seats().observe((LifecycleOwner)presenter.getMvpContext().getLifecycleOwner(), (Observer)new Observer<List<SeatItem>>(){

            public void onChanged(@Nullable List<SeatItem> data) {
                if (!FP.empty((Collection)((Collection)presenter.seats().getValue()))) {
                    SeatViewContainer.this.updateSeats((List)presenter.seats().getValue());
                }
            }
        });
        presenter.updateOne().observe((LifecycleOwner)presenter.getMvpContext().getLifecycleOwner(), (Observer)new Observer<Integer>(){

            public void onChanged(@Nullable Integer index) {
                List itemList;
                if (index != null && !FP.empty((Collection)(itemList = (List)presenter.seats().getValue())) && index >= 0 && index < itemList.size()) {
                    SeatViewContainer.this.updateSeat(index, (SeatItem)itemList.get(index));
                }
            }
        });
        presenter.getClipViewData().observe((LifecycleOwner)presenter.getLifeCycleOwner(), (Observer)new Observer<Boolean>(){

            public void onChanged(@Nullable Boolean clip) {
                if (Boolean.TRUE.equals(clip)) {
                    SeatViewContainer.this.setClip(true);
                } else {
                    SeatViewContainer.this.setClip(false);
                }
            }
        });
    }

    @Override
    public void updateSeats(List<SeatItem> seatItems) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"updateSeats %s", (Object[])new Object[]{seatItems});
        }
        Runnable updateSeatRunnable = () -> {
            if (this.mSeatViewWrapper != null) {
                this.mSeatViewWrapper.updateSeats(seatItems);
            }
            this.post((Runnable)new YYTaskExecutor.RunnableEx(){

                public void run() {
                    SeatViewContainer.this.updateSeatViewLocation();
                }
            });
        };
        try {
            this.mMainHandler.removeCallbacksAndMessages(this.updateSeatPostToken);
            updateSeatRunnable.run();
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"updateSeats: ", (Throwable)e, (Object[])new Object[0]);
            this.mMainHandler.postAtTime(updateSeatRunnable, this.updateSeatPostToken, 0L);
        }
    }

    @Override
    public void updateSeat(int position, SeatItem data) {
        if (this.mSeatViewWrapper != null) {
            this.mSeatViewWrapper.updateSeat(position, data);
        }
        this.updateSeatViewLocation();
    }

    public View getInnerView() {
        if (this.mSeatViewWrapper != null) {
            return this.mSeatViewWrapper.getRealSeatView();
        }
        return null;
    }

    @Override
    public Map<Long, Point> getSeatViewLoaction(boolean isAbsolute) {
        if (this.mSeatViewWrapper != null) {
            return this.mSeatViewWrapper.getSeatViewLoaction(isAbsolute);
        }
        return null;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeCallbacks(this.mCheckLocationRunnable);
    }

    public void updateSeatViewLocation() {
        MLog.debug((Object)TAG, (String)"updateSeatViewLocation mSeatViewWrapper %s, mPresenter %s", (Object[])new Object[]{this.mSeatViewWrapper, this.mPresenter});
        if ((this.mPresenter != null || RuntimeContext.isInGray()) && MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"can calculate seat location: %s", (Object[])new Object[]{this.mPresenter != null ? this.mPresenter.canCalculateSeatLocation().getValue() : "presenter is null"});
        }
        if (this.mPresenter != null && Boolean.FALSE.equals(this.mPresenter.canCalculateSeatLocation().getValue())) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"seat is gone,can not calculate location.", (Object[])new Object[0]);
            }
            return;
        }
        if (this.mSeatViewWrapper != null && this.mSeatViewWrapper.getVisibility() == 0) {
            if (this.mCheckLocationRunnable == null) {
                this.mCheckLocationRunnable = new Runnable(){

                    @Override
                    public void run() {
                        if (RuntimeContext.isInGray() && MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)SeatViewContainer.TAG, (String)"updateSeatViewLocation run, mSeatViewWrapper %s, mPresenter %s", (Object[])new Object[]{SeatViewContainer.this.mSeatViewWrapper, SeatViewContainer.this.mPresenter});
                        }
                        if (SeatViewContainer.this.mPresenter == null || SeatViewContainer.this.mPresenter.getMvpContext() == null || SeatViewContainer.this.mPresenter.getMvpContext().isDestroy()) {
                            MLog.error((Object)SeatViewContainer.TAG, (Throwable)new IllegalStateException("updateSeatViewLocation presenter is null, or isDestroy"));
                            return;
                        }
                        if (SeatViewContainer.this.mSeatViewWrapper != null && SeatViewContainer.this.mPresenter.needUpdateSeatLocation()) {
                            int[] to = new int[2];
                            SeatViewContainer.this.getLocationInWindow(to);
                            if (SeatViewContainer.this.isTranslationEnd(SeatViewContainer.this.mViewPosition, to)) {
                                if (SeatViewContainer.this.mPresenter != null) {
                                    SeatViewContainer.this.mPresenter.updateSeatViewLocation(SeatViewContainer.this.getSeatViewLoaction(true), SeatViewContainer.this.getSeatViewLoaction(false));
                                } else if (!MLog.isLogLevelAboveDebug()) {
                                    MLog.debug((Object)SeatViewContainer.TAG, (String)"updateSeatViewLocation \u5f02\u5e38\uff0cseatview\u4e0d\u663e\u793a", (Object[])new Object[0]);
                                }
                            } else {
                                SeatViewContainer.access$302(SeatViewContainer.this, to);
                                SeatViewContainer.this.postDelayed(SeatViewContainer.this.mCheckLocationRunnable, 1000L);
                            }
                        }
                    }
                };
            }
            this.removeCallbacks(this.mCheckLocationRunnable);
            this.post(this.mCheckLocationRunnable);
        }
    }

    private boolean isTranslationEnd(int[] from, int[] to) {
        return from != null && to != null && Arrays.equals(from, to);
    }

    private void setClip(boolean clip) {
        this.setClipChildren(clip);
        this.setClipToPadding(clip);
    }

    @Override
    @Nullable
    public View getItemView(int index) {
        return this.mSeatViewWrapper.getItemView(index);
    }

    static /* synthetic */ int[] access$302(SeatViewContainer x0, int[] x1) {
        x0.mViewPosition = x1;
        return x1;
    }
}

