/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.roompush;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import com.opensource.svgaplayer.SVGACallback;
import com.opensource.svgaplayer.SVGADrawable;
import com.opensource.svgaplayer.SVGADynamicEntity;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.opensource.svgaplayer.utils.SVGARect;
import com.yy.appbase.callback.SimpleSVGACallback;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.component.roompush.ChannelPushPresenter;
import com.yy.hiyo.channel.component.roompush.RoomPushMvp;
import com.yy.hiyo.channel.component.roompush.bean.BaseRoomPushBean;
import com.yy.hiyo.channel.component.roompush.bean.RoomPushBean;
import com.yy.hiyo.channel.component.roompush.bean.SvgaPushBean;
import com.yy.hiyo.channel.component.roompush.callback.IItemViewCallback;
import com.yy.hiyo.channel.component.roompush.itemview.Type1View;
import com.yy.hiyo.channel.component.roompush.itemview.Type2View;
import com.yy.hiyo.channel.component.roompush.itemview.Type3View;
import com.yy.hiyo.channel.component.roompush.itemview.TypeGiftView;
import com.yy.hiyo.channel.component.roompush.itemview.TypeImgBg;

public class RoomPushView
extends YYConstraintLayout
implements RoomPushMvp.IView,
IItemViewCallback {
    private static final long ANIM_DURATION = 300L;
    private int translationWidth = 0;
    private Context mContext;
    private ChannelPushPresenter mPresenter;
    private ViewGroup mParent;
    private YYFrameLayout mRoot;
    private ObjectAnimator enterAnim;
    private ObjectAnimator exitAnim;
    private OnUILintener mUIListener;
    private String mRoomId;
    private int screenWidth;
    private int screenHeight;
    private Runnable mFinishTask = () -> this.finishShow();

    public RoomPushView(Context context, ViewGroup parent) {
        super(context);
        this.mContext = context;
        this.mParent = parent;
        this.translationWidth = ResolutionUtils.getScreenWidth((Context)context);
        this.initView();
    }

    private void initView() {
        RoomPushView.inflate((Context)this.mContext, (int)R.layout.layout_roompush_channel, (ViewGroup)this);
        this.screenWidth = ResolutionUtils.getScreenWidth((Context)this.mContext);
        this.screenHeight = ResolutionUtils.getScreenHeight((Context)this.mContext);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        if (Build.VERSION.SDK_INT >= 17) {
            params.addRule(21);
        } else {
            params.addRule(11);
        }
        params.topMargin = ResolutionUtils.dip2Px((float)48.0f);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mRoot = (YYFrameLayout)this.findViewById(R.id.layout_root);
    }

    public void show(BaseRoomPushBean bean2) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTVoiceRoomPush", (String)"showing, type: %s", (Object[])new Object[]{bean2.getType()});
        }
        this.setVisibility(0);
        if (bean2 instanceof RoomPushBean) {
            this.showOldPush((RoomPushBean)bean2);
        } else if (bean2 instanceof SvgaPushBean) {
            this.showSvgaPush((SvgaPushBean)bean2);
        }
    }

    private void showOldPush(RoomPushBean bean2) {
        if (bean2.getType() == 1) {
            this.mRoot.addView((View)new Type1View(this.mContext, bean2, this));
            this.doShow();
            RoomTrack.INSTANCE.reportBroadcastShow(this.mRoomId, "1", bean2.getBroadcastSource());
        } else if (bean2.getType() == 2) {
            this.mRoot.addView((View)new Type2View(this.mContext, bean2, this));
            this.doShow();
            RoomTrack.INSTANCE.reportBroadcastShow(this.mRoomId, "2", bean2.getBroadcastSource());
        } else if (bean2.getType() == 7) {
            this.mRoot.addView((View)new Type3View(this.mContext, bean2, this));
            this.doShow();
            RoomTrack.INSTANCE.reportBroadcastShow(this.mRoomId, "5", bean2.getBroadcastSource());
        } else if (bean2.getType() == 3) {
            this.mRoot.addView((View)new TypeGiftView(this.mContext, bean2, this));
            this.doShow();
            RoomTrack.INSTANCE.reportBroadcastShow(this.mRoomId, "3", bean2.getBroadcastSource());
        } else if (bean2.getType() == 4 || bean2.getType() == 6) {
            if (!TextUtils.isEmpty((CharSequence)bean2.getSvgaUrl())) {
                this.addSvga(bean2);
                this.doShowNoAnim();
            } else {
                FeatureLog.e((String)"FTVoiceRoomPush", (String)"bean.getType %s svga url is empty", (Object[])new Object[]{bean2.getType()});
                this.finishShow();
            }
        } else if (bean2.getType() == 5) {
            RoomTrack.INSTANCE.reportBroadcastShow(this.mRoomId, "4", bean2.getBroadcastSource());
            this.mRoot.addView((View)new TypeImgBg(this.mContext, bean2, this));
            this.doShow();
        } else {
            FeatureLog.e((String)"FTVoiceRoomPush", (String)"no match type", (Object[])new Object[0]);
            this.finishShow();
        }
    }

    private void doShowNoAnim() {
        if (null != this.mUIListener) {
            this.mUIListener.viewStatusChanged(true);
        }
        this.mParent.addView((View)this);
        this.setTranslationX(0.0f);
        this.setAlpha(1.0f);
    }

    private void showSvgaPush(final SvgaPushBean bean2) {
        SvgaPushBean sBean = bean2;
        final SVGAImageView svgaImageView = new SVGAImageView(this.mContext);
        svgaImageView.setLoopCount(1);
        float hightPercent = 0.3f;
        String svgaUrl = "";
        if (sBean != null && sBean.getHightPercent() != null && sBean.getHightPercent() > 0L) {
            hightPercent = (float)bean2.getHightPercent().longValue() / 100.0f;
            svgaUrl = bean2.getBigSvgaUrl();
        } else {
            svgaUrl = bean2.getSvgaUrl();
        }
        final FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(this.screenWidth, (int)((float)this.screenWidth * hightPercent));
        svgaImageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        SvgaLoader.load((SVGAImageView)svgaImageView, (String)svgaUrl, (ISvgaLoadCallback)new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                SVGADynamicEntity dynamicEntity = new SVGADynamicEntity();
                if (bean2.getReplaceKeyValue() != null) {
                    for (SvgaPushBean.ReplaceKeyValue replaceKeyValue : bean2.getReplaceKeyValue()) {
                        if (replaceKeyValue.getReplaceType() == 1) {
                            TextPaint textPaint = RoomPushView.this.getNormalTextPaint(replaceKeyValue.getSize(), replaceKeyValue.getColor());
                            dynamicEntity.setDynamicText(replaceKeyValue.getValue(), textPaint, replaceKeyValue.getKey());
                            continue;
                        }
                        if (replaceKeyValue.getReplaceType() != 2) continue;
                        SVGARect rect = svgaVideoEntity.getVideoSize();
                        String thumbUrl = rect.getWidth() > 0.0 && rect.getHeight() > 0.0 ? YYImageUtils.getThumbnailPostfixPx((int)((int)rect.getWidth()), (int)((int)rect.getHeight()), (boolean)true) : YYImageUtils.getThumbnailPostfixPx((int)layoutParams.width, (int)layoutParams.height, (boolean)true);
                        RoomPushView.this.loadImage(replaceKeyValue.getValue() + thumbUrl, replaceKeyValue.getKey(), dynamicEntity);
                    }
                }
                SVGADrawable drawable2 = new SVGADrawable(svgaVideoEntity, dynamicEntity);
                svgaImageView.setImageDrawable((Drawable)drawable2);
                svgaImageView.startAnimation();
            }

            public void onFailed(Exception e) {
                RoomPushView.this.finishShow();
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"FTVoiceRoomPush", (String)"load svga %s failed", (Object[])new Object[]{bean2.getSvgaUrl()});
                }
            }
        });
        svgaImageView.setCallback((SVGACallback)new SimpleSVGACallback(){

            public void onFinished() {
                YYTaskExecutor.postToMainThread(() -> RoomPushView.this.hide(false));
            }
        });
        svgaImageView.setOnClickListener(v -> {
            if (null != this.mPresenter) {
                this.mPresenter.onClickItem(bean2);
            }
        });
        this.mRoot.addView((View)svgaImageView);
        this.doShowNoAnim();
    }

    private void addSvga(final RoomPushBean bean2) {
        final SVGAImageView svgaImageView = new SVGAImageView(this.mContext);
        svgaImageView.setLoopCount(1);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(this.screenWidth, this.screenWidth);
        svgaImageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        SvgaLoader.load((SVGAImageView)svgaImageView, (String)bean2.getSvgaUrl(), (ISvgaLoadCallback)new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                if (bean2.getType() == 6) {
                    SVGADynamicEntity dynamicEntity = new SVGADynamicEntity();
                    TextPaint textPaint = RoomPushView.this.getNormalTextPaint(bean2.getTextSize(), bean2.getColor());
                    CharSequence charSequence = TextUtils.ellipsize((CharSequence)bean2.getNick(), (TextPaint)textPaint, (float)ResolutionUtils.dip2Px((float)50.0f), (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
                    dynamicEntity.setDynamicText(new StaticLayout(charSequence, 0, charSequence.length(), textPaint, 0, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false), "nickname");
                    CharSequence content = TextUtils.ellipsize((CharSequence)bean2.getContent(), (TextPaint)textPaint, (float)ResolutionUtils.dip2Px((float)300.0f), (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
                    dynamicEntity.setDynamicText(new StaticLayout(content, 0, content.length(), textPaint, 0, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false), "custom_copywriting");
                    String thumbSmall = YYImageUtils.getThumbSmall();
                    RoomPushView.this.loadImage(bean2.getAvatar() + thumbSmall, "profile", dynamicEntity);
                    SVGADrawable drawable2 = new SVGADrawable(svgaVideoEntity, dynamicEntity);
                    svgaImageView.setImageDrawable((Drawable)drawable2);
                }
                svgaImageView.startAnimation();
            }

            public void onFailed(Exception e) {
                RoomPushView.this.finishShow();
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"FTVoiceRoomPush", (String)"load svga %s failed", (Object[])new Object[]{bean2.getSvgaUrl()});
                }
            }
        });
        svgaImageView.setCallback((SVGACallback)new SimpleSVGACallback(){

            public void onFinished() {
                YYTaskExecutor.postToMainThread(() -> RoomPushView.this.hide(false));
            }
        });
        this.mRoot.addView((View)svgaImageView);
    }

    private void loadImage(String url, final String key, final SVGADynamicEntity dynamicEntity) {
        ImageLoader.loadBitmap((Context)this.getContext(), (String)url, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

            public void onLoadFailed(Exception e) {
            }

            public void onResourceReady(Bitmap bitmap) {
                dynamicEntity.setDynamicImage(bitmap, key);
            }
        });
    }

    private TextPaint getNormalTextPaint(int size, String color2) {
        TextPaint textPaint = new TextPaint();
        if (size > 0) {
            textPaint.setTextSize((float)size);
        } else {
            textPaint.setTextSize(13.0f);
        }
        if (!TextUtils.isEmpty((CharSequence)color2)) {
            textPaint.setColor(ColorUtils.parseColor((String)color2));
        } else {
            textPaint.setColor(ColorUtils.parseColor((String)"#ffffff"));
        }
        return textPaint;
    }

    private void doShow() {
        this.doShowWithAnim();
    }

    private void doShowWithAnim() {
        if (null != this.mUIListener) {
            this.mUIListener.viewStatusChanged(true);
        }
        this.mParent.addView((View)this);
        this.showAnim();
    }

    public void hide(boolean hasAnim) {
        if (hasAnim) {
            this.hideAnim();
            YYTaskExecutor.postToMainThread((Runnable)this.mFinishTask, (long)400L);
        } else {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTVoiceRoomPush", (String)"hided, Anim=false", (Object[])new Object[0]);
            }
            this.finishShow();
        }
    }

    public void showAnim() {
        if (null == this.enterAnim) {
            this.enterAnim = this.getStartEnterAnim();
        }
        this.enterAnim.start();
    }

    private ObjectAnimator getStartEnterAnim() {
        float trans = this.translationWidth;
        if (LanguageUtils.isRtl()) {
            trans = -this.translationWidth;
        }
        ObjectAnimator mStartAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)this, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f}), PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_X, (float[])new float[]{trans, 0.0f})});
        mStartAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        mStartAnimator.setDuration(400L);
        return mStartAnimator;
    }

    @NonNull
    private ObjectAnimator getExitAnim() {
        float trans = -this.translationWidth;
        if (LanguageUtils.isRtl()) {
            trans = this.translationWidth;
        }
        ObjectAnimator mAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)this, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{1.0f, 0.0f}), PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_X, (float[])new float[]{0.0f, trans})});
        mAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        mAnimator.setDuration(333L);
        mAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTVoiceRoomPush", (String)"hided, Anim=true", (Object[])new Object[0]);
                }
                RoomPushView.this.post(() -> RoomPushView.this.finishShow());
            }
        });
        return mAnimator;
    }

    public void hideAnim() {
        if (null == this.exitAnim) {
            this.exitAnim = this.getExitAnim();
        }
        this.exitAnim.start();
    }

    private void finishShow() {
        FeatureLog.i((String)"FTVoiceRoomPush", (String)"finishShow, getVisibility: %d", (Object[])new Object[]{this.getVisibility()});
        if (this.getVisibility() == 8) {
            return;
        }
        YYTaskExecutor.removeTask((Runnable)this.mFinishTask);
        this.setVisibility(8);
        if (null != this.mRoot) {
            this.mRoot.removeAllViews();
        }
        if (null != this.mParent) {
            this.mParent.removeView((View)this);
        }
        if (null != this.mUIListener) {
            this.mUIListener.viewStatusChanged(false);
        }
    }

    public void setPresenter(RoomPushMvp.IPresenter presenter) {
        this.mPresenter = (ChannelPushPresenter)presenter;
    }

    @Override
    public void onClickItem(RoomPushBean bean2) {
        if (null != this.mPresenter) {
            this.mPresenter.onClickItem(bean2);
        }
    }

    public void setRoomId(String roomId) {
        this.mRoomId = roomId;
    }

    public void setOnUIListener(OnUILintener listener) {
        this.mUIListener = listener;
    }

    public static interface OnUILintener {
        public void viewStatusChanged(boolean var1);
    }
}

