/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.robot;

import android.content.Context;
import android.net.Uri;
import android.os.Message;
import androidx.fragment.app.FragmentActivity;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.common.Callback;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.envsetting.EnvSettingType;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.appbase.service.IService;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelRobotInfo;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.cbase.ChannelMsgDef;
import com.yy.hiyo.channel.cbase.channelhiido.ChannelTrack;
import com.yy.hiyo.channel.component.robot.DeleteRobotWindow;
import com.yy.hiyo.channel.component.robot.IRobotListPresenter;
import com.yy.hiyo.channel.component.robot.RobotListWindow;
import com.yy.hiyo.channel.component.robot.bean.ChannelRobotConfig;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import com.yy.webservice.WebEnvSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.ihago.channel.srv.robot.AddRobotReq;
import net.ihago.channel.srv.robot.AddRobotRes;
import net.ihago.channel.srv.robot.GetConfigReq;
import net.ihago.channel.srv.robot.GetConfigRes;
import net.ihago.channel.srv.robot.GetRobotInsListReq;
import net.ihago.channel.srv.robot.GetRobotInsListRes;
import net.ihago.channel.srv.robot.GetRobotTemplatesReq;
import net.ihago.channel.srv.robot.GetRobotTemplatesRes;
import net.ihago.channel.srv.robot.RobotIns;
import net.ihago.channel.srv.robot.RobotTemplate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\nH\u0016J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0012\u0010\u0016\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0011H\u0002J\b\u0010\u001a\u001a\u00020\u0011H\u0016J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0016J\b\u0010\u001c\u001a\u00020\u0011H\u0016J\b\u0010\u001d\u001a\u00020\u0011H\u0016J\u0012\u0010\u001e\u001a\u00020\u00112\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0012\u0010!\u001a\u00020\u00112\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\b\u0010\"\u001a\u00020\u0011H\u0002J\b\u0010#\u001a\u00020\u0011H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/yy/hiyo/channel/component/robot/RobotListController;", "Lcom/yy/appbase/core/DefaultController;", "Lcom/yy/hiyo/channel/component/robot/IRobotListPresenter;", "env", "Lcom/yy/framework/core/Environment;", "(Lcom/yy/framework/core/Environment;)V", "mAddedRobotList", "", "Lcom/yy/hiyo/channel/base/bean/ChannelRobotInfo;", "mChannelID", "", "mDeleteRobotWindow", "Lcom/yy/hiyo/channel/component/robot/DeleteRobotWindow;", "mRobotListWindow", "Lcom/yy/hiyo/channel/component/robot/RobotListWindow;", "mWaitingAddRobotList", "addRobot", "", "robotInfo", "deleteRobot", "robotId", "getJumpRobotPage", "handleMessage", "msg", "Landroid/os/Message;", "initRobotList", "jumpManageRobot", "jumpRobotPage", "onBackDeleteRobot", "onBackRobotList", "onWindowDetach", "abstractWindow", "Lcom/yy/framework/core/ui/AbstractWindow;", "onWindowShown", "showDeleteRobotWindow", "showRobotListWindow", "RobotListManager", "channel-components_release"})
public final class RobotListController
extends DefaultController
implements IRobotListPresenter {
    private RobotListWindow mRobotListWindow;
    private DeleteRobotWindow mDeleteRobotWindow;
    private List<ChannelRobotInfo> mAddedRobotList;
    private List<ChannelRobotInfo> mWaitingAddRobotList;
    private String mChannelID;
    private static int mAddRobotNumber;
    private static boolean mRequesting;
    @NotNull
    private static Map<String, ChannelRobotConfig> mCacheConfig;
    private static long mRobotUid;
    private static boolean mIsAtRobot;
    @NotNull
    private static String mRobotInsId;
    public static final RobotListManager RobotListManager;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleMessage(@Nullable Message msg) {
        super.handleMessage(msg);
        Message message = msg;
        if (message != null) {
            if (message.what == ChannelMsgDef.MSG_OPEN_ROBOT_LIST_WINDOW) {
                if (msg.obj instanceof String) {
                    Object object = msg.obj;
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                    }
                    this.mChannelID = (String)object;
                }
                this.showRobotListWindow();
                return;
            }
        }
        Message message2 = msg;
        if (message2 == null) return;
        if (message2.what != ChannelMsgDef.MSG_OPEN_DELETE_ROBOT_WINDOW) return;
        this.showDeleteRobotWindow();
    }

    private final void showRobotListWindow() {
        if (this.mRobotListWindow == null) {
            this.mRobotListWindow = new RobotListWindow((Context)this.mContext, this, "RobotListWindow");
        }
        if (this.mRobotListWindow != null) {
            this.mWindowMgr.popToWindow((AbstractWindow)this.mRobotListWindow, false);
        }
        this.mWindowMgr.pushWindow((AbstractWindow)this.mRobotListWindow, true);
    }

    private final void showDeleteRobotWindow() {
        block2: {
            if (this.mDeleteRobotWindow == null) {
                this.mDeleteRobotWindow = new DeleteRobotWindow((Context)this.mContext, this, "RobotListWindow");
            }
            if (this.mDeleteRobotWindow != null) {
                this.mWindowMgr.popToWindow((AbstractWindow)this.mDeleteRobotWindow, false);
            }
            this.mWindowMgr.pushWindow((AbstractWindow)this.mDeleteRobotWindow, true);
            DeleteRobotWindow deleteRobotWindow = this.mDeleteRobotWindow;
            if (deleteRobotWindow == null) break block2;
            deleteRobotWindow.updateDeleteRobotList(this.mAddedRobotList);
        }
    }

    @Override
    public void onBackRobotList() {
        if (this.mRobotListWindow != null) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mRobotListWindow);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initRobotList() {
        void manageRobotAuthority;
        block4: {
            block5: {
                RobotListWindow robotListWindow = this.mRobotListWindow;
                if (robotListWindow != null) {
                    robotListWindow.showLoading(true);
                }
                IService iService = ServiceManagerProxy.getService(IChannelCenterService.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)iService, (String)"ServiceManagerProxy.getS\u2026enterService::class.java)");
                IChannel currentChannel2 = ((IChannelCenterService)iService).getCurrentChannel();
                Ref.BooleanRef booleanRef = new Ref.BooleanRef();
                booleanRef.element = false;
                if (currentChannel2 == null) break block4;
                IRoleService iRoleService = currentChannel2.getRoleService();
                Intrinsics.checkExpressionValueIsNotNull((Object)iRoleService, (String)"currentChannel.roleService");
                if (iRoleService.getMyRoleCache() == 15) break block5;
                IRoleService iRoleService2 = currentChannel2.getRoleService();
                Intrinsics.checkExpressionValueIsNotNull((Object)iRoleService2, (String)"currentChannel.roleService");
                if (iRoleService2.getMyRoleCache() != 10) break block4;
            }
            manageRobotAuthority.element = true;
        }
        GetRobotTemplatesReq addedRobotListReq = new GetRobotTemplatesReq.Builder().cid(this.mChannelID).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)addedRobotListReq, (IProtoCallback)new SimpleProtoCallback<GetRobotTemplatesRes>(this, (Ref.BooleanRef)manageRobotAuthority){
            final /* synthetic */ RobotListController this$0;
            final /* synthetic */ Ref.BooleanRef $manageRobotAuthority;

            public void onResponse(@NotNull GetRobotTemplatesRes message, long code, @Nullable String msg) {
                block2: {
                    block1: {
                        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                        super.onResponse((AndroidMessage)message, code, msg);
                        RobotListController.access$getMWaitingAddRobotList$p(this.this$0).clear();
                        List list2 = message.robotTemplates;
                        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"message.robotTemplates");
                        Collection collection = list2;
                        boolean bl = false;
                        if (!(!collection.isEmpty())) break block1;
                        for (RobotTemplate robot : message.robotTemplates) {
                            ChannelRobotInfo channelRobotInfo = new ChannelRobotInfo();
                            boolean bl2 = false;
                            boolean bl3 = false;
                            ChannelRobotInfo $this$apply = channelRobotInfo;
                            boolean bl4 = false;
                            $this$apply.robotId = robot.tid;
                            $this$apply.robotName = robot.name;
                            $this$apply.ttype = robot.ttype;
                            $this$apply.detail = robot.desc;
                            $this$apply.isAdded = false;
                            $this$apply.avatar = robot.avatar;
                            $this$apply.owner = robot.owner;
                            Integer n = robot.status;
                            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"robot.status");
                            $this$apply.status = n;
                            $this$apply.hasManageRobotAuthority = this.$manageRobotAuthority.element;
                            ChannelRobotInfo robotInfo = channelRobotInfo;
                            RobotListController.access$getMWaitingAddRobotList$p(this.this$0).add(robotInfo);
                        }
                        RobotListWindow robotListWindow = RobotListController.access$getMRobotListWindow$p(this.this$0);
                        if (robotListWindow == null) break block2;
                        robotListWindow.updateWaitingAddRobotList(RobotListController.access$getMWaitingAddRobotList$p(this.this$0));
                        break block2;
                    }
                    RobotListWindow robotListWindow = RobotListController.access$getMRobotListWindow$p(this.this$0);
                    if (robotListWindow == null) break block2;
                    robotListWindow.updateWaitingAddRobotList(RobotListController.access$getMWaitingAddRobotList$p(this.this$0));
                }
            }

            public void onError(@Nullable String reason, int code) {
                block1: {
                    super.onError(reason, code);
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"RobotListController", (String)("onError,[reason" + reason + ", code:" + code + "] "), (Object[])new Object[0]);
                    }
                    RobotListWindow robotListWindow = RobotListController.access$getMRobotListWindow$p(this.this$0);
                    if (robotListWindow == null) break block1;
                    RobotListWindow robotListWindow2 = robotListWindow;
                    boolean bl = false;
                    List list2 = new ArrayList<E>();
                    robotListWindow2.updateWaitingAddRobotList(list2);
                }
            }
            {
                this.this$0 = $outer;
                this.$manageRobotAuthority = $captured_local_variable$1;
            }
        });
        RobotListManager.requestAddRobotList(this.mChannelID, (Callback<List<ChannelRobotInfo>>)((Callback)new Callback<List<ChannelRobotInfo>>(this){
            final /* synthetic */ RobotListController this$0;

            public final void onResponse(List<ChannelRobotInfo> it) {
                block0: {
                    RobotListController.access$getMAddedRobotList$p(this.this$0).clear();
                    List list2 = RobotListController.access$getMAddedRobotList$p(this.this$0);
                    List<ChannelRobotInfo> list3 = it;
                    Intrinsics.checkExpressionValueIsNotNull(list3, (String)"it");
                    list2.addAll((Collection)list3);
                    RobotListWindow robotListWindow = RobotListController.access$getMRobotListWindow$p(this.this$0);
                    if (robotListWindow == null) break block0;
                    robotListWindow.updateAddRobotList(RobotListController.access$getMAddedRobotList$p(this.this$0));
                }
            }
            {
                this.this$0 = robotListController;
            }
        }));
    }

    @Override
    public void addRobot(@NotNull ChannelRobotInfo robotInfo) {
        Intrinsics.checkParameterIsNotNull((Object)robotInfo, (String)"robotInfo");
        AddRobotReq addRobotReq = new AddRobotReq.Builder().ttype(robotInfo.ttype).tid(robotInfo.robotId).avatar("").cid(this.mChannelID).name("").desc("").build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)addRobotReq, (IProtoCallback)new SimpleProtoCallback<AddRobotRes>(this){
            final /* synthetic */ RobotListController this$0;

            public void onResponse(@NotNull AddRobotRes message, long code, @Nullable String msg) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                super.onResponse((AndroidMessage)message, code, msg);
                if (code == 0L) {
                    RobotListController.access$initRobotList(this.this$0);
                } else if (code == 1005L) {
                    ToastUtils.showToast((Context)((Context)RobotListController.access$getMContext$p(this.this$0)), (int)R.string.add_robot_number_limit);
                }
            }

            public void onError(@Nullable String reason, int code) {
                super.onError(reason, code);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"RobotListController", (String)("onError,[reason" + reason + ", code:" + code + ']'), (Object[])new Object[0]);
                }
                if (code == (int)1005L) {
                    ToastUtils.showToast((Context)((Context)RobotListController.access$getMContext$p(this.this$0)), (int)R.string.add_robot_number_limit);
                }
            }
            {
                this.this$0 = $outer;
            }
        });
        String string2 = robotInfo.robotId;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"robotInfo.robotId");
        ChannelTrack.INSTANCE.reportAddRobot(string2);
    }

    @Override
    public void jumpRobotPage(@NotNull ChannelRobotInfo robotInfo) {
        Intrinsics.checkParameterIsNotNull((Object)robotInfo, (String)"robotInfo");
        WebEnvSettings settings = new WebEnvSettings();
        EnvSettings envSettings = EnvSettings.instance();
        Intrinsics.checkExpressionValueIsNotNull((Object)envSettings, (String)"EnvSettings.instance()");
        String baseUrl = envSettings.getUriSettingValue() == EnvSettingType.Product ? "https://www.ihago.net/a/channel-robot/index.html" : "https://test.ihago.net/a/channel-robot/index.html";
        String params = this.getJumpRobotPage(robotInfo);
        settings.url = baseUrl + '?' + params;
        settings.isFullScreen = true;
        settings.hideTitleBar = true;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"RobotListController", (String)("jumpRobotPage,url:" + settings.url), (Object[])new Object[0]);
        }
        IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
        if (iServiceManager == null) {
            Intrinsics.throwNpe();
        }
        ((IWebService)iServiceManager.getService(IWebService.class)).loadUrl(settings);
        String string2 = robotInfo.robotId;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"robotInfo.robotId");
        ChannelTrack.INSTANCE.reportClickRobot(string2, robotInfo.isAdded);
    }

    private final String getJumpRobotPage(ChannelRobotInfo robotInfo) {
        String string2 = robotInfo.detail;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"robotInfo.detail");
        CharSequence charSequence = string2;
        boolean bl = false;
        String encoderDesc = charSequence.length() > 0 ? Uri.encode((String)robotInfo.detail, (String)"UTF-8") : "";
        String string3 = robotInfo.ext;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"robotInfo.ext");
        CharSequence charSequence2 = string3;
        boolean bl2 = false;
        String encoderExt = charSequence2.length() > 0 ? Uri.encode((String)robotInfo.ext, (String)"UTF-8") : "";
        String string4 = robotInfo.avatar;
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"robotInfo.avatar");
        CharSequence charSequence3 = string4;
        boolean bl3 = false;
        String encoderAvatar = charSequence3.length() > 0 ? Uri.encode((String)robotInfo.avatar, (String)"UTF-8") : "";
        String string5 = robotInfo.robotName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"robotInfo.robotName");
        CharSequence charSequence4 = string5;
        boolean bl4 = false;
        String encoderName = charSequence4.length() > 0 ? Uri.encode((String)robotInfo.robotName, (String)"UTF-8") : "";
        return "insid=" + robotInfo.instanceId + "&cid=" + this.mChannelID + "&tid=" + robotInfo.robotId + "&name=" + encoderName + "&desc=" + encoderDesc + "&avatar=" + encoderAvatar + "&ext=" + encoderExt + "&ttype=" + robotInfo.ttype + "&userRole=" + ChannelTrack.INSTANCE.getUserRole();
    }

    @Override
    public void deleteRobot(@NotNull String robotId) {
        Intrinsics.checkParameterIsNotNull((Object)robotId, (String)"robotId");
    }

    public void onWindowShown(@Nullable AbstractWindow abstractWindow) {
        super.onWindowShown(abstractWindow);
        this.initRobotList();
    }

    public void onWindowDetach(@Nullable AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (Intrinsics.areEqual((Object)abstractWindow, (Object)this.mRobotListWindow)) {
            this.mRobotListWindow = null;
        }
    }

    @Override
    public void jumpManageRobot() {
    }

    @Override
    public void onBackDeleteRobot() {
        if (this.mDeleteRobotWindow != null) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mDeleteRobotWindow);
        }
    }

    public RobotListController(@Nullable Environment env) {
        super(env);
        List list2;
        RobotListController robotListController = this;
        boolean bl = false;
        robotListController.mAddedRobotList = list2 = (List)new ArrayList();
        robotListController = this;
        bl = false;
        robotListController.mWaitingAddRobotList = list2 = (List)new ArrayList();
        this.mChannelID = "";
    }

    static {
        RobotListManager = new RobotListManager(null);
        boolean bl = false;
        mCacheConfig = new LinkedHashMap();
        mRobotInsId = "";
    }

    public static final /* synthetic */ List access$getMWaitingAddRobotList$p(RobotListController $this) {
        return $this.mWaitingAddRobotList;
    }

    public static final /* synthetic */ void access$setMWaitingAddRobotList$p(RobotListController $this, List list2) {
        $this.mWaitingAddRobotList = list2;
    }

    public static final /* synthetic */ RobotListWindow access$getMRobotListWindow$p(RobotListController $this) {
        return $this.mRobotListWindow;
    }

    public static final /* synthetic */ void access$setMRobotListWindow$p(RobotListController $this, RobotListWindow robotListWindow) {
        $this.mRobotListWindow = robotListWindow;
    }

    public static final /* synthetic */ List access$getMAddedRobotList$p(RobotListController $this) {
        return $this.mAddedRobotList;
    }

    public static final /* synthetic */ void access$setMAddedRobotList$p(RobotListController $this, List list2) {
        $this.mAddedRobotList = list2;
    }

    public static final /* synthetic */ void access$initRobotList(RobotListController $this) {
        $this.initRobotList();
    }

    public static final /* synthetic */ FragmentActivity access$getMContext$p(RobotListController $this) {
        return $this.mContext;
    }

    public static final /* synthetic */ void access$setMContext$p(RobotListController $this, FragmentActivity fragmentActivity) {
        $this.mContext = fragmentActivity;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u000b2\u0012\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0*0)J$\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020 2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\f0)J\u0016\u0010/\u001a\u00020&2\u0006\u00100\u001a\u00020\u00122\u0006\u00101\u001a\u00020\u000bR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR(\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u001a\u0010\u001a\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u00062"}, d2={"Lcom/yy/hiyo/channel/component/robot/RobotListController$RobotListManager;", "", "()V", "mAddRobotNumber", "", "getMAddRobotNumber", "()I", "setMAddRobotNumber", "(I)V", "mCacheConfig", "", "", "Lcom/yy/hiyo/channel/component/robot/bean/ChannelRobotConfig;", "getMCacheConfig", "()Ljava/util/Map;", "setMCacheConfig", "(Ljava/util/Map;)V", "mIsAtRobot", "", "getMIsAtRobot", "()Z", "setMIsAtRobot", "(Z)V", "mRequesting", "getMRequesting", "setMRequesting", "mRobotInsId", "getMRobotInsId", "()Ljava/lang/String;", "setMRobotInsId", "(Ljava/lang/String;)V", "mRobotUid", "", "getMRobotUid", "()J", "setMRobotUid", "(J)V", "requestAddRobotList", "", "mChannelID", "callback", "Lcom/yy/appbase/common/Callback;", "", "Lcom/yy/hiyo/channel/base/bean/ChannelRobotInfo;", "requestRobotConfig", "channelId", "roomOwnerId", "setRonbotAtInfo", "isRobot", "robotInsId", "channel-components_release"})
    public static final class RobotListManager {
        public final int getMAddRobotNumber() {
            return mAddRobotNumber;
        }

        public final void setMAddRobotNumber(int n) {
            mAddRobotNumber = n;
        }

        public final boolean getMRequesting() {
            return mRequesting;
        }

        public final void setMRequesting(boolean bl) {
            mRequesting = bl;
        }

        @NotNull
        public final Map<String, ChannelRobotConfig> getMCacheConfig() {
            return mCacheConfig;
        }

        public final void setMCacheConfig(@NotNull Map<String, ChannelRobotConfig> map) {
            Intrinsics.checkParameterIsNotNull(map, (String)"<set-?>");
            mCacheConfig = map;
        }

        public final long getMRobotUid() {
            return mRobotUid;
        }

        public final void setMRobotUid(long l) {
            mRobotUid = l;
        }

        public final boolean getMIsAtRobot() {
            return mIsAtRobot;
        }

        public final void setMIsAtRobot(boolean bl) {
            mIsAtRobot = bl;
        }

        @NotNull
        public final String getMRobotInsId() {
            return mRobotInsId;
        }

        public final void setMRobotInsId(@NotNull String string2) {
            Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
            mRobotInsId = string2;
        }

        public final void requestRobotConfig(@NotNull String channelId, long roomOwnerId, @NotNull Callback<ChannelRobotConfig> callback2) {
            Intrinsics.checkParameterIsNotNull((Object)channelId, (String)"channelId");
            Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
            if (this.getMRequesting()) {
                return;
            }
            if (this.getMCacheConfig().get(channelId) != null) {
                ChannelRobotConfig channelRobotConfig = this.getMCacheConfig().get(channelId);
                if (channelRobotConfig == null) {
                    Intrinsics.throwNpe();
                }
                callback2.onResponse((Object)channelRobotConfig);
                return;
            }
            this.setMRequesting(true);
            GetConfigReq configReq = new GetConfigReq.Builder().cid(channelId).uid(Long.valueOf(roomOwnerId)).build();
            ProtoManager.getInstance().sendRpc((AndroidMessage)configReq, (IProtoCallback)new SimpleProtoCallback<GetConfigRes>(callback2, channelId){
                final /* synthetic */ Callback $callback;
                final /* synthetic */ String $channelId;

                public void onResponse(@NotNull GetConfigRes message, long code, @Nullable String msg) {
                    Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                    super.onResponse((AndroidMessage)message, code, msg);
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"RobotListController", (String)("requestRobotConfig onResponse,show:" + message.entrance_gray + ' ' + "max:" + message.max_robots + ' '), (Object[])new Object[0]);
                    }
                    ChannelRobotConfig channelRobotConfig = new ChannelRobotConfig();
                    boolean bl = false;
                    boolean bl2 = false;
                    ChannelRobotConfig $this$apply = channelRobotConfig;
                    boolean bl3 = false;
                    Boolean bl4 = message.entrance_gray;
                    Intrinsics.checkExpressionValueIsNotNull((Object)bl4, (String)"message.entrance_gray");
                    $this$apply.showEntrance = bl4;
                    Integer n = message.max_robots;
                    Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"message.max_robots");
                    $this$apply.maxRobot = n;
                    Long l = message.robotUid;
                    Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"message.robotUid");
                    $this$apply.robotUid = l;
                    Long l2 = message.robotUid;
                    Intrinsics.checkExpressionValueIsNotNull((Object)l2, (String)"message.robotUid");
                    RobotListController.RobotListManager.setMRobotUid(l2);
                    ChannelRobotConfig channelRobotConfig2 = channelRobotConfig;
                    RobotListController.RobotListManager.setMRequesting(false);
                    this.$callback.onResponse((Object)channelRobotConfig2);
                    RobotListController.RobotListManager.getMCacheConfig().put(this.$channelId, channelRobotConfig2);
                }

                public void onError(@Nullable String reason, int code) {
                    super.onError(reason, code);
                    RobotListController.RobotListManager.setMRequesting(false);
                    ChannelRobotConfig channelRobotConfig = new ChannelRobotConfig();
                    boolean bl = false;
                    boolean bl2 = false;
                    ChannelRobotConfig $this$apply = channelRobotConfig;
                    boolean bl3 = false;
                    $this$apply.showEntrance = false;
                    $this$apply.maxRobot = 0;
                    ChannelRobotConfig channelRobotConfig2 = channelRobotConfig;
                    this.$callback.onResponse((Object)channelRobotConfig2);
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"RobotListController", (String)("requestRobotConfig onError,reason" + reason + ", code:" + code), (Object[])new Object[0]);
                    }
                }
                {
                    this.$callback = $captured_local_variable$0;
                    this.$channelId = $captured_local_variable$1;
                }
            });
        }

        public final void requestAddRobotList(@NotNull String mChannelID, @NotNull Callback<List<ChannelRobotInfo>> callback2) {
            Intrinsics.checkParameterIsNotNull((Object)mChannelID, (String)"mChannelID");
            Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
            GetRobotInsListReq waitingAddRobotListReq = new GetRobotInsListReq.Builder().cid(mChannelID).build();
            ProtoManager.getInstance().sendRpc((AndroidMessage)waitingAddRobotListReq, (IProtoCallback)new SimpleProtoCallback<GetRobotInsListRes>(callback2){
                final /* synthetic */ Callback $callback;

                public void onResponse(@NotNull GetRobotInsListRes message, long code, @Nullable String msg) {
                    Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                    super.onResponse((AndroidMessage)message, code, msg);
                    List list2 = message.robotInses;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"message.robotInses");
                    Collection collection = list2;
                    boolean bl = false;
                    if (!collection.isEmpty()) {
                        bl = false;
                        List list3 = new ArrayList<E>();
                        for (RobotIns robot : message.robotInses) {
                            ChannelRobotInfo channelRobotInfo = new ChannelRobotInfo();
                            boolean bl2 = false;
                            boolean bl3 = false;
                            ChannelRobotInfo $this$apply = channelRobotInfo;
                            boolean bl4 = false;
                            $this$apply.robotId = robot.tid;
                            $this$apply.robotName = robot.name;
                            $this$apply.detail = robot.desc;
                            $this$apply.isAdded = true;
                            $this$apply.avatar = robot.avatar;
                            $this$apply.ext = robot.ext;
                            $this$apply.cid = robot.cid;
                            $this$apply.ttype = robot.ttype;
                            $this$apply.instanceId = robot.insId;
                            ChannelRobotInfo robotInfo = channelRobotInfo;
                            list3.add(robotInfo);
                        }
                        RobotListController.RobotListManager.setMAddRobotNumber(list3.size());
                        this.$callback.onResponse((Object)list3);
                    } else {
                        RobotListController.RobotListManager.setMAddRobotNumber(0);
                        Callback callback2 = this.$callback;
                        boolean bl5 = false;
                        List list4 = new ArrayList<E>();
                        callback2.onResponse((Object)list4);
                    }
                }

                public void onError(@Nullable String reason, int code) {
                    super.onError(reason, code);
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"RobotListController", (String)("onError,[reason" + reason + ", code:" + code + "] "), (Object[])new Object[0]);
                    }
                    Callback callback2 = this.$callback;
                    boolean bl = false;
                    List list2 = new ArrayList<E>();
                    callback2.onResponse((Object)list2);
                }
                {
                    this.$callback = $captured_local_variable$0;
                }
            });
        }

        public final void setRonbotAtInfo(boolean isRobot, @NotNull String robotInsId) {
            Intrinsics.checkParameterIsNotNull((Object)robotInsId, (String)"robotInsId");
            this.setMIsAtRobot(isRobot);
            this.setMRobotInsId(robotInsId);
        }

        private RobotListManager() {
        }

        public /* synthetic */ RobotListManager(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

