/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.publicscreen.receiver;

import biz.IMMsgItem;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.service.ICIMService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.channel.base.bean.ChannelPushContent;
import com.yy.hiyo.channel.base.callback.IMsgReceiver;
import com.yy.hiyo.channel.base.service.IMsgSource;
import com.yy.hiyo.channel.cbase.publicscreen.IPublicScreenService;
import com.yy.hiyo.channel.component.publicscreen.receiver.GameGroupSource;
import com.yy.hiyo.channel.component.publicscreen.receiver.HagoMsgSource;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.channel.publicscreen.IChannelMsgReceiver;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ChannelMsgReceiver
extends DefaultController
implements IChannelMsgReceiver {
    private static final String TAG = "ChannelMsgReceiver";
    private List<IMsgReceiver> messageReceives = new CopyOnWriteArrayList<IMsgReceiver>();
    private List<IMsgSource> msgSources = new ArrayList<IMsgSource>();
    private boolean inited;
    private IMsgReceiver mMsgReceiver = new IMsgReceiver(){

        public void onReceiveMsg(String channel, BaseImMsg msg) {
            for (IMsgReceiver msgReceiver : ChannelMsgReceiver.this.messageReceives) {
                msgReceiver.onReceiveMsg(channel, msg);
            }
        }

        public void onReceiveMsgs(String channel, List<BaseImMsg> msgs) {
            for (IMsgReceiver msgReceiver : ChannelMsgReceiver.this.messageReceives) {
                msgReceiver.onReceiveMsgs(channel, msgs);
            }
        }

        public boolean isUnSupportBelow_3_3(IMMsgItem msg) {
            IPublicScreenService service = (IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class);
            return service != null && service.getMsgItemFactory().isUnSupportBelow_3_3(msg);
        }

        public BaseImMsg transformMsgItem(String msgId, IMMsgItem msg, ChannelPushContent pushContent) {
            IPublicScreenService service = (IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class);
            return service == null ? null : service.getMsgItemFactory().transformMsgItem(msgId, msg, pushContent);
        }
    };

    public ChannelMsgReceiver(Environment env) {
        super(env);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED, (INotify)this);
        if (RuntimeContext.sIsAppStartFinished) {
            this.ensureSource();
        }
    }

    private void ensureSource() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        HagoMsgSource mHagoSource = new HagoMsgSource(this.getEnvironment());
        this.addMsgSource(mHagoSource);
        mHagoSource.init(this.mMsgReceiver);
        Object mCimSource = ((ICIMService)this.getServiceManager().getService(ICIMService.class)).getCimMsgSource();
        if (mCimSource instanceof IMsgSource) {
            this.addMsgSource((IMsgSource)mCimSource);
            ((IMsgSource)mCimSource).init(this.mMsgReceiver);
        }
        GameGroupSource gameGroupSource = new GameGroupSource(this.getEnvironment());
        this.addMsgSource(gameGroupSource);
        gameGroupSource.init(this.mMsgReceiver);
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == NotificationDef.N_STARTUP_FINISHED) {
            this.ensureSource();
        }
    }

    private void addMsgSource(IMsgSource channel) {
        this.msgSources.add(channel);
    }

    public void registerMsgReceiver(IMsgReceiver receiver) {
        if (receiver != null && !this.messageReceives.contains(receiver)) {
            this.messageReceives.add(receiver);
        }
    }

    public void unRegisterMsgReceiver(IMsgReceiver receiver) {
        if (receiver != null) {
            this.messageReceives.remove(receiver);
        }
    }
}

