/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.profile.profilecard.voiceroom;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.appbase.ui.webview.WebViewPanel;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.CharmValueJumpConfig;
import com.yy.appbase.unifyconfig.config.GrowthBusinessConfig;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.URLUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.BasePanel;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.RecommendEnterData;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IEnteredChannel;
import com.yy.hiyo.channel.base.service.IOperationCallback;
import com.yy.hiyo.channel.base.service.ISeatUpdateListener;
import com.yy.hiyo.channel.cbase.AbsChannelWindow;
import com.yy.hiyo.channel.cbase.channelhiido.RadioUtils;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.tools.IRevenueToolsModulePresenter;
import com.yy.hiyo.channel.component.anchorfansclub.FansClubPresenter;
import com.yy.hiyo.channel.component.invite.InvitePresenter;
import com.yy.hiyo.channel.component.profile.profilecard.base.FunctionInterceptor;
import com.yy.hiyo.channel.component.profile.profilecard.base.InterceptCallback;
import com.yy.hiyo.channel.component.profile.profilecard.base.ProfileCardPresenter;
import com.yy.hiyo.channel.component.profile.profilecard.helper.ProfileCardStatistics;
import com.yy.hiyo.channel.component.profile.profilecard.voiceroom.IVoiceRoomCallback;
import com.yy.hiyo.channel.component.profile.profilecard.voiceroom.VoiceRoomFunctionInterceptor;
import com.yy.hiyo.channel.component.profile.profilecard.voiceroom.VoiceRoomProfileCardData;
import com.yy.hiyo.channel.component.profile.profilecard.voiceroom.VoiceRoomProfileCardManager;
import com.yy.hiyo.channel.component.seat.SeatTrack;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.multivideo.IMultiVideoPresenter;
import com.yy.hiyo.user.base.profilecard.OpenProfileFrom;
import com.yy.hiyo.wallet.base.pay.bean.WalletTabConfig;
import com.yy.hiyo.wallet.base.revenue.gift.param.ShowGiftPanelParam;
import com.yy.webservice.WebEnvSettings;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class VoiceRoomProfileCardPresenter
extends ProfileCardPresenter
implements IVoiceRoomCallback {
    private static final String TAG = "VoiceRoomProfileCardPresenter";
    protected VoiceRoomFunctionInterceptor mFunctionInterceptor;

    @Override
    public void showProfileCard(long uid, @Nonnull OpenProfileFrom from) {
        if (this.isDestroyed()) {
            return;
        }
        if (this.getChannel().getSeatService().isInSeat(uid)) {
            this.showProfileCard(uid, true, from);
        } else {
            super.showProfileCard(uid, from);
        }
    }

    @Override
    public void showProfileCard(long uid, boolean inChannel, @Nonnull OpenProfileFrom from) {
        this.showProfileCard(uid, inChannel, from, null, null, null);
    }

    @Override
    public void showProfileCard(long uid, boolean inChannel, @Nonnull OpenProfileFrom from, @Nullable Boolean isShowMention, @Nullable String targetCid, @Nullable Long targetChannelOwnerUid) {
        if (this.isDestroyed()) {
            return;
        }
        VoiceRoomProfileCardData data = this.buildProfileCardData(uid, from);
        data.isInChannel = inChannel;
        data.targetChannelId = targetCid != null ? targetCid : "";
        data.targetChannelOwnerUid = targetChannelOwnerUid != null ? targetChannelOwnerUid : 0L;
        long anchorUid = 0L;
        anchorUid = this.getChannel().getRoleService().getAnchorUid() != 0L ? this.getChannel().getRoleService().getAnchorUid() : this.getChannel().getOwnerUid();
        if (uid == anchorUid && 14 == this.getChannel().getPluginService().getCurPluginData().mode) {
            data.hasFansClubEntry = ((FansClubPresenter)this.getPresenter(FansClubPresenter.class)).hasFansClubEntry();
            data.anchorUid = anchorUid;
        }
        VoiceRoomProfileCardManager manager = new VoiceRoomProfileCardManager((Context)((IChannelPageContext)this.getMvpContext()).getContext(), data, (IChannel)this.getChannel());
        manager.setCallback(this);
        manager.setSeatUpdateNotifier(this.createSeatUpdateNotifier());
        manager.setDataProvider(this);
        manager.show();
        if (isShowMention != null) {
            manager.setMentionVisible(isShowMention != false && uid != AccountUtil.getUid());
        }
        String userType = this.getChannel().getRoleService().getMyRoleCache() == 15 ? "1" : (this.getChannel().getSeatService().isInSeat(uid) ? "2" : "3");
        RoomTrack.INSTANCE.pictureClick(this.getChannelId(), userType, uid == AccountUtil.getUid(), this.getStatisEnterType(from.getValue()), this.getChannel().getPluginService().getCurPluginData().isVideoMode(), uid);
        if (14 == this.getChannel().getPluginService().getCurPluginData().mode) {
            ProfileCardStatistics.INSTANCE.reportRadioProfileCardShow((IChannel)this.getChannel(), from, uid, RadioUtils.INSTANCE.getMVideoMode());
        } else {
            ProfileCardStatistics.INSTANCE.reportProfileCardShow((IChannel)this.getChannel(), from, uid);
        }
    }

    protected String getStatisEnterType(int enterType) {
        if (enterType == OpenProfileFrom.FROM_SEAT.getValue()) {
            return "1";
        }
        if (enterType == OpenProfileFrom.FROM_MICUP.getValue()) {
            return "2";
        }
        return "9";
    }

    protected VoiceRoomProfileCardData buildProfileCardData(long uid, OpenProfileFrom from) {
        int channelType;
        IEnteredChannel channel = this.getChannel();
        VoiceRoomProfileCardData data = new VoiceRoomProfileCardData();
        data.from = from;
        data.uid = uid;
        data.channelId = channel.getChannelId();
        data.enterChannelEntry = channel.getEnterParam().entry;
        data.enterParamExtra = channel.getEnterParam().extra;
        if (!FP.empty((CharSequence)channel.getEnterParam().postId) && uid == channel.getEnterParam().matchedUid) {
            data.enterParamExtra.put("post_id", channel.getEnterParam().postId);
            data.enterParamExtra.put("post_token", channel.getEnterParam().postToken);
            data.enterParamExtra.put("post_page_source", channel.getEnterParam().postPageSource);
            data.enterParamExtra.put("post_creator_id", channel.getEnterParam().matchedUid);
        }
        data.isInSeat = channel.getSeatService().isInSeat(uid);
        data.seatIndex = channel.getSeatService().getSeatIndex(uid);
        data.isInFirstSeat = channel.getSeatService().isInFirstSeat(uid);
        data.mineRoleSession = channel.getPermissionService().getRoleSession(AccountUtil.getUid());
        data.targetRoleSession = channel.getPermissionService().getRoleSession(uid);
        data.role = channel.getRoleService().getRoleCache(uid);
        data.isTargetAnchor = channel.getRoleService().isAnchor(uid);
        data.isMeAnchor = channel.getRoleService().isMeAnchor();
        data.roomSource = channel.getDataService().getChannelDetailInfo(null).baseInfo.source;
        int channelVersion = channel.getDataService().getChannelDetailInfo(null).baseInfo.version;
        int role = data.targetRoleSession.getRole();
        if (channelVersion == 1 && role != 15 && role != 10 && 2 == (channelType = channel.getDataService().getChannelDetailInfo(null).baseInfo.type)) {
            String pid = channel.getDataService().getChannelDetailInfo(null).baseInfo.pid;
            IChannel parentChannel = ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).getChannel(pid);
            if (parentChannel != null) {
                role = parentChannel.getRoleService().getRoleCache(uid);
                parentChannel.getRoleService().updateMemberCacheFromServer(data.channelId);
            } else {
                role = 1;
            }
        }
        data.isTargetMember = role == 10 || role == 15 || role == 5;
        data.canOpSeat = this.mOperationStrategy == null || this.mOperationStrategy.canOpSeat();
        data.canOpMic = this.mOperationStrategy == null || this.mOperationStrategy.canOpMic();
        data.canOpVideo = this.mOperationStrategy != null && this.mOperationStrategy.canOpVideo();
        return data;
    }

    @Override
    public void setFunctionInterceptor(@NonNull FunctionInterceptor functionInterceptor) {
        super.setFunctionInterceptor(functionInterceptor);
        if (functionInterceptor instanceof VoiceRoomFunctionInterceptor) {
            this.mFunctionInterceptor = (VoiceRoomFunctionInterceptor)functionInterceptor;
        }
    }

    @Override
    public void onMakeSit(final long uid) {
        InterceptCallback callback2 = () -> {
            RecommendEnterData recommendEnterData;
            if (this.isDestroyed()) {
                return;
            }
            this.getChannel().getSeatService().makeSitDown(-1, uid, new IOperationCallback(){

                public void onSuccess() {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)VoiceRoomProfileCardPresenter.TAG, (String)("onMakeSit success uid = " + uid), (Object[])new Object[0]);
                    }
                }

                public void onFail(long reason) {
                    if (reason == 1L) {
                        ToastUtils.showToast((Context)((IChannelPageContext)VoiceRoomProfileCardPresenter.this.getMvpContext()).getContext(), (String)ResourceUtils.getString((int)R.string.tips_channel_notice_no_permit), (int)0);
                    }
                    MLog.error((Object)VoiceRoomProfileCardPresenter.TAG, (String)("onMakeSit fail reason = " + reason), (Object[])new Object[0]);
                }
            });
            String token = "";
            if (this.getChannel() != null && this.getChannel().getEnterParam() != null && (recommendEnterData = (RecommendEnterData)this.getChannel().getEnterParam().getExtra("from_recommend_info", null)) != null) {
                token = recommendEnterData.getToken();
            }
            SeatTrack.INSTANCE.upVoiceClick(this.getChannel().getChannelId(), "1", token);
        };
        if (this.mFunctionInterceptor != null) {
            this.mFunctionInterceptor.onMakeSit(uid, callback2);
        } else {
            callback2.done();
        }
    }

    @Override
    public void onMakeLeaveSeat(final long uid) {
        InterceptCallback callback2 = () -> {
            if (this.isDestroyed()) {
                return;
            }
            this.getChannel().getSeatService().makeStandUp(uid, new IOperationCallback(){

                public void onSuccess() {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)VoiceRoomProfileCardPresenter.TAG, (String)("onMakeLeaveSeat success uid = " + uid), (Object[])new Object[0]);
                    }
                }

                public void onFail(long reason) {
                    if (reason == 1L) {
                        ToastUtils.showToast((Context)((IChannelPageContext)VoiceRoomProfileCardPresenter.this.getMvpContext()).getContext(), (String)ResourceUtils.getString((int)R.string.tips_channel_notice_no_permit), (int)0);
                    }
                    MLog.error((Object)VoiceRoomProfileCardPresenter.TAG, (String)("onMakeLeaveSeat fail reason = " + reason), (Object[])new Object[0]);
                }
            });
            SeatTrack.INSTANCE.downVoiceClick(this.getChannel().getChannelId(), "1");
        };
        if (this.mFunctionInterceptor != null) {
            this.mFunctionInterceptor.onMakeLeaveSeat(uid, callback2);
        } else {
            callback2.done();
        }
    }

    @Override
    public void onLeaveSeatSelf(long uid) {
        InterceptCallback callback2 = () -> {
            if (this.isDestroyed()) {
                return;
            }
            this.getChannel().getSeatService().standUp(null);
            SeatTrack.INSTANCE.downVoiceClick(this.getChannel().getChannelId(), "3");
            this.getChannel().getSeatService().addSeatUpdateListener(new ISeatUpdateListener(){

                public void onSeatUpdate(List<SeatUser> seatUserList) {
                }
            });
        };
        if (this.mFunctionInterceptor != null) {
            this.mFunctionInterceptor.onLeaveSeatSelf(uid, callback2);
        } else {
            callback2.done();
        }
    }

    @Override
    public void onMakeLeaveAndLockSeat(final long uid) {
        InterceptCallback callback2 = () -> {
            if (this.isDestroyed()) {
                return;
            }
            int seatIndex = this.getChannel().getSeatService().getSeatIndex(uid);
            if (this.getChannel().getSeatService().isSeatLocked(seatIndex)) {
                this.getChannel().getSeatService().makeStandUp(uid, new IOperationCallback(){

                    public void onSuccess() {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)VoiceRoomProfileCardPresenter.TAG, (String)("onMakeLeaveAndLockSeat makeStandUp success uid = " + uid), (Object[])new Object[0]);
                        }
                    }

                    public void onFail(long reason) {
                        if (reason == 1L) {
                            ToastUtils.showToast((Context)((IChannelPageContext)VoiceRoomProfileCardPresenter.this.getMvpContext()).getContext(), (String)ResourceUtils.getString((int)R.string.tips_channel_notice_no_permit), (int)0);
                        }
                        MLog.error((Object)VoiceRoomProfileCardPresenter.TAG, (String)("onMakeLeaveAndLockSeat makeStandUp fail reason = " + reason), (Object[])new Object[0]);
                    }
                });
            } else {
                this.getChannel().getSeatService().lockSeat(true, seatIndex, new IOperationCallback(){

                    public void onSuccess() {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)VoiceRoomProfileCardPresenter.TAG, (String)("onMakeLeaveAndLockSeat lockSeat success uid = " + uid), (Object[])new Object[0]);
                        }
                    }

                    public void onFail(long reason) {
                        if (reason == 1L) {
                            ToastUtils.showToast((Context)((IChannelPageContext)VoiceRoomProfileCardPresenter.this.getMvpContext()).getContext(), (String)ResourceUtils.getString((int)R.string.tips_channel_notice_no_permit), (int)0);
                        }
                        MLog.error((Object)VoiceRoomProfileCardPresenter.TAG, (String)("onMakeLeaveAndLockSeat lockSeat fail reason = " + reason), (Object[])new Object[0]);
                    }
                });
            }
            SeatTrack.INSTANCE.onHostClickLeaveAndLock(this.getChannel().getChannelId(), this.getChannel().getPluginService().getCurPluginData().getPluginId());
        };
        if (this.mFunctionInterceptor != null) {
            this.mFunctionInterceptor.onMakeLeaveAndLockSeat(uid, callback2);
        } else {
            callback2.done();
        }
    }

    @Override
    public void onSendGiftClicked(long uid, boolean sweepAniming) {
        InterceptCallback callback2 = () -> {
            if (this.isDestroyed()) {
                return;
            }
            ((InvitePresenter)this.getPresenter(InvitePresenter.class)).hidePanel();
            ShowGiftPanelParam param2 = new ShowGiftPanelParam(2);
            param2.setSelectedUid(Collections.singletonList(uid));
            param2.setGiftCarouselAnim(sweepAniming);
            ((IRevenueToolsModulePresenter)this.getPresenter(IRevenueToolsModulePresenter.class)).getGiftPresenter().showGiftPanel(param2);
        };
        if (this.mFunctionInterceptor != null) {
            this.mFunctionInterceptor.onSendGiftClicked(uid, sweepAniming, callback2);
        } else {
            callback2.done();
        }
        ProfileCardStatistics.INSTANCE.reportGiftSendClick((IChannel)this.getChannel());
    }

    @Override
    public void onCharmValueClick(long uid) {
        if (this.isDestroyed()) {
            return;
        }
        this.jumpUrl(uid, false);
        RoomTrack.INSTANCE.reportCharmValueClick(this.getChannel().getChannelId());
        ProfileCardStatistics.INSTANCE.reportCharmClick((IChannel)this.getChannel());
    }

    @Override
    public void onContributionClick(long uid) {
        if (this.isDestroyed()) {
            return;
        }
        this.jumpUrl(uid, true);
        RoomTrack.INSTANCE.reportRichPeopleClick();
        ProfileCardStatistics.INSTANCE.reportContributionClick((IChannel)this.getChannel());
    }

    @Override
    public void onGoldenBeansClick(long uid) {
        if (this.isDestroyed()) {
            return;
        }
        Message msg = Message.obtain();
        Bundle bundle = new Bundle();
        bundle.putInt("fromType", 104);
        msg.setData(bundle);
        msg.what = AppbaseMsgDef.SHOW_WINDOW_RECHARGE;
        WalletTabConfig walletTabConfig = new WalletTabConfig();
        walletTabConfig.setLocationBean(true);
        msg.obj = walletTabConfig;
        MsgDispatcher.getInstance().sendMessage(msg);
    }

    @Override
    public void onPayLevelClick(long uid) {
        if (this.isDestroyed()) {
            return;
        }
        GrowthBusinessConfig config = (GrowthBusinessConfig)UnifyConfig.INSTANCE.getConfigData(BssCode.GROWTH_BUSINESS);
        if (config != null && StringUtils.isNotEmpty((String)config.getData().getWealthLevel().getJumpUrl())) {
            String jumpUrl = config.getData().getWealthLevel().getJumpUrl();
            StringBuilder builder = new StringBuilder(jumpUrl);
            if (AccountUtil.getUid() != uid) {
                builder.append("#/intro");
            }
            if (jumpUrl.contains("?")) {
                builder.append("&");
            } else {
                builder.append("?");
            }
            builder.append(UriProvider.appendCommonWebUrlParams());
            builder.append(StringUtils.formatWitUSLocal((String)"&uid=%d", (Object[])new Object[]{uid}));
            jumpUrl = builder.toString();
            WebEnvSettings settings = new WebEnvSettings();
            settings.url = jumpUrl;
            settings.isFullScreen = false;
            settings.isShowBackBtn = true;
            settings.webViewBackgroundColor = -1;
            settings.usePageTitle = true;
            ((IWebService)ServiceManagerProxy.getServiceManager().getService(IWebService.class)).loadUrl(settings);
        }
        RoomTrack.INSTANCE.reportProfileCardPayLevelClick(AccountUtil.getUid() == uid);
    }

    @Override
    public Boolean isRadioModel() {
        return ((IChannelPageContext)this.getMvpContext()).getChannel().getPluginService().getCurPluginData().getMode() == 14;
    }

    @Override
    public void onCameraFlip(long uid) {
        if (((IChannelPageContext)this.getMvpContext()).hasPresenter(IMultiVideoPresenter.class)) {
            ((IMultiVideoPresenter)this.getPresenter(IMultiVideoPresenter.class)).switchCamera();
        }
    }

    @Override
    public void onChangeVideo(long uid, boolean open) {
        int index = this.getChannel().getSeatService().getSeatIndex(uid);
        if (((IChannelPageContext)this.getMvpContext()).hasPresenter(IMultiVideoPresenter.class)) {
            ((IMultiVideoPresenter)this.getPresenter(IMultiVideoPresenter.class)).setVideo(index, uid, open, uid == AccountUtil.getUid(), null);
        }
    }

    private void jumpUrl(long uid, final boolean isContribution) {
        FragmentActivity context = ((IChannelPageContext)this.getMvpContext()).getContext();
        CharmValueJumpConfig config = (CharmValueJumpConfig)UnifyConfig.INSTANCE.getConfigData(BssCode.CHARM_VALUE_JUMP);
        if (config != null && config.getJumpData() != null) {
            WebViewPanel webViewPanel;
            int height;
            float heightValue = config.getJumpData().getDialogHeight();
            boolean isHeightPercent = config.getJumpData().isHeightUsePercent();
            if (isHeightPercent && heightValue > 0.0f && heightValue <= 1.0f) {
                height = (int)((float)ResolutionUtils.getScreenHeight((Context)context) * heightValue);
                webViewPanel = new WebViewPanel((Context)context);
            } else if (heightValue > 0.0f) {
                height = ResolutionUtils.dip2Px((float)heightValue);
                webViewPanel = new WebViewPanel((Context)context);
            } else {
                webViewPanel = new WebViewPanel((Context)context);
                height = 0;
            }
            final String jumpUrl = config.getJumpData().getJumpUrl();
            if (FP.empty((CharSequence)jumpUrl)) {
                return;
            }
            ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(uid, new OnProfileCallback(){

                public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                    if (FP.empty(userInfoKSList)) {
                        return;
                    }
                    UserInfoKS userInfo = userInfoKSList.get(0);
                    StringBuilder urlBuilder = new StringBuilder();
                    urlBuilder.append(jumpUrl);
                    if (jumpUrl.contains("?")) {
                        urlBuilder.append("&");
                    } else {
                        urlBuilder.append("?");
                    }
                    urlBuilder.append(UriProvider.appendCommonWebUrlParams());
                    urlBuilder.append(StringUtils.formatWitUSLocal((String)"&uid=%d", (Object[])new Object[]{userInfo.uid}));
                    urlBuilder.append(StringUtils.formatWitUSLocal((String)"&userName=%s", (Object[])new Object[]{URLUtils.encode((String)userInfo.nick)}));
                    if (isContribution) {
                        urlBuilder.append(StringUtils.formatWitUSLocal((String)"&type=%s", (Object[])new Object[]{"contribution"}));
                    }
                    String finalJumpUrl = urlBuilder.toString();
                    webViewPanel.setBottomStyle();
                    webViewPanel.setData(finalJumpUrl, ScreenUtils.getInstance().getWidthPixels(), height);
                    AbsChannelWindow window = VoiceRoomProfileCardPresenter.this.getWindow();
                    if (null != window) {
                        window.getPanelLayer().showPanel((BasePanel)webViewPanel, true);
                    }
                }

                public void onFail(int id2, String msg, String response) {
                }

                public int id() {
                    return 0;
                }
            });
        }
    }
}

