/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.profile.profilecard.voiceroom;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.kvo.HeadFrameType;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IHonorService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.press.ClickScaleAnimProvider;
import com.yy.appbase.ui.widget.bubble.BubblePopupWindow;
import com.yy.appbase.ui.widget.bubble.BubbleStyle;
import com.yy.appbase.ui.widget.bubble.RelativePos;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.CommonConfig;
import com.yy.appbase.unifyconfig.config.GrowthBusinessConfig;
import com.yy.appbase.unifyconfig.config.ProfileCardGiftEntryConfig;
import com.yy.appbase.util.RepeatClickUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.channel.ChannelNotifyDef;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.anchorfansclub.IFansClubService;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.ChannelInfo;
import com.yy.hiyo.channel.base.bean.UserTagInfo;
import com.yy.hiyo.channel.base.bean.UserTagLocation;
import com.yy.hiyo.channel.base.bean.fansgroup.AnchorFansClubBean;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.rolepermission.RolePermission;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IChannelHonorService;
import com.yy.hiyo.channel.base.service.IProfileCardHonorCallback;
import com.yy.hiyo.channel.base.service.ISeatUpdateListener;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.component.profile.fanslv.FansGroupConfig;
import com.yy.hiyo.channel.component.profile.fanslv.FansGroupData;
import com.yy.hiyo.channel.component.profile.profilecard.MiniCardBgInfo;
import com.yy.hiyo.channel.component.profile.profilecard.base.AbsProfileCardManager;
import com.yy.hiyo.channel.component.profile.profilecard.base.ViewProvider;
import com.yy.hiyo.channel.component.profile.profilecard.voiceroom.IVoiceRoomCallback;
import com.yy.hiyo.channel.component.profile.profilecard.voiceroom.OpFlags;
import com.yy.hiyo.channel.component.profile.profilecard.voiceroom.ProfileCardBeanViewModel;
import com.yy.hiyo.channel.component.profile.profilecard.voiceroom.ProfileCardDataModel;
import com.yy.hiyo.channel.component.profile.profilecard.voiceroom.VoiceRoomProfileCardData;
import com.yy.hiyo.channel.component.profile.profilecard.widget.HorFunctionListView;
import com.yy.hiyo.channel.component.profile.profilecard.widget.ProfileCardBrowserView;
import com.yy.hiyo.channel.component.profile.profilecard.widget.ProfileCardButton;
import com.yy.hiyo.channel.module.anchorlevel.AnchorLevelModel;
import com.yy.hiyo.channel.module.anchorlevel.hiido.AnchorLevelReporter;
import com.yy.hiyo.channel.module.endpage.utils.EndPageUtils;
import com.yy.hiyo.channel.utils.FollowPathKt;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.data.Relation;
import com.yy.hiyo.relation.base.data.RelationInfo;
import com.yy.hiyo.relation.base.data.RelationNumInfo;
import com.yy.hiyo.relation.base.follow.view.FollowView;
import com.yy.hiyo.relation.base.follow.view.IFollowClickInterceptor;
import com.yy.hiyo.wallet.base.IPayLevelService;
import com.yy.hiyo.wallet.base.revenue.IGetPayLevelCallback;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import net.ihago.money.api.anchorlevel.GetAnchorLevelByUIDRes;
import net.ihago.money.api.anchorlevel.SubLevelConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VoiceRoomProfileCardManager
extends AbsProfileCardManager
implements ViewProvider,
ISeatUpdateListener {
    private static final String TAG = "VoiceRoomProfileCardManager";
    protected VoiceRoomProfileCardData mProfileCardData;
    private IVoiceRoomCallback mVoiceRoomCallback;
    private ProfileCardDataModel mDataModel = new ProfileCardDataModel();
    private boolean mSweepAniming = false;
    private ProfileCardBrowserView mFollowingBrowserView;
    private ProfileCardBrowserView mFansBrowserView;
    private ProfileCardBrowserView mCharmValueBrowserView;
    private ProfileCardBrowserView mContributionBrowserView;
    private ProfileCardBrowserView mGoldenBeansBrowserView;
    private ProfileCardBrowserView mPayLevelBrowserView;
    private ProfileCardBrowserView mFansClubBrowserView;
    private ProfileCardButton mSendGiftBtnView;
    private BubblePopupWindow mGoldenBeansGuide;
    private IChannel mChannel;
    private final KvoBinder mBinder = new KvoBinder((Object)this);
    private Runnable mSweepAnimRunnable = () -> this.startSweepAnim();
    private Runnable showGoldenBeansGuideTask = () -> this.showGoldenBeanGuide();

    public VoiceRoomProfileCardManager(@NonNull Context context, @NonNull VoiceRoomProfileCardData data, IChannel channel) {
        super(context, data);
        this.mProfileCardData = data;
        this.mChannel = channel;
    }

    public void setCallback(IVoiceRoomCallback voiceRoomCallback) {
        this.setBaseCallback(voiceRoomCallback);
        this.mVoiceRoomCallback = voiceRoomCallback;
    }

    @Override
    protected void fetchData() {
        super.fetchData();
        this.fetchCharmAndContributionValue();
        this.fetchPayLevelValue();
        this.fetchAnchorLevelValue();
        this.fetchFansGroupValue();
        if (this.mProfileCardData.hasFansClubEntry) {
            this.fetchFansClubInfo(this.mProfileCardData.uid);
        }
        this.fetchBgImg();
        this.requestChannelMemberInfo(this.mProfileCardData.channelId, this.mProfileCardData.uid, this.mChannel);
        this.getUserTags(this.mProfileCardData.uid);
        if (!this.showMentioned()) {
            this.fetchGoldenBeansValue();
        }
        this.fetchFamilyInfo();
    }

    private void fetchFamilyInfo() {
        ChannelDetailInfo channelDetailInfo = ((IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class)).getChannel(this.mProfileCardData.channelId).getDataService().getCacheDetail();
        if (channelDetailInfo != null) {
            this.requestFamilyInfo(this.mProfileCardData.uid, channelDetailInfo.baseInfo);
        }
    }

    private void getUserTags(final long uid) {
        ((IChannelHonorService)ServiceManagerProxy.getServiceManager().getService(IChannelHonorService.class)).reqUserTags(uid, UserTagLocation.LOCATION_MINI_CARD.getLocation(), (ICommonCallback)new ICommonCallback<List<UserTagInfo>>(){

            public void onSuccess(List<UserTagInfo> userTagInfos, Object ... ext) {
                if (VoiceRoomProfileCardManager.this.mProfileCardDialog != null) {
                    VoiceRoomProfileCardManager.this.mProfileCardDialog.setUserTags(userTagInfos, uid);
                }
            }

            public void onFail(int errCode, String msg, Object ... ext) {
            }
        });
    }

    public void fetchBgImg() {
        this.mDataProvider.requestBgInfo(this.mProfileCardData.uid, new ICommonCallback<MiniCardBgInfo>(){

            public void onSuccess(MiniCardBgInfo miniCardBgInfo, Object ... ext) {
                if (VoiceRoomProfileCardManager.this.mProfileCardDialog == null || VoiceRoomProfileCardManager.this.mVoiceRoomCallback == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)VoiceRoomProfileCardManager.TAG, (String)"fetchFansGroupValue return", (Object[])new Object[0]);
                    }
                    return;
                }
                VoiceRoomProfileCardManager.this.mProfileCardDialog.updateBgImg(miniCardBgInfo);
            }

            public void onFail(int errCode, String msg, Object ... ext) {
            }
        });
    }

    private void fetchFansGroupValue() {
        this.mDataProvider.requestFansGroup(this.mProfileCardData.uid, new ICommonCallback<FansGroupData>(){

            public void onSuccess(FansGroupData fansGroupData, Object ... ext) {
                boolean isShow;
                boolean bl = isShow = fansGroupData.getFansGroupConfig().getValue() != null && ((FansGroupConfig)fansGroupData.getFansGroupConfig().getValue()).getTypeConfigInfo().isOnlyShow();
                if (VoiceRoomProfileCardManager.this.mProfileCardDialog == null || VoiceRoomProfileCardManager.this.mVoiceRoomCallback == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)VoiceRoomProfileCardManager.TAG, (String)"fetchFansGroupValue return", (Object[])new Object[0]);
                    }
                    return;
                }
                if (!isShow || VoiceRoomProfileCardManager.this.mVoiceRoomCallback.isRadioModel().booleanValue()) {
                    VoiceRoomProfileCardManager.this.mProfileCardDialog.updateFansGroup(fansGroupData);
                }
            }

            public void onFail(int errCode, String msg, Object ... ext) {
                MLog.error((Object)VoiceRoomProfileCardManager.TAG, (String)"fetchFansGroupValue error, code=%d", (Object[])new Object[]{errCode});
            }
        });
    }

    private void fetchCharmAndContributionValue() {
        this.mDataModel.fetchCharmAndControbution(this.mProfileCardData.channelId, this.mProfileCardData.uid, new ProfileCardDataModel.ICharmAndContributionCallback(){

            @Override
            public void updateData(long charmValue, long contribution) {
                VoiceRoomProfileCardManager.this.updateCharmValue(charmValue);
                VoiceRoomProfileCardManager.this.updateContribution(contribution);
            }

            @Override
            public void onFail(long code) {
                MLog.error((Object)VoiceRoomProfileCardManager.TAG, (String)"fetchCharmAndContributionValue error, code=%d", (Object[])new Object[]{code});
            }
        });
    }

    private void fetchGoldenBeansValue() {
        new ProfileCardBeanViewModel().fetchBeanVisible(this.mChannel.getChannelId(), (Function2<? super Boolean, ? super Long, Unit>)((Function2)(hasHistoryBean, bean2) -> {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"fetchGoldenBeansValue isVisible %s, bean %s", (Object[])new Object[]{hasHistoryBean, bean2});
            }
            this.updateGoldenBeansValue((boolean)hasHistoryBean, (long)bean2);
            return null;
        }));
    }

    private void fetchPayLevelValue() {
        ((IPayLevelService)ServiceManagerProxy.getServiceManager().getService(IPayLevelService.class)).getPayLevel(this.mProfileCardData.uid, new IGetPayLevelCallback(){

            public void onSuccess(int level) {
                VoiceRoomProfileCardManager.this.updatePayLevelBrowserView(level);
            }

            public void onFail(long code, @NotNull String msg) {
                MLog.error((Object)VoiceRoomProfileCardManager.TAG, (String)"queryUserPayLevel error code= %d", (Object[])new Object[]{code});
            }
        });
    }

    private void fetchMedalsData() {
        if (this.mDataProvider == null) {
            return;
        }
        final IChannelHonorService honorService = (IChannelHonorService)ServiceManagerProxy.getService(IChannelHonorService.class);
        if (honorService == null) {
            return;
        }
        this.mDataProvider.requestHonorList(this.mProfileCardData.uid, new IProfileCardHonorCallback(){

            public void onSuccess(@Nullable List<Integer> lightBeans, @Nullable List<Integer> grayBeans, int lightUpAmount) {
                if (VoiceRoomProfileCardManager.this.mProfileCardDialog != null) {
                    VoiceRoomProfileCardManager.this.mProfileCardDialog.updateMedals(lightBeans != null ? honorService.getHonorsByIds(lightBeans) : Collections.emptyList(), grayBeans != null ? honorService.getHonorsByIds(grayBeans) : Collections.emptyList(), lightUpAmount);
                }
            }

            public void onFailed(long code, @Nullable String reason) {
            }
        });
    }

    private void fetchGiftWallData() {
        if (this.mDataProvider == null) {
            return;
        }
        this.mDataProvider.requestGiftWallEntrance(this.mProfileCardData.uid, giftWallEntranceData -> {
            if (this.mProfileCardDialog != null) {
                this.mProfileCardDialog.updateGiftWallEntrance(giftWallEntranceData);
            }
        });
    }

    private void fetchAnchorLevelValue() {
        ChannelInfo channelInfo;
        ChannelPluginData channelPluginData;
        if (FP.nonNull((Object[])new Object[]{this.mChannel, this.mChannel.getPluginService(), this.mChannel.getDataService(), this.mChannel.getDataService().getChannelDetailInfo(null)}) && FP.nonNull((Object[])new Object[]{channelPluginData = this.mChannel.getPluginService().getCurPluginData(), channelInfo = this.mChannel.getDataService().getChannelDetailInfo(null).baseInfo}) && EndPageUtils.INSTANCE.showAnchorLevel(channelPluginData) && "radio".equals(channelPluginData.getId()) && this.mProfileCardData.uid == channelInfo.ownerUid) {
            AnchorLevelModel.INSTANCE.getAnchorLevelByUid(this.mProfileCardData.uid, new ICommonCallback<GetAnchorLevelByUIDRes>(){

                public void onSuccess(GetAnchorLevelByUIDRes data, Object ... ext) {
                    boolean hasPunish = false;
                    if (FP.nonNull((Object[])new Object[]{VoiceRoomProfileCardManager.this.mProfileCardDialog, data, data.info})) {
                        SubLevelConfig punishLevelInfo;
                        if (!data.punish_info.__isDefaultInstance() && !data.punish_info.punish_level_info.__isDefaultInstance() && (punishLevelInfo = data.punish_info.punish_level_info) != null) {
                            hasPunish = true;
                            VoiceRoomProfileCardManager.this.updateAnchorLevel(punishLevelInfo.level_icon_small, punishLevelInfo.level_name, punishLevelInfo.level_id);
                        }
                        if (!hasPunish) {
                            VoiceRoomProfileCardManager.this.updateAnchorLevel(data.info.level_icon_small, data.info.level_name, data.info.level_id);
                        }
                    }
                }

                public void onFail(int errCode, String msg, Object ... ext) {
                }
            });
        }
    }

    private void updateAnchorLevel(String levelIcon, String levelName, int levelId) {
        if (levelId == 0) {
            return;
        }
        this.mProfileCardDialog.updateAnchorLevel(levelIcon, levelName);
        AnchorLevelReporter.INSTANCE.reportLevelShow(levelId, 1, this.mProfileCardData.uid);
    }

    @Override
    public List<HorFunctionListView.ViewItem> createBrowserViews() {
        boolean showPayLevel = false;
        GrowthBusinessConfig config = (GrowthBusinessConfig)UnifyConfig.INSTANCE.getConfigData(BssCode.GROWTH_BUSINESS);
        if (config != null && config.getData().getWealthLevel().getShow()) {
            showPayLevel = true;
        }
        ArrayList<HorFunctionListView.ViewItem> itemViews = new ArrayList<HorFunctionListView.ViewItem>(showPayLevel ? 3 : 2);
        if (showPayLevel) {
            this.mPayLevelBrowserView = new ProfileCardBrowserView(this.mContext);
            this.mPayLevelBrowserView.setBg(ResourceUtils.getDrawable((int)R.drawable.bg_profile_card_wealth_1));
            this.mPayLevelBrowserView.setTextColor(ColorUtils.parseColor((String)"#B32C07"));
            this.mPayLevelBrowserView.setLevelPattern(true);
            this.mPayLevelBrowserView.updateVIPNumber(0L);
            this.mPayLevelBrowserView.updateTitle(R.string.tips_vip_msg);
            this.mPayLevelBrowserView.setLeftIcon(R.drawable.icon_profile_card_wealth_level_0);
            HorFunctionListView.ViewItem payLevelView = HorFunctionListView.ViewItem.builder(this.mContext).contentView((View)this.mPayLevelBrowserView, -1, -2).build();
            payLevelView.getView().setOnClickListener(v -> {
                if (RepeatClickUtils.canRepeatClick((String)"voice_room_profile_charm_value") && this.mVoiceRoomCallback != null) {
                    this.close();
                    this.mVoiceRoomCallback.onPayLevelClick(this.mProfileCardData.uid);
                }
            });
            itemViews.add(payLevelView);
        }
        this.mContributionBrowserView = new ProfileCardBrowserView(this.mContext);
        this.mContributionBrowserView.setBg(ResourceUtils.getDrawable((int)R.drawable.bg_profile_card_contribution));
        this.mContributionBrowserView.setTextColor(ColorUtils.parseColor((String)"#007E76"));
        this.mContributionBrowserView.updateNumber(0L);
        this.mContributionBrowserView.updateTitle(R.string.btn_profile_contribution_value);
        this.mContributionBrowserView.setLeftIcon(R.drawable.ic_contribution_value);
        HorFunctionListView.ViewItem contributionView = HorFunctionListView.ViewItem.builder(this.mContext).contentView((View)this.mContributionBrowserView, -1, -2).build();
        contributionView.getView().setOnClickListener(v -> {
            if (RepeatClickUtils.canRepeatClick((String)"voice_room_profile_contribution_value") && this.mVoiceRoomCallback != null) {
                this.close();
                this.mVoiceRoomCallback.onContributionClick(this.mProfileCardData.uid);
            }
        });
        itemViews.add(contributionView);
        this.mCharmValueBrowserView = new ProfileCardBrowserView(this.mContext);
        this.mCharmValueBrowserView.setBg(ResourceUtils.getDrawable((int)R.drawable.bg_profile_card_charisma));
        this.mCharmValueBrowserView.setTextColor(ColorUtils.parseColor((String)"#DB6600"));
        this.mCharmValueBrowserView.updateNumber(0L);
        this.mCharmValueBrowserView.updateTitle(R.string.btn_profile_charm_value);
        this.mCharmValueBrowserView.setLeftIcon(R.drawable.ic_charm_value);
        HorFunctionListView.ViewItem charmValueView = HorFunctionListView.ViewItem.builder(this.mContext).contentView((View)this.mCharmValueBrowserView, -1, -2).build();
        charmValueView.getView().setOnClickListener(v -> {
            if (RepeatClickUtils.canRepeatClick((String)"voice_room_profile_charm_value") && this.mVoiceRoomCallback != null) {
                this.close();
                this.mVoiceRoomCallback.onCharmValueClick(this.mProfileCardData.uid);
            }
        });
        itemViews.add(charmValueView);
        if (this.mProfileCardData.uid != AccountUtil.getUid()) {
            this.mFansBrowserView = new ProfileCardBrowserView(this.mContext);
            this.mFansBrowserView.updateTitle(R.string.btn_profile_card_bottom_fans);
            HorFunctionListView.ViewItem fansView = HorFunctionListView.ViewItem.builder(this.mContext).contentView((View)this.mFansBrowserView, -1, -2).build();
            if (this.mProfileCardData.uid == AccountUtil.getUid()) {
                fansView.getView().setOnClickListener(v -> {
                    if (this.mVoiceRoomCallback != null) {
                        this.close();
                        this.mVoiceRoomCallback.onFansListClicked(this.mProfileCardData.uid);
                    }
                });
            }
        }
        boolean showBean = true;
        FeatureLog.i((String)"FTVoiceRoomChat", (String)"The profile golden bean ABTest result is A: %b", (Object[])new Object[]{showBean});
        if (this.mProfileCardData.uid == AccountUtil.getUid() && showBean) {
            this.mGoldenBeansBrowserView = new ProfileCardBrowserView(this.mContext);
            this.mGoldenBeansBrowserView.updateNumber(0L);
            this.mGoldenBeansBrowserView.updateTitle(R.string.title_wallet_bean);
            this.mGoldenBeansBrowserView.setLeftIcon(R.drawable.icon_golden_bean);
            HorFunctionListView.ViewItem goldenBeansView = HorFunctionListView.ViewItem.builder(this.mContext).contentView((View)this.mGoldenBeansBrowserView, -1, -2).build();
            goldenBeansView.getView().setOnClickListener(v -> {
                if (RepeatClickUtils.canRepeatClick((String)"voice_room_profile_golden_beans_value") && this.mVoiceRoomCallback != null) {
                    this.close();
                    this.mVoiceRoomCallback.onGoldenBeansClick(this.mProfileCardData.uid);
                }
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "picture_bean_but_click").put("room_id", this.mProfileCardData.channelId).put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("gid", RoomTrack.INSTANCE.getPluginId(this.mProfileCardData.channelId)).put("user_role", String.valueOf(RoomTrack.INSTANCE.getUserRole(this.mProfileCardData.channelId))));
            });
        }
        if (this.mProfileCardData.hasFansClubEntry) {
            this.mFansClubBrowserView = new ProfileCardBrowserView(this.mContext);
            this.mFansClubBrowserView.setBg(ResourceUtils.getDrawable((int)R.drawable.bg_profile_card_fans_club));
            this.mFansClubBrowserView.setTextColor(ColorUtils.parseColor((String)"#6949C9"));
            this.mFansClubBrowserView.updateNumber(0L);
            this.mFansClubBrowserView.updateTitle("");
            this.mFansClubBrowserView.setLeftIcon(R.drawable.icon_fans_club_default);
            HorFunctionListView.ViewItem fansClubView = HorFunctionListView.ViewItem.builder(this.mContext).contentView((View)this.mFansClubBrowserView, -1, -2).build();
            fansClubView.getView().setOnClickListener(v -> {
                if (ServiceManagerProxy.getService(IFansClubService.class) != null) {
                    this.close();
                    if (this.mProfileCardData.anchorUid == AccountUtil.getUid()) {
                        ((IFansClubService)ServiceManagerProxy.getService(IFansClubService.class)).showFansClubMembers(this.mProfileCardData.anchorUid);
                    } else {
                        ((IFansClubService)ServiceManagerProxy.getService(IFansClubService.class)).openFansClubCard(this.mProfileCardData.anchorUid);
                    }
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("60041647").put("function_id", "small_card_entry_click"));
                }
            });
            itemViews.add(fansClubView);
        }
        return itemViews;
    }

    @Override
    public List<HorFunctionListView.ViewItem> createBtnViews() {
        HorFunctionListView.ViewItem sendGiftBtnItem;
        FrameLayout.LayoutParams lp;
        ArrayList<HorFunctionListView.ViewItem> viewItems = new ArrayList<HorFunctionListView.ViewItem>(2);
        if (this.mProfileCardData.uid != AccountUtil.getUid()) {
            this.mFollowBtnView = new FollowView(this.mContext);
            this.mFollowBtnView.setMFollowBackString(this.mContext.getString(R.string.follow_back));
            if (!this.mFollowBtnView.getMIsNewUi()) {
                this.mFollowBtnView.setFollowEachBg(this.mContext.getResources().getDrawable(R.drawable.select_ffc102_bg));
                this.mFollowBtnView.setFollowingBg(this.mContext.getResources().getDrawable(R.drawable.select_ffc102_bg));
                ClickScaleAnimProvider.apply((View)this.mFollowBtnView);
            } else {
                this.mFollowBtnView.setFollowingBg(this.mContext.getResources().getDrawable(R.drawable.bg_follow_base));
                this.mFollowBtnView.setFollowEachBg(this.mContext.getResources().getDrawable(R.drawable.bg_follow_no_base));
            }
            this.mFollowBtnView.setTextSize(16.0f);
            this.mFollowBtnView.setBoldStyle();
            this.mFollowBtnView.setFollowStatusListener((followStatus, oldStatus) -> {
                if (viewItems.size() <= 0) {
                    return;
                }
                if (viewItems.size() == 1) {
                    this.mFollowBtnView.setTextState(0);
                } else {
                    this.mFollowBtnView.setTextState(2);
                }
                int followWeight = 1;
                int chatWeight = 1;
                int giftWeight = 1;
                if (oldStatus.getValue() != Relation.FOLLOW.getValue() && followStatus.isFollow() && this.mProfileCardData.uid != AccountUtil.getUid() && this.mProfileCardData.role == 15) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)"follow uid:%s, role:%s", (Object[])new Object[]{this.mProfileCardData.uid, this.mProfileCardData.role});
                    }
                    NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ChannelNotifyDef.NOTIFY_FOLLOW_SUCCESS));
                }
                if (followStatus.isFollow()) {
                    if (NAB.B.equals((Object)NewABDefine.FOLLOW_CHAT.getTest())) {
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "ola_chat_enter_show").put("clicked_uid", followStatus.getUid() + "").put("user_uid", AccountUtil.getUid() + ""));
                        this.mFollowBtnView.setFollowEachBg(this.mContext.getResources().getDrawable(R.drawable.bg_follow_base));
                        this.mFollowBtnView.setFollowIcon(this.mContext.getResources().getDrawable(R.drawable.icon_follow_chat));
                        this.mFollowBtnView.setFollowText(ResourceUtils.getString((int)R.string.profile_chat));
                        this.mFollowBtnView.setFollowTextColor(ColorUtils.parseColor((String)"#FFFFFF"));
                    }
                } else if (NAB.B.equals((Object)NewABDefine.FOLLOW_CHAT.getTest())) {
                    this.mFollowBtnView.setFollowText(ResourceUtils.getString((int)R.string.string_follow));
                    this.mFollowBtnView.setFollowTextColor(ColorUtils.parseColor((String)"#333333"));
                }
                if (viewItems.size() > 1) {
                    if (followStatus.isFollow()) {
                        if (viewItems.size() > 2) {
                            chatWeight = 6;
                            followWeight = 5;
                            giftWeight = 3;
                        } else if (!this.mFollowBtnView.getMIsNewUi()) {
                            followWeight = 2;
                        }
                    } else if (viewItems.size() > 2) {
                        chatWeight = 6;
                        followWeight = 4;
                        giftWeight = 4;
                    } else {
                        followWeight = 1;
                    }
                }
                for (HorFunctionListView.ViewItem view : viewItems) {
                    LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)view.getView().getLayoutParams();
                    if (view.getContentView() instanceof FollowView) {
                        layoutParams.weight = followWeight;
                    } else if (view.getContentView() instanceof YYImageView) {
                        layoutParams.weight = chatWeight;
                    } else if (view.getContentView() instanceof ProfileCardButton) {
                        layoutParams.weight = giftWeight;
                    }
                    view.getView().setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                }
            });
            this.mFollowBtnView.setClickInterceptor(new IFollowClickInterceptor(){

                public boolean interceptor(RelationInfo followStatus) {
                    VoiceRoomProfileCardManager.this.doFollowOrUnFollowOther(followStatus);
                    VoiceRoomProfileCardManager.this.startSweepAnim();
                    YYTaskExecutor.removeTask((Runnable)VoiceRoomProfileCardManager.this.mSweepAnimRunnable);
                    return true;
                }
            });
            if (this.mFollowBtnView.getMIsNewUi()) {
                this.mFollowBtnView.setWidthMathParent(true);
            }
            lp = new FrameLayout.LayoutParams(-1, ResolutionUtils.dip2Px((float)40.0f));
            sendGiftBtnItem = HorFunctionListView.ViewItem.builder(this.mContext).contentView((View)this.mFollowBtnView, lp).build();
            viewItems.add(sendGiftBtnItem);
        }
        if (this.mProfileCardData.isInSeat && this.configSwitch()) {
            this.mSendGiftBtnView = new ProfileCardButton(this.mContext);
            this.mSendGiftBtnView.setOnClickListener(v -> {
                if (this.mVoiceRoomCallback != null) {
                    this.close();
                    this.mVoiceRoomCallback.onSendGiftClicked(this.mProfileCardData.uid, this.mSweepAniming);
                }
            });
            this.mSendGiftBtnView.updateBackground(R.drawable.shape_profile_card_gift_bg_new);
            this.mSendGiftBtnView.updateIcon(R.drawable.icon_profile_card_send_gift);
            this.mSendGiftBtnView.updateText(R.color.white, R.string.btn_profile_card_send_gift);
            this.mSendGiftBtnView.setTextSize(16);
            this.mSendGiftBtnView.setBoldStyle();
            lp = new FrameLayout.LayoutParams(-1, ResolutionUtils.dip2Px((float)40.0f));
            sendGiftBtnItem = HorFunctionListView.ViewItem.builder(this.mContext).contentView((View)this.mSendGiftBtnView, lp).build();
            viewItems.add(sendGiftBtnItem);
            if (this.mProfileCardData.uid != AccountUtil.getUid()) {
                YYTaskExecutor.postToMainThread((Runnable)this.mSweepAnimRunnable, (long)5000L);
            }
        }
        return viewItems;
    }

    private boolean configSwitch() {
        AConfigData config;
        if (this.mProfileCardData.uid == AccountUtil.getUid() && this.mVoiceRoomCallback != null && this.mVoiceRoomCallback.isRadioModel().booleanValue() && (config = UnifyConfig.INSTANCE.getConfigData(BssCode.PROFILE_CARD_GIFT_ENTRY_SWITCH)) instanceof ProfileCardGiftEntryConfig) {
            return !((ProfileCardGiftEntryConfig)config).isClose(AccountUtil.realCountry());
        }
        return true;
    }

    @Override
    public List<HorFunctionListView.ViewItem> createOperationViews() {
        int opFlags = 0;
        if (this.mProfileCardData.uid == AccountUtil.getUid()) {
            if (this.mProfileCardData.isInSeat) {
                if (this.mProfileCardData.canOpSeat) {
                    opFlags |= 4;
                }
                if (this.mProfileCardData.canOpMic) {
                    opFlags |= 0x80;
                }
                if (this.mProfileCardData.canOpVideo) {
                    opFlags |= 0x20;
                    opFlags |= 0x40;
                }
            }
        } else {
            boolean isMeAnchor = false;
            if (null != this.mChannel && null != this.mChannel.getRoleService()) {
                isMeAnchor = this.mChannel.getRoleService().isMeAnchor();
            }
            if (this.mProfileCardData.mineRoleSession.getRole() > this.mProfileCardData.targetRoleSession.getRole() || isMeAnchor && this.mProfileCardData.targetRoleSession.getRole() < 10) {
                if (this.mProfileCardData.isInSeat) {
                    if (this.mProfileCardData.mineRoleSession.hasPermission(RolePermission.MANAGE_SEAT) && this.mProfileCardData.canOpSeat) {
                        if (!("multivideo".equals(this.mChannel.getPluginService().getCurPluginData().getId()) || this.mProfileCardData.isInFirstSeat && this.mChannel.getPluginService().getCurPluginData().getMode() != 16)) {
                            opFlags |= 1;
                        }
                        opFlags |= 4;
                    }
                    if (this.mProfileCardData.mineRoleSession.hasPermission(RolePermission.KICK_OUT_CHANNEL) && this.mProfileCardData.targetRoleSession.getRole() == 1) {
                        opFlags |= 8;
                    } else if (this.mProfileCardData.mineRoleSession.hasPermission(RolePermission.SET_ROLE)) {
                        opFlags |= 0x10;
                    }
                    if (this.mProfileCardData.mineRoleSession.hasPermission(RolePermission.MANAGE_SEAT) && this.mProfileCardData.canOpMic) {
                        opFlags |= 0x80;
                    }
                    if (this.mProfileCardData.canOpVideo) {
                        opFlags |= 0x20;
                    }
                } else if (this.mProfileCardData.isInChannel) {
                    if (this.mProfileCardData.mineRoleSession.hasPermission(RolePermission.MANAGE_SEAT) && this.mProfileCardData.canOpSeat) {
                        opFlags |= 2;
                    }
                    if (this.mProfileCardData.mineRoleSession.hasPermission(RolePermission.KICK_OUT_CHANNEL) && this.mProfileCardData.targetRoleSession.getRole() == 1) {
                        opFlags |= 8;
                    } else if (this.mProfileCardData.mineRoleSession.hasPermission(RolePermission.SET_ROLE)) {
                        opFlags |= 0x10;
                    }
                }
            }
        }
        if ("radio".equals(this.mChannel.getPluginService().getCurPluginData().getId()) && (this.mProfileCardData.mineRoleSession.getRole() != 15 && !this.mChannel.getRoleService().isMeAnchor() || this.mProfileCardData.uid != AccountUtil.getUid())) {
            opFlags &= 0xFFFFFFFD;
            opFlags &= 0xFFFFFFFB;
        }
        return this.buildOperationViews(opFlags);
    }

    @Override
    public boolean showMentioned() {
        return this.mProfileCardData.uid != AccountUtil.getUid();
    }

    @Override
    public boolean showMedals() {
        this.fetchMedalsData();
        return true;
    }

    @Override
    public boolean showGiftWall() {
        boolean giftWallSwitch = false;
        AConfigData commonConfig = UnifyConfig.INSTANCE.getConfigData(BssCode.COMMON_CONFIG);
        if (commonConfig instanceof CommonConfig) {
            giftWallSwitch = ((CommonConfig)commonConfig).getData().giftWallSwitch;
        }
        if (giftWallSwitch) {
            this.fetchGiftWallData();
        }
        return giftWallSwitch;
    }

    private List<HorFunctionListView.ViewItem> buildOperationViews(int flags) {
        ArrayList<HorFunctionListView.ViewItem> itemViews = new ArrayList<HorFunctionListView.ViewItem>(4);
        if (OpFlags.withFlag(flags, 1)) {
            itemViews.add(this.createOperationViewItem(R.drawable.icon_profile_card_lock, R.string.btn_profile_card_bottom_leave_lock, v -> {
                if (this.mVoiceRoomCallback != null) {
                    this.close();
                    this.mVoiceRoomCallback.onMakeLeaveAndLockSeat(this.mProfileCardData.uid);
                }
            }));
        }
        if (OpFlags.withFlag(flags, 2)) {
            itemViews.add(this.createOperationViewItem(R.drawable.icon_profile_card_sit, R.string.btn_profile_card_bottom_sit, v -> {
                if (this.mVoiceRoomCallback != null) {
                    this.close();
                    this.mVoiceRoomCallback.onMakeSit(this.mProfileCardData.uid);
                }
            }));
        }
        if (OpFlags.withFlag(flags, 4) && !"hago.amongus".equals(this.mProfileCardData.roomSource)) {
            itemViews.add(this.createOperationViewItem(R.drawable.icon_profile_card_leave_seat, R.string.btn_profile_card_bottom_leave_seat, v -> {
                if (this.mVoiceRoomCallback != null) {
                    this.close();
                    if (this.mProfileCardData.uid == AccountUtil.getUid()) {
                        this.mVoiceRoomCallback.onLeaveSeatSelf(this.mProfileCardData.uid);
                    } else {
                        this.mVoiceRoomCallback.onMakeLeaveSeat(this.mProfileCardData.uid);
                    }
                }
            }));
        }
        if (OpFlags.withFlag(flags, 8)) {
            itemViews.add(this.createOperationViewItem(R.drawable.icon_profile_card_tick_out, R.string.btn_profile_card_bottom_tick_out, v -> {
                if (this.mVoiceRoomCallback != null) {
                    this.close();
                    this.mVoiceRoomCallback.onKickOut(this.mProfileCardData.uid);
                }
            }));
        }
        if (OpFlags.withFlag(flags, 16)) {
            itemViews.add(this.createOperationViewItem(R.drawable.icon_profile_card_tick_out, R.string.title_channel_remove_manager, v -> {
                if (this.mVoiceRoomCallback != null) {
                    this.close();
                    this.mVoiceRoomCallback.onRemoveMember(this.mProfileCardData.uid);
                }
            }));
        }
        if (OpFlags.withFlag(flags, 128)) {
            itemViews.add(this.createMicOperationViewItem());
        }
        if (OpFlags.withFlag(flags, 32)) {
            itemViews.add(this.createVideoOperationViewItem());
        }
        if (OpFlags.withFlag(flags, 64)) {
            itemViews.add(this.createFlipOperationViewItem());
        }
        return itemViews;
    }

    @Override
    public void onViewInit() {
        super.onViewInit();
    }

    @Override
    public void onViewDestroy() {
        super.onViewDestroy();
        this.removeSweepAnim();
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.showGoldenBeansGuideTask);
        if (this.mGoldenBeansGuide != null) {
            this.mGoldenBeansGuide.dismiss();
            this.mGoldenBeansGuide = null;
        }
    }

    @Override
    protected void onBindData() {
        super.onBindData();
        if (this.mProfileCardData.uid == AccountUtil.getUid()) {
            HeadFrameType headFrameType = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getHeadFrameType();
            Kvo.addKvoBinding((KvoSource)headFrameType, (Object)this, (String)"onMyHeadFrameTypeUpdate");
        }
        if (this.mFollowBtnView != null) {
            this.mFollowBtnView.bindFollowStatus(this.mProfileCardData.uid, FollowPathKt.followPath(this.mChannel).getValue());
        }
        RelationNumInfo relationNum = ((IRelationService)ServiceManagerProxy.getInstance().getService(IRelationService.class)).getRelationNum(this.mProfileCardData.uid, true, null);
        this.mBinder.singleBindSourceTo((KvoSource)relationNum);
    }

    @Override
    protected void onUnbindData() {
        super.onUnbindData();
        if (this.mProfileCardData.uid == AccountUtil.getUid()) {
            HeadFrameType headFrameType = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getHeadFrameType();
            Kvo.removeKvoBinding((KvoSource)headFrameType, (Object)this, (String)"onMyHeadFrameTypeUpdate");
        }
        if (this.mFollowBtnView != null) {
            this.mFollowBtnView.removeBinding();
        }
        this.mBinder.clearAllKvoConnections();
    }

    private void showGlodenBeansTip() {
        boolean hadShowGoldenBeansGuide = SettingFlags.getBoolean((String)"key_show_goden_beans_guide", (boolean)false);
        if (hadShowGoldenBeansGuide) {
            return;
        }
        YYTaskExecutor.postToMainThread((Runnable)this.showGoldenBeansGuideTask, (long)300L);
    }

    private void startSweepAnim() {
        if (this.mSendGiftBtnView != null && !this.mSweepAniming) {
            this.mSweepAniming = true;
            this.mSendGiftBtnView.startSweepTransAnim(this.mProfileCardData.uid == AccountUtil.getUid());
        }
    }

    private void initGoldenBeanGuide() {
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_golden_beans_guide_channel, null);
        BubbleStyle bubbleStyle = (BubbleStyle)view.findViewById(R.id.bll_root);
        bubbleStyle.setFillColor(Color.parseColor((String)"#59CB31"));
        bubbleStyle.setCornerRadius((float)ResolutionUtils.dip2Px((float)3.0f));
        bubbleStyle.setPadding(0, 0, ResolutionUtils.dip2Px((float)12.0f), 0);
        this.mGoldenBeansGuide = new BubblePopupWindow(view, bubbleStyle);
    }

    private void showGoldenBeanGuide() {
        if (this.mGoldenBeansBrowserView == null) {
            return;
        }
        this.initGoldenBeanGuide();
        RelativePos relativePos = new RelativePos(0, 1);
        this.mGoldenBeansGuide.showArrowToWithMarginH((View)this.mGoldenBeansBrowserView, relativePos, ResolutionUtils.dip2Px((float)12.0f), -ResolutionUtils.dip2Px((float)20.0f), true);
        SettingFlags.setBoolean((String)"key_show_goden_beans_guide", (boolean)true);
    }

    private void removeSweepAnim() {
        YYTaskExecutor.removeTask((Runnable)this.mSweepAnimRunnable);
        if (this.mSendGiftBtnView != null) {
            this.mSweepAniming = false;
            this.mSendGiftBtnView.removeSweepAnim();
        }
    }

    @KvoMethodAnnotation(name="followNum", sourceClass=RelationNumInfo.class, thread=1)
    public void updateFollowNumber(KvoEventIntent event) {
        RelationNumInfo relationNumInfo = (RelationNumInfo)event.source();
        long followNumber = relationNumInfo.getFollowNum();
        if (followNumber < 0L) {
            followNumber = 0L;
        }
        FeatureLog.i((String)"FTVoiceRoomFollow", (String)"profile card follow number: %s", (Object[])new Object[]{followNumber});
        if (this.mFollowingBrowserView != null) {
            this.mFollowingBrowserView.updateNumber(followNumber);
        }
        if (null != this.mSelfFollowingView) {
            this.mSelfFollowingView.updateNumber(followNumber);
        }
    }

    @KvoMethodAnnotation(name="fansNum", sourceClass=RelationNumInfo.class, thread=1)
    public void updateFansNumber(KvoEventIntent event) {
        RelationNumInfo relationNumInfo = (RelationNumInfo)event.source();
        long fansNumber = relationNumInfo.getFansNum();
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTVoiceRoomFollow", (String)"profile card fans number: %s", (Object[])new Object[]{fansNumber});
        }
        if (this.mFansBrowserView != null) {
            this.mFansBrowserView.updateNumber(fansNumber);
        }
        if (null != this.mSelfFansView) {
            this.mSelfFansView.updateNumber(fansNumber);
        }
        if (this.mProfileCardDialog != null) {
            this.mProfileCardDialog.updateOtherFans(fansNumber);
        }
    }

    @KvoMethodAnnotation(name="headFrameType", sourceClass=HeadFrameType.class)
    public void onMyHeadFrameTypeUpdate(KvoEventIntent event) {
        if (this.mProfileCardData.uid != AccountUtil.getUid()) {
            return;
        }
        int frameId = (int)((HeadFrameType)event.source()).headFrameType;
        this.updateHeadFrame(frameId);
    }

    public void updateCharmValue(long value) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTVoiceRoomFollow", (String)"profile card charm value: %s", (Object[])new Object[]{value});
        }
        if (value <= 0L) {
            this.mCharmValueBrowserView.setLeftIcon(R.drawable.ic_charm_value_0);
            this.mCharmValueBrowserView.setBackgroundResource(R.drawable.bg_profile_card_revenue_0);
            this.mCharmValueBrowserView.setTextColor(ColorUtils.parseColor((String)"#999999"));
        } else {
            this.mCharmValueBrowserView.setLeftIcon(R.drawable.ic_charm_value);
            this.mCharmValueBrowserView.setBackgroundResource(R.drawable.bg_profile_card_charisma);
            this.mCharmValueBrowserView.setTextColor(ColorUtils.parseColor((String)"#DB6600"));
        }
        if (this.mCharmValueBrowserView != null) {
            this.mCharmValueBrowserView.updateNumber(value);
        }
    }

    public void updateContribution(long value) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTVoiceRoomFollow", (String)"profile card contribution: %s", (Object[])new Object[]{value});
        }
        if (value <= 0L) {
            this.mContributionBrowserView.setLeftIcon(R.drawable.ic_contribution_value_0);
            this.mContributionBrowserView.setBackgroundResource(R.drawable.bg_profile_card_revenue_0);
            this.mContributionBrowserView.setTextColor(ColorUtils.parseColor((String)"#999999"));
        } else {
            this.mContributionBrowserView.setLeftIcon(R.drawable.ic_contribution_value);
            this.mContributionBrowserView.setBackgroundResource(R.drawable.bg_profile_card_contribution);
            this.mContributionBrowserView.setTextColor(ColorUtils.parseColor((String)"#007e76"));
        }
        if (this.mContributionBrowserView != null) {
            this.mContributionBrowserView.updateNumber(value);
        }
    }

    private void updateGoldenBeansValue(boolean hasHistoryBean, long value) {
        if (this.mProfileCardDialog != null) {
            this.mProfileCardDialog.updateGoldenBeansCount(hasHistoryBean, value);
        }
    }

    private void updatePayLevelBrowserView(int level) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTVoiceRoomFollow", (String)"profile card pay level value: %d", (Object[])new Object[]{level});
        }
        if (this.mPayLevelBrowserView == null) {
            return;
        }
        if (level >= 28) {
            this.mPayLevelBrowserView.setTextColor(ColorUtils.parseColor((String)"#A95B1B"));
            this.mPayLevelBrowserView.setBackground(ResourceUtils.getDrawable((int)R.drawable.bg_profile_card_wealth_28));
            this.mPayLevelBrowserView.setLeftIcon(R.drawable.icon_profile_card_wealth_level_28);
        } else if (level >= 14) {
            this.mPayLevelBrowserView.setTextColor(ColorUtils.parseColor((String)"#A91B1B"));
            this.mPayLevelBrowserView.setBackground(ResourceUtils.getDrawable((int)R.drawable.bg_profile_card_wealth_14));
            this.mPayLevelBrowserView.setLeftIcon(R.drawable.icon_profile_card_wealth_level_14);
        } else if (level >= 5) {
            this.mPayLevelBrowserView.setTextColor(ColorUtils.parseColor((String)"#1B76A9"));
            this.mPayLevelBrowserView.setBackground(ResourceUtils.getDrawable((int)R.drawable.bg_profile_card_wealth_5));
            this.mPayLevelBrowserView.setLeftIcon(R.drawable.icon_profile_card_wealth_level_5);
        } else if (level >= 1) {
            this.mPayLevelBrowserView.setTextColor(ColorUtils.parseColor((String)"#B32C07"));
            this.mPayLevelBrowserView.setBackground(ResourceUtils.getDrawable((int)R.drawable.bg_profile_card_wealth_1));
            this.mPayLevelBrowserView.setLeftIcon(R.drawable.icon_profile_card_wealth_level_1);
        } else {
            this.mPayLevelBrowserView.setTextColor(ColorUtils.parseColor((String)"#999999"));
            this.mPayLevelBrowserView.setBackground(ResourceUtils.getDrawable((int)R.drawable.bg_profile_card_revenue_0));
            this.mPayLevelBrowserView.setLeftIcon(R.drawable.icon_profile_card_wealth_level_0);
        }
        this.mPayLevelBrowserView.updateVIPNumber(level);
    }

    @Override
    protected void updateHeadFrame(int id2) {
        IHonorService.HeadFrame headFrame = ((IHonorService)ServiceManagerProxy.getService(IHonorService.class)).getHeadFrameFromCache(id2);
        if (headFrame != null && StringUtils.isNotEmpty((String)headFrame.url) && !headFrame.onlyBBS) {
            super.updateHeadFrame(id2);
        }
    }

    public void setMentionVisible(boolean visible) {
        if (this.mProfileCardDialog != null) {
            this.mProfileCardDialog.setMentionVisible(visible);
        }
    }

    @Override
    public boolean avatarNeedShake() {
        boolean abSwitch = NAB.A.equals((Object)NewABDefine.PROFILE_SHAKE_GUIDE.getTest());
        boolean self = AccountUtil.getUid() == this.mProfileCardData.uid;
        int count = SettingFlags.getIntValue((String)"AVATAR_SHAKE_TIMES", (int)0);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("avatarNeedShake abSwitch = " + abSwitch + ",counter = " + count + ",self = " + self), (Object[])new Object[0]);
        }
        return abSwitch && count < 2 && !self;
    }

    private void fetchFansClubInfo(long uid) {
        IFansClubService fansClubService = (IFansClubService)ServiceManagerProxy.getService(IFansClubService.class);
        if (fansClubService != null) {
            fansClubService.requestAnchorFansClubInfo(uid, (Function1)new Function1<AnchorFansClubBean, Unit>(){

                public Unit invoke(AnchorFansClubBean anchorFansClubBean) {
                    if (VoiceRoomProfileCardManager.this.mFansClubBrowserView != null) {
                        VoiceRoomProfileCardManager.this.mFansClubBrowserView.updateTitle(anchorFansClubBean.getClubName());
                        VoiceRoomProfileCardManager.this.mFansClubBrowserView.updateNumber(anchorFansClubBean.getIntimacy());
                    }
                    return null;
                }
            });
        }
    }

    @Override
    protected void doFollowOrUnFollowOther(RelationInfo followStatus) {
        if (followStatus != null && followStatus.isFollow() && NAB.B.equals((Object)NewABDefine.FOLLOW_CHAT.getTest())) {
            Bundle bundle = new Bundle();
            Message message = Message.obtain();
            message.what = BaseMsgDef.IM_ROOM_SHOW;
            bundle.putLong("target_uid", followStatus.getUid());
            message.setData(bundle);
            MsgDispatcher.getInstance().sendMessageSync(message);
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "ola_chat_enter_click").put("clicked_uid", followStatus.getUid() + "").put("user_uid", AccountUtil.getUid() + ""));
            if (this.mDialogLinkManager != null) {
                this.mDialogLinkManager.dismissDialog();
            }
            return;
        }
        super.doFollowOrUnFollowOther(followStatus);
    }
}

