/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.profile.profilecard.channel;

import android.content.Context;
import androidx.annotation.NonNull;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IOperationCallback;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.component.profile.profilecard.base.FunctionInterceptor;
import com.yy.hiyo.channel.component.profile.profilecard.base.InterceptCallback;
import com.yy.hiyo.channel.component.profile.profilecard.base.ProfileCardPresenter;
import com.yy.hiyo.channel.component.profile.profilecard.channel.ChannelFunctionInterceptor;
import com.yy.hiyo.channel.component.profile.profilecard.channel.ChannelProfileCardData;
import com.yy.hiyo.channel.component.profile.profilecard.channel.ChannelProfileCardManager;
import com.yy.hiyo.channel.component.profile.profilecard.channel.IChannelCallback;
import com.yy.hiyo.channel.component.profile.profilecard.helper.ProfileCardStatistics;
import com.yy.hiyo.channel.plugins.general.innerpresenter.GameOpenChannelPresenter;
import com.yy.hiyo.user.base.profilecard.OpenProfileFrom;
import javax.annotation.Nonnull;

public class ChannelProfileCardPresenter
extends ProfileCardPresenter
implements IChannelCallback {
    private static final String TAG = "ChannelProfileCardPresenter";
    private ChannelFunctionInterceptor mFunctionInterceptor;

    @Override
    public void showProfileCard(long uid, @Nonnull OpenProfileFrom from) {
        if (this.isDestroyed()) {
            return;
        }
        if (this.getChannel().getSeatService().isInSeat(uid)) {
            this.showProfileCard(uid, true, from);
        } else {
            super.showProfileCard(uid, from);
        }
    }

    private String getStatisEnterType(int enterType) {
        if (enterType == OpenProfileFrom.FROM_SEAT.getValue()) {
            return "1";
        }
        if (enterType == OpenProfileFrom.FROM_MICUP.getValue()) {
            return "2";
        }
        return "9";
    }

    @Override
    public void showProfileCard(long uid, boolean inChannel, @Nonnull OpenProfileFrom from) {
        if (this.isDestroyed()) {
            return;
        }
        ChannelProfileCardData data = this.buildProfileCardData(uid, from);
        data.isInChannel = inChannel;
        ChannelProfileCardManager manager = new ChannelProfileCardManager((IChannelPageContext)this.getMvpContext(), data);
        manager.setCallback(this);
        manager.setSeatUpdateNotifier(this.createSeatUpdateNotifier());
        manager.setDataProvider(this);
        manager.show();
        String userType = this.getChannel().getRoleService().getMyRoleCache() == 15 ? "1" : (this.getChannel().getSeatService().isInSeat(uid) ? "2" : "3");
        RoomTrack.INSTANCE.pictureClick(this.getChannelId(), userType, uid == AccountUtil.getUid(), this.getStatisEnterType(from.getValue()), this.getChannel().getPluginService().getCurPluginData().isVideoMode(), uid);
        ProfileCardStatistics.INSTANCE.reportProfileCardShow((IChannel)this.getChannel(), from, uid);
    }

    private ChannelProfileCardData buildProfileCardData(long uid, OpenProfileFrom from) {
        ChannelProfileCardData data = new ChannelProfileCardData();
        data.from = from;
        data.uid = uid;
        data.channelId = this.getChannel().getChannelId();
        EnterParam enterParam = this.getChannel().getEnterParam();
        if (enterParam != null) {
            data.enterChannelEntry = enterParam.entry;
            data.enterParamExtra = enterParam.extra;
            if (!FP.empty((CharSequence)enterParam.postId) && uid == enterParam.matchedUid) {
                data.enterParamExtra.put("post_id", enterParam.postId);
                data.enterParamExtra.put("post_token", enterParam.postToken);
                data.enterParamExtra.put("post_page_source", enterParam.postPageSource);
                data.enterParamExtra.put("post_creator_id", enterParam.matchedUid);
            }
        }
        data.isInVoiceCall = this.getChannel().getSeatService().isInSeat(uid);
        data.isStartVoiceCall = this.getChannel().getSeatService().hasUserInSeat();
        data.mineRoleSession = this.getChannel().getPermissionService().getRoleSession(AccountUtil.getUid());
        data.targetRoleSession = this.getChannel().getPermissionService().getRoleSession(uid);
        boolean bl = data.canVoiceCall = !this.getChannel().getSeatService().isSeatFull();
        if (data.targetRoleSession != null) {
            int role = data.targetRoleSession.getRole();
            data.isTargetMember = role == 10 || role == 15 || role == 5;
        }
        return data;
    }

    @Override
    public void setFunctionInterceptor(@NonNull FunctionInterceptor functionInterceptor) {
        super.setFunctionInterceptor(functionInterceptor);
        if (functionInterceptor instanceof ChannelFunctionInterceptor) {
            this.mFunctionInterceptor = (ChannelFunctionInterceptor)functionInterceptor;
        }
    }

    @Override
    public void onMakeJoinVoiceCall(final long uid) {
        InterceptCallback callback2 = () -> {
            if (this.isDestroyed()) {
                return;
            }
            this.getChannel().getSeatService().makeSitDown(-1, uid, new IOperationCallback(){

                public void onSuccess() {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)ChannelProfileCardPresenter.TAG, (String)("onMakeJoinVoiceCall success uid = " + uid), (Object[])new Object[0]);
                    }
                }

                public void onFail(long reason) {
                    if (reason == 1L) {
                        ToastUtils.showToast((Context)((IChannelPageContext)ChannelProfileCardPresenter.this.getMvpContext()).getContext(), (String)ResourceUtils.getString((int)R.string.tips_channel_notice_no_permit), (int)0);
                    }
                    MLog.error((Object)ChannelProfileCardPresenter.TAG, (String)("onMakeJoinVoiceCall fail uid = " + uid), (Object[])new Object[0]);
                }
            });
        };
        if (this.mFunctionInterceptor != null) {
            this.mFunctionInterceptor.onMakeJoinVoiceCall(uid, callback2);
        } else {
            callback2.done();
        }
    }

    @Override
    public void onMakeLeaveVoiceCall(final long uid) {
        InterceptCallback callback2 = () -> {
            if (this.isDestroyed()) {
                return;
            }
            this.getChannel().getSeatService().makeStandUp(uid, new IOperationCallback(){

                public void onSuccess() {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)ChannelProfileCardPresenter.TAG, (String)("onMakeLeaveVoiceCall success uid = " + uid), (Object[])new Object[0]);
                    }
                }

                public void onFail(long reason) {
                    if (reason == 1L) {
                        ToastUtils.showToast((Context)((IChannelPageContext)ChannelProfileCardPresenter.this.getMvpContext()).getContext(), (String)ResourceUtils.getString((int)R.string.tips_channel_notice_no_permit), (int)0);
                    }
                    MLog.error((Object)ChannelProfileCardPresenter.TAG, (String)("onMakeLeaveVoiceCall fail uid = " + uid), (Object[])new Object[0]);
                }
            });
        };
        if (this.mFunctionInterceptor != null) {
            this.mFunctionInterceptor.onMakeLeaveVoiceCall(uid, callback2);
        } else {
            callback2.done();
        }
    }

    @Override
    public void onLeaveVoiceCallSelf(long uid) {
        InterceptCallback callback2 = () -> {
            if (this.isDestroyed()) {
                return;
            }
            this.getChannel().getSeatService().standUp(isSuccess -> {});
        };
        if (this.mFunctionInterceptor != null) {
            this.mFunctionInterceptor.onLeaveVoiceCallSelf(uid, callback2);
        } else {
            callback2.done();
        }
    }

    @Override
    public boolean interceptClick() {
        return ((GameOpenChannelPresenter)this.getPresenter(GameOpenChannelPresenter.class)).isOpenByGame();
    }
}

