/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.profile.profilecard.channel;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Message;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.HeadFrameType;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.IGetOnlineStatusCallback;
import com.yy.appbase.util.StatusUtil;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.rolepermission.RolePermission;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.cbase.channelhiido.ChannelTrack;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.component.bottombar.BottomPresenter;
import com.yy.hiyo.channel.component.profile.profilecard.base.AbsProfileCardManager;
import com.yy.hiyo.channel.component.profile.profilecard.channel.ChannelProfileCardData;
import com.yy.hiyo.channel.component.profile.profilecard.channel.IChannelCallback;
import com.yy.hiyo.channel.component.profile.profilecard.channel.OpFlags;
import com.yy.hiyo.channel.component.profile.profilecard.widget.ChatEntranceView;
import com.yy.hiyo.channel.component.profile.profilecard.widget.HorFunctionListView;
import com.yy.hiyo.channel.plugins.voiceroom.common.gamelobby.GameChannelFollow;
import com.yy.hiyo.channel.plugins.voiceroom.common.gamelobby.IGameChannelFollowView;
import com.yy.hiyo.channel.utils.FollowPathKt;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.data.RelationInfo;
import com.yy.hiyo.relation.base.data.RelationNumInfo;
import com.yy.hiyo.relation.base.follow.view.FollowView;
import com.yy.hiyo.relation.base.follow.view.IFollowClickInterceptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ChannelProfileCardManager
extends AbsProfileCardManager {
    private static final String TAG = "ChannelProfileCardManager";
    private ChannelProfileCardData mProfileCardData;
    private IChannelCallback mChannelCallback;
    private IChannelPageContext mIMvpContext;
    private final KvoBinder mBinder = new KvoBinder((Object)this);
    private GameChannelFollow mGameChannelFollow = null;
    private GameChannelFollow.OnGameChannelFollow mOnGameChannelFollow = null;
    private IGameChannelFollowView mIGameChannelFollowView = null;

    public ChannelProfileCardManager(@NonNull IChannelPageContext context, @NonNull ChannelProfileCardData data) {
        super((Context)context.getContext(), data);
        this.mIMvpContext = context;
        this.mProfileCardData = data;
    }

    public void setCallback(IChannelCallback callback2) {
        this.setBaseCallback(callback2);
        this.mChannelCallback = callback2;
    }

    @Override
    protected void onBindData() {
        super.onBindData();
        if (this.mProfileCardData.uid == AccountUtil.getUid()) {
            HeadFrameType headFrameType = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getHeadFrameType();
            Kvo.addKvoBinding((KvoSource)headFrameType, (Object)this, (String)"onMyHeadFrameTypeUpdate");
        }
        if (this.mFollowBtnView != null) {
            this.mFollowBtnView.bindFollowStatus(this.mProfileCardData.uid, FollowPathKt.followPath((IChannel)this.mIMvpContext.getChannel()).getValue());
        }
        this.requestChannelMemberInfo(this.mProfileCardData.channelId, this.mProfileCardData.uid, (IChannel)this.mIMvpContext.getChannel());
        RelationNumInfo relationNum = ((IRelationService)ServiceManagerProxy.getInstance().getService(IRelationService.class)).getRelationNum(this.mProfileCardData.uid, true, null);
        this.mBinder.singleBindSourceTo((KvoSource)relationNum);
    }

    @Override
    protected void onUnbindData() {
        super.onUnbindData();
        if (this.mProfileCardData.uid == AccountUtil.getUid()) {
            HeadFrameType headFrameType = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getHeadFrameType();
            Kvo.removeKvoBinding((KvoSource)headFrameType, (Object)this, (String)"onMyHeadFrameTypeUpdate");
        }
        if (this.mFollowBtnView != null) {
            this.mFollowBtnView.removeBinding();
        }
        this.mBinder.clearAllKvoConnections();
        if (this.mGameChannelFollow != null) {
            this.mGameChannelFollow.destroy();
        }
        this.mOnGameChannelFollow = null;
        this.mIGameChannelFollowView = null;
    }

    @Override
    public List<HorFunctionListView.ViewItem> createBrowserViews() {
        return Collections.emptyList();
    }

    protected void addChatItem(List<HorFunctionListView.ViewItem> viewItems) {
        ChatEntranceView chatImg = new ChatEntranceView(this.mContext);
        chatImg.setOnClickListener(v -> {
            if (this.mChannelCallback != null && this.mChannelCallback.interceptClick()) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_can_not_click_in_game);
                return;
            }
            ChannelTrack.INSTANCE.onGoImClick();
            this.close();
            Bundle bundle = new Bundle();
            Message message = Message.obtain();
            message.what = BaseMsgDef.IM_ROOM_SHOW;
            if (this.mBaseData != null) {
                bundle.putLong("target_uid", this.mBaseData.uid);
            }
            bundle.putInt("bundle_im_from", 14);
            bundle.putInt("im_page_source", 11);
            message.setData(bundle);
            MsgDispatcher.getInstance().sendMessageSync(message);
        });
        FrameLayout.LayoutParams chatLp = new FrameLayout.LayoutParams(-1, ResolutionUtils.dip2Px((float)40.0f));
        HorFunctionListView.ViewItem chatItem = HorFunctionListView.ViewItem.builder(this.mContext).contentView((View)chatImg, chatLp).build();
        viewItems.add(chatItem);
    }

    @Override
    public List<HorFunctionListView.ViewItem> createBtnViews() {
        ArrayList<HorFunctionListView.ViewItem> viewItems = new ArrayList<HorFunctionListView.ViewItem>(2);
        if (this.mProfileCardData.uid != AccountUtil.getUid()) {
            this.addChatItem(viewItems);
            this.mFollowBtnView = new FollowView(this.mContext, true);
            Drawable drawable2 = ResourceUtils.getDrawable((int)R.drawable.select_ffc102_bg);
            this.mFollowBtnView.setFollowingBg(drawable2);
            this.mFollowBtnView.setWidthMathParent(true);
            this.mFollowBtnView.setFollowEachBg(this.mContext.getResources().getDrawable(R.drawable.bg_follow_no_base));
            this.mFollowBtnView.setTextSize(13.0f);
            this.mFollowBtnView.setBoldStyle();
            this.mFollowBtnView.setClickInterceptor(new IFollowClickInterceptor(){

                public boolean interceptor(RelationInfo followStatus) {
                    ChannelProfileCardManager.this.doFollowOrUnFollowOther(followStatus);
                    return true;
                }
            });
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, ResolutionUtils.dip2Px((float)40.0f));
            HorFunctionListView.ViewItem sendGiftBtnItem = HorFunctionListView.ViewItem.builder(this.mContext).contentView((View)this.mFollowBtnView, lp).build();
            viewItems.add(sendGiftBtnItem);
        }
        return viewItems;
    }

    @Override
    protected void fetchData() {
        super.fetchData();
        IUserInfoService userInfoService = (IUserInfoService)ServiceManagerProxy.getServiceManager().getService(IUserInfoService.class);
        userInfoService.queryOnlineStatus(this.mBaseData.uid, new IGetOnlineStatusCallback(){

            public void onSuccess(int status) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)ChannelProfileCardManager.TAG, (String)("onSuccess(): status = " + status), (Object[])new Object[0]);
                }
                if (ChannelProfileCardManager.this.mProfileCardDialog != null) {
                    ChannelProfileCardManager.this.mProfileCardDialog.updateStatusBadge(StatusUtil.getStatusBadge((int)status));
                } else {
                    MLog.error((Object)ChannelProfileCardManager.TAG, (String)"onSuccess(): updateStatusBadge failed mProfileCardDialog is null ", (Object[])new Object[0]);
                }
            }

            public void onError(int code, String msg) {
                MLog.error((Object)ChannelProfileCardManager.TAG, (String)("onSuccess(): code = " + code + ",msg = " + msg), (Object[])new Object[0]);
            }
        });
    }

    @Override
    public List<HorFunctionListView.ViewItem> createOperationViews() {
        int opFlags = 0;
        if (this.mProfileCardData.uid == AccountUtil.getUid()) {
            if (this.mProfileCardData.isInVoiceCall) {
                opFlags |= 2;
                opFlags |= 0x10;
            }
        } else if (this.mProfileCardData.mineRoleSession.getRole() > this.mProfileCardData.targetRoleSession.getRole()) {
            if (this.mProfileCardData.isInVoiceCall) {
                if (this.mProfileCardData.mineRoleSession.hasPermission(RolePermission.MANAGE_SEAT)) {
                    opFlags |= 2;
                }
                if (this.mProfileCardData.mineRoleSession.hasPermission(RolePermission.KICK_OUT_CHANNEL) && this.mProfileCardData.targetRoleSession.getRole() == 1) {
                    opFlags |= 4;
                } else if (this.mProfileCardData.mineRoleSession.hasPermission(RolePermission.SET_ROLE) && this.mProfileCardData.targetRoleSession.getRole() > 1) {
                    opFlags |= 8;
                }
                if (this.mProfileCardData.mineRoleSession.hasPermission(RolePermission.MANAGE_SEAT)) {
                    opFlags |= 0x10;
                }
            } else if (this.mProfileCardData.isStartVoiceCall && this.mProfileCardData.isInChannel) {
                if (this.mProfileCardData.mineRoleSession.hasPermission(RolePermission.MANAGE_SEAT) && this.mProfileCardData.canVoiceCall) {
                    opFlags |= 1;
                }
                if (this.mProfileCardData.mineRoleSession.hasPermission(RolePermission.KICK_OUT_CHANNEL) && this.mProfileCardData.targetRoleSession.getRole() == 1) {
                    opFlags |= 4;
                } else if (this.mProfileCardData.mineRoleSession.hasPermission(RolePermission.SET_ROLE) && this.mProfileCardData.targetRoleSession.getRole() > 1) {
                    opFlags |= 8;
                }
            } else if (this.mProfileCardData.isInChannel) {
                if (this.mProfileCardData.mineRoleSession.hasPermission(RolePermission.KICK_OUT_CHANNEL) && this.mProfileCardData.targetRoleSession.getRole() == 1) {
                    opFlags |= 4;
                } else if (this.mProfileCardData.mineRoleSession.hasPermission(RolePermission.SET_ROLE) && this.mProfileCardData.targetRoleSession.getRole() > 1) {
                    opFlags |= 8;
                }
            }
        }
        return this.buildOperationViews(opFlags);
    }

    @Override
    public boolean showMentioned() {
        return null == this.mIMvpContext || null == this.mIMvpContext.getChannel() || !((BottomPresenter)this.mIMvpContext.getPresenter(BottomPresenter.class)).isSendMsgBaned() || this.mIMvpContext.getChannel().getRoleService().getMyRoleCache() > 1;
    }

    @Override
    public boolean showMedals() {
        return false;
    }

    @Override
    public boolean showGiftWall() {
        return false;
    }

    private List<HorFunctionListView.ViewItem> buildOperationViews(int flags) {
        ArrayList<HorFunctionListView.ViewItem> viewItems = new ArrayList<HorFunctionListView.ViewItem>(2);
        if (OpFlags.withFlag(flags, 1)) {
            viewItems.add(this.createOperationViewItem(R.drawable.ic_channel_join_voice_call, R.string.btn_join_voice_call, v -> {
                if (this.mChannelCallback != null) {
                    this.close();
                    this.mChannelCallback.onMakeJoinVoiceCall(this.mProfileCardData.uid);
                }
            }));
        }
        if (OpFlags.withFlag(flags, 2)) {
            viewItems.add(this.createOperationViewItem(R.drawable.ic_channel_leave_voice_call, R.string.btn_channel_profile_card_leave_voice_call, v -> {
                if (this.mChannelCallback != null) {
                    this.close();
                    if (this.mProfileCardData.uid == AccountUtil.getUid()) {
                        this.mChannelCallback.onLeaveVoiceCallSelf(this.mProfileCardData.uid);
                    } else {
                        this.mChannelCallback.onMakeLeaveVoiceCall(this.mProfileCardData.uid);
                    }
                }
            }));
        }
        if (OpFlags.withFlag(flags, 4)) {
            viewItems.add(this.createOperationViewItem(R.drawable.icon_profile_card_tick_out, R.string.btn_profile_card_bottom_tick_out, v -> {
                if (this.mChannelCallback != null) {
                    this.close();
                    this.mChannelCallback.onKickOut(this.mProfileCardData.uid);
                }
            }));
        }
        if (OpFlags.withFlag(flags, 8)) {
            viewItems.add(this.createOperationViewItem(R.drawable.icon_profile_card_tick_out, R.string.btn_channel_remove_member, v -> {
                if (this.mChannelCallback != null) {
                    this.close();
                    this.mChannelCallback.onRemoveMember(this.mProfileCardData.uid);
                }
            }));
        }
        if (OpFlags.withFlag(flags, 16)) {
            viewItems.add(this.createMicOperationViewItem());
        }
        return viewItems;
    }

    @KvoMethodAnnotation(name="followNum", sourceClass=RelationNumInfo.class, thread=1)
    public void updateFollowNumber(KvoEventIntent event) {
        RelationNumInfo relationNumInfo = (RelationNumInfo)event.source();
        long followNumber = relationNumInfo.getFollowNum();
        if (followNumber < 0L) {
            followNumber = 0L;
        }
        FeatureLog.i((String)"FTVoiceRoomFollow", (String)"profile card follow number: %s", (Object[])new Object[]{followNumber});
        if (null != this.mSelfFollowingView) {
            this.mSelfFollowingView.updateNumber(followNumber);
        }
    }

    @KvoMethodAnnotation(name="fansNum", sourceClass=RelationNumInfo.class, thread=1)
    public void updateFansNumber(KvoEventIntent event) {
        RelationNumInfo relationNumInfo = (RelationNumInfo)event.source();
        long fansNumber = relationNumInfo.getFansNum();
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTVoiceRoomFollow", (String)"profile card fans number: %s", (Object[])new Object[]{fansNumber});
        }
        if (null != this.mSelfFansView) {
            this.mSelfFansView.updateNumber(relationNumInfo.getFansNum());
        }
    }

    @KvoMethodAnnotation(name="headFrameType", sourceClass=HeadFrameType.class)
    public void onMyHeadFrameTypeUpdate(KvoEventIntent event) {
        if (this.mProfileCardData.uid != AccountUtil.getUid()) {
            return;
        }
        int frameId = (int)((HeadFrameType)event.source()).headFrameType;
        this.updateHeadFrame(frameId);
    }
}

