/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.play.game;

import android.view.View;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.ui.widget.image.RoundConerImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.component.play.game.GameListPresenter;
import com.yy.hiyo.channel.component.play.game.OnRoomGameItemClick;
import com.yy.hiyo.game.base.bean.GameInfo;
import net.ihago.rec.srv.home.FlagType;

public class NewRoomGameViewHolder
extends RecyclerView.ViewHolder {
    private RoundConerImageView mGameIcon;
    private TextView mGameName;
    private GameInfo mGameInfo;
    private OnRoomGameItemClick mClickListener;
    private int mNameColor = -1;
    private View redDot;

    public NewRoomGameViewHolder(View itemView, int color2) {
        super(itemView);
        this.mNameColor = color2;
        this.mGameIcon = (RoundConerImageView)itemView.findViewById(R.id.iv_game_list_header);
        this.mGameIcon.setAutoTransforToWebpFlag(false);
        this.mGameName = (TextView)itemView.findViewById(R.id.game_name);
        this.mGameName.setTextColor(this.mNameColor);
        this.redDot = itemView.findViewById(R.id.red_dot);
        itemView.setOnClickListener(v -> {
            if (this.mClickListener != null) {
                this.mClickListener.onClick(this.mGameInfo);
            }
        });
    }

    public void bindView(GameInfo info) {
        this.mGameInfo = info;
        if (this.mGameInfo == null) {
            return;
        }
        this.mGameName.setText((CharSequence)this.mGameInfo.getGname());
        if (GameListPresenter.isComeSoonGame(this.mGameInfo)) {
            ImageLoader.loadImage((RecycleImageView)this.mGameIcon, (int)R.drawable.icon_game_default);
        } else if (GameListPresenter.isTurnTableGame(this.mGameInfo)) {
            ImageLoader.loadImage((RecycleImageView)this.mGameIcon, (int)R.drawable.game_turntable);
        } else {
            ImageLoader.loadImage((RecycleImageView)this.mGameIcon, (String)this.mGameInfo.getIconUrl());
        }
        if (info.getVoiceRoomFlag() == FlagType.FlagTypeNew.getValue()) {
            this.redDot.setVisibility(0);
        } else {
            this.redDot.setVisibility(8);
        }
    }

    public void setOnItemClick(OnRoomGameItemClick click) {
        this.mClickListener = click;
    }
}

