/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.play.game;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.component.play.game.GameCategoryTitleViewHolder;
import com.yy.hiyo.channel.component.play.game.NewRoomGameViewHolder;
import com.yy.hiyo.channel.component.play.game.OnRoomGameItemClick;
import com.yy.hiyo.game.base.bean.GameInfo;
import java.util.ArrayList;
import java.util.List;

public class NewRoomGameListAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    public static final int VIEW_TYPE_GAME_INFO = 0;
    public static final int VIEW_TYPE_CATEGORY_TITLE = 1;
    private final List<GameInfo> mDatas = new ArrayList<GameInfo>();
    private OnRoomGameItemClick mClick;
    private String mRoomId;
    private int mNameColor = -1;

    public void setRoomId(String roomId) {
        this.mRoomId = roomId;
    }

    public void setData(final List<GameInfo> data) {
        if (FP.empty(data)) {
            return;
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                NewRoomGameListAdapter.this.setDataIdle(data);
            }
        });
    }

    private void setDataIdle(List<GameInfo> data) {
        this.mDatas.clear();
        this.mDatas.addAll(data);
        this.notifyDataSetChanged();
    }

    @Nullable
    public GameInfo getItem(int position) {
        if (position >= 0 && position < this.mDatas.size()) {
            return this.mDatas.get(position);
        }
        return null;
    }

    public void setOnItemClick(OnRoomGameItemClick click) {
        this.mClick = click;
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == 1) {
            View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.voice_room_game_list_category_title_item, parent, false);
            GameCategoryTitleViewHolder holder = new GameCategoryTitleViewHolder(itemView);
            return holder;
        }
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.voice_room_game_list_new_item_channel, parent, false);
        NewRoomGameViewHolder holder = new NewRoomGameViewHolder(itemView, this.mNameColor);
        holder.setOnItemClick(this.mClick);
        return holder;
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof NewRoomGameViewHolder) {
            NewRoomGameViewHolder newRoomGameViewHolder = (NewRoomGameViewHolder)holder;
            if (position < this.mDatas.size()) {
                newRoomGameViewHolder.bindView(this.mDatas.get(position));
                this.reportHiido();
            }
        } else if (holder instanceof GameCategoryTitleViewHolder) {
            GameCategoryTitleViewHolder gameCategoryTitleViewHolder = (GameCategoryTitleViewHolder)holder;
            gameCategoryTitleViewHolder.bindView(this.mDatas.get(position));
        }
    }

    public int getItemCount() {
        return this.mDatas.size();
    }

    public int getItemViewType(int position) {
        return this.mDatas.get(position).getGameType() == -3 ? 1 : 0;
    }

    private void reportHiido() {
        if (StringUtils.isNotEmpty((String)this.mRoomId) && !FP.empty(this.mDatas)) {
            StringBuilder builder = new StringBuilder();
            for (GameInfo info : this.mDatas) {
                if (info == null) continue;
                builder.append(info.gid).append("#");
            }
            RoomTrack.INSTANCE.reportRoomPanelShow(this.mRoomId, builder.toString());
        }
    }

    public void setColor(int color2) {
        this.mNameColor = color2;
    }
}

