/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.play.game;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.tools.IRevenueToolsModulePresenter;
import com.yy.hiyo.channel.cbase.utils.ChannelUtils;
import com.yy.hiyo.channel.component.play.game.GameListMvp;
import com.yy.hiyo.channel.component.play.game.OnRoomGameItemClick;
import com.yy.hiyo.channel.component.redpoint.ChannelGameRedPointManager;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.AbsPluginPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.IPlugin;
import com.yy.hiyo.game.base.bean.GameCategory;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameInfoSource;
import com.yy.hiyo.game.base.channelgame.IChannelGameListModel;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.game.service.callback.OnGameInfoChangedListener;
import java.util.ArrayList;
import java.util.List;

public class GameListPresenter
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>>
implements GameListMvp.IPresenter,
OnGameInfoChangedListener,
OnRoomGameItemClick {
    private static final String TAG = "GameListPresenter";
    public static final int COME_SOON_TYPE = -1;
    public static final int TURNTABLE_TYPE = -2;
    public static final int GAME_CATEGORY_TYPE = -3;
    private GameListMvp.IView mIView;
    private GameListMvp.IPresenter.OnGameListListener mOnGameListListener;

    public void onGameInfoChanged(GameInfoSource type, List<GameInfo> list2) {
        if (GameInfoSource.IN_VOICE_ROOM == type && this.mIView != null) {
            this.mIView.setPluginGameList(this.handlePluginList(list2));
        }
    }

    @Override
    @Nullable
    public List<GameInfo> getRoomGameList() {
        if (ServiceManagerProxy.getServiceManager() != null && ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class) != null) {
            return ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getInVoiceRoomGameInfoList();
        }
        return null;
    }

    @Override
    public void setIView(GameListMvp.IView iView) {
        this.mIView = iView;
        if (this.mIView != null) {
            this.mIView.setOnItemClick(this);
            this.mIView.setPluginGameList(this.handlePluginList(this.getRoomGameList()));
        }
        if (FP.empty(this.getRoomGameList())) {
            MLog.warn((Object)TAG, (String)"setIView, \u6e38\u620f\u5217\u8868\u4e3a\u7a7a", (Object[])new Object[0]);
            ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).addGameInfoListener((OnGameInfoChangedListener)this, true);
            IChannelGameListModel listModel = ((IGameService)ServiceManagerProxy.getService(IGameService.class)).getChannelGameListModel();
            listModel.requestInVoiceRoomGameList(null);
        }
    }

    @Override
    public void hidePanel() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"hidePanel", (Object[])new Object[0]);
        }
        this.mIView = null;
        this.mOnGameListListener.onHide();
    }

    @Override
    public void setOnGameListListener(GameListMvp.IPresenter.OnGameListListener listener) {
        this.mOnGameListListener = listener;
    }

    @Override
    public void onClick(@Nullable GameInfo info) {
        if (this.isDestroyed()) {
            MLog.error((Object)TAG, (String)"onClick ", (Throwable)new IllegalStateException("isDestroy"), (Object[])new Object[0]);
            return;
        }
        if (info != null && info.getGameType() != -1) {
            ChannelGameRedPointManager.INSTANCE.setKey(info.gid, true);
            info.setVoiceRoomFlag(-1);
        }
        if (info != null && info.getGameType() == -2) {
            if (!NetworkUtils.isNetworkAvailable((Context)((IChannelPageContext)this.getMvpContext()).getContext())) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"turntable click not network", (Object[])new Object[0]);
                }
                ToastUtils.showToast((Context)((IChannelPageContext)this.getMvpContext()).getContext(), (int)R.string.check_network_and_retry);
                return;
            }
            this.hidePanel();
            RoomTrack.INSTANCE.reportRouBtnClick(this.getChannelId());
            IRevenueToolsModulePresenter turnTablePresenter = (IRevenueToolsModulePresenter)this.getPresenter(IRevenueToolsModulePresenter.class);
            if (turnTablePresenter != null) {
                turnTablePresenter.start();
            }
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onClick info: %s", (Object[])new Object[]{info});
        }
        if (info == null) {
            MLog.error((Object)TAG, (String)"game click, but game info is null", (Object[])new Object[0]);
            if (RuntimeContext.sIsDebuggable) {
                throw new IllegalArgumentException("why game info is null");
            }
            return;
        }
        if (GameListPresenter.isComeSoonGame(info)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"come soon click", (Object[])new Object[0]);
            }
            return;
        }
        if (info != null && info.getGameMode() != 8) {
            MLog.error((Object)TAG, (String)"can not select the game:%s", (Object[])new Object[]{info});
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_operate_failed), (int)0);
            return;
        }
        int pluginMode = this.getChannel().getPluginService().getCurPluginData().mode;
        if (pluginMode == 14 && !this.getChannel().getRoleService().isMeOwner() && !this.getChannel().getRoleService().isMeAnchor()) {
            ToastUtils.showToast((Context)this.getContext(), (int)R.string.tips_radio_master_change_plguin);
            return;
        }
        if (ChannelDefine.isGameModeIncludeLocal((int)pluginMode)) {
            String gameId = this.getChannel().getPluginService().getCurPluginData().getPluginId();
            GameInfo currentGameInfo = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId);
            if (currentGameInfo != null && StringUtils.equal((String)currentGameInfo.gid, (String)info.gid)) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"the same game.", (Object[])new Object[0]);
                }
                this.hidePanel();
                return;
            }
            IPlugin.InterceptPluginChange intercept = this.canClosePlugin(currentGameInfo, info);
            if (intercept.canChange) {
                String msg;
                this.hidePanel();
                String closeName = currentGameInfo != null ? currentGameInfo.getGname() : "";
                boolean isClosePk = false;
                if (ChannelDefine.isPlayCalcuMode((int)pluginMode) && ((IRevenueToolsModulePresenter)this.getPresenter(IRevenueToolsModulePresenter.class)).isPKOpen() && !ChannelDefine.isPlayCalcuMode((int)ChannelUtils.getMode((GameInfo)info))) {
                    closeName = ResourceUtils.getString((int)R.string.short_tips_close_with_pk, (Object[])new Object[]{closeName});
                    isClosePk = true;
                }
                if (TextUtils.isEmpty((CharSequence)(msg = intercept.warnDialogMsg))) {
                    msg = StringUtils.formatWitUSLocal((String)ResourceUtils.getString((int)R.string.tips_voice_room_switch_mode), (Object[])new Object[]{closeName, info.getGname()});
                }
                this.showSwitchDialog(msg, info, isClosePk);
            } else {
                String tips = intercept.forbidTips;
                if (TextUtils.isEmpty((CharSequence)tips)) {
                    tips = ResourceUtils.getString((int)R.string.short_tips_game_close_current);
                }
                ToastUtils.showToast((Context)((IChannelPageContext)this.getMvpContext()).getContext(), (String)tips, (int)0);
            }
            return;
        }
        this.hidePanel();
        this.selectGame(info);
    }

    private void selectGame(@NonNull GameInfo info) {
        this.mOnGameListListener.onSelectGame(info);
        String nowGid = "";
        if (this.getChannel().getPluginService() != null && this.getChannel().getPluginService().getCurPluginData() != null) {
            nowGid = this.getChannel().getPluginService().getCurPluginData().getId();
        }
        RoomTrack.INSTANCE.changeGameClick(this.getChannel().getChannelId(), info.gid, nowGid);
    }

    private List<GameInfo> handlePluginList(List<GameInfo> list2) {
        ArrayList<GameInfo> gameInfos = new ArrayList<GameInfo>();
        if (list2 != null) {
            List gameCategories = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getVoiceRoomGameCategory();
            if (gameCategories != null) {
                GameInfo gameInfo = null;
                for (GameCategory gameCategory : gameCategories) {
                    if (gameCategory.getGameIds() == null) continue;
                    gameInfos.add(this.buildGameCategory(gameCategory.getCatName()));
                    for (String gameId : gameCategory.getGameIds()) {
                        gameInfo = this.findGameInfo(gameId, list2);
                        if (gameInfo == null) continue;
                        gameInfos.add(gameInfo);
                    }
                }
            } else {
                gameInfos.addAll(list2);
            }
            gameInfos.add(this.buildComeSoonGame());
            boolean radioFromGroupEnabled = SettingFlags.getBoolean((String)"radio_from_group_enabled", (boolean)false);
            GameInfo gameInfoRemoved = null;
            if (!radioFromGroupEnabled) {
                ChannelDetailInfo channelDetailInfo = this.getChannel().getChannelDetail();
                if (channelDetailInfo.baseInfo.isGroupParty() && (!this.getChannel().getRoleService().isMeOwner() || channelDetailInfo.baseInfo.showUid != AccountUtil.getUid())) {
                    for (GameInfo gameInfo : gameInfos) {
                        if (!"radio".equals(gameInfo.gid)) continue;
                        gameInfoRemoved = gameInfo;
                        break;
                    }
                }
            }
            if (gameInfoRemoved != null) {
                gameInfos.remove(gameInfoRemoved);
            }
        }
        return gameInfos;
    }

    @Nullable
    private GameInfo findGameInfo(String gid, List<GameInfo> gameInfos) {
        for (GameInfo gameInfo : gameInfos) {
            if (!TextUtils.equals((CharSequence)gameInfo.gid, (CharSequence)gid)) continue;
            return gameInfo;
        }
        return null;
    }

    private GameInfo buildComeSoonGame() {
        return GameInfo.newBuilder((GameInfoSource)GameInfoSource.IN_VOICE_ROOM).gname(ResourceUtils.getString((int)R.string.btn_come_soon)).gameType(-1).build();
    }

    private GameInfo buildGameCategory(String cateName) {
        return GameInfo.newBuilder((GameInfoSource)GameInfoSource.IN_VOICE_ROOM).gname(cateName).gameType(-3).build();
    }

    public static boolean isComeSoonGame(GameInfo gameInfo) {
        return gameInfo != null && gameInfo.getGameType() == -1;
    }

    public static boolean isTurnTableGame(GameInfo gameInfo) {
        return gameInfo != null && gameInfo.getGameType() == -2;
    }

    private IPlugin.InterceptPluginChange canClosePlugin(GameInfo cur, GameInfo next) {
        return ((AbsPluginPresenter)this.getPresenter(AbsPluginPresenter.class)).canBeRemoveWhileRunning(cur, next);
    }

    private void showSwitchDialog(String msg, final GameInfo nextGameInfo, final boolean isClosePk) {
        if (nextGameInfo == null) {
            return;
        }
        if (StringUtils.isEmpty((String)nextGameInfo.getGname())) {
            return;
        }
        OkCancelDialog dialog2 = new OkCancelDialog.Builder().message((CharSequence)msg).cancelable(true).outSideCancelable(true).setCancelLabel((CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_no)).okLabel((CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_yes)).listener(new OkCancelDialogListener(){

            public void onCancel() {
            }

            public void onOk() {
                if (isClosePk) {
                    ((IRevenueToolsModulePresenter)GameListPresenter.this.getPresenter(IRevenueToolsModulePresenter.class)).forceClosePk();
                }
                GameListPresenter.this.selectGame(nextGameInfo);
            }
        }).build();
        this.getDialogLinkManager().showDialog((BaseDialog)dialog2);
    }

    public String getChannelId() {
        return this.getChannel().getChannelId();
    }

    private FragmentActivity getContext() {
        return ((IChannelPageContext)this.getMvpContext()).getContext();
    }

    private DialogLinkManager getDialogLinkManager() {
        return ((IChannelPageContext)this.getMvpContext()).getDialogLinkManager();
    }

    public void onDestroy() {
        super.onDestroy();
        if (ServiceManagerProxy.getServiceManager() != null) {
            ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).removeGameInfoListener((OnGameInfoChangedListener)this);
        }
    }
}

