/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.play.game;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.service.IHomePlanService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.service.IEnteredChannel;
import com.yy.hiyo.channel.component.play.common.GameListItemDecoreation;
import com.yy.hiyo.channel.component.play.game.GameListMvp;
import com.yy.hiyo.channel.component.play.game.GameListPresenter;
import com.yy.hiyo.channel.component.play.game.NewRoomGameListAdapter;
import com.yy.hiyo.channel.component.play.game.OnRoomGameItemClick;
import com.yy.hiyo.channel.component.redpoint.ChannelGameRedPointManager;
import com.yy.hiyo.game.base.bean.GameInfo;
import java.util.ArrayList;
import java.util.List;
import net.ihago.rec.srv.home.FlagType;

public class GameListPanel
extends YYConstraintLayout
implements GameListMvp.IView {
    private GameListMvp.IPresenter mPresenter;
    private RecyclerView mPluginGameRv;
    private View mPanelShade;
    private NewRoomGameListAdapter mPluginAdapter;

    public GameListPanel(Context context) {
        super(context);
        this.createView(context);
    }

    private void createView(Context context) {
        GameListPanel.inflate((Context)this.getContext(), (int)R.layout.voice_room_game_list_panel_channel, (ViewGroup)this);
        this.mPluginGameRv = (RecyclerView)this.findViewById(R.id.game_list_view);
        this.mPanelShade = this.findViewById(R.id.panel_shade);
        GridLayoutManager layoutManager = new GridLayoutManager(context, 4);
        layoutManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

            public int getSpanSize(int position) {
                GameInfo gameInfo;
                if (GameListPanel.this.mPluginAdapter != null && (gameInfo = GameListPanel.this.mPluginAdapter.getItem(position)) != null) {
                    return gameInfo.getGameType() == -3 ? 4 : 1;
                }
                return 1;
            }
        });
        this.mPluginGameRv.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.mPluginGameRv.addItemDecoration((RecyclerView.ItemDecoration)new GameListItemDecoreation(ResolutionUtils.dip2Px((float)8.0f)));
        this.mPluginAdapter = new NewRoomGameListAdapter();
        this.mPluginGameRv.setAdapter((RecyclerView.Adapter)this.mPluginAdapter);
        this.setOnClickListener(v -> {
            if (this.mPresenter != null) {
                this.mPresenter.hidePanel();
            }
        });
    }

    @Override
    public View getPanel() {
        return this;
    }

    public void setPresenter(GameListMvp.IPresenter presenter) {
        this.mPresenter = presenter;
        if (this.mPresenter != null) {
            this.mPresenter.setIView(this);
        }
        GameListPresenter gameListPresenter = (GameListPresenter)presenter;
        this.mPluginAdapter.setRoomId(gameListPresenter.getChannelId());
    }

    @Override
    public void setPluginGameList(List<GameInfo> list2) {
        if (this.mPluginAdapter != null) {
            this.mPluginAdapter.setData(this.handleShowList(list2));
        }
    }

    private List<GameInfo> handleShowList(List<GameInfo> list2) {
        ArrayList<GameInfo> gameInfoList = new ArrayList<GameInfo>();
        if (!FP.empty(list2)) {
            IHomePlanService homePlanService = (IHomePlanService)ServiceManagerProxy.getServiceManager().getService(IHomePlanService.class);
            boolean needCheckMinor = homePlanService.isMyselfMinorProtect();
            for (GameInfo gameInfo : list2) {
                if (gameInfo.isHide() || needCheckMinor && homePlanService.isHideChannelPlugin(gameInfo.gid) || !this.canShowRadioPlugin(gameInfo)) continue;
                gameInfoList.add(gameInfo);
            }
        }
        this.handleReadState(gameInfoList);
        return gameInfoList;
    }

    private void handleReadState(List<GameInfo> list2) {
        for (GameInfo gameInfo : list2) {
            boolean hasRead = ChannelGameRedPointManager.INSTANCE.checkKey(gameInfo.gid, false);
            if (gameInfo.getVoiceRoomFlag() == FlagType.FlagTypeNew.getValue()) {
                if (hasRead) {
                    gameInfo.setVoiceRoomFlag(-1);
                    continue;
                }
                ChannelGameRedPointManager.INSTANCE.setKey(gameInfo.gid, false);
                continue;
            }
            ChannelGameRedPointManager.INSTANCE.removeKey(gameInfo.gid);
        }
    }

    private boolean canShowRadioPlugin(GameInfo gameInfo) {
        IEnteredChannel channel = ((GameListPresenter)this.mPresenter).getChannel();
        return !gameInfo.isOnlyOwnerShowRadio() || channel.getRoleService().getMyRoleCache() == 15 || channel.getRoleService().isMeAnchor();
    }

    @Override
    public void setOnItemClick(OnRoomGameItemClick click) {
        this.mPluginAdapter.setOnItemClick(click);
    }

    public void setModel(int model) {
        if (model == 1) {
            this.setBackgroundColor(-1);
            this.mPanelShade.setVisibility(8);
            int color2 = ColorUtils.parseColor((String)"#999999");
            this.mPluginAdapter.setColor(color2);
        } else {
            this.setBackgroundColor(ColorUtils.parseColor((String)"#e6272735"));
            this.mPanelShade.setVisibility(0);
            this.mPluginAdapter.setColor(ResourceUtils.getColor((int)R.color.color_80ffffff));
        }
    }
}

