/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.play.activity;

import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.component.play.activity.BaseActViewHolder;
import com.yy.hiyo.channel.component.play.activity.OnRoomActivityItemClick;
import com.yy.hiyo.wallet.base.action.ActivityAction;

public class RoomActivityItemViewHolder
extends BaseActViewHolder {
    private CircleImageView mActivityIcon;
    private TextView mActivityName;
    private YYTextView mRedPoint;
    private YYTextView mYellowFlag;
    private ActivityAction mActivityAction;
    private OnRoomActivityItemClick mClickListener;
    private int mNameColor = -1;

    public RoomActivityItemViewHolder(View itemView, int color2) {
        super(itemView);
        this.mNameColor = color2;
        this.mActivityIcon = (CircleImageView)itemView.findViewById(R.id.iv_activity_image);
        this.mActivityIcon.setAutoTransforToWebpFlag(false);
        this.mActivityName = (TextView)itemView.findViewById(R.id.tv_activity_name);
        this.mRedPoint = (YYTextView)itemView.findViewById(R.id.view_activity_red);
        this.mYellowFlag = (YYTextView)itemView.findViewById(R.id.view_activity_yellow);
        this.mActivityName.setTextColor(this.mNameColor);
        itemView.setOnClickListener(v -> {
            if (this.mClickListener != null) {
                this.mClickListener.onClick(this.mActivityAction);
            }
        });
    }

    @Override
    void bindView(ActivityAction activityAction) {
        super.bindView(activityAction);
        if (activityAction == null) {
            return;
        }
        this.mActivityAction = activityAction;
        this.mActivityName.setText((CharSequence)this.mActivityAction.title);
        ImageLoader.loadImage((RecycleImageView)this.mActivityIcon, (String)this.mActivityAction.iconUrl);
        ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)this.mActivityIcon.getLayoutParams();
        layoutParams.topMargin = ResolutionUtils.dip2Px((float)10.0f);
        if (TextUtils.isEmpty((CharSequence)activityAction.tagName)) {
            this.mYellowFlag.setVisibility(8);
        } else {
            this.mYellowFlag.setVisibility(0);
            this.mYellowFlag.setText((CharSequence)activityAction.tagName);
        }
        if (activityAction.linkType == ActivityAction.LinkShowType.APP) {
            this.mRedPoint.setVisibility(8);
        } else if (!this.isNoNeedAB()) {
            this.mRedPoint.setVisibility(8);
        } else {
            this.mRedPoint.setVisibility(activityAction.hasRead ? 8 : 0);
        }
    }

    private boolean isNoNeedAB() {
        String countryCode = AccountUtil.registerCountry();
        return "AE".equalsIgnoreCase(countryCode) || "VN".equalsIgnoreCase(countryCode) || "TH".equalsIgnoreCase(countryCode) || "SA".equalsIgnoreCase(countryCode) || "EG".equalsIgnoreCase(countryCode) || "BR".equalsIgnoreCase(countryCode) || "IN".equalsIgnoreCase(countryCode) || "ID".equalsIgnoreCase(countryCode);
    }

    public void setOnItemClick(OnRoomActivityItemClick click) {
        this.mClickListener = click;
    }
}

