/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.play;

import android.content.Context;
import android.view.View;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.cocosproxy.CocosProxyType;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.framework.core.ui.BasePanel;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.utils.ChannelUtils;
import com.yy.hiyo.channel.component.base.ProxyPresenter;
import com.yy.hiyo.channel.component.play.RoomGameAndActivityListMvp;
import com.yy.hiyo.channel.component.play.RoomGameAndActivityListPanel;
import com.yy.hiyo.channel.component.play.activity.RoomActivityListPanel;
import com.yy.hiyo.channel.component.play.activity.RoomActivityListPresenter;
import com.yy.hiyo.channel.component.play.common.TabPageItem;
import com.yy.hiyo.channel.component.play.game.GameListMvp;
import com.yy.hiyo.channel.component.play.game.GameListPanel;
import com.yy.hiyo.channel.component.play.game.GameListPresenter;
import com.yy.hiyo.channel.component.play.game.selector.PluginSelectorPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.common.game.IGamePlayPresenter;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameService;
import java.util.ArrayList;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;

public class RoomGameAndActivityListPresenter
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>>
implements RoomGameAndActivityListMvp.IPresenter {
    private static final String TAG = "RoomGameAndActivityListPresenter";
    RelativeLayout.LayoutParams mParams;
    private BasePanel mBasePanel;
    private GameListPanel mGameListPanel;
    private GameListPresenter mGameListPresenter;
    private RoomActivityListPanel mRoomActivityListPanel;
    private RoomActivityListPresenter mRoomActivityListPresenter;
    private RoomGameAndActivityListPanel mRoomGameAndActivityListPanel;

    public void onPageAttach(AbsPage page, boolean isReAttach) {
        super.onPageAttach(page, isReAttach);
    }

    @Override
    public void showGameAndActivityListPanel() {
        this.createGameAndActivityPanel();
        this.mRoomGameAndActivityListPanel.setTabItemList(this.getShowViewList(true, true));
        this.showContent();
    }

    public void showActivityListPanel() {
        if (!this.getRoomActivityListPresenter().isHaveActivityList()) {
            return;
        }
        this.createGameAndActivityPanel();
        this.mRoomGameAndActivityListPanel.setTabItemList(this.getShowViewList(false, true));
        this.showContent();
    }

    public void showGameListPanel() {
        this.createGameAndActivityPanel();
        this.mRoomGameAndActivityListPanel.setTabItemList(this.getShowViewList(true, false));
        this.showContent();
    }

    private void showContent() {
        this.createBasePanel();
        this.mBasePanel.setContent((View)this.mRoomGameAndActivityListPanel, this.mParams);
        this.getWindow().getPanelLayer().showPanel(this.mBasePanel, true);
    }

    private List<TabPageItem> getShowViewList(boolean isShowGameList, boolean isShowActivityList) {
        boolean isHaveActivityList;
        ArrayList<TabPageItem> viewList = new ArrayList<TabPageItem>();
        if (isShowGameList) {
            this.initGameListPanel();
            String gameTitle = ResourceUtils.getString((int)R.string.voice_game);
            viewList.add(new TabPageItem((View)this.mGameListPanel, gameTitle));
        }
        if (isShowActivityList && (isHaveActivityList = this.getRoomActivityListPresenter().isHaveActivityList())) {
            this.initRoomActivityListPanel();
            String activityTitle = ResourceUtils.getString((int)R.string.title_voice_room_activity_list);
            viewList.add(new TabPageItem((View)this.mRoomActivityListPanel, activityTitle));
        }
        return viewList;
    }

    private void createGameAndActivityPanel() {
        this.mRoomGameAndActivityListPanel = new RoomGameAndActivityListPanel((Context)this.getContext());
        this.mRoomGameAndActivityListPanel.setModel(this.getChannel().getPluginService().getCurPluginData().mode);
        this.mRoomGameAndActivityListPanel.setPresenter(this);
    }

    private void createBasePanel() {
        this.mParams = new RelativeLayout.LayoutParams(-1, -2);
        this.mParams.addRule(12);
        this.mBasePanel = new BasePanel((Context)this.getContext());
        this.mBasePanel.setShowAnim(this.mBasePanel.createBottomShowAnimation());
        this.mBasePanel.setHideAnim(this.mBasePanel.createBottomHideAnimation());
        this.mBasePanel.setListener((BasePanel.IPanelListener)new BasePanel.SimplePanelListener(){

            public void onPanelHide(BasePanel panel, boolean animated) {
                RoomGameAndActivityListPresenter.this.removePanel();
            }
        });
    }

    private void initRoomActivityListPanel() {
        if (this.mRoomActivityListPanel == null) {
            this.mRoomActivityListPanel = new RoomActivityListPanel((Context)this.getContext());
            this.mRoomActivityListPanel.setModel(this.getChannel().getPluginService().getCurPluginData().mode);
        }
        this.mRoomActivityListPanel.setPresenter(this.getRoomActivityListPresenter());
        this.mRoomActivityListPanel.setTitleVisibility(8);
    }

    public void checkRoomActivityReadStatus() {
        if (this.mRoomGameAndActivityListPanel != null) {
            this.mRoomGameAndActivityListPanel.checkRoomActivityReadStatus();
        }
    }

    private void initGameListPanel() {
        if (this.mGameListPanel == null) {
            this.mGameListPanel = new GameListPanel((Context)this.getContext());
            this.mGameListPanel.setModel(this.getChannel().getPluginService().getCurPluginData().mode);
        }
        this.mGameListPanel.setPresenter(this.getGameListPresenter());
    }

    private void removePanel() {
        this.mBasePanel = null;
        this.mRoomGameAndActivityListPanel = null;
        if (this.mGameListPresenter != null) {
            this.mGameListPresenter.setIView(null);
        }
        if (this.mRoomActivityListPresenter != null) {
            this.mRoomActivityListPresenter.setIView(null);
        }
    }

    private RoomActivityListPresenter getRoomActivityListPresenter() {
        if (this.mRoomActivityListPresenter == null) {
            this.mRoomActivityListPresenter = (RoomActivityListPresenter)((IChannelPageContext)this.getMvpContext()).getPresenter(RoomActivityListPresenter.class);
            this.mRoomActivityListPresenter.setOnActivityListHideListener(this::hideGameListPanel);
        }
        return this.mRoomActivityListPresenter;
    }

    public GameListMvp.IPresenter getGameListPresenter() {
        if (this.mGameListPresenter == null) {
            this.mGameListPresenter = (GameListPresenter)((IChannelPageContext)this.getMvpContext()).getPresenter(GameListPresenter.class);
            this.mGameListPresenter.setOnGameListListener(new GameListMvp.IPresenter.OnGameListListener(){

                @Override
                public void onSelectGame(GameInfo info) {
                    if (info == null || RoomGameAndActivityListPresenter.this.isDestroyed()) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)RoomGameAndActivityListPresenter.TAG, (String)"onSelectGame info null", (Object[])new Object[0]);
                        }
                        return;
                    }
                    RoomGameAndActivityListPresenter.this.selectGame(info);
                }

                @Override
                public void onHide() {
                    if (!RoomGameAndActivityListPresenter.this.isDestroyed()) {
                        RoomGameAndActivityListPresenter.this.hideGameListPanel();
                    }
                }
            });
        }
        return this.mGameListPresenter;
    }

    private void hideGameListPanel() {
        this.getWindow().getPanelLayer().hidePanel(this.mBasePanel, true);
        this.removePanel();
    }

    private FragmentActivity getContext() {
        return ((IChannelPageContext)this.getMvpContext()).getContext();
    }

    public void selectGame(GameInfo info) {
        ((PluginSelectorPresenter)this.getPresenter(PluginSelectorPresenter.class)).preSelectPlugin(info, (Function1<? super Boolean, Unit>)((Function1)isSwitch -> {
            if (isSwitch.booleanValue()) {
                this.switchMode(info);
            }
            return Unit.INSTANCE;
        }));
    }

    private void switchMode(@NonNull GameInfo info) {
        if (ServiceManagerProxy.getService(IGameCenterService.class) != null && ((IGameCenterService)ServiceManagerProxy.getService(IGameCenterService.class)).isPlaying()) {
            ((IGamePlayPresenter)this.getPresenter(IGamePlayPresenter.class)).sendMsgtoGame(CocosProxyType.onMasterPreCloseGame, "");
        }
        ((ProxyPresenter)this.getPresenter(ProxyPresenter.class)).switchMode(ChannelUtils.getMode((GameInfo)info), info, (Callback<Boolean>)((Callback)isSuccess -> {
            if (this.getChannel().getSeatService().isInSeat(AccountUtil.getUid()) && Boolean.TRUE.equals(isSuccess) && ("micup".equals(info.gid) || !info.isRoomCheesGame() && !info.isRoomAssistGame() && ((IGameService)ServiceManagerProxy.getServiceManager().getService(IGameService.class)).isGameValid(info) && !"pickme".equals(info.gid) && !"ktv".equals(info.gid))) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"onSelectGame \u623f\u95f4\u53d1\u9001\u5df2\u51c6\u5907 %s", (Object[])new Object[]{info.gid});
                }
                this.getChannel().getPluginService().ready(true, null);
            }
            if (Boolean.TRUE.equals(isSuccess) && ChannelUtils.isGame((GameInfo)info)) {
                SettingFlags.setStringValue((String)"key_last_play_game_gid", (String)info.gid);
            }
        }));
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mRoomActivityListPanel != null) {
            this.mRoomActivityListPanel.destroy();
        }
        this.hideGameListPanel();
    }
}

