/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.orderbox;

import android.content.Context;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IMsgService;
import com.yy.hiyo.channel.cbase.publicscreen.msg.PureTextMsg;
import com.yy.hiyo.channel.component.orderbox.OrderBoxInfo;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.money.api.orderbox.FinishOrderReq;
import net.ihago.money.api.orderbox.FinishOrderRes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0012\u001a\u00020\bJ\u0006\u0010\u0013\u001a\u00020\bJ\u0006\u0010\u0014\u001a\u00020\bJ\u001a\u0010\u0015\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/yy/hiyo/channel/component/orderbox/OrderBoxTask;", "Lcom/yy/hiyo/channel/base/service/IMsgService$IDataListener;", "info", "Lcom/yy/hiyo/channel/component/orderbox/OrderBoxInfo;", "channel", "Lcom/yy/hiyo/channel/base/service/IChannel;", "onFinish", "Lkotlin/Function1;", "", "(Lcom/yy/hiyo/channel/component/orderbox/OrderBoxInfo;Lcom/yy/hiyo/channel/base/service/IChannel;Lkotlin/jvm/functions/Function1;)V", "id", "", "getId", "()Ljava/lang/String;", "getInfo", "()Lcom/yy/hiyo/channel/component/orderbox/OrderBoxInfo;", "isFinished", "", "finishOrderBox", "monitorMsg", "onDestroy", "onMsgStatuChanged", "msg", "Lcom/yy/hiyo/channel/publicscreen/BaseImMsg;", "state", "", "start", "channel-components_release"})
final class OrderBoxTask
implements IMsgService.IDataListener {
    private boolean isFinished;
    @NotNull
    private final String id;
    @NotNull
    private final OrderBoxInfo info;
    private final IChannel channel;
    private final Function1<OrderBoxTask, Unit> onFinish;

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final void start() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"FTChannel.OrderBox", (String)"start", (Object[])new Object[0]);
        }
        this.monitorMsg();
    }

    public final void monitorMsg() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"FTChannel.OrderBox", (String)"monitorMsg", (Object[])new Object[0]);
        }
        this.channel.getMsgService().addDataListener((IMsgService.IDataListener)this);
    }

    public void onMsgStatuChanged(@Nullable BaseImMsg msg, int state) {
        BaseImMsg baseImMsg = msg;
        if (!(baseImMsg instanceof PureTextMsg)) {
            baseImMsg = null;
        }
        PureTextMsg pureTextMsg = (PureTextMsg)baseImMsg;
        String text = String.valueOf(pureTextMsg != null ? pureTextMsg.getMsgText() : null);
        BaseImMsg baseImMsg2 = msg;
        MLog.debug((Object)"FTChannel.OrderBox", (String)("onMsgStatuChanged " + (baseImMsg2 != null ? Long.valueOf(baseImMsg2.getFrom()) : null) + ", " + state + ", " + text), (Object[])new Object[0]);
        if (!this.isFinished && state == 1 && msg instanceof PureTextMsg && ((PureTextMsg)msg).getFrom() == AccountUtil.getUid() && StringUtils.equals((String)this.info.getToken(), (String)text)) {
            this.finishOrderBox();
        }
    }

    public final void finishOrderBox() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"FTChannel.OrderBox", (String)"finishOrderBox begin", (Object[])new Object[0]);
        }
        FinishOrderReq req = new FinishOrderReq.Builder().sequence(Long.valueOf(System.nanoTime())).cid(this.info.getCid()).build();
        ProtoManager.getInstance().sendHttp(this.info.getCid(), (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<FinishOrderRes>(this, "FTChannel.OrderBox.FinishOrder"){
            final /* synthetic */ OrderBoxTask this$0;

            public void onResponse(@NotNull FinishOrderRes res, long code, @Nullable String msgTip) {
                Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
                super.onResponse((AndroidMessage)res, code, msgTip);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"FTChannel.OrderBox", (String)"finishOrderBox success", (Object[])new Object[0]);
                }
                OrderBoxTask.access$setFinished$p(this.this$0, true);
                OrderBoxTask.access$getOnFinish$p(this.this$0).invoke((Object)this.this$0);
                this.this$0.onDestroy();
            }

            public void onError(@Nullable String reason, int code) {
                super.onError(reason, code);
                MLog.error((Object)"FTChannel.OrderBox", (String)("finishOrderBox fail " + reason + ", " + code), (Object[])new Object[0]);
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_unknown_error, (int)0);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        });
    }

    public final void onDestroy() {
        this.channel.getMsgService().removeDataListener((IMsgService.IDataListener)this);
    }

    @NotNull
    public final OrderBoxInfo getInfo() {
        return this.info;
    }

    public OrderBoxTask(@NotNull OrderBoxInfo info, @NotNull IChannel channel, @NotNull Function1<? super OrderBoxTask, Unit> onFinish2) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        Intrinsics.checkParameterIsNotNull(onFinish2, (String)"onFinish");
        this.info = info;
        this.channel = channel;
        this.onFinish = onFinish2;
        this.id = this.info.getCid();
    }

    public static final /* synthetic */ boolean access$isFinished$p(OrderBoxTask $this) {
        return $this.isFinished;
    }

    public static final /* synthetic */ void access$setFinished$p(OrderBoxTask $this, boolean bl) {
        $this.isFinished = bl;
    }

    public static final /* synthetic */ Function1 access$getOnFinish$p(OrderBoxTask $this) {
        return $this.onFinish;
    }
}

