/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.music.searchmusic;

import android.app.Activity;
import android.content.Context;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.data.MusicPlaylistDBBean;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYEditText;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ImeUtil;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.component.music.addmusic.AddMusicAdapter;
import com.yy.hiyo.channel.component.music.addmusic.IAddMusicAdapterCallback;
import com.yy.hiyo.channel.component.music.searchmusic.ISearchMusicCallback;
import java.util.ArrayList;
import java.util.List;

public class SearchMusicPage
extends YYFrameLayout
implements IAddMusicAdapterCallback {
    private Context mContext;
    private CommonStatusLayout mCommonStatusLayout;
    private RecyclerView mRecyclerView;
    private YYEditText mSearchEditText;
    private YYFrameLayout mClearLayout;
    private RecycleImageView mBack;
    private List<MusicPlaylistDBBean> mSourceList;
    private List<MusicPlaylistDBBean> mShownList;
    private AddMusicAdapter mAdapter;
    private ISearchMusicCallback mSearchMusicCallback;

    public SearchMusicPage(Context context, List<MusicPlaylistDBBean> list2, ISearchMusicCallback callBack) {
        super(context);
        this.mContext = context;
        this.mSearchMusicCallback = callBack;
        this.mSourceList = new ArrayList<MusicPlaylistDBBean>();
        this.mSourceList.addAll(list2);
        this.initView();
    }

    private void initView() {
        LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_search_music_page_channel, (ViewGroup)this, true);
        this.mCommonStatusLayout = (CommonStatusLayout)this.findViewById(R.id.status_layout);
        this.mBack = (RecycleImageView)this.findViewById(R.id.back_iv);
        this.mBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (SearchMusicPage.this.mSearchMusicCallback != null) {
                    SearchMusicPage.this.mSearchMusicCallback.backEvent(SearchMusicPage.this.getSourceList());
                }
            }
        });
        this.mSearchEditText = (YYEditText)this.findViewById(R.id.et_input);
        this.mSearchEditText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable editable) {
                if (editable != null) {
                    if (editable.toString().length() > 0) {
                        SearchMusicPage.this.mClearLayout.setVisibility(0);
                    } else {
                        SearchMusicPage.this.mClearLayout.setVisibility(8);
                    }
                    SearchMusicPage.this.searchByKeyword(editable.toString());
                }
            }
        });
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.rv_list);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext));
        DividerItemDecoration itemDecoration = new DividerItemDecoration(this.mContext, 1);
        itemDecoration.setDrawable(ResourceUtils.getDrawable((int)R.drawable.shape_playlist_divider));
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)itemDecoration);
        this.mShownList = new ArrayList<MusicPlaylistDBBean>();
        this.mAdapter = new AddMusicAdapter(this.mContext, this.mShownList, this);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mClearLayout = (YYFrameLayout)this.findViewById(R.id.clear_layout);
        this.mClearLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SearchMusicPage.this.mSearchEditText.setText((CharSequence)"");
            }
        });
    }

    @Override
    public void doSelectAction(boolean isSelected, int index) {
        MusicPlaylistDBBean shownBean;
        if (this.mShownList != null && index < this.mShownList.size() && this.mSourceList != null && (shownBean = this.mShownList.get(index)) != null) {
            if (null == this.mAdapter || this.mAdapter.isSelectMode()) {
                for (MusicPlaylistDBBean bean2 : this.mSourceList) {
                    if (bean2 == null || TextUtils.isEmpty((CharSequence)shownBean.getMusicName()) || !shownBean.getMusicName().equals(bean2.getMusicName())) continue;
                    bean2.setSelected(shownBean.isSelected());
                }
            } else if (null != this.mSearchMusicCallback) {
                this.mSearchMusicCallback.selectMusic(shownBean);
            }
        }
    }

    public void setSelectMode(boolean isSelectModel) {
        if (null != this.mAdapter) {
            this.mAdapter.setSelectMode(isSelectModel);
        }
    }

    private void searchByKeyword(String keyword) {
        this.mShownList.clear();
        if ("".equals(keyword)) {
            this.mAdapter.setKeyword(null);
            this.mAdapter.notifyDataSetChanged();
            this.setEmptyView();
            return;
        }
        for (MusicPlaylistDBBean bean2 : this.mSourceList) {
            String name = bean2.getMusicName();
            if (StringUtils.isEmpty((String)name) || !name.toLowerCase().contains(keyword)) continue;
            this.mShownList.add(bean2);
        }
        if (this.mShownList.size() == 0) {
            this.setEmptyView();
        } else {
            this.mCommonStatusLayout.hideAllStatus();
        }
        this.mAdapter.setKeyword(keyword);
        this.mAdapter.notifyDataSetChanged();
    }

    private void setEmptyView() {
        this.mCommonStatusLayout.showNoDataCenter();
        this.mCommonStatusLayout.findViewById(R.id.status_frame).setBackgroundColor(ResourceUtils.getColor((int)R.color.transparent));
        YYImageView mStatusIcon = (YYImageView)this.findViewById(R.id.icon_status);
        YYTextView mStatusText = (YYTextView)this.findViewById(R.id.text_status);
        mStatusIcon.setBackgroundResource(R.drawable.playlist_empty);
        mStatusText.setTextColor(ResourceUtils.getColor((int)R.color.white));
        mStatusText.setText((CharSequence)ResourceUtils.getString((int)R.string.tips_playlist_nomusic));
    }

    public void onShown() {
        if (this.mAdapter.getItemCount() == 0) {
            this.mSearchEditText.requestFocus();
            ImeUtil.showIMEDelay((Activity)((Activity)this.getContext()), (View)this.mSearchEditText, (long)100L);
        }
    }

    public void onHidden() {
        ImeUtil.hideIME((Activity)((Activity)this.getContext()));
    }

    public List<MusicPlaylistDBBean> getSourceList() {
        return this.mSourceList;
    }
}

