/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.music.addmusic;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.data.MusicPlaylistDBBean;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.component.music.addmusic.AddMusicAdapter;
import com.yy.hiyo.channel.component.music.addmusic.IAddMusicAdapterCallback;
import com.yy.hiyo.channel.component.music.addmusic.mvp.AddMusicMvp;
import com.yy.hiyo.mvp.base.ICustomView;
import java.util.ArrayList;
import java.util.List;

public class AddMusicPage
extends YYRelativeLayout
implements ICustomView,
AddMusicMvp.IView,
IAddMusicAdapterCallback {
    private static final String TAG = "AddMusicPage";
    private Context mContext;
    private CommonStatusLayout mCommonStatusLayout;
    private YYLinearLayout mSelectLayout;
    private RecycleImageView mSelectAllIv;
    private RecycleImageView mBackIv;
    private RecyclerView mMusicRecyclerView;
    private YYTextView mConfirmAddTv;
    private YYTextView mSearchTv;
    private YYTextView mRescanTv;
    private List<MusicPlaylistDBBean> mList;
    private AddMusicAdapter mAdapter;
    private AddMusicMvp.IPresenter mPresenter;
    private Observer mGetLocalMusicObserver;
    private long mRescanTimestamp = 0L;
    private boolean mIsScanning = false;
    private int mSelectCount = 0;

    public AddMusicPage(Context context) {
        super(context);
        this.mContext = context;
        this.createView(null);
    }

    public void createView(@Nullable AttributeSet attrs) {
        AddMusicPage.inflate((Context)this.getContext(), (int)R.layout.layout_add_music_page_channel, (ViewGroup)this);
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.initView();
        this.initObserver();
    }

    private void initView() {
        this.mBackIv = (RecycleImageView)this.findViewById(R.id.back_iv);
        this.mBackIv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AddMusicPage.this.mPresenter != null) {
                    if (AddMusicPage.this.mSelectCount > 0) {
                        AddMusicPage.this.mPresenter.showExitDialog();
                    } else {
                        AddMusicPage.this.mPresenter.exit();
                    }
                }
            }
        });
        this.mRescanTv = (YYTextView)this.findViewById(R.id.tv_rescan);
        this.mRescanTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AddMusicPage.this.mIsScanning) {
                    return;
                }
                AddMusicPage.this.mSelectCount = 0;
                AddMusicPage.this.showScanningView();
                AddMusicPage.this.mRescanTimestamp = System.currentTimeMillis();
                if (AddMusicPage.this.mPresenter != null) {
                    AddMusicPage.this.mPresenter.getLocalMusicFiles(true);
                }
            }
        });
        this.mSelectAllIv = (RecycleImageView)this.findViewById(R.id.select_all_iv);
        this.mSelectLayout = (YYLinearLayout)this.findViewById(R.id.select_layout);
        this.mSelectLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AddMusicPage.this.mSelectAllIv.isSelected()) {
                    AddMusicPage.this.mSelectAllIv.setSelected(false);
                    AddMusicPage.this.setAllSelected(false);
                } else {
                    AddMusicPage.this.mSelectAllIv.setSelected(true);
                    AddMusicPage.this.setAllSelected(true);
                }
            }
        });
        this.mMusicRecyclerView = (RecyclerView)this.findViewById(R.id.music_list);
        this.mMusicRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext));
        DividerItemDecoration itemDecoration = new DividerItemDecoration(this.mContext, 1);
        itemDecoration.setDrawable(ResourceUtils.getDrawable((int)R.drawable.shape_playlist_divider));
        this.mMusicRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)itemDecoration);
        this.mList = new ArrayList<MusicPlaylistDBBean>();
        this.mAdapter = new AddMusicAdapter(this.mContext, this.mList, this);
        this.mAdapter.changeMode();
        this.mMusicRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mConfirmAddTv = (YYTextView)this.findViewById(R.id.add_tv);
        this.mConfirmAddTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AddMusicPage.this.mList.size() == 0) {
                    return;
                }
                if (AddMusicPage.this.mPresenter != null) {
                    AddMusicPage.this.mPresenter.addingMusic(AddMusicPage.this.getSelectedMusicList());
                }
            }
        });
        this.mSearchTv = (YYTextView)this.findViewById(R.id.search_tv);
        this.mSearchTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AddMusicPage.this.mPresenter != null) {
                    AddMusicPage.this.mPresenter.toSearchPage(AddMusicPage.this.mList);
                }
            }
        });
        this.mCommonStatusLayout = (CommonStatusLayout)this.findViewById(R.id.status_layout);
        this.showScanningView();
    }

    private void initObserver() {
        this.mGetLocalMusicObserver = new Observer<List<MusicPlaylistDBBean>>(){

            public void onChanged(final @Nullable List<MusicPlaylistDBBean> musicPlaylistDBBeans) {
                if (AddMusicPage.this.mRescanTimestamp != 0L && System.currentTimeMillis() - AddMusicPage.this.mRescanTimestamp < 3000L) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            AddMusicPage.this.showMusicList(musicPlaylistDBBeans);
                        }
                    }, (long)2000L);
                } else {
                    AddMusicPage.this.showMusicList(musicPlaylistDBBeans);
                }
            }
        };
    }

    private void showMusicList(List<MusicPlaylistDBBean> musicPlaylistDBBeans) {
        if (musicPlaylistDBBeans != null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"onChanged %d", (Object[])new Object[]{musicPlaylistDBBeans.size()});
            }
            if (musicPlaylistDBBeans.size() == 0) {
                this.mCommonStatusLayout.hideAllStatus();
                this.showEmptyView();
            } else {
                this.mList.clear();
                this.mList.addAll(musicPlaylistDBBeans);
                this.showMusicList();
                this.updateSelectedView();
            }
            this.mIsScanning = false;
        }
    }

    private void showMusicList() {
        this.mCommonStatusLayout.hideAllStatus();
        this.mSearchTv.setVisibility(0);
        this.mSelectLayout.setVisibility(0);
        this.mMusicRecyclerView.setVisibility(0);
        this.mRescanTv.setVisibility(0);
    }

    private void showEmptyView() {
        this.mMusicRecyclerView.setVisibility(8);
        this.mCommonStatusLayout.showNoDataCenter(R.drawable.playlist_empty, ResourceUtils.getString((int)R.string.tips_no_music_available), null);
        this.mCommonStatusLayout.findViewById(R.id.status_frame).setBackgroundColor(ResourceUtils.getColor((int)R.color.transparent));
        this.mSearchTv.setVisibility(8);
        this.mSelectLayout.setVisibility(8);
        YYTextView mStatusText = (YYTextView)this.findViewById(R.id.text_status);
        mStatusText.setTextColor(ResourceUtils.getColor((int)R.color.white));
        this.mRescanTv.setVisibility(0);
    }

    private void showScanningView() {
        this.mIsScanning = true;
        this.mMusicRecyclerView.setVisibility(8);
        this.mCommonStatusLayout.showLoading(ResourceUtils.getString((int)R.string.tips_scanning), "music_scanning.svga", ResolutionUtils.dip2Px((float)130.0f), ResolutionUtils.dip2Px((float)130.0f));
        this.mCommonStatusLayout.findViewById(R.id.loadingFragment).setBackgroundColor(ResourceUtils.getColor((int)R.color.transparent));
        this.mSearchTv.setVisibility(8);
        this.mSelectLayout.setVisibility(8);
        YYTextView mStatusText = (YYTextView)this.findViewById(R.id.loading_text);
        mStatusText.setTextColor(ResourceUtils.getColor((int)R.color.white));
        this.mRescanTv.setVisibility(8);
    }

    private void setAllSelected(boolean isSelected) {
        for (MusicPlaylistDBBean bean2 : this.mList) {
            bean2.setSelected(isSelected);
        }
        this.mAdapter.notifyDataSetChanged();
        this.mSelectCount = isSelected ? this.mList.size() : 0;
        this.setConfirmAddText();
    }

    private void updateSelectedView() {
        this.mSelectCount = 0;
        for (MusicPlaylistDBBean bean2 : this.mList) {
            if (!bean2.isSelected()) continue;
            ++this.mSelectCount;
        }
        this.mAdapter.notifyDataSetChanged();
        this.setConfirmAddText();
        if (this.mSelectCount == this.mList.size()) {
            this.mSelectAllIv.setSelected(true);
        } else {
            this.mSelectAllIv.setSelected(false);
        }
    }

    public void setPresenter(AddMusicMvp.IPresenter presenter) {
        this.mPresenter = presenter;
        presenter.getLocalMusicFiles(false).observe((LifecycleOwner)presenter.getMvpContext().getLifecycleOwner(), this.mGetLocalMusicObserver);
    }

    private void setConfirmAddText() {
        if (this.mSelectCount > 0) {
            this.mConfirmAddTv.setText((CharSequence)this.getResources().getString(R.string.btn_playlist_confirm_add_music_count, new Object[]{this.mSelectCount}));
            this.mConfirmAddTv.setAlpha(1.0f);
            this.mConfirmAddTv.setEnabled(true);
        } else {
            this.mConfirmAddTv.setText((CharSequence)this.getResources().getString(R.string.btn_playlist_confirm_add_music));
            this.mConfirmAddTv.setAlpha(0.2f);
            this.mConfirmAddTv.setEnabled(false);
        }
    }

    @Override
    public void doSelectAction(boolean isSelected, int index) {
        this.mSelectCount = isSelected ? ++this.mSelectCount : --this.mSelectCount;
        this.setConfirmAddText();
        if (this.mSelectCount == this.mList.size()) {
            this.mSelectAllIv.setSelected(true);
        } else {
            this.mSelectAllIv.setSelected(false);
        }
    }

    public int getSelectCount() {
        return this.mSelectCount;
    }

    public List<MusicPlaylistDBBean> getSelectedMusicList() {
        ArrayList<MusicPlaylistDBBean> addingList = new ArrayList<MusicPlaylistDBBean>();
        for (MusicPlaylistDBBean bean2 : this.mList) {
            if (!bean2.isSelected()) continue;
            addingList.add(bean2);
        }
        return addingList;
    }
}

