/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.music;

import android.net.Uri;
import com.yy.appbase.data.MusicPlaylistDBBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.SdkVersionUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.FileOperatorQ;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MusicHelper {
    public static final int MUSIC_STATUS_PREPARE = 0;
    public static final int MUSIC_STATUS_PLAYING = 1;
    public static final int MUSIC_STATUS_PAUSE = 2;
    private static int musicStatus = 0;
    private static List<MusicPlaylistDBBean> playList;
    private static MusicPlaylistDBBean playingBean;

    public static synchronized void requestPlaylist(final PlaylistCallback callback2) {
        if (null == playList) {
            IServiceManager serviceManager;
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTChannelBgm", (String)"\u62c9\u53d6\u97f3\u4e50\u6b4c\u66f2\u5217\u8868", (Object[])new Object[0]);
            }
            if ((serviceManager = ServiceManagerProxy.getServiceManager()) == null || serviceManager.getService(IDBService.class) == null) {
                FeatureLog.e((String)"FTChannelBgm", (String)"service is null maybe not init finish", (Object[])new Object[0]);
                if (null != callback2) {
                    callback2.playlistGetted(playList);
                }
                return;
            }
            MyBox box = ((IDBService)serviceManager.getService(IDBService.class)).boxForCurUser(MusicPlaylistDBBean.class);
            if (null != box) {
                box.getAll((MyBox.IGetItemsCallBack)new MyBox.IGetItemsCallBack<MusicPlaylistDBBean>(){

                    public void onLoaded(final ArrayList<MusicPlaylistDBBean> datas) {
                        if (null != datas && !datas.isEmpty()) {
                            YYTaskExecutor.execute((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    if (FeatureLog.isLogLevelBlowInfo()) {
                                        FeatureLog.i((String)"FTChannelBgm", (String)"\u97f3\u4e50\u6b4c\u66f2\u5217\u8868 size\uff1a%s", (Object[])new Object[]{datas.size()});
                                    }
                                    for (MusicPlaylistDBBean bean2 : datas) {
                                        bean2.setFileExist(YYFileUtils.isFileExisted((String)bean2.getMusicPath()));
                                    }
                                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            playList = new ArrayList();
                                            playList.addAll(datas);
                                            Collections.sort(playList);
                                            if (null != callback2) {
                                                callback2.playlistGetted(playList);
                                            }
                                        }
                                    });
                                }
                            });
                        } else if (null != callback2) {
                            callback2.playlistGetted(playList);
                        }
                    }
                });
            } else {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTChannelBgm", (String)"\u97f3\u4e50\uff1abox is null", (Object[])new Object[0]);
                }
                if (null != callback2) {
                    callback2.playlistGetted(playList);
                }
            }
        } else if (null != callback2) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    List thePlayList = playList;
                    for (MusicPlaylistDBBean bean2 : thePlayList) {
                        if (SdkVersionUtils.hasScopedStorage()) {
                            bean2.setFileExist(FileOperatorQ.INSTANCE.checkUriFileExit(Uri.parse((String)bean2.getContentUri())));
                            continue;
                        }
                        bean2.setFileExist(YYFileUtils.isFileExisted((String)bean2.getMusicPath()));
                    }
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            callback2.playlistGetted(playList);
                        }
                    });
                }
            });
        }
    }

    public static String getMusicSuffix(String music) {
        if (FP.empty((CharSequence)music) || !music.contains(".")) {
            return "";
        }
        int index = music.lastIndexOf(".");
        return music.substring(index);
    }

    public static void reloadList() {
        playList = null;
        MusicHelper.requestPlaylist(null);
    }

    public static void setPlayList(List<MusicPlaylistDBBean> list2) {
        if (null == playList) {
            playList = new ArrayList<MusicPlaylistDBBean>();
        } else {
            playList.clear();
        }
        playList.addAll(list2);
    }

    public static List<MusicPlaylistDBBean> getPlayList() {
        return playList;
    }

    public static int getPlaylistSize() {
        return null == playList ? 0 : playList.size();
    }

    public static MusicPlaylistDBBean getPlayingBean() {
        return playingBean;
    }

    public static void setPlayingBean(MusicPlaylistDBBean playingBean) {
        MusicHelper.playingBean = playingBean;
    }

    public static int getMusicStatus() {
        return musicStatus;
    }

    public static void setMusicStatus(int musicStatus) {
        MusicHelper.musicStatus = musicStatus;
    }

    public static void setDataNull() {
        playList = null;
        playingBean = null;
        musicStatus = 0;
    }

    public static interface PlaylistCallback {
        public void playlistGetted(List<MusicPlaylistDBBean> var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MusicStatus {
    }
}

