/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.mention;

import android.text.TextUtils;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.base.logger.MLog;
import com.yy.hiyo.channel.base.bean.ChannelUser;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.component.mention.bean.MentionData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public enum MentionDataManager {
    INSTANCE;

    private List<MentionData> mMemberList = new ArrayList<MentionData>();
    private List<MentionData> mExtDataList = new ArrayList<MentionData>();
    private static final int MAX_VALUE = 500;

    public void requestData(final String nick, IChannel channel, final IMentionDataListener listener) {
        if (channel == null) {
            return;
        }
        channel.getRoleService().getMemberAndMasterList(Integer.MAX_VALUE, 0, new IRoleService.IGetUserListCallBack(){

            public void onSuccess(IChannel channel, long total, List<ChannelUser> members) {
                if (members == null) {
                    if (MentionDataManager.this.mExtDataList != null) {
                        MentionDataManager.this.sortData(MentionDataManager.this.mExtDataList);
                        if (listener != null) {
                            listener.onSuccess(MentionDataManager.this.mExtDataList);
                        }
                    }
                    return;
                }
                final ArrayList<MentionData> mentionDataList = new ArrayList<MentionData>();
                ArrayList<Long> uidList = new ArrayList<Long>();
                for (ChannelUser member : members) {
                    MentionData mentionData = MentionData.createFrom(member);
                    if (mentionData == null) continue;
                    uidList.add(member.uid);
                    mentionDataList.add(mentionData);
                }
                if (uidList.size() == 0 && MentionDataManager.this.mExtDataList != null) {
                    for (MentionData data : MentionDataManager.this.mExtDataList) {
                        uidList.add(data.getUid());
                    }
                }
                ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(uidList, new OnProfileCallback(){

                    public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                        if (userInfoKSList == null) {
                            return;
                        }
                        block0: for (UserInfoKS userInfoKS : userInfoKSList) {
                            for (MentionData mentionData : mentionDataList) {
                                if (mentionData.getUid() != userInfoKS.uid) continue;
                                mentionData.setAvatar(userInfoKS.getAvatar());
                                mentionData.setNick(userInfoKS.getNick());
                                continue block0;
                            }
                        }
                        MentionDataManager.this.mMemberList.clear();
                        for (MentionData mentionData : mentionDataList) {
                            MentionData data;
                            if (!MentionDataManager.this.mMemberList.contains(mentionData)) {
                                MentionDataManager.this.mMemberList.add(mentionData);
                                continue;
                            }
                            int index = MentionDataManager.this.mMemberList.indexOf(mentionData);
                            if (MentionDataManager.this.mMemberList.size() <= index || (data = (MentionData)MentionDataManager.this.mMemberList.get(index)).getRole() == mentionData.getRole()) continue;
                            MentionDataManager.this.mMemberList.set(index, mentionData);
                        }
                        for (MentionData data : MentionDataManager.this.mExtDataList) {
                            if (MentionDataManager.this.mMemberList.contains(data)) continue;
                            MentionDataManager.this.mMemberList.add(data);
                        }
                        if (nick.equals("[@]")) {
                            if (listener != null) {
                                MentionDataManager.this.sortData(MentionDataManager.this.mMemberList);
                                listener.onSuccess(MentionDataManager.this.mMemberList);
                            }
                            return;
                        }
                        if (TextUtils.isEmpty((CharSequence)nick)) {
                            if (listener != null) {
                                listener.onSuccess(null);
                            }
                            return;
                        }
                        ArrayList<MentionData> data = new ArrayList<MentionData>();
                        for (MentionData mentionData : MentionDataManager.this.mMemberList) {
                            if (TextUtils.isEmpty((CharSequence)mentionData.getNick()) || !mentionData.getNick().contains(nick)) continue;
                            data.add(mentionData);
                        }
                        MentionDataManager.this.sortData(data);
                        if (listener != null) {
                            listener.onSuccess(data);
                        }
                    }

                    public void onFail(int id2, String msg, String response) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)"MentionDataManager", (String)"getModule fail:%s", (Object[])new Object[]{msg});
                        }
                    }
                });
            }

            public void onError(IChannel channel, int errorCode, String errorTips, Exception e) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"MentionDataManager", (String)"getMemberAndMasterList fail:%s", (Object[])new Object[]{errorCode});
                }
            }
        });
    }

    private void sortData(List<MentionData> list2) {
        if (list2 == null || list2.size() == 0) {
            return;
        }
        Comparator<MentionData> comparator = new Comparator<MentionData>(){

            @Override
            public int compare(MentionData o1, MentionData o2) {
                if (o1 == null || o2 == null) {
                    return -1;
                }
                if (o1.getRole() < o2.getRole()) {
                    return 1;
                }
                return -1;
            }
        };
        Collections.sort(list2, comparator);
    }

    public void addData(MentionData mentionData) {
        if (mentionData == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"MentionDataManager", (String)"addData null", (Object[])new Object[0]);
            }
            return;
        }
        if (this.mMemberList.size() >= 500) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"MentionDataManager", (String)"addData size large", (Object[])new Object[0]);
            }
            return;
        }
        if (!this.mExtDataList.contains(mentionData)) {
            MLog.debug((Object)"MentionDataManager", (String)"addData:%s", (Object[])new Object[]{mentionData});
            this.mExtDataList.add(mentionData);
        }
    }

    public List<MentionData> getData() {
        return this.mMemberList;
    }

    public void clear() {
        this.mMemberList.clear();
        this.mExtDataList.clear();
    }

    public static interface IMentionDataListener {
        public void onSuccess(List<MentionData> var1);

        public void onFail();
    }
}

