/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.lock;

import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.utils.ImeUtil;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.ui.dialog.popmenu.ButtonItem;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IDataService;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.cbase.model.bean.LockInfo;
import com.yy.hiyo.channel.component.lock.LockDialog;
import com.yy.hiyo.channel.component.lock.LockModel;
import com.yy.hiyo.channel.component.lock.LockMvp;
import com.yy.hiyo.mvp.base.BasePresenter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class LockPresenter
extends BasePresenter
implements LockMvp.IPresenter {
    public static final int TYPE_UNLOCK_CHANNEL_BY_USER = 1;
    public static final int TYPE_LOCK_CHANNEL_BY_MASTER = 2;
    public static final int TYPE_UNLOCK_CHANNEL_BY_MASTER = 3;
    public static final int TYPE_PARTY_LOCK_CHANNEL_BY_MASTER = 4;
    private LockDialog mDialog;
    private Context mContext;
    private LockMvp.IView mView;
    private LockModel mModel;
    private LockCallback mLockCallback;
    private String mChannelId;
    private LockInfo mLockInfo;
    private int mLockType;

    public LockPresenter(Context context) {
        this.mContext = context;
        this.mModel = new LockModel();
    }

    @Override
    public void setView(LockMvp.IView view) {
        this.mView = view;
    }

    @Override
    public void showDialog(int type, String errorInfo, LockCallback callback2) {
        if (null == this.mDialog) {
            this.mDialog = new LockDialog(this.mContext);
        }
        if ((type == 1 || type == 3) && this.mDialog.isShowing()) {
            this.mDialog.showError(errorInfo);
            RoomTrack.INSTANCE.showUserLockError(this.mChannelId);
        } else {
            this.mLockCallback = callback2;
            this.mLockType = type;
            this.mDialog.setPresenter(this);
            this.mDialog.showDialog(type);
            this.mDialog.setCancelable(true);
            this.mDialog.setOnCloseClickListener(new ButtonItem.OnClickListener(){

                public void onClick() {
                    LockPresenter.this.reportClose();
                }
            });
            this.mDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog2) {
                    LockPresenter.this.reportClose();
                }
            });
        }
    }

    private void reportClose() {
        if (this.mLockType == 1) {
            RoomTrack.INSTANCE.clickUserLockCancel(this.mChannelId);
        }
    }

    @Override
    public void dissmissDialog() {
        if (null != this.mDialog) {
            this.hideIme();
            this.mDialog.dismiss();
        }
    }

    @Override
    public void hideIme() {
        ImeUtil.hideIME((Context)this.mContext, (View)this.mDialog.getCurrentFocus());
    }

    private void lockGroup(String pwd, int lockEnterMode) {
        this.mModel.lockGroup(this.mChannelId, pwd, lockEnterMode, new IDataService.IUpdateInfoCallBack(){

            public void onSuccess(IChannel group) {
                ToastUtils.showToast((Context)LockPresenter.this.mContext, (String)ResourceUtils.getString((int)R.string.tips_channel_lock_success), (int)0);
                LockPresenter.this.dissmissDialog();
                if (null == LockPresenter.this.mLockInfo) {
                    LockPresenter.this.mLockInfo = new LockInfo();
                }
                if (group != null && group.getDataService().getChannelDetailInfo(null) != null) {
                    String pwd = group.getDataService().getChannelDetailInfo(null).baseInfo.password;
                    LockPresenter.this.mLockInfo.setPassword(pwd);
                }
                LockPresenter.this.mLockInfo.setLocked(true);
                if (null != LockPresenter.this.mLockCallback) {
                    LockPresenter.this.mLockCallback.updateLockInfo(LockPresenter.this.mLockInfo);
                }
            }

            public void onContainSensitiveWord() {
                ToastUtils.showToast((Context)LockPresenter.this.mContext, (String)ResourceUtils.getString((int)R.string.tips_channel_lock_failed), (int)0);
            }

            public void onFailUnauthorized() {
                ToastUtils.showToast((Context)LockPresenter.this.mContext, (int)R.string.tips_channel_no_permission);
            }

            public void onError(String channelId, int errorCode, String errorTips, Exception e) {
                ToastUtils.showToast((Context)LockPresenter.this.mContext, (String)ResourceUtils.getString((int)R.string.tips_channel_lock_failed), (int)0);
            }
        });
    }

    @Override
    public void clickOk(String str, int lockEnterMode) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTVoiceRoom", (String)"LockDialog \u70b9\u51fbok\uff0clockType: %s", (Object[])new Object[]{this.mLockType});
        }
        if (this.mLockType == 2) {
            this.lockGroup(str, lockEnterMode);
            RoomTrack.INSTANCE.clickLockOk(this.mChannelId);
        } else if (this.mLockType == 4) {
            this.lockGroup(str, lockEnterMode);
            RoomTrack.INSTANCE.clickLockOk(this.mChannelId);
        } else if (this.mLockType == 1) {
            if (null != this.mLockCallback) {
                this.mLockCallback.unlockEnterRoom(str);
            }
            RoomTrack.INSTANCE.clickUserLockEnter(this.mChannelId);
        } else if (this.mLockType == 3) {
            if (this.mLockCallback != null) {
                this.mLockCallback.unLockChannel(str);
            }
            RoomTrack.INSTANCE.clickUnlockOk(this.mChannelId);
        }
    }

    public String getPassword() {
        return null != this.mLockInfo ? this.mLockInfo.getPassword() : "";
    }

    @Override
    public void setLockInfo(LockInfo lockInfo) {
        this.mLockInfo = lockInfo;
    }

    public void onDestroy() {
        super.onDestroy();
        if (null != this.mDialog && this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
    }

    @Override
    public void setChannelId(String channelId) {
        this.mChannelId = channelId;
    }

    public static interface LockCallback {
        public void unlockEnterRoom(String var1);

        public void updateLockInfo(LockInfo var1);

        default public void unLockChannel(String pwd) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LockType {
    }
}

