/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.invite.online.search;

import androidx.annotation.MainThread;
import biz.UserInfo;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.logger.MLog;
import com.yy.hiyo.channel.base.OnlineUserInviteStatus;
import com.yy.hiyo.channel.base.bean.OnlineUserSearchData;
import com.yy.hiyo.channel.base.bean.OnlineUserSearchInfo;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IOnlineUserSearchService;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.base.service.ISeatService;
import com.yy.hiyo.channel.service.BaseService;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.ihago.base.srv.elastic.SearchRoomUserReq;
import net.ihago.base.srv.elastic.SearchRoomUserRes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\b\u0010\u0014\u001a\u00020\rH\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/yy/hiyo/channel/component/invite/online/search/OnlineUserSearchService;", "Lcom/yy/hiyo/channel/service/BaseService;", "Lcom/yy/hiyo/channel/base/service/IOnlineUserSearchService;", "currentChannel", "Lcom/yy/hiyo/channel/base/service/IChannel;", "(Lcom/yy/hiyo/channel/base/service/IChannel;)V", "logTag", "", "onlineUserSearchData", "Lcom/yy/hiyo/channel/base/bean/OnlineUserSearchData;", "getOnlineUserSearchData", "()Lcom/yy/hiyo/channel/base/bean/OnlineUserSearchData;", "fetchOnlineUser", "", "cid", "vid", "", "getInviteStatus", "Lcom/yy/hiyo/channel/base/OnlineUserInviteStatus;", "uid", "resetData", "channel-components_release"})
public final class OnlineUserSearchService
extends BaseService
implements IOnlineUserSearchService {
    private final String logTag = "OnlineUserSearchService";
    @NotNull
    private final OnlineUserSearchData onlineUserSearchData;
    private final IChannel currentChannel;

    @NotNull
    public OnlineUserSearchData getOnlineUserSearchData() {
        return this.onlineUserSearchData;
    }

    @MainThread
    public void fetchOnlineUser(@NotNull String cid, long vid) {
        Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)this.logTag, (String)("fetchOnlineUser cid: " + cid + " , vid: " + vid), (Object[])new Object[0]);
        }
        if (StringsKt.isBlank((CharSequence)cid) || vid == 0L) {
            return;
        }
        SearchRoomUserReq req = new SearchRoomUserReq.Builder().cid(cid).vid(Long.valueOf(vid)).build();
        ProtoManager.getInstance().sendHttp((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<SearchRoomUserRes>(this, vid){
            final /* synthetic */ OnlineUserSearchService this$0;
            final /* synthetic */ long $vid;

            public void onResponse(@NotNull SearchRoomUserRes res, long code, @Nullable String msgTip) {
                List list2;
                long resUid;
                Object object;
                Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
                super.onResponse((AndroidMessage)res, code, msgTip);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)OnlineUserSearchService.access$getLogTag$p(this.this$0), (String)("fetchOnlineUser onResponse code: " + code), (Object[])new Object[0]);
                }
                long l = (object = res.user) != null && (object = ((UserInfo)object).uid) != null ? (Long)object : (resUid = 0L);
                if (!ProtoManager.isSuccessCode((long)code) || resUid == 0L) {
                    MLog.error((Object)OnlineUserSearchService.access$getLogTag$p(this.this$0), (String)("fetchOnlineUser invalid info resUid: " + resUid + " , vid: " + this.$vid), (Object[])new Object[0]);
                    list2 = CollectionsKt.emptyList();
                } else {
                    UserInfo userInfo = res.user;
                    String string2 = userInfo != null ? userInfo.nick : null;
                    long l2 = this.$vid;
                    long l3 = resUid;
                    boolean bl = false;
                    String string3 = string2;
                    if (string3 == null) {
                        string3 = "";
                    }
                    String string4 = string3;
                    UserInfo userInfo2 = res.user;
                    string2 = userInfo2 != null ? userInfo2.avatar : null;
                    bl = false;
                    String string5 = string2;
                    if (string5 == null) {
                        string5 = "";
                    }
                    String string6 = string5;
                    OnlineUserInviteStatus onlineUserInviteStatus = OnlineUserSearchService.access$getInviteStatus(this.this$0, resUid);
                    String string7 = string6;
                    String string8 = string4;
                    long l4 = l2;
                    long l5 = l3;
                    OnlineUserSearchInfo onlineUser = new OnlineUserSearchInfo(l5, l4, string8, string7, onlineUserInviteStatus);
                    list2 = CollectionsKt.listOf((Object)onlineUser);
                }
                List onlineUserList = list2;
                this.this$0.getOnlineUserSearchData().getOnlineUserList().set((Collection)onlineUserList);
            }

            public void onError(@Nullable String reason, int code) {
                super.onError(reason, code);
                MLog.error((Object)OnlineUserSearchService.access$getLogTag$p(this.this$0), (String)("fetchOnlineUser onError code: " + code), (Object[])new Object[0]);
                this.this$0.getOnlineUserSearchData().getOnlineUserList().set((Collection)CollectionsKt.emptyList());
            }
            {
                this.this$0 = $outer;
                this.$vid = $captured_local_variable$1;
            }
        });
    }

    @MainThread
    public void resetData() {
        this.getOnlineUserSearchData().getOnlineUserList().clear();
    }

    private final OnlineUserInviteStatus getInviteStatus(long uid) {
        boolean isMeInSeat;
        boolean isSeatFull;
        boolean isOwnerOrMaster;
        IRoleService iRoleService = this.currentChannel.getRoleService();
        boolean bl = isOwnerOrMaster = iRoleService != null ? iRoleService.isOwnerOrMaster(AccountUtil.getUid()) : false;
        if (!isOwnerOrMaster) {
            return OnlineUserInviteStatus.NONE;
        }
        ISeatService iSeatService = this.currentChannel.getSeatService();
        boolean bl2 = isSeatFull = iSeatService != null ? iSeatService.isSeatFull() : false;
        if (isSeatFull) {
            return OnlineUserInviteStatus.NONE;
        }
        ISeatService iSeatService2 = this.currentChannel.getSeatService();
        boolean bl3 = isMeInSeat = iSeatService2 != null ? iSeatService2.isInSeat(uid) : false;
        if (isMeInSeat) {
            return OnlineUserInviteStatus.SEATED;
        }
        return OnlineUserInviteStatus.INVITEABLE;
    }

    public OnlineUserSearchService(@NotNull IChannel currentChannel2) {
        Intrinsics.checkParameterIsNotNull((Object)currentChannel2, (String)"currentChannel");
        super(currentChannel2);
        this.currentChannel = currentChannel2;
        this.logTag = "OnlineUserSearchService";
        this.onlineUserSearchData = new OnlineUserSearchData();
    }

    public static final /* synthetic */ String access$getLogTag$p(OnlineUserSearchService $this) {
        return $this.logTag;
    }

    public static final /* synthetic */ OnlineUserInviteStatus access$getInviteStatus(OnlineUserSearchService $this, long uid) {
        return $this.getInviteStatus(uid);
    }
}

