/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.invite.online.data;

import android.annotation.SuppressLint;
import android.graphics.Color;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.common.CommonCallback;
import com.yy.appbase.common.DataCallback;
import com.yy.appbase.common.DataTransformGroup;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelInfo;
import com.yy.hiyo.channel.base.bean.HonorBean;
import com.yy.hiyo.channel.base.bean.OnlineInfo;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IChannelHonorService;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.component.invite.base.OnlineBean;
import com.yy.hiyo.channel.component.invite.online.data.OnlineDataProvider;
import com.yy.hiyo.channel.component.invite.online.data.OnlinePageData;
import com.yy.hiyo.channel.component.invite.online.data.OnlineWithStatusPageData;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.wallet.base.IPrivilegeService;
import com.yy.hiyo.wallet.base.privilege.bean.NickColorConfig;
import com.yy.hiyo.wallet.base.privilege.service.NickColorService;
import com.yy.hiyo.wallet.base.revenue.privilege.IPrivilegeCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class DefaultOnlineDataProvider
implements OnlineDataProvider {
    private static final String TAG = "DefaultOnlineDataProvider";
    protected IChannel mChannel;
    protected MutableLiveData<Long> mOnlineCount = new MutableLiveData();

    public DefaultOnlineDataProvider(IChannel channel) {
        this.mChannel = channel;
        this.mOnlineCount.setValue((Object)0L);
    }

    @Override
    public void fetchOnlineData(final ProtoManager.Page page, final DataCallback<OnlinePageData> callback2) {
        this.mChannel.getRoleService().getOnlineUserList(page, new IRoleService.IGetOnlineUserListCallBack(){

            public void onSuccess(String channel, ProtoManager.Page resultPage, OnlineInfo data) {
                DefaultOnlineDataProvider.this.mOnlineCount.setValue((Object)(resultPage != null ? resultPage.total : 0L));
                ArrayList<OnlineBean> onlineBeanList = new ArrayList<OnlineBean>();
                if (data != null && data.getOnlineUids() != null) {
                    for (Long uid : data.getOnlineUids()) {
                        if (uid <= 0L) continue;
                        OnlineBean onlineBean = new OnlineBean();
                        onlineBean.uid = uid;
                        onlineBean.isVipSeat = data.getVips() != null && data.getVips().contains(uid);
                        onlineBean.wearingInfos = DefaultOnlineDataProvider.this.provideWearingInfos((List)data.getWearingsMap().get(uid.longValue()));
                        onlineBean.mUserTagInfoList = ((IChannelHonorService)ServiceManagerProxy.getService(IChannelHonorService.class)).getUserTagsFromConfig((List)data.getUserCardMap().get(uid.longValue()));
                        onlineBean.isAnchor = DefaultOnlineDataProvider.this.mChannel.getRoleService().isAnchor(uid.longValue());
                        onlineBeanList.add(onlineBean);
                    }
                }
                OnlinePageData pageData = new OnlinePageData(page, onlineBeanList);
                if (FP.empty(onlineBeanList)) {
                    DefaultOnlineDataProvider.this.onDataReady(pageData, (DataCallback<OnlinePageData>)callback2);
                } else {
                    DataTransformGroup.of(onlineBeanList).add((list2, cb) -> DefaultOnlineDataProvider.this.requestUserInfos((List<OnlineBean>)list2, cb)).add((list2, cb) -> DefaultOnlineDataProvider.this.requestRoleType((List<OnlineBean>)list2, cb)).add((list2, cb) -> DefaultOnlineDataProvider.this.requestIsMember((List<OnlineBean>)list2, cb)).add((list2, cb) -> DefaultOnlineDataProvider.this.requestNickColor((List<OnlineBean>)list2, cb)).transform(() -> DefaultOnlineDataProvider.this.onDataReady(pageData, (DataCallback<OnlinePageData>)callback2));
                }
            }

            public void onError(String channel, int errorCode, String errorTips, Exception e) {
                if (null != callback2) {
                    callback2.onResult(null);
                }
            }
        });
    }

    @Override
    public void fetchOnlineWithStatusData(ProtoManager.Page page, final DataCallback<OnlineWithStatusPageData> callback2) {
        this.fetchOnlineData(page, new DataCallback<OnlinePageData>(){

            public void onResult(@Nullable OnlinePageData data) {
                if (callback2 != null) {
                    if (data != null) {
                        callback2.onResult((Object)new OnlineWithStatusPageData(data.getPage(), null, data.getOnlineList()));
                    } else {
                        callback2.onResult(null);
                    }
                }
            }
        });
    }

    protected List<HonorBean> provideWearingInfos(List<Integer> honorIds) {
        List list2;
        IChannelHonorService channelCenterService;
        ArrayList<HonorBean> honorBeans = new ArrayList<HonorBean>();
        if (!FP.empty(honorIds) && (channelCenterService = (IChannelHonorService)ServiceManagerProxy.getService(IChannelHonorService.class)) != null && (list2 = channelCenterService.getHonorsByIds(honorIds)) != null) {
            honorBeans.addAll(list2);
        }
        return honorBeans;
    }

    protected void requestUserInfos(final List<OnlineBean> onlineBeanList, final CommonCallback callback2) {
        ArrayList<Long> uids = new ArrayList<Long>();
        for (OnlineBean onlineBean : onlineBeanList) {
            uids.add(onlineBean.uid);
        }
        ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(uids, new OnProfileCallback(){

            public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                HashMap<Long, UserInfoKS> userInfoKSMap = new HashMap<Long, UserInfoKS>();
                if (userInfoKSList != null) {
                    for (UserInfoKS userInfoKS : userInfoKSList) {
                        userInfoKSMap.put(userInfoKS.uid, userInfoKS);
                    }
                }
                for (OnlineBean onlineBean : onlineBeanList) {
                    onlineBean.userInfo = (UserInfoKS)userInfoKSMap.get(onlineBean.uid);
                }
                callback2.onFinish();
            }

            public void onFail(int id2, String msg, String response) {
                callback2.onFinish();
            }

            public int id() {
                return 0;
            }
        });
    }

    protected void requestNickColor(final List<OnlineBean> onlineBeanList, final CommonCallback callback2) {
        ArrayList<Long> uids = new ArrayList<Long>();
        for (OnlineBean onlineBean : onlineBeanList) {
            uids.add(onlineBean.uid);
        }
        NickColorService nickColorService2 = null;
        if (ServiceManagerProxy.getServiceManager() != null) {
            nickColorService2 = (NickColorService)((IPrivilegeService)ServiceManagerProxy.getServiceManager().getService(IPrivilegeService.class)).getService(NickColorService.class);
        }
        if (nickColorService2 == null) {
            callback2.onFinish();
        } else {
            nickColorService2.fetchMultiUserPrivilege(uids, false, (IPrivilegeCallback)new IPrivilegeCallback<Map<Long, NickColorConfig>>(){

                public void onFailed(int code, @Nullable String msg) {
                    MLog.error((Object)DefaultOnlineDataProvider.TAG, (String)"requestNickColor error, code=%d, msg=%s", (Object[])new Object[]{code, msg});
                    callback2.onFinish();
                }

                @SuppressLint(value={"LoopUsage", "colorParseUsage"})
                public void onSucceed(@Nullable Map<Long, NickColorConfig> data) {
                    if (data != null) {
                        for (OnlineBean onlineBean : onlineBeanList) {
                            NickColorConfig config = data.get(onlineBean.uid);
                            if (config == null || FP.empty((CharSequence)config.getColor())) continue;
                            try {
                                onlineBean.nickColor = Color.parseColor((String)config.getColor());
                            }
                            catch (Exception e) {
                                MLog.error((Object)DefaultOnlineDataProvider.TAG, (String)("getNickColor parse color error, " + e.getMessage()), (Object[])new Object[0]);
                            }
                        }
                    }
                    callback2.onFinish();
                }
            });
        }
    }

    protected void requestRoleType(final List<OnlineBean> onlineBeanList, final CommonCallback callback2) {
        ArrayList<Long> uids = new ArrayList<Long>();
        for (OnlineBean onlineBean : onlineBeanList) {
            uids.add(onlineBean.uid);
        }
        this.mChannel.getRoleService().getRoles(uids, new IRoleService.IGetRolesCallBack(){

            public void onSuccess(String channelId, HashMap<Long, Integer> roles) {
                boolean isTopChannel = 1 == DefaultOnlineDataProvider.this.mChannel.getDataService().getChannelDetailInfo(null).baseInfo.type;
                boolean isOldVersion = DefaultOnlineDataProvider.this.mChannel.getDataService().getChannelDetailInfo(null).baseInfo.version == 0;
                for (OnlineBean onlineBean : onlineBeanList) {
                    Integer role = roles.get(onlineBean.uid);
                    int n = onlineBean.roleType = role != null ? role : 1;
                    if (!isOldVersion && !isTopChannel) continue;
                    onlineBean.isMember = onlineBean.roleType == 10 || onlineBean.roleType == 15 || onlineBean.roleType == 5;
                }
                callback2.onFinish();
            }

            public void onError(String channelId, int errorCode, String errorTips, Exception e) {
                MLog.error((Object)DefaultOnlineDataProvider.TAG, (String)"getRoles error, code=%d, msg=%s", (Object[])new Object[]{errorCode, errorTips});
                callback2.onFinish();
            }
        });
    }

    protected void requestIsMember(final List<OnlineBean> onlineBeanList, final CommonCallback callback2) {
        ChannelInfo channelInfo = this.mChannel.getDataService().getChannelDetailInfo(null).baseInfo;
        boolean isOldVersion = channelInfo.version == 0;
        boolean isGroupParty = channelInfo.isGroupParty();
        if (isOldVersion) {
            if (callback2 != null) {
                callback2.onFinish();
            }
            return;
        }
        String cid = channelInfo.pid;
        if (!isGroupParty) {
            cid = channelInfo.getChannelId();
        }
        ArrayList<Long> uids = new ArrayList<Long>();
        for (OnlineBean onlineBean : onlineBeanList) {
            uids.add(onlineBean.uid);
        }
        IChannel parentChannel = ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).getChannel(cid);
        if (parentChannel != null) {
            parentChannel.getRoleService().getRoles(uids, new IRoleService.IGetRolesCallBack(){

                public void onSuccess(String channelId, HashMap<Long, Integer> roles) {
                    for (OnlineBean onlineBean : onlineBeanList) {
                        Integer role = roles.get(onlineBean.uid);
                        onlineBean.isMember = role != null && (role == 10 || role == 15 || role == 5);
                    }
                    if (callback2 != null) {
                        callback2.onFinish();
                    }
                }

                public void onError(String channelId, int errorCode, String errorTips, Exception e) {
                    MLog.error((Object)DefaultOnlineDataProvider.TAG, (String)"getRoles error, code=%d, msg=%s", (Object[])new Object[]{errorCode, errorTips});
                    if (callback2 != null) {
                        callback2.onFinish();
                    }
                }
            });
            parentChannel.getRoleService().updateMemberCacheFromServer(cid);
        } else if (callback2 != null) {
            callback2.onFinish();
        }
    }

    protected void onDataReady(OnlinePageData pageData, DataCallback<OnlinePageData> callback2) {
        this.transformData(pageData.getOnlineList());
        if (null != callback2) {
            callback2.onResult((Object)pageData);
        }
    }

    @Override
    public LiveData<Long> getOnlineCount() {
        return this.mOnlineCount;
    }

    @Override
    public ChannelPluginData getPluginData() {
        if (this.mChannel.getPluginService() != null) {
            return this.mChannel.getPluginService().getCurPluginData();
        }
        return null;
    }

    @Override
    public String getChannelId() {
        return this.mChannel.getChannelId();
    }

    protected void transformData(List<OnlineBean> onlineBeanList) {
    }
}

