/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.invite.online;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.DataCallback;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.component.invite.InvitePresenter;
import com.yy.hiyo.channel.component.invite.base.IPanelPage;
import com.yy.hiyo.channel.component.invite.base.OnlineBean;
import com.yy.hiyo.channel.component.invite.online.OnlineItemView;
import com.yy.hiyo.channel.component.invite.online.OnlineListCallback;
import com.yy.hiyo.channel.component.invite.online.data.OnlineDataProvider;
import com.yy.hiyo.channel.component.invite.online.data.OnlinePageData;
import com.yy.hiyo.channel.component.invite.online.data.OnlineWithStatusPageData;
import com.yy.hiyo.channel.component.invite.online.handler.OnlineInviteHandler;
import com.yy.hiyo.channel.component.invite.online.viewholder.CountItemHolder;
import com.yy.hiyo.channel.component.invite.online.viewholder.GroupTitleHolder;
import com.yy.hiyo.channel.component.invite.online.viewholder.SpaceItemHolder;
import com.yy.hiyo.channel.component.invite.online.viewholder.VipSeatBarHolder;
import com.yy.hiyo.channel.component.seat.holder.SimpleItemBinder;
import com.yy.hiyo.channel.plugins.voiceroom.common.gamelobby.GameChannelInfoPresenter;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.proto.ProtoManager;
import java.util.ArrayList;
import java.util.List;
import me.drakeet.multitype.ItemViewBinder;
import me.drakeet.multitype.MultiTypeAdapter;

public class OnlineListComponent
implements IPanelPage,
OnlineInviteHandler.OnInviteStatusChangeListener {
    private static final String TAG = "OnlineListComponent";
    private static final int PAGE_SIZE = 20;
    private Context mContext;
    private IMvpContext mMvpContext;
    private View mContentView;
    private RecyclerView mRecyclerView;
    private MultiTypeAdapter mAdapter;
    private List<Object> mOnlineList = new ArrayList<Object>();
    private CommonStatusLayout mStatusLayout;
    private SmartRefreshLayout mRefreshLayout;
    private SpaceItemHolder.SpaceItem mBottomSpaceItem = new SpaceItemHolder.SpaceItem();
    private VipSeatBarHolder.BarItem mPrioritySeatBar = new VipSeatBarHolder.BarItem();
    private OnlineInviteHandler mInviteHandler;
    private OnlineDataProvider mDataProvider;
    private OnlineListCallback mListCallback;
    private long mNextOffset = 0L;
    private long mOnlineListSnap = 0L;
    private OnlineBean mFirstVip = null;
    private IEmptyCallback mEmptyCallback;

    public OnlineListComponent(IMvpContext mvpContext) {
        this.mContext = mvpContext.getContext();
        this.mMvpContext = mvpContext;
        this.createViews();
        this.initListener();
    }

    private void createViews() {
        this.mContentView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.room_online_list_page_channel, null);
        this.mStatusLayout = (CommonStatusLayout)this.mContentView.findViewById(R.id.status_layout);
        this.mRecyclerView = (RecyclerView)this.mContentView.findViewById(R.id.recycler);
        this.mRefreshLayout = (SmartRefreshLayout)this.mContentView.findViewById(R.id.layout_refresh);
        this.mRefreshLayout.setEnableLoadMore(false);
        this.mRefreshLayout.setEnableRefresh(false);
        this.mAdapter = new MultiTypeAdapter(this.mOnlineList);
        this.registerViewHolder();
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
    }

    public void initData() {
        this.loadNextPage();
    }

    private void initListener() {
        this.mRefreshLayout.setOnLoadMoreListener(refreshLayout -> this.loadNextPage());
    }

    public void setInviteHandler(@NonNull OnlineInviteHandler inviteHandler) {
        inviteHandler.addInviteStatusChangeLister(this);
        this.mInviteHandler = inviteHandler;
    }

    public void setDataProvider(@NonNull OnlineDataProvider dataProvider) {
        this.mDataProvider = dataProvider;
    }

    public void setListCallback(OnlineListCallback listCallback) {
        this.mListCallback = listCallback;
    }

    private void loadNextPage() {
        if (this.mDataProvider == null) {
            return;
        }
        ProtoManager.Page requestPage = new ProtoManager.Page();
        requestPage.snap = this.mOnlineListSnap;
        requestPage.offset = this.mNextOffset;
        requestPage.limit = 20L;
        boolean isBaseMode = ((InvitePresenter)this.mMvpContext.getPresenter(InvitePresenter.class)).isBaseMode();
        if (isBaseMode) {
            this.mDataProvider.fetchOnlineWithStatusData(requestPage, (DataCallback<OnlineWithStatusPageData>)((DataCallback)data -> {
                if (this.isDestroy()) {
                    return;
                }
                this.mRefreshLayout.finishLoadMore();
                this.mStatusLayout.hideLoading();
                if (data == null) {
                    if (this.mNextOffset == 0L) {
                        this.mStatusLayout.showNoData();
                        if (this.mEmptyCallback != null) {
                            this.mEmptyCallback.onEmpty();
                        }
                    }
                    return;
                }
                if (data.getPage().offset == 0L) {
                    this.mOnlineList.clear();
                }
                List<OnlineBean> onlineList = this.mInviteHandler.filterOnlineData(data.getOnlineList());
                List<OnlineBean> partyList = this.mInviteHandler.filterOnlineData(data.getPartyList());
                ArrayList<Object> tempList = new ArrayList<Object>();
                if (FP.size(partyList) > 0) {
                    tempList.add(new GroupTitleHolder.GroupTitleItem(ResourceUtils.getString((int)R.string.group_title_in_group), partyList.size()));
                    tempList.addAll(partyList);
                }
                if (onlineList.size() > 0) {
                    if (FP.size(partyList) > 0) {
                        tempList.add(new GroupTitleHolder.GroupTitleItem(ResourceUtils.getString((int)R.string.group_title_online), onlineList.size()));
                    }
                    tempList.addAll(onlineList);
                }
                this.handleData((OnlinePageData)data, onlineList, (List<Object>)tempList);
            }));
        } else {
            this.mDataProvider.fetchOnlineData(requestPage, (DataCallback<OnlinePageData>)((DataCallback)data -> {
                if (this.isDestroy()) {
                    return;
                }
                this.mRefreshLayout.finishLoadMore();
                this.mStatusLayout.hideLoading();
                if (data == null || FP.empty(data.getOnlineList())) {
                    if (this.mNextOffset == 0L) {
                        this.mStatusLayout.showNoData();
                        if (this.mEmptyCallback != null) {
                            this.mEmptyCallback.onEmpty();
                        }
                    }
                    return;
                }
                if (data.getPage().offset == 0L) {
                    this.mOnlineList.clear();
                }
                List<OnlineBean> onlineList = this.mInviteHandler.filterOnlineData(data.getOnlineList());
                int inSeatCount = 0;
                boolean fromMultiVideo = false;
                for (OnlineBean onlineBean : onlineList) {
                    if (onlineBean.pluginMode == 15) {
                        fromMultiVideo = true;
                    }
                    if (!onlineBean.isSeated) continue;
                    ++inSeatCount;
                }
                ArrayList<Object> tempList = new ArrayList<Object>();
                tempList.addAll(onlineList);
                if (fromMultiVideo) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)("inSeatCount" + inSeatCount + " onlineList.size():" + onlineList.size()), (Object[])new Object[0]);
                    }
                    if (inSeatCount > 0) {
                        tempList.add(0, new CountItemHolder.CountItem(ResourceUtils.getString((int)R.string.title_invite_seat_count), String.valueOf(inSeatCount)));
                    }
                    if (onlineList.size() - inSeatCount > 0) {
                        int onlineCountIndex = inSeatCount > 0 ? 1 + inSeatCount : 0;
                        tempList.add(onlineCountIndex, new CountItemHolder.CountItem(ResourceUtils.getString((int)R.string.title_invite_online_count), String.valueOf(onlineList.size() - inSeatCount)));
                    }
                }
                this.handleData((OnlinePageData)data, onlineList, (List<Object>)tempList);
            }));
        }
    }

    private void handleData(OnlinePageData data, List<OnlineBean> onlineList, List<Object> tempList) {
        int spaceIndex = this.mOnlineList.indexOf(this.mBottomSpaceItem);
        if (spaceIndex < 0) {
            this.mOnlineList.add(this.mBottomSpaceItem);
            this.mOnlineList.addAll(0, tempList);
            this.mAdapter.notifyDataSetChanged();
        } else {
            this.mOnlineList.addAll(spaceIndex, tempList);
            this.mAdapter.notifyItemRangeInserted(spaceIndex, tempList.size());
        }
        ArrayList<Long> uids = new ArrayList<Long>();
        for (OnlineBean onlineBean : onlineList) {
            uids.add(onlineBean.uid);
            if (this.mFirstVip != null || onlineBean.uid == AccountUtil.getUid() || !onlineBean.isVipSeat) continue;
            this.mFirstVip = onlineBean;
            int firstVipIndex = this.mOnlineList.indexOf(this.mFirstVip);
            if (firstVipIndex < 0) continue;
            this.mOnlineList.add(firstVipIndex, this.mPrioritySeatBar);
        }
        if (!uids.isEmpty() && this.mListCallback != null) {
            ((GameChannelInfoPresenter)this.mListCallback.getMvpContext().getPresenter(GameChannelInfoPresenter.class)).requestChannelStatusInfos(uids, null);
        }
        this.mOnlineListSnap = data.getPage().snap;
        this.mNextOffset += (long)data.getOnlineList().size();
        if (this.mNextOffset < data.getPage().total) {
            this.mRefreshLayout.setEnableLoadMore(true);
        } else {
            this.mRefreshLayout.setEnableLoadMore(false);
        }
    }

    private void registerViewHolder() {
        this.mAdapter.register(OnlineBean.class, (ItemViewBinder)new SimpleItemBinder<OnlineBean, OnlineItemView>(){

            @Override
            public OnlineItemView createItemView(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                OnlineItemView itemView = new OnlineItemView(parent.getContext());
                itemView.setOnlineListCallback(OnlineListComponent.this.mListCallback);
                itemView.setItemListener(new OnlineItemView.OnItemListener(){

                    @Override
                    public void onAvatarClick(OnlineBean data) {
                        if (OnlineListComponent.this.mListCallback != null) {
                            OnlineListComponent.this.mListCallback.onAvatarClick(data);
                        }
                    }

                    @Override
                    public void onUpdateActionBtn(OnlineBean data, TextView actionBtn) {
                        if (OnlineListComponent.this.mInviteHandler != null) {
                            OnlineListComponent.this.mInviteHandler.updateActionBtn(data, actionBtn);
                        }
                    }
                });
                return itemView;
            }
        });
        this.mAdapter.register(CountItemHolder.CountItem.class, (ItemViewBinder)new CountItemHolder());
        this.mAdapter.register(GroupTitleHolder.GroupTitleItem.class, (ItemViewBinder)new GroupTitleHolder());
        this.mAdapter.register(SpaceItemHolder.SpaceItem.class, (ItemViewBinder)new SpaceItemHolder(-1, ResourceUtils.getDimen((int)R.dimen.common_load_more_height)));
        this.mAdapter.register(VipSeatBarHolder.BarItem.class, (ItemViewBinder)new VipSeatBarHolder());
    }

    public void removeItem(long uid) {
        if (null != this.mOnlineList && null != this.mAdapter) {
            for (Object object : this.mOnlineList) {
                if (!(object instanceof OnlineBean) || ((OnlineBean)object).uid != uid) continue;
                this.mOnlineList.remove(object);
                this.mAdapter.notifyDataSetChanged();
                break;
            }
        }
    }

    public View getView() {
        return this.mContentView;
    }

    @Override
    public void onInviteStatusChanged(OnlineBean onlineBean) {
        int index = this.mOnlineList.indexOf(onlineBean);
        if (index >= 0 && index < this.mOnlineList.size()) {
            this.mAdapter.notifyItemChanged(index);
        }
    }

    @Override
    public void onInviteStatusChanged(long uid) {
        for (int i = 0; i < this.mOnlineList.size(); ++i) {
            Object obj = this.mOnlineList.get(i);
            if (!(obj instanceof OnlineBean)) continue;
            OnlineBean onlineBean = (OnlineBean)obj;
            if (onlineBean.uid != uid) continue;
            this.mAdapter.notifyItemChanged(i);
            break;
        }
    }

    @Override
    public void onShow() {
        this.initData();
        this.mInviteHandler.onInit();
    }

    @Override
    public void onHide() {
        this.mInviteHandler.onDestroy();
    }

    @Override
    public View getPage() {
        return this.mContentView;
    }

    private boolean isDestroy() {
        return this.mMvpContext == null || this.mMvpContext.isDestroy();
    }

    public void setEmptyCallback(IEmptyCallback callback2) {
        this.mEmptyCallback = callback2;
    }

    static interface IEmptyCallback {
        public void onEmpty();
    }
}

