/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.invite.friend.viewholder;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.component.invite.friend.share.PlatformShareData;
import com.yy.hiyo.share.base.BaseShareChannel;
import com.yy.hiyo.share.base.ShareChannelIdDef;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class PlatformViewHolder
extends BaseItemBinder.ViewHolder<PlatformShareData>
implements View.OnClickListener {
    private LinearLayout llRoot;
    private OnPlatformShareListener platformShareListener;

    private PlatformViewHolder(LinearLayout itemView) {
        super((View)itemView);
        this.llRoot = itemView;
    }

    public void setData(PlatformShareData data) {
        super.setData((Object)data);
        this.llRoot.removeAllViews();
        if (data == null && data.getChannelList() != null) {
            return;
        }
        for (BaseShareChannel channel : data.getChannelList()) {
            this.addChannel(channel);
        }
        if (data.canSendFamilyCall()) {
            this.addFamilyCall();
        }
    }

    public void setPlatformShareListener(OnPlatformShareListener platformShareListener) {
        this.platformShareListener = platformShareListener;
    }

    private void addChannel(BaseShareChannel channel) {
        if (channel == null) {
            return;
        }
        int idResId = 0;
        int iconResId = 0;
        switch (channel.getId()) {
            case 2: {
                idResId = R.id.share_platform_whatsapp;
                iconResId = R.drawable.select_share_whatsapp_bg;
                break;
            }
            case 5: {
                idResId = R.id.share_platform_facebook;
                iconResId = R.drawable.select_share_fb_bg;
                break;
            }
            case 3: {
                idResId = R.id.share_platform_instagram;
                iconResId = R.drawable.select_share_ins_bg;
                break;
            }
            case 1: {
                idResId = R.id.share_platform_line;
                iconResId = R.drawable.select_share_line_bg;
                break;
            }
            case 6: {
                idResId = R.id.share_platform_messenger;
                iconResId = R.drawable.select_share_messenger_bg;
                break;
            }
            case 9: {
                idResId = R.id.share_platform_vk;
                iconResId = R.drawable.select_share_vk_bg;
                break;
            }
            case 10: {
                idResId = R.id.share_copy_link;
                iconResId = R.drawable.select_share_copy_bg;
                break;
            }
            case 13: {
                idResId = R.id.share_native;
                iconResId = R.drawable.select_share_native_bg;
                break;
            }
        }
        this.addView(idResId, iconResId);
    }

    private void addFamilyCall() {
        int idResId = R.id.channel_family_call;
        int iconResId = R.drawable.icon_family_call_room_launch;
        this.addView(idResId, iconResId);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("60080028").put("function_id", "entry_show"));
    }

    private void addView(int idResId, int iconResId) {
        if (idResId > 0) {
            int ivSize = ResolutionUtils.dip2Px((float)40.0f);
            int verMargin = ResolutionUtils.dip2Px((float)18.0f);
            int horMargin = ResolutionUtils.dip2Px((float)10.0f);
            YYImageView ivChannel = new YYImageView(this.llRoot.getContext());
            ivChannel.setId(idResId);
            ivChannel.setBackgroundResource(iconResId);
            this.llRoot.addView((View)ivChannel, ivSize, ivSize);
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)ivChannel.getLayoutParams();
            lp.topMargin = verMargin;
            lp.bottomMargin = verMargin;
            lp.leftMargin = horMargin;
            lp.rightMargin = horMargin;
            ivChannel.setOnClickListener((View.OnClickListener)this);
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (this.platformShareListener == null) {
            return;
        }
        if (id2 == R.id.channel_family_call) {
            this.platformShareListener.onSendFamilyCall();
        } else {
            int channelId = ShareChannelIdDef.getChannelIdByViewId((int)id2);
            if (channelId != -1) {
                this.platformShareListener.onPlatformShare(channelId);
            }
        }
    }

    public static BaseItemBinder getItemBinder(final OnPlatformShareListener platformShareListener) {
        return new BaseItemBinder<PlatformShareData, PlatformViewHolder>(){

            @NonNull
            protected PlatformViewHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                YYLinearLayout llRoot = new YYLinearLayout(parent.getContext());
                llRoot.setOrientation(0);
                int paddingLR = ResolutionUtils.dip2Px((float)5.0f);
                llRoot.setPadding(paddingLR, 0, paddingLR, 0);
                ViewGroup.LayoutParams rootLP = new ViewGroup.LayoutParams(-1, -2);
                llRoot.setLayoutParams(rootLP);
                PlatformViewHolder viewHolder = new PlatformViewHolder((LinearLayout)llRoot);
                viewHolder.setPlatformShareListener(platformShareListener);
                return viewHolder;
            }
        };
    }

    public static interface OnPlatformShareListener {
        public void onPlatformShare(int var1);

        public void onSendFamilyCall();
    }
}

