/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.invite.friend.viewholder;

import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.yy.appbase.invite.InviteFriendData;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.util.StatusUtil;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.channel.R;
import java.util.List;

public class FriendViewHolder
extends BaseItemBinder.ViewHolder<InviteFriendData> {
    private View rootView;
    private CircleImageView avatarIv;
    private YYTextView nameTv;
    private YYTextView fromTv;
    private YYTextView statusTv;
    private YYView onlineView;
    private OnItemClickListener itemInviteClickListener;

    public FriendViewHolder(View itemView) {
        super(itemView);
        this.rootView = itemView;
        this.avatarIv = (CircleImageView)itemView.findViewById(R.id.iv_avatar);
        this.nameTv = (YYTextView)itemView.findViewById(R.id.tv_name);
        this.fromTv = (YYTextView)itemView.findViewById(R.id.tv_from);
        this.statusTv = (YYTextView)itemView.findViewById(R.id.tv_status);
        this.onlineView = (YYView)itemView.findViewById(R.id.v_status);
    }

    public void setData(final InviteFriendData data) {
        super.setData((Object)data);
        this.nameTv.setText((CharSequence)data.mFriend.getNick());
        ImageLoader.loadBitmap((RecycleImageView)this.avatarIv, (String)(data.mFriend.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75)), (int)AvatarUtils.getDefaultAvatar((int)data.mFriend.getSex()));
        Drawable drawable2 = null;
        if (data.channelMode == 1) {
            drawable2 = StatusUtil.getStatusBadge((int)data.mFriend.getStatus());
        } else if (data.mFriend.isOnline()) {
            drawable2 = data.mFriend.isInGame() ? ResourceUtils.getDrawable((int)R.drawable.shape_in_game) : (data.mFriend.isMatching() ? ResourceUtils.getDrawable((int)R.drawable.shape_in_team) : ResourceUtils.getDrawable((int)R.drawable.shape_online));
        }
        this.onlineView.setBackgroundDrawable(drawable2);
        this.updateInviteState(data.inviteState);
        long type = data.mFriend.getType();
        if (type == 0L) {
            String nick = data.mFriend.getAlias();
            if (nick != null && nick.length() > 12) {
                nick = nick.substring(0, 12) + "...";
            }
            this.fromTv.setVisibility(0);
            this.fromTv.setText((CharSequence)ResourceUtils.getString((int)R.string.xx_on_fb, (Object[])new Object[]{nick}));
        } else if (type == 1L) {
            String nick = data.mFriend.getAlias();
            if (nick != null && nick.length() > 12) {
                nick = nick.substring(0, 12) + "...";
            }
            this.fromTv.setVisibility(0);
            this.fromTv.setText((CharSequence)ResourceUtils.getString((int)R.string.xx_on_contact, (Object[])new Object[]{nick}));
        } else if (type == 7L) {
            this.fromTv.setVisibility(0);
            this.fromTv.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_follow_each_people));
        } else {
            this.fromTv.setVisibility(8);
        }
        this.statusTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if ((data.inviteState == 3 || data.inviteState == 1) && FriendViewHolder.this.itemInviteClickListener != null) {
                    FriendViewHolder.this.itemInviteClickListener.onInviteClicked(data);
                }
            }
        });
        this.rootView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (FriendViewHolder.this.itemInviteClickListener != null) {
                    FriendViewHolder.this.itemInviteClickListener.onInfoClicked(data);
                }
            }
        });
    }

    private void updateInviteState(int inviteState) {
        if (inviteState == 2) {
            this.statusTv.setText(R.string.btn_invite_friend_invited);
            this.statusTv.setBackgroundResource(0);
            this.statusTv.setTextColor(Color.parseColor((String)"#999999"));
        } else if (inviteState == 3) {
            this.statusTv.setText(R.string.btn_invite_friend_notifyable);
            this.statusTv.setBackgroundResource(R.drawable.shape_invite_friend_status_notifyable);
            this.statusTv.setTextColor(ResourceUtils.getColor((int)R.color.white));
        } else if (inviteState == 4) {
            this.statusTv.setText(R.string.btn_invite_friend_notified);
            this.statusTv.setBackgroundResource(0);
            this.statusTv.setTextColor(Color.parseColor((String)"#999999"));
        } else {
            this.statusTv.setText(R.string.btn_invite_friend_invitable);
            this.statusTv.setBackgroundResource(R.drawable.shape_invite_friend_status_invitable);
            this.statusTv.setTextColor(ResourceUtils.getColor((int)R.color.white));
        }
    }

    public void setItemInviteClickListener(OnItemClickListener itemInviteClickListener) {
        this.itemInviteClickListener = itemInviteClickListener;
    }

    public static BaseItemBinder getItemBinder(final OnItemClickListener inviteClickListener) {
        return new BaseItemBinder<InviteFriendData, FriendViewHolder>(){

            @NonNull
            protected FriendViewHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                View itemView = inflater.inflate(R.layout.item_invite_friend, parent, false);
                FriendViewHolder viewHolder = new FriendViewHolder(itemView);
                viewHolder.setItemInviteClickListener(inviteClickListener);
                return viewHolder;
            }
        };
    }

    public void onPartialUpdate(InviteFriendData item, List<Object> payloads) {
        super.onPartialUpdate((Object)item, payloads);
        if (FP.empty(payloads)) {
            return;
        }
        if (payloads.get(0) instanceof Integer) {
            this.updateInviteState((Integer)payloads.get(0));
        }
    }

    public static interface OnItemClickListener {
        public void onInviteClicked(InviteFriendData var1);

        public void onInfoClicked(InviteFriendData var1);
    }
}

