/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.invite.friend.share;

import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.DataCallback;
import com.yy.appbase.envsetting.EnvSettingType;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.CommonConfig;
import com.yy.appbase.unifyconfig.config.CommonConfigData;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.URLUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.component.invite.friend.data.TokenProvider;
import com.yy.hiyo.channel.component.invite.friend.share.PlatformShareData;
import com.yy.hiyo.game.base.helper.ShortUrlUtil;
import com.yy.hiyo.share.base.DownloadCallback;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.hiyo.share.base.dataprovider.ShareDataProvider;
import java.net.URLEncoder;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ChannelPlatformShareDataProvider
extends ShareDataProvider {
    private static final String DEFAULT_IMG_URL = "https://o-id.ihago.net/ikxd/ea959b76fdad64905838abb04a3e07c0/voiceroom_invite_share.png";
    private static final String SHARE_URL_ARGS = "&appType=android&roomId=%s&roomTitle=%s&roomNum=%d&inviteUid=%d&userName=%s&userImg=%s&targetShare=%s&roomType=%s&secondRoomType=%s&ownerUid=%s&vid=%s";
    private static final String SHARE_URL_ROOM_TOKEN_ARG = "&roomToken=%s";
    private PlatformShareData shareData;

    public void setShareData(@NotNull PlatformShareData data) {
        this.shareData = data;
        this.reset();
        this.preload();
    }

    protected void buildTitle(com.yy.hiyo.share.base.dataprovider.DataCallback<String> callback2) {
        UserInfoKS userInfoKS = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(AccountUtil.getUid(), null);
        String shareTitle = null;
        if (userInfoKS != null) {
            int roomType = this.shareData.getInviteData().roomType;
            shareTitle = roomType == 1 ? ResourceUtils.getString((int)R.string.short_tips_share_invite_join_party, (Object[])new Object[]{userInfoKS.nick}) : (roomType == 2 ? ResourceUtils.getString((int)R.string.short_tips_share_invite_join_live, (Object[])new Object[]{userInfoKS.nick}) : ResourceUtils.getString((int)R.string.short_tips_share_invite_join_group, (Object[])new Object[]{userInfoKS.nick, this.shareData.getInviteData().channelName}));
        }
        callback2.onData(shareTitle);
    }

    protected void buildText(com.yy.hiyo.share.base.dataprovider.DataCallback<String> callback2) {
        String title = this.getShareBundle().getTitle();
        String url = this.getShareBundle().getUrl();
        String text = StringUtils.format((String)"%s %s", (Object[])new Object[]{title, url});
        callback2.onData((Object)text);
    }

    protected void buildImage(final com.yy.hiyo.share.base.dataprovider.DataCallback<String> callback2) {
        String imgUrl = this.getImgUrl();
        ((IIntlShareService)ServiceManagerProxy.getService(IIntlShareService.class)).downloadShareImage(imgUrl, new DownloadCallback(){

            public void onSuccess(String url, String path) {
                callback2.onData((Object)path);
            }

            public void onFail(String url) {
                callback2.onData(null);
            }
        });
    }

    @NotNull
    private String getImgUrl() {
        String imgUrl = this.shareData.getInviteData().channelCover;
        if (FP.empty((CharSequence)imgUrl)) {
            imgUrl = DEFAULT_IMG_URL;
        }
        return imgUrl;
    }

    protected void buildUrl(final com.yy.hiyo.share.base.dataprovider.DataCallback<String> callback2) {
        final String baseUrl = this.getBaseShareUrl();
        if (this.shareData != null && this.shareData.getInviteData() != null && this.shareData.getInviteData().isFamily) {
            String url = StringUtils.format((String)baseUrl, (Object[])new Object[]{this.shareData.getInviteData().channelId});
            ShortUrlUtil.getShortUrl((String)url, (ShortUrlUtil.IGetShortUrl)new ShortUrlUtil.IGetShortUrl(){

                public void onSuccess(String input, String shortUrl) {
                    callback2.onData((Object)shortUrl);
                }

                public void onError(String input, int code, String msg) {
                    callback2.onData((Object)input);
                }
            });
        } else {
            this.getUserInfo(new OnProfileCallback(){

                public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                    UserInfoKS userInfoKS = userInfoKSList.get(0);
                    StringBuilder urlBuilder = new StringBuilder(baseUrl);
                    urlBuilder.append(StringUtils.formatWitUSLocal((String)ChannelPlatformShareDataProvider.SHARE_URL_ARGS, (Object[])new Object[]{((ChannelPlatformShareDataProvider)ChannelPlatformShareDataProvider.this).shareData.getInviteData().channelId, URLEncoder.encode(((ChannelPlatformShareDataProvider)ChannelPlatformShareDataProvider.this).shareData.getInviteData().channelName), ((ChannelPlatformShareDataProvider)ChannelPlatformShareDataProvider.this).shareData.getInviteData().onlineCount, AccountUtil.getUid(), URLEncoder.encode(userInfoKS.nick), URLEncoder.encode(ChannelPlatformShareDataProvider.this.getImgUrl()), ((ChannelPlatformShareDataProvider)ChannelPlatformShareDataProvider.this).shareData.getInviteData().targetShare, ((ChannelPlatformShareDataProvider)ChannelPlatformShareDataProvider.this).shareData.getInviteData().roomType, ((ChannelPlatformShareDataProvider)ChannelPlatformShareDataProvider.this).shareData.getInviteData().secondRoomType, ((ChannelPlatformShareDataProvider)ChannelPlatformShareDataProvider.this).shareData.getInviteData().ownerUid, userInfoKS.vid}));
                    TokenProvider provider = ((ChannelPlatformShareDataProvider)ChannelPlatformShareDataProvider.this).shareData.getInviteData().tokenProvider;
                    if (provider != null) {
                        provider.getToken((DataCallback<String>)((DataCallback)token -> {
                            if (!FP.empty((CharSequence)token)) {
                                urlBuilder.append(StringUtils.formatWitUSLocal((String)ChannelPlatformShareDataProvider.SHARE_URL_ROOM_TOKEN_ARG, (Object[])new Object[]{token}));
                            }
                            this.buildShortUrl(urlBuilder.toString(), (com.yy.hiyo.share.base.dataprovider.DataCallback<String>)callback2);
                        }));
                    } else {
                        this.buildShortUrl(urlBuilder.toString(), (com.yy.hiyo.share.base.dataprovider.DataCallback<String>)callback2);
                    }
                }

                public void onFail(int id2, String msg, String response) {
                    this.buildShortUrl(baseUrl, (com.yy.hiyo.share.base.dataprovider.DataCallback<String>)callback2);
                }

                private void buildShortUrl(String url, final com.yy.hiyo.share.base.dataprovider.DataCallback<String> callback22) {
                    ShortUrlUtil.getShortUrl((String)url, (ShortUrlUtil.IGetShortUrl)new ShortUrlUtil.IGetShortUrl(){

                        public void onSuccess(String input, String shortUrl) {
                            callback22.onData((Object)shortUrl);
                        }

                        public void onError(String input, int code, String msg) {
                            callback22.onData((Object)input);
                        }
                    });
                }
            });
        }
    }

    private String getBaseShareUrl() {
        AConfigData configData;
        if (this.shareData != null && this.shareData.getInviteData() != null && this.shareData.getInviteData().isFamily && (configData = UnifyConfig.INSTANCE.getConfigData(BssCode.COMMON_CONFIG)) instanceof CommonConfig) {
            CommonConfigData data = ((CommonConfig)configData).getData();
            String familyUrl = data.familyDetailUrl;
            if (StringUtils.isNotEmpty((String)familyUrl)) {
                return URLUtils.addParam((String)familyUrl, (String)"useNativeDetail", (String)"true");
            }
        }
        EnvSettingType type = EnvSettings.instance().getUriSettingValue();
        StringBuilder urlBuilder = new StringBuilder();
        if (type == EnvSettingType.Product) {
            urlBuilder.append("https://www.ihago.net/a/channel-share/index.html");
        } else {
            urlBuilder.append("https://test.ihago.net/a/channel-share/index.html");
        }
        urlBuilder.append("?").append(UriProvider.appendCommonWebUrlParams());
        return urlBuilder.toString();
    }

    private void getUserInfo(OnProfileCallback callback2) {
        long uid = AccountUtil.getUid();
        if (this.shareData.getInviteData().roomType != 3) {
            uid = this.shareData.getInviteData().ownerUid;
        }
        ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(uid, callback2);
    }
}

