/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.invite.friend.data;

import com.yy.appbase.common.DataCallback;
import com.yy.appbase.invite.InviteFriendData;
import com.yy.appbase.service.IInviteFriendService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IRoleService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class FriendDataProvider {
    private IChannel mChannel;

    public FriendDataProvider(IChannel channel) {
        this.mChannel = channel;
    }

    public void fetchFriendData(final int mode, final DataCallback<List<InviteFriendData>> callback2) {
        ((IInviteFriendService)ServiceManagerProxy.getServiceManager().getService(IInviteFriendService.class)).requestList(new IInviteFriendService.IInviteFriendCallback(){

            public void loadSuccess(final List<InviteFriendData> list2) {
                if (FP.empty(list2)) {
                    callback2.onResult(null);
                    return;
                }
                LinkedList<Long> uids = new LinkedList<Long>();
                String msg = FriendDataProvider.this.buildInviteMsg(mode);
                for (InviteFriendData inviteFriendData : list2) {
                    inviteFriendData.channelMode = mode;
                    inviteFriendData.msg = msg;
                    uids.add(inviteFriendData.mFriend.getUid());
                }
                FriendDataProvider.this.mChannel.getRoleService().isInChannel(uids, new IRoleService.IQueryUsersInThisChannelCallBack(){

                    public void onSuccess(String cid, HashMap<Long, Boolean> inChannelMap) {
                        ArrayList<InviteFriendData> notInChannelList = new ArrayList<InviteFriendData>();
                        for (InviteFriendData inviteFriendData : list2) {
                            Boolean inChannel = inChannelMap.get(inviteFriendData.mFriend.getUid());
                            if (inChannel != null && inChannel.booleanValue()) continue;
                            notInChannelList.add(inviteFriendData);
                        }
                        callback2.onResult(notInChannelList);
                    }

                    public void onError(String cid, int errorCode, String errorTips, Exception e) {
                        callback2.onResult((Object)list2);
                    }
                });
            }

            public void loadFail() {
                callback2.onResult(null);
            }
        });
    }

    private String buildInviteMsg(int mode) {
        if (mode == 14) {
            return ResourceUtils.getString((int)R.string.desc_join_live_room);
        }
        if (mode == 1) {
            return ResourceUtils.getString((int)R.string.desc_group_chat_together);
        }
        return ResourceUtils.getString((int)R.string.desc_voice_chat_together);
    }
}

