/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.invite.friend;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SimpleItemAnimator;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.yy.appbase.common.DataCallback;
import com.yy.appbase.invite.InviteFriendData;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.base.env.RuntimeContext;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.cbase.channelhiido.RadioUtils;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.component.invite.base.IPanelPage;
import com.yy.hiyo.channel.component.invite.callback.IInviteAllCallback;
import com.yy.hiyo.channel.component.invite.callback.IInviteFriendCallback;
import com.yy.hiyo.channel.component.invite.friend.FriendListCallback;
import com.yy.hiyo.channel.component.invite.friend.behavior.FriendInviteBehavior;
import com.yy.hiyo.channel.component.invite.friend.data.FriendDataProvider;
import com.yy.hiyo.channel.component.invite.friend.data.NotifyFansData;
import com.yy.hiyo.channel.component.invite.friend.share.PlatformShareData;
import com.yy.hiyo.channel.component.invite.friend.viewholder.FriendViewHolder;
import com.yy.hiyo.channel.component.invite.friend.viewholder.NotifyFansItemBinder;
import com.yy.hiyo.channel.component.invite.friend.viewholder.PlatformViewHolder;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.drakeet.multitype.ItemViewBinder;
import me.drakeet.multitype.MultiTypeAdapter;
import net.ihago.room.srv.follow.ECode;
import org.jetbrains.annotations.NotNull;

@SuppressLint(value={"ViewConstructor"})
public class FriendListPage
extends YYFrameLayout
implements IPanelPage,
FriendViewHolder.OnItemClickListener,
PlatformViewHolder.OnPlatformShareListener,
NotifyFansItemBinder.OnItemClickListener {
    private IMvpContext mMvpContext;
    private CommonStatusLayout mStatusLayout;
    private RecyclerView mRecyclerView;
    private SmartRefreshLayout mRefreshLayout;
    private List<Object> mList = new ArrayList<Object>();
    private MultiTypeAdapter mAdapter;
    private FriendListCallback mListCallback;
    private FriendDataProvider mFriendDataProvider;
    private FriendInviteBehavior mFriendInviteBehavior;
    private IChannel mChannel;

    public FriendListPage(@NotNull IMvpContext mvpContext, IChannel channel) {
        super((Context)mvpContext.getContext());
        this.mMvpContext = mvpContext;
        this.mChannel = channel;
        this.createViews();
        this.mAdapter = new MultiTypeAdapter(this.mList);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.registerViewHolder();
    }

    private void createViews() {
        FriendListPage.inflate((Context)this.getContext(), (int)R.layout.dialog_invite_list_page_channel, (ViewGroup)this);
        this.mStatusLayout = (CommonStatusLayout)this.findViewById(R.id.status_layout);
        this.mRefreshLayout = (SmartRefreshLayout)this.findViewById(R.id.refresh_layout);
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.rv_list);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        if (this.mRecyclerView.getItemAnimator() instanceof SimpleItemAnimator) {
            ((SimpleItemAnimator)this.mRecyclerView.getItemAnimator()).setSupportsChangeAnimations(false);
        }
        this.mRefreshLayout.setEnableRefresh(false);
        this.mRefreshLayout.setEnableLoadMore(false);
    }

    public void setFriendDataProvider(FriendDataProvider friendDataProvider) {
        this.mFriendDataProvider = friendDataProvider;
    }

    public void setFriendInviteBehavior(FriendInviteBehavior friendInviteBehavior) {
        this.mFriendInviteBehavior = friendInviteBehavior;
    }

    public void setListCallback(FriendListCallback listCallback) {
        this.mListCallback = listCallback;
    }

    private void registerViewHolder() {
        this.mAdapter.register(PlatformShareData.class, (ItemViewBinder)PlatformViewHolder.getItemBinder(this));
        this.mAdapter.register(InviteFriendData.class, (ItemViewBinder)FriendViewHolder.getItemBinder(this));
        this.mAdapter.register(NotifyFansData.class, (ItemViewBinder)new NotifyFansItemBinder(this));
    }

    private void loadData() {
        if (this.mFriendDataProvider == null) {
            return;
        }
        this.mStatusLayout.showLoading();
        this.mFriendDataProvider.fetchFriendData(this.mChannel.getPluginService().getCurPluginData().mode, (DataCallback<List<InviteFriendData>>)((DataCallback)result -> {
            this.mStatusLayout.hideLoading();
            this.mList.clear();
            this.mFriendInviteBehavior.getSendFamilyCallPermission((DataCallback<Boolean>)((DataCallback)hasPermission -> {
                PlatformShareData platformShareData = this.mFriendInviteBehavior.getPlatformShareData();
                boolean canSendFamilyCall = false;
                if (hasPermission != null) {
                    canSendFamilyCall = hasPermission;
                }
                platformShareData.setCanSendFamilyCall(canSendFamilyCall);
                this.mList.add(platformShareData);
                if (FP.empty((Collection)result)) {
                    this.mStatusLayout.showNoData();
                } else {
                    this.mList.addAll((Collection<Object>)result);
                }
                this.mAdapter.notifyDataSetChanged();
            }));
        }));
    }

    private boolean isBaseChannel() {
        return this.mChannel.getPluginService().getCurPluginData().mode == 1;
    }

    @Override
    public void onInviteClicked(final InviteFriendData data) {
        if (data == null || data.mFriend == null) {
            return;
        }
        if (data.inviteState == 3 && this.mChannel != null) {
            RoomTrack.INSTANCE.reportInviteOfflineClick(this.mChannel.getChannelId(), data.mFriend.getUid());
        }
        if (this.mFriendInviteBehavior != null) {
            this.mFriendInviteBehavior.onInviteFriend(data, new IInviteFriendCallback(){

                @Override
                public void onSuccess() {
                    data.inviteState = data.inviteState == 1 ? 2 : 4;
                    int index = FriendListPage.this.mList.indexOf(data);
                    if (index >= 0 && index < FriendListPage.this.mList.size()) {
                        FriendListPage.this.mAdapter.notifyItemChanged(index);
                    }
                    if (FriendListPage.this.mListCallback != null) {
                        FriendListPage.this.mListCallback.onInviteFriendSuccess(data.mFriend.getUid());
                    }
                }

                @Override
                public void onFail(int code) {
                    if (code == 4) {
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_cross_region_invite_channel, (int)0);
                    }
                }
            });
        }
    }

    @Override
    public void onInfoClicked(InviteFriendData data) {
        if (data == null || data.mFriend == null) {
            return;
        }
        if (this.mListCallback != null) {
            this.mListCallback.onAvatarClick(data);
        }
    }

    @Override
    public void onPlatformShare(int channelId) {
        if (this.mFriendInviteBehavior != null) {
            this.mFriendInviteBehavior.onPlatformShare(channelId);
        }
        if (this.mListCallback != null) {
            this.mListCallback.onPlatformShareClick(channelId);
        }
    }

    @Override
    public void onSendFamilyCall() {
        if (this.mListCallback != null) {
            this.mListCallback.onSendFamilyCallClick();
        }
    }

    @Override
    public void onNotifyFansClick(final NotifyFansData data) {
        if (data.getInviteState() == 3) {
            final String cid = this.mChannel.getChannelId();
            final String pluginId = this.mChannel.getPluginService().getCurPluginData().getPluginId();
            this.mFriendInviteBehavior.inviteAllFans(cid, pluginId, new IInviteAllCallback(){

                @Override
                public void onSuccess(@NotNull String channelId, @NotNull String pid) {
                    if (StringUtils.equal((String)channelId, (String)cid) && StringUtils.equal((String)pid, (String)pluginId)) {
                        int index;
                        ToastUtils.showToast((Context)FriendListPage.this.mMvpContext.getContext(), (int)R.string.short_tips_notify_success);
                        data.setInviteState(4);
                        if (FriendListPage.this.mList != null && FriendListPage.this.mAdapter != null && (index = FriendListPage.this.mList.indexOf(data)) >= 0 && index < FriendListPage.this.mList.size()) {
                            FriendListPage.this.mAdapter.notifyItemChanged(index);
                        }
                    }
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "one_invite_but_click_result_back").put("result_type", "1").put("room_model", RadioUtils.INSTANCE.getMVideoMode()));
                }

                @Override
                public void onError(int code) {
                    if (code == ECode.ErrNotifyExceedOneDayLimit.getValue()) {
                        ToastUtils.showToast((Context)FriendListPage.this.mMvpContext.getContext(), (int)R.string.short_tips_notify_limit_one_day);
                    } else if (code == ECode.ErrNotifyTooBusy.getValue()) {
                        ToastUtils.showToast((Context)FriendListPage.this.mMvpContext.getContext(), (int)R.string.short_tips_notify_limit_too_busy);
                    }
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "one_invite_but_click_result_back").put("result_type", "2").put("room_model", RadioUtils.INSTANCE.getMVideoMode()));
                }
            });
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "one_invite_but_click").put("gid", pluginId).put("room_id", cid).put("room_model", RadioUtils.INSTANCE.getMVideoMode()));
        }
    }

    @Override
    public void onShow() {
        this.loadData();
        if (this.mChannel == null) {
            return;
        }
        if (this.mChannel.getRoleService().isMeOwner() || this.mChannel.getRoleService().isMeAnchor()) {
            RoomTrack.INSTANCE.onVoiceRoomOwnerInviteListShow(this.mChannel.getChannelId(), RadioUtils.INSTANCE.getMVideoMode());
        }
    }

    @Override
    public void onHide() {
    }

    @Override
    public View getPage() {
        return this;
    }
}

