/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.invite.channel;

import android.graphics.Color;
import android.widget.TextView;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IOperationCallback;
import com.yy.hiyo.channel.cbase.channelhiido.ChannelTrack;
import com.yy.hiyo.channel.component.invite.base.OnlineBean;
import com.yy.hiyo.channel.component.invite.online.handler.AbsOnlineInviteHandler;
import java.util.Collection;
import java.util.List;

public class VoiceCallInviteHandler
extends AbsOnlineInviteHandler {
    private static final String TAG = "VoiceCallInviteHandler";
    private static final int COLOR_IN_VOICE_CALL;
    private static final int COLOR_INVITED;
    private IChannel mChannel;

    public VoiceCallInviteHandler(IChannel channel) {
        this.mChannel = channel;
    }

    @Override
    public List<OnlineBean> filterOnlineData(List<OnlineBean> data) {
        List uidList = this.mChannel.getSeatService().getSeatUidsList();
        if (!FP.empty((Collection)uidList) && data != null) {
            for (OnlineBean onlineBean : data) {
                if (!uidList.contains(onlineBean.uid)) continue;
                onlineBean.inivteStatus = 3;
            }
        }
        return super.filterOnlineData(data);
    }

    @Override
    public String getInviteTitle() {
        return ResourceUtils.getString((int)R.string.short_title_channel_invite_to_voice_call);
    }

    @Override
    public void onInviteClick(final OnlineBean onlineBean) {
        ChannelTrack.INSTANCE.onVoiceInviteOkClick();
        this.mChannel.getSeatService().makeSitDown(-1, onlineBean.uid, new IOperationCallback(){

            public void onSuccess() {
                onlineBean.inivteStatus = 1;
                VoiceCallInviteHandler.this.notifyInviteStatusChange(onlineBean);
            }

            public void onFail(long reason) {
                MLog.error((Object)VoiceCallInviteHandler.TAG, (String)("onInviteClick makeSitDown fail reason = " + reason), (Object[])new Object[0]);
            }
        });
    }

    @Override
    public void updateActionBtn(OnlineBean onlineBean, TextView actionBtn) {
        if (onlineBean.uid == AccountUtil.getUid() || !onlineBean.inParty) {
            actionBtn.setVisibility(8);
        } else if (onlineBean.inivteStatus == 3) {
            actionBtn.setVisibility(0);
            actionBtn.setTextColor(COLOR_IN_VOICE_CALL);
            actionBtn.setText(R.string.btn_channel_in_voice_call);
            actionBtn.setBackgroundResource(0);
            actionBtn.setOnClickListener(null);
        } else if (onlineBean.inivteStatus == 1) {
            actionBtn.setVisibility(0);
            actionBtn.setTextColor(COLOR_INVITED);
            actionBtn.setText(R.string.invited);
            actionBtn.setBackgroundResource(0);
            actionBtn.setOnClickListener(null);
        } else if (onlineBean.inivteStatus == 0) {
            actionBtn.setVisibility(0);
            actionBtn.setTextColor(-1);
            actionBtn.setText(R.string.btn_profile_card_sit);
            actionBtn.setBackgroundResource(R.drawable.bg_sit_profile_card);
            actionBtn.setOnClickListener(v -> this.onInviteClick(onlineBean));
        } else {
            actionBtn.setVisibility(8);
        }
    }

    static {
        COLOR_INVITED = COLOR_IN_VOICE_CALL = Color.parseColor((String)"#999999");
    }
}

