/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.invite;

import android.annotation.SuppressLint;
import android.content.Context;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.DataCallback;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.envsetting.EnvSettingType;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.invite.InviteFriendData;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IBaseEnvService;
import com.yy.appbase.service.IOOSService;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.oos.IUploadObjectCallBack;
import com.yy.appbase.service.oos.UploadObjectRequest;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.CommonConfig;
import com.yy.appbase.unifyconfig.config.CommonConfigData;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.URLUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.framework.core.ui.BasePanel;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IDataService;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.component.familygroup.familycall.FamilyCallPresenter;
import com.yy.hiyo.channel.component.invite.PlatFormInvitePanel;
import com.yy.hiyo.channel.component.invite.friend.FriendListCallback;
import com.yy.hiyo.channel.component.invite.friend.behavior.DefaultFriendInviteBehavior;
import com.yy.hiyo.channel.component.invite.friend.data.AbsTokenProvider;
import com.yy.hiyo.channel.component.invite.friend.data.InviteData;
import com.yy.hiyo.channel.component.invite.friend.share.PlatformShareData;
import com.yy.hiyo.channel.component.setting.report.ChannelReportManager;
import com.yy.hiyo.game.base.helper.ShortUrlUtil;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.hiyo.share.base.IShareTemplate;
import com.yy.hiyo.share.base.ShareBundle;
import com.yy.hiyo.share.base.dataprovider.MutableShareBundle;
import com.yy.hiyo.share.base.template.ImageShareTemplate;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import org.jetbrains.annotations.NotNull;

public class PlatFormInvitePresenter
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>> {
    @SuppressLint(value={"StaticFieldLeak"})
    protected BasePanel mCurrPanel;
    private static final String TAG = "FTVoiceRoomPlatFormInvitePresenter";
    private FriendListCallback mFriendListCallback;
    private PlatformShareData shareData;
    private static final String SHARE_URL_ARGS = "&appType=android&roomId=%s&roomTitle=%s&roomNum=%d&inviteUid=%d&userName=%s&userImg=%s&targetShare=%s&roomType=%s&secondRoomType=%s&ownerUid=%s&vid=%s";
    private static final String SHARE_URL_ROOM_TOKEN_ARG = "&roomToken=%s";
    private MutableShareBundle mShareBundle = new MutableShareBundle();
    private Runnable mRunnable = new Runnable(){

        @Override
        public void run() {
            if (PlatFormInvitePresenter.this.mCurrPanel != null) {
                PlatFormInvitePresenter.this.getCurrentWindow().getPanelLayer().hidePanel(PlatFormInvitePresenter.this.mCurrPanel, true);
            }
        }
    };

    public void showInvitePanel(String imagePath) {
        if (null == this.getCurrentWindow()) {
            MLog.error((Object)TAG, (String)"window is null", (Object[])new Object[0]);
            return;
        }
        if (this.mCurrPanel != null) {
            this.getCurrentWindow().getPanelLayer().hidePanel(this.mCurrPanel, true);
        }
        if (!FP.empty((CharSequence)imagePath)) {
            this.showPanel(imagePath);
        }
    }

    private void showPanel(final String imagePath) {
        this.shareData = new PlatformShareData();
        InviteData inviteData = new InviteData();
        inviteData.channelId = this.getChannelId();
        inviteData.channelName = this.getChannelName();
        inviteData.ownerUid = this.getChannelDetailInfo().baseInfo.ownerUid;
        inviteData.uid = AccountUtil.getUid();
        inviteData.setRoomType(this.getPluginMode());
        if (this.getChannel() != null && this.getChannel().getPluginService().getCurPluginData() != null) {
            inviteData.setSecondRoomType(this.getChannel().getPluginService().getCurPluginData());
        }
        inviteData.channelCover = this.buildChannelCover(inviteData.roomType);
        inviteData.onlineCount = this.getChannelOnlineCount();
        inviteData.isFamily = this.getChannelDetailInfo().baseInfo.isFamily();
        inviteData.familyService = this.getChannel().getFamilyService();
        inviteData.tokenProvider = new AbsTokenProvider(){

            @Override
            public void fetchToken(final @NotNull DataCallback<String> cb) {
                if (PlatFormInvitePresenter.this.isDestroyed()) {
                    cb.onResult((Object)"");
                    return;
                }
                PlatFormInvitePresenter.this.getChannel().getDataService().getInviteEnterToken(new IDataService.IGetInviteTokenCallBack(){

                    public void onSuccess(String cid, String enterToken) {
                        cb.onResult((Object)enterToken);
                    }

                    public void onError(String cid, int errorCode, String errorTips, Exception e) {
                        MLog.error((Object)PlatFormInvitePresenter.TAG, (String)"getInviteEnterToken error, code=%d, msg=%d", (Object[])new Object[]{errorCode, errorTips});
                        cb.onResult((Object)"");
                    }
                });
            }
        };
        this.shareData.setInviteData(inviteData);
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                String md5;
                block2: {
                    md5 = "";
                    try {
                        md5 = YYFileUtils.getFileMD5String((File)new File(imagePath), (long)1000L);
                    }
                    catch (IOException e) {
                        if (!MLog.isLogLevelBlowInfo()) break block2;
                        MLog.info((Object)PlatFormInvitePresenter.TAG, (String)"showInvitePanel \u9519\u8bef:%s", (Object[])new Object[]{e});
                    }
                }
                String fileName = "share/image/" + md5 + ".jpg";
                PlatFormInvitePresenter.this.mShareBundle.setImagePath(imagePath);
                ((IOOSService)ServiceManagerProxy.getServiceManager().getService(IOOSService.class)).uploadFile(fileName, imagePath, new IUploadObjectCallBack(){

                    public void onSuccess(final UploadObjectRequest request) {
                        YYTaskExecutor.postToMainThread((Runnable)PlatFormInvitePresenter.this.mRunnable, (long)5000L);
                        PlatFormInvitePanel panel = new PlatFormInvitePanel((Context)((IChannelPageContext)PlatFormInvitePresenter.this.getMvpContext()).getContext());
                        DefaultFriendInviteBehavior friendInviteBehavior = new DefaultFriendInviteBehavior(PlatFormInvitePresenter.this.getMvpContext(), null);
                        panel.setFriendInviteBehavior(friendInviteBehavior);
                        PlatFormInvitePresenter.this.mFriendListCallback = new FriendListCallback(){

                            @Override
                            public void onAvatarClick(InviteFriendData data) {
                            }

                            @Override
                            public void onPlatformShareClick(int channelId) {
                                if (MLog.isLogLevelBlowInfo()) {
                                    MLog.info((Object)PlatFormInvitePresenter.TAG, (String)"showInvitePanel onPlatFormShareClick, channelId:%s", (Object[])new Object[]{channelId});
                                }
                                PlatFormInvitePresenter.this.share(channelId, request.mUrl);
                            }

                            @Override
                            public void onInviteFriendSuccess(long uid) {
                            }

                            @Override
                            public void onSendFamilyCallClick() {
                                ((FamilyCallPresenter)PlatFormInvitePresenter.this.getPresenter(FamilyCallPresenter.class)).showFamilyCallPanel(1);
                                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("60080028").put("function_id", "entry_click"));
                            }

                            @Override
                            public void onReportClick() {
                                if (PlatFormInvitePresenter.this.mCurrPanel != null) {
                                    PlatFormInvitePresenter.this.getCurrentWindow().getPanelLayer().hidePanel(PlatFormInvitePresenter.this.mCurrPanel, true);
                                }
                                if (MLog.isLogLevelBlowInfo()) {
                                    MLog.info((Object)PlatFormInvitePresenter.TAG, (String)"showInvitePanel onReportClick", (Object[])new Object[0]);
                                }
                                ChannelReportManager channelReportManager = new ChannelReportManager((IChannel)PlatFormInvitePresenter.this.getChannel());
                                channelReportManager.reportChannel((Context)((IChannelPageContext)PlatFormInvitePresenter.this.getMvpContext()).getContext(), ((IChannelPageContext)PlatFormInvitePresenter.this.getMvpContext()).getDialogLinkManager(), 10, PlatFormInvitePresenter.this.getChannelDetailInfo().baseInfo.ownerUid, PlatFormInvitePresenter.this.getChannelDetailInfo().baseInfo, "", 0L);
                            }

                            @Override
                            public void onCloseClick() {
                                if (PlatFormInvitePresenter.this.mCurrPanel != null) {
                                    if (MLog.isLogLevelBlowInfo()) {
                                        MLog.info((Object)PlatFormInvitePresenter.TAG, (String)"showInvitePanel onCloseClick", (Object[])new Object[0]);
                                    }
                                    PlatFormInvitePresenter.this.getCurrentWindow().getPanelLayer().hidePanel(PlatFormInvitePresenter.this.mCurrPanel, true);
                                }
                            }
                        };
                        panel.setListCallback(PlatFormInvitePresenter.this.mFriendListCallback);
                        PlatFormInvitePresenter.this.getCurrentWindow().getPanelLayer().showPanel((BasePanel)panel, true);
                        PlatFormInvitePresenter.this.mCurrPanel = panel;
                    }

                    public void onFailure(UploadObjectRequest request, int errorCode, Exception exception) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)PlatFormInvitePresenter.TAG, (String)"showInvitePanel onFailure, errorCode:%s, exception:%s", (Object[])new Object[]{errorCode, exception});
                        }
                    }
                });
            }
        });
    }

    private void share(final int channelId, String requesetUrl) {
        String baseUrl = this.getBaseShareUrl();
        final ImageShareTemplate imageShareTemplate = new ImageShareTemplate();
        if (this.shareData != null && this.shareData.getInviteData() != null && this.shareData.getInviteData().isFamily) {
            String url = StringUtils.format((String)baseUrl, (Object[])new Object[]{this.shareData.getInviteData().channelId});
            ShortUrlUtil.getShortUrl((String)url, (ShortUrlUtil.IGetShortUrl)new ShortUrlUtil.IGetShortUrl(){

                public void onSuccess(String input, String shortUrl) {
                    PlatFormInvitePresenter.this.mShareBundle.setUrl(input);
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)PlatFormInvitePresenter.TAG, (String)"share success", (Object[])new Object[0]);
                    }
                    IIntlShareService shareService = (IIntlShareService)ServiceManagerProxy.getServiceManager().getService(IIntlShareService.class);
                    shareService.share(channelId, (ShareBundle)PlatFormInvitePresenter.this.mShareBundle, (IShareTemplate)imageShareTemplate);
                }

                public void onError(String input, int code, String msg) {
                    PlatFormInvitePresenter.this.mShareBundle.setUrl(input);
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)PlatFormInvitePresenter.TAG, (String)"share onError, code:%s, msg:%s", (Object[])new Object[]{code, msg});
                    }
                    IIntlShareService shareService = (IIntlShareService)ServiceManagerProxy.getServiceManager().getService(IIntlShareService.class);
                    shareService.share(channelId, (ShareBundle)PlatFormInvitePresenter.this.mShareBundle, (IShareTemplate)imageShareTemplate);
                }
            });
        } else {
            UserInfoKS userInfoKS;
            long uid = AccountUtil.getUid();
            if (this.shareData.getInviteData().roomType != 3) {
                uid = this.shareData.getInviteData().ownerUid;
            }
            if ((userInfoKS = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(uid, null)) != null && this.shareData != null) {
                StringBuilder urlBuilder = new StringBuilder(baseUrl);
                urlBuilder.append(StringUtils.formatWitUSLocal((String)SHARE_URL_ARGS, (Object[])new Object[]{this.shareData.getInviteData().channelId, URLEncoder.encode(this.shareData.getInviteData().channelName), this.shareData.getInviteData().onlineCount, AccountUtil.getUid(), URLEncoder.encode(userInfoKS.nick), URLEncoder.encode(requesetUrl), this.shareData.getInviteData().targetShare, this.shareData.getInviteData().roomType, this.shareData.getInviteData().secondRoomType, this.shareData.getInviteData().ownerUid, userInfoKS.vid}));
                this.shareData.getInviteData().tokenProvider.getToken((DataCallback<String>)((DataCallback)token -> {
                    if (!FP.empty((CharSequence)token)) {
                        urlBuilder.append(StringUtils.formatWitUSLocal((String)SHARE_URL_ROOM_TOKEN_ARG, (Object[])new Object[]{token}));
                    }
                    ShortUrlUtil.getShortUrl((String)urlBuilder.toString(), (ShortUrlUtil.IGetShortUrl)new ShortUrlUtil.IGetShortUrl(){

                        public void onSuccess(String input, String shortUrl) {
                            PlatFormInvitePresenter.this.mShareBundle.setUrl(shortUrl);
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)PlatFormInvitePresenter.TAG, (String)"share success", (Object[])new Object[0]);
                            }
                            IIntlShareService shareService = (IIntlShareService)ServiceManagerProxy.getServiceManager().getService(IIntlShareService.class);
                            shareService.share(channelId, (ShareBundle)PlatFormInvitePresenter.this.mShareBundle, (IShareTemplate)imageShareTemplate);
                        }

                        public void onError(String input, int code, String msg) {
                            PlatFormInvitePresenter.this.mShareBundle.setUrl(input);
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)PlatFormInvitePresenter.TAG, (String)"share onError, code:%s, msg:%s", (Object[])new Object[]{code, msg});
                            }
                            IIntlShareService shareService = (IIntlShareService)ServiceManagerProxy.getServiceManager().getService(IIntlShareService.class);
                            shareService.share(channelId, (ShareBundle)PlatFormInvitePresenter.this.mShareBundle, (IShareTemplate)imageShareTemplate);
                        }
                    });
                }));
            } else {
                ShortUrlUtil.getShortUrl((String)baseUrl, (ShortUrlUtil.IGetShortUrl)new ShortUrlUtil.IGetShortUrl(){

                    public void onSuccess(String input, String shortUrl) {
                        PlatFormInvitePresenter.this.mShareBundle.setUrl(input);
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)PlatFormInvitePresenter.TAG, (String)"share success", (Object[])new Object[0]);
                        }
                        IIntlShareService shareService = (IIntlShareService)ServiceManagerProxy.getServiceManager().getService(IIntlShareService.class);
                        shareService.share(channelId, (ShareBundle)PlatFormInvitePresenter.this.mShareBundle, (IShareTemplate)imageShareTemplate);
                    }

                    public void onError(String input, int code, String msg) {
                        PlatFormInvitePresenter.this.mShareBundle.setUrl(input);
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)PlatFormInvitePresenter.TAG, (String)"share onError, code:%s, msg:%s", (Object[])new Object[]{code, msg});
                        }
                        IIntlShareService shareService = (IIntlShareService)ServiceManagerProxy.getServiceManager().getService(IIntlShareService.class);
                        shareService.share(channelId, (ShareBundle)PlatFormInvitePresenter.this.mShareBundle, (IShareTemplate)imageShareTemplate);
                    }
                });
            }
        }
    }

    private String getBaseShareUrl() {
        AConfigData configData;
        if (this.shareData != null && this.shareData.getInviteData() != null && this.shareData.getInviteData().isFamily && (configData = UnifyConfig.INSTANCE.getConfigData(BssCode.COMMON_CONFIG)) instanceof CommonConfig) {
            CommonConfigData data = ((CommonConfig)configData).getData();
            String familyUrl = data.familyDetailUrl;
            if (StringUtils.isNotEmpty((String)familyUrl)) {
                return URLUtils.addParam((String)familyUrl, (String)"useNativeDetail", (String)"true");
            }
        }
        EnvSettingType type = EnvSettings.instance().getUriSettingValue();
        StringBuilder urlBuilder = new StringBuilder();
        if (type == EnvSettingType.Product) {
            urlBuilder.append("https://www.ihago.net/a/channel-share/index.html");
        } else {
            urlBuilder.append("https://test.ihago.net/a/channel-share/index.html");
        }
        urlBuilder.append("?").append(UriProvider.appendCommonWebUrlParams());
        return urlBuilder.toString();
    }

    private DefaultWindow getCurrentWindow() {
        return (DefaultWindow)((IBaseEnvService)ServiceManagerProxy.getServiceManager().getService(IBaseEnvService.class)).getBaseAEnv().getWindowManager().getCurrentWindow();
    }

    protected boolean isOwnerOrMaster() {
        return this.getChannel().getRoleService().getRoleCache(AccountUtil.getUid()) == 15 || this.getChannel().getRoleService().getRoleCache(AccountUtil.getUid()) == 10;
    }

    private long getChannelOnlineCount() {
        return this.getChannelDetailInfo().dynamicInfo.onlines;
    }

    private String buildChannelCover(int roomType) {
        String cover = "";
        if (roomType == 2) {
            cover = this.getChannelDetailInfo().baseInfo.roomAvatar;
        } else if (roomType == 3) {
            cover = this.getChannelDetailInfo().baseInfo.avatar;
        }
        if (StringUtils.isEmpty((String)cover) || "https://o-static.ihago.net/ikxd/22e01f3a0ae739ace0d43f4216037839/groupframe.png".equals(cover)) {
            UserInfoBean userInfo;
            long uid = this.getChannel().getOwnerUid();
            if (this.getChannelDetailInfo().baseInfo.showUid != 0L) {
                uid = this.getChannelDetailInfo().baseInfo.showUid;
            }
            if ((userInfo = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(uid, null)) != null) {
                cover = userInfo.getAvatar();
            }
        }
        return cover;
    }
}

