/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.invite;

import android.content.Context;
import android.graphics.Color;
import android.view.View;
import android.widget.RelativeLayout;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.yy.appbase.ui.widget.tablayout.SlidingTabLayout;
import com.yy.appbase.ui.widget.viewpager.YYViewPager;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.component.base.ui.widget.DimBgPanel;
import com.yy.hiyo.channel.component.invite.InvitePageProvider;
import com.yy.hiyo.channel.component.invite.base.IPanelPage;
import com.yy.hiyo.channel.component.invite.friend.InvitePagerAdapter;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.mvp.base.PageMvpContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class InvitePanel
extends DimBgPanel {
    private Context mContext;
    private IMvpContext mMvpContext;
    private View mView;
    private SlidingTabLayout mTabs;
    private YYViewPager mViewPager;
    private InvitePageProvider mInvitePageProvider;
    private List<IPanelPage> mPanelPages = new ArrayList<IPanelPage>();

    public InvitePanel(@NotNull Context context, @NotNull InvitePageProvider pageProvider) {
        super(context);
        this.mContext = context;
        this.mMvpContext = PageMvpContext.Companion.of((View)this);
        this.mInvitePageProvider = pageProvider;
        this.createViews();
    }

    private void createViews() {
        this.mView = View.inflate((Context)this.mContext, (int)R.layout.dialog_invite_friend_channel, null);
        this.setContent(this.mView);
        RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.mView.getLayoutParams();
        lp.width = -1;
        lp.height = ResolutionUtils.dip2Px((float)495.0f);
        lp.addRule(12);
        this.mViewPager = (YYViewPager)this.mView.findViewById(R.id.invite_view_pager);
        this.mTabs = (SlidingTabLayout)this.mView.findViewById(R.id.invite_tabs);
        this.setShowAnim(this.createBottomShowAnimation());
        this.setHideAnim(this.createBottomHideAnimation());
    }

    @Override
    protected void onShow() {
        super.onShow();
        this.show();
        for (IPanelPage panelPage : this.mPanelPages) {
            panelPage.onShow();
        }
    }

    protected void onHidden() {
        super.onHidden();
        for (IPanelPage panelPage : this.mPanelPages) {
            panelPage.onHide();
        }
        this.mPanelPages.clear();
    }

    public void show() {
        this.mPanelPages.clear();
        List<PageData> pages = this.mInvitePageProvider.getPages(this.mMvpContext);
        if (pages != null || pages.size() > 1) {
            this.setTabSelectStyle();
        } else {
            this.setTabNoneStyle();
        }
        ArrayList<String> titleList = new ArrayList<String>();
        ArrayList<View> pageList = new ArrayList<View>();
        if (pages != null) {
            for (PageData pageData : pages) {
                titleList.add(pageData.title);
                pageList.add(pageData.page.getPage());
                this.mPanelPages.add(pageData.page);
            }
        }
        this.mTabs.setOnTabSelectListener(this.mInvitePageProvider.getTabSelectListener());
        InvitePagerAdapter pagerAdapter = new InvitePagerAdapter(pageList, titleList);
        this.mViewPager.setAdapter((PagerAdapter)pagerAdapter);
        this.mTabs.setViewPager((ViewPager)this.mViewPager);
        this.mTabs.setCurrentTab(0);
    }

    private void setTabSelectStyle() {
        this.mTabs.setTextSelectColor(ResourceUtils.getColor((int)R.color.color_ffc102));
        this.mTabs.setUnderlineHeight(0.5f);
        this.mTabs.setIndicatorHeight((float)ResolutionUtils.dip2Px((float)3.0f));
    }

    private void setTabNoneStyle() {
        this.mTabs.setTextSelectColor(Color.parseColor((String)"#999999"));
        this.mTabs.setUnderlineHeight(0.0f);
        this.mTabs.setIndicatorHeight(0.0f);
    }

    public static class PageData {
        public String title;
        public IPanelPage page;

        public PageData(String title, IPanelPage page) {
            this.title = title;
            this.page = page;
        }
    }
}

