/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.common;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.extension.EasyExtensionKt;
import com.yy.appbase.extensions.ViewExtensionsKt;
import com.yy.hiyo.mvp.base.callback.IDestroyable;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u0000 \"*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003:\u0001\"B\u001f\b\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0002\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0010\u001a\u00020\u0004H\u0002J\u0017\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0012H\u0002J7\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0016\u0010\u001b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001d0\u001c\"\u0004\u0018\u00010\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eJ-\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00028\u00002\u0016\u0010\u001b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001d0\u001c\"\u0004\u0018\u00010\u001dH\u0016\u00a2\u0006\u0002\u0010!R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00060\u00060\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/yy/hiyo/channel/component/common/WeakCommonCallback;", "T", "Lcom/yy/appbase/callback/ICommonCallback;", "Landroidx/lifecycle/Observer;", "", "destroyable", "Lcom/yy/hiyo/mvp/base/callback/IDestroyable;", "callback", "(Lcom/yy/hiyo/mvp/base/callback/IDestroyable;Lcom/yy/appbase/callback/ICommonCallback;)V", "getDestroyable", "()Lcom/yy/hiyo/mvp/base/callback/IDestroyable;", "setDestroyable", "(Lcom/yy/hiyo/mvp/base/callback/IDestroyable;)V", "ref", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "isDestroyed", "onChanged", "", "t", "(Ljava/lang/Boolean;)V", "onDestroy", "onFail", "errCode", "", "msg", "", "ext", "", "", "(ILjava/lang/String;[Ljava/lang/Object;)V", "onSuccess", "data", "(Ljava/lang/Object;[Ljava/lang/Object;)V", "Companion", "channel-components_release"})
public final class WeakCommonCallback<T>
implements ICommonCallback<T>,
Observer<Boolean> {
    private WeakReference<IDestroyable> ref;
    @NotNull
    private IDestroyable destroyable;
    private ICommonCallback<T> callback;
    public static final Companion Companion = new Companion(null);

    public void onSuccess(T data, Object ... ext) {
        Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
        if (!this.isDestroyed()) {
            ICommonCallback<T> iCommonCallback = this.callback;
            if (iCommonCallback != null) {
                iCommonCallback.onSuccess(data, new Object[]{ext});
            }
        }
        this.onDestroy();
    }

    public void onFail(int errCode, @Nullable String msg, Object ... ext) {
        Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
        if (!this.isDestroyed()) {
            ICommonCallback<T> iCommonCallback = this.callback;
            if (iCommonCallback != null) {
                iCommonCallback.onFail(errCode, msg, new Object[]{ext});
            }
        }
        this.onDestroy();
    }

    private final void onDestroy() {
        IDestroyable iDestroyable = (IDestroyable)this.ref.get();
        if (iDestroyable != null && (iDestroyable = iDestroyable.isDestroyData()) != null) {
            iDestroyable.removeObserver((Observer)this);
        }
        this.callback = null;
        this.ref.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDestroyed() {
        IDestroyable refObject = (IDestroyable)this.ref.get();
        if (refObject == null) return true;
        LiveData liveData = refObject.isDestroyData();
        if (!Intrinsics.areEqual((Object)(liveData != null ? (Boolean)liveData.getValue() : null), (Object)true)) return false;
        return true;
    }

    public void onChanged(@Nullable Boolean t) {
        if (EasyExtensionKt.isTrue((Boolean)t)) {
            this.onDestroy();
        }
    }

    @NotNull
    public final IDestroyable getDestroyable() {
        return this.destroyable;
    }

    public final void setDestroyable(@NotNull IDestroyable iDestroyable) {
        Intrinsics.checkParameterIsNotNull((Object)iDestroyable, (String)"<set-?>");
        this.destroyable = iDestroyable;
    }

    private WeakCommonCallback(IDestroyable destroyable, ICommonCallback<T> callback2) {
        this.destroyable = destroyable;
        this.callback = callback2;
        this.ref = new WeakReference<IDestroyable>(this.destroyable);
        ViewExtensionsKt.onUi((Object)this, (Function0)((Function0)new Function0<Unit>(){

            public final void invoke() {
                LiveData liveData = this.getDestroyable().isDestroyData();
                Intrinsics.checkExpressionValueIsNotNull((Object)liveData, (String)"destroyable.isDestroyData");
                if (!EasyExtensionKt.isTrue((Boolean)((Boolean)liveData.getValue()))) {
                    this.getDestroyable().isDestroyData().observeForever((Observer)this);
                }
            }
        }));
    }

    public /* synthetic */ WeakCommonCallback(IDestroyable destroyable, ICommonCallback callback2, DefaultConstructorMarker $constructor_marker) {
        this(destroyable, callback2);
    }

    @JvmStatic
    @NotNull
    public static final <T> WeakCommonCallback<T> of(@NotNull IDestroyable destroyable, @Nullable ICommonCallback<T> callback2) {
        return Companion.of(destroyable, callback2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u0002H\u0005\u0018\u00010\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/yy/hiyo/channel/component/common/WeakCommonCallback$Companion;", "", "()V", "of", "Lcom/yy/hiyo/channel/component/common/WeakCommonCallback;", "T", "destroyable", "Lcom/yy/hiyo/mvp/base/callback/IDestroyable;", "callback", "Lcom/yy/appbase/callback/ICommonCallback;", "channel-components_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final <T> WeakCommonCallback<T> of(@NotNull IDestroyable destroyable, @Nullable ICommonCallback<T> callback2) {
            Intrinsics.checkParameterIsNotNull((Object)destroyable, (String)"destroyable");
            return new WeakCommonCallback(destroyable, callback2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

