/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.channelswipe;

import com.yy.appbase.extensions.CommonExtensionsKt;
import com.yy.appbase.recommend.bean.Channel;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.channel.component.channelswipe.ISwipeData;
import com.yy.hiyo.channel.component.channelswipe.LiveSwipeData;
import com.yy.hiyo.channel.component.channelswipe.OnSwipeDataChangeListener;
import com.yy.hiyo.channel.component.channelswipe.SwipeDataManager;
import com.yy.hiyo.channel.module.recommend.base.bean.Group;
import com.yy.hiyo.channel.module.recommend.base.bean.Nation;
import com.yy.hiyo.channel.module.recommend.base.bean.RadioLiveChannel;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.room.api.rrec.RoomTabItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00112\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\"J\u001c\u0010#\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00112\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\"J\u0014\u0010$\u001a\u00020\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\"J\u0014\u0010%\u001a\u00020\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\"J\u000e\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(J\u0010\u0010)\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0011H\u0002J\u000e\u0010*\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0011J\u0006\u0010+\u001a\u00020\u001fJ \u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020\u00062\f\u0010/\u001a\b\u0012\u0004\u0012\u00020-0\rH\u0002J\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\u0006\u00101\u001a\u00020\u0004J\u001c\u00102\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0002J\u0006\u00103\u001a\u00020\u0004J\u0010\u00104\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u0004H\u0002J\u0010\u00105\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u0004H\u0002J\u000e\u00106\u001a\u00020(2\u0006\u00107\u001a\u00020\u0011J \u00108\u001a\u00020(2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00060\"2\b\u0010:\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010;\u001a\u00020(2\b\u0010<\u001a\u0004\u0018\u00010=J\u0012\u0010>\u001a\u00020\u001f2\b\u0010:\u001a\u0004\u0018\u00010\u0006H\u0002J\u0018\u0010?\u001a\u00020\u001f2\b\u0010:\u001a\u0004\u0018\u00010\u00062\u0006\u0010@\u001a\u00020\u0004J\u000e\u0010A\u001a\u00020\u001f2\u0006\u0010B\u001a\u00020\u0016J\u000e\u0010C\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dJ\u001c\u0010D\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u00042\f\u0010E\u001a\b\u0012\u0004\u0012\u00020-0\rJ$\u0010D\u001a\u00020\u001f2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\b0\r2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020-0\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\nR\u0013\u0010\u001a\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\nR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/yy/hiyo/channel/component/channelswipe/SwipeDataManager;", "", "()V", "CHECK_MAX_NUM", "", "TAG", "", "currentChannel", "Lcom/yy/appbase/recommend/bean/Channel;", "getCurrentChannel", "()Lcom/yy/appbase/recommend/bean/Channel;", "currentIndex", "mCacheRequestIds", "", "mChannelDataList", "mCurrentDataList", "mCurrentTabId", "", "mJoinChannelFrom", "mLastCheckChannelLiveStatusTime", "mListenerRef", "Ljava/lang/ref/WeakReference;", "Lcom/yy/hiyo/channel/component/channelswipe/OnSwipeDataChangeListener;", "mSubjectChannelDataList", "nextChannel", "getNextChannel", "preChannel", "getPreChannel", "swipeData", "Lcom/yy/hiyo/channel/component/channelswipe/ISwipeData;", "addChannelData", "", "tabId", "list", "", "addChannelDataByLoadMore", "addSubjectChannelData", "addSubjectChannelDataByLoadMore", "changeChannelPage", "next", "", "cleanTabData", "clearChannelData", "clearSubjectChannelData", "getChannelById", "Lnet/ihago/room/api/rrec/RoomTabItem;", "id", "channels", "getChannelIds", "from", "getChannelIdsLimitSize", "getJoinChannelFrom", "getNextIndex", "getPreIndex", "isNeedCheckChannelLiveStatus", "curTime", "isRequestChannelId", "ids", "channelId", "isSupportSubjectCollection", "group", "Lcom/yy/hiyo/channel/module/recommend/base/bean/Group;", "processChannelIndex", "processEnterChannelData", "joinChannelFrom", "setOnSwipeDataChangeListener", "listener", "setSwipeData", "updateChannelInfo", "curChannels", "lastChannels", "channel-components_release"})
public final class SwipeDataManager {
    @NotNull
    public static final String TAG = "SwipeDataManager";
    private static final int CHECK_MAX_NUM = 100;
    private static final List<Channel> mChannelDataList;
    private static long mCurrentTabId;
    private static final List<Channel> mSubjectChannelDataList;
    private static final List<Channel> mCurrentDataList;
    private static List<String> mCacheRequestIds;
    private static WeakReference<OnSwipeDataChangeListener> mListenerRef;
    private static int mJoinChannelFrom;
    private static int currentIndex;
    private static long mLastCheckChannelLiveStatusTime;
    private static ISwipeData swipeData;
    public static final SwipeDataManager INSTANCE;

    @Nullable
    public final Channel getCurrentChannel() {
        if (currentIndex >= 0 && currentIndex < mCurrentDataList.size()) {
            return mCurrentDataList.get(currentIndex);
        }
        return null;
    }

    @Nullable
    public final Channel getPreChannel() {
        int index = this.getPreIndex(currentIndex);
        MLog.debug((Object)TAG, (String)("preChannel index:" + index), (Object[])new Object[0]);
        if (index >= 0 && index < mCurrentDataList.size()) {
            return mCurrentDataList.get(index);
        }
        return null;
    }

    private final int getPreIndex(int from) {
        MLog.debug((Object)TAG, (String)("getPreIndex from:" + from + ", size:" + mCurrentDataList.size()), (Object[])new Object[0]);
        if (mCurrentDataList.size() <= 1) {
            return -1;
        }
        int index = from - 1;
        if (index < 0) {
            index = mCurrentDataList.size() - 1;
        }
        if (index == currentIndex) {
            return -1;
        }
        return index >= 0 && index < mCurrentDataList.size() && swipeData.supportSwipeType(mCurrentDataList.get(index)) ? index : this.getPreIndex(index);
    }

    @Nullable
    public final Channel getNextChannel() {
        int index = this.getNextIndex(currentIndex);
        MLog.debug((Object)TAG, (String)("nextChannel index:" + index), (Object[])new Object[0]);
        if (index >= 0 && index < mCurrentDataList.size()) {
            return mCurrentDataList.get(index);
        }
        return null;
    }

    private final int getNextIndex(int from) {
        MLog.debug((Object)TAG, (String)("getNextIndex from:" + from + ", size:" + mCurrentDataList.size()), (Object[])new Object[0]);
        if (mCurrentDataList.size() <= 1) {
            return -1;
        }
        int index = from + 1;
        if (index > mCurrentDataList.size() - 1) {
            index = 0;
        }
        if (index == currentIndex) {
            return -1;
        }
        return index >= 0 && index < mCurrentDataList.size() && swipeData.supportSwipeType(mCurrentDataList.get(index)) ? index : this.getNextIndex(index);
    }

    public final void changeChannelPage(boolean next) {
        int preIndex;
        int nextIndex;
        if (mCurrentDataList.isEmpty()) {
            return;
        }
        int n = next ? ((nextIndex = this.getNextIndex(currentIndex)) >= 0 && nextIndex < mCurrentDataList.size() ? nextIndex : 0) : (currentIndex = (preIndex = this.getPreIndex(currentIndex)) >= 0 && preIndex < mCurrentDataList.size() ? preIndex : 0);
        if (mCurrentDataList.size() - currentIndex < 10) {
            long delay = 500L;
            if (currentIndex != mCurrentDataList.size() - 1) {
                delay = 2500L;
            }
            YYTaskExecutor.postToMainThread((Runnable)changeChannelPage.1.INSTANCE, (long)delay);
        }
    }

    public final void processEnterChannelData(@Nullable String channelId, int joinChannelFrom) {
        if (joinChannelFrom != 24) {
            mJoinChannelFrom = joinChannelFrom;
        }
        mCurrentDataList.clear();
        if (mJoinChannelFrom == 19) {
            Collection collection = mSubjectChannelDataList;
            boolean bl = false;
            if (!collection.isEmpty()) {
                mCurrentDataList.addAll((Collection<Channel>)mSubjectChannelDataList);
            }
        } else {
            Collection collection = mChannelDataList;
            boolean bl = false;
            if (!collection.isEmpty()) {
                mCurrentDataList.addAll((Collection<Channel>)mChannelDataList);
            }
        }
        this.processChannelIndex(channelId);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("Enter " + currentIndex + ", " + channelId), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processChannelIndex(String channelId) {
        if (CommonExtensionsKt.isNotNullOrEmpty((String)channelId)) {
            int findIndex = -1;
            int n = 0;
            int n2 = ((Collection)mCurrentDataList).size();
            while (n < n2) {
                void i;
                if (Intrinsics.areEqual((Object)mCurrentDataList.get((int)i).getId(), (Object)channelId)) {
                    findIndex = i;
                    break;
                }
                ++i;
            }
            currentIndex = findIndex > -1 ? findIndex : 0;
        }
    }

    public final void addChannelData(long tabId, @NotNull List<? extends Channel> list2) {
        Intrinsics.checkParameterIsNotNull(list2, (String)"list");
        if (!swipeData.supportSwipeTab(tabId)) {
            return;
        }
        mCurrentTabId = tabId;
        Collection collection = list2;
        boolean $i$f$isNullOrEmpty = false;
        if (collection.isEmpty()) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"addChannelData isEmpty", (Object[])new Object[0]);
            }
            return;
        }
        for (Channel channel : list2) {
            if (!swipeData.supportAddData(channel)) continue;
            mChannelDataList.add(channel);
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("addChannelData after " + mChannelDataList.size()), (Object[])new Object[0]);
        }
        mLastCheckChannelLiveStatusTime = System.currentTimeMillis();
    }

    public final void addChannelDataByLoadMore(long tabId, @NotNull List<? extends Channel> list2) {
        block4: {
            Intrinsics.checkParameterIsNotNull(list2, (String)"list");
            this.addChannelData(tabId, list2);
            if (mJoinChannelFrom == 19) break block4;
            String curChannelId = null;
            if (currentIndex >= 0 && currentIndex < mCurrentDataList.size()) {
                curChannelId = mCurrentDataList.get(currentIndex).getId();
            }
            mCurrentDataList.clear();
            mCurrentDataList.addAll((Collection<Channel>)mChannelDataList);
            String string2 = curChannelId;
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                INSTANCE.processChannelIndex(it);
                WeakReference<OnSwipeDataChangeListener> weakReference = mListenerRef;
                if (weakReference != null) {
                    WeakReference<OnSwipeDataChangeListener> weakReference2 = weakReference;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    WeakReference<OnSwipeDataChangeListener> ref = weakReference2;
                    boolean bl6 = false;
                    OnSwipeDataChangeListener onSwipeDataChangeListener = (OnSwipeDataChangeListener)ref.get();
                    if (onSwipeDataChangeListener != null) {
                        onSwipeDataChangeListener.onChange();
                    }
                }
            }
        }
    }

    public final void clearChannelData(long tabId) {
        if (!swipeData.supportSwipeTab(tabId)) {
            return;
        }
        this.cleanTabData(tabId);
    }

    private final void cleanTabData(long tabId) {
        boolean bl = false;
        List tabDataList = new ArrayList();
        Iterable $this$forEach$iv = mChannelDataList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Channel it = (Channel)element$iv;
            boolean bl2 = false;
            if (!swipeData.shouldClean(tabId, it)) continue;
            tabDataList.add(it);
        }
        mChannelDataList.removeAll(tabDataList);
    }

    public final void addSubjectChannelData(@NotNull List<? extends Channel> list2) {
        Intrinsics.checkParameterIsNotNull(list2, (String)"list");
        Collection collection = list2;
        boolean $i$f$isNullOrEmpty = false;
        if (collection.isEmpty()) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"addSubjectChannelData isEmpty", (Object[])new Object[0]);
            }
            return;
        }
        for (Channel channel : list2) {
            if (!(channel instanceof RadioLiveChannel)) continue;
            mSubjectChannelDataList.add(channel);
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("addSubjectChannelData after " + mSubjectChannelDataList.size()), (Object[])new Object[0]);
        }
        mLastCheckChannelLiveStatusTime = System.currentTimeMillis();
    }

    public final void addSubjectChannelDataByLoadMore(@NotNull List<? extends Channel> list2) {
        block4: {
            Intrinsics.checkParameterIsNotNull(list2, (String)"list");
            this.addSubjectChannelData(list2);
            if (mJoinChannelFrom != 19) break block4;
            String curChannelId = null;
            if (currentIndex >= 0 && currentIndex < mCurrentDataList.size()) {
                curChannelId = mCurrentDataList.get(currentIndex).getId();
            }
            mCurrentDataList.clear();
            mCurrentDataList.addAll((Collection<Channel>)mSubjectChannelDataList);
            String string2 = curChannelId;
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                INSTANCE.processChannelIndex(it);
                WeakReference<OnSwipeDataChangeListener> weakReference = mListenerRef;
                if (weakReference != null) {
                    WeakReference<OnSwipeDataChangeListener> weakReference2 = weakReference;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    WeakReference<OnSwipeDataChangeListener> ref = weakReference2;
                    boolean bl6 = false;
                    OnSwipeDataChangeListener onSwipeDataChangeListener = (OnSwipeDataChangeListener)ref.get();
                    if (onSwipeDataChangeListener != null) {
                        onSwipeDataChangeListener.onChange();
                    }
                }
            }
        }
    }

    public final void clearSubjectChannelData() {
        mSubjectChannelDataList.clear();
    }

    public final int getJoinChannelFrom() {
        return mJoinChannelFrom;
    }

    @NotNull
    public final List<String> getChannelIds(int from) {
        mCacheRequestIds.clear();
        List<String> ids = from == 19 ? this.getChannelIdsLimitSize(mSubjectChannelDataList) : this.getChannelIdsLimitSize(mChannelDataList);
        mCacheRequestIds.addAll((Collection<String>)ids);
        return ids;
    }

    private final List<String> getChannelIdsLimitSize(List<Channel> channels) {
        boolean bl = false;
        List ids = new ArrayList();
        if (channels.size() <= 100) {
            for (Channel channel : channels) {
                ids.add(channel.getId());
            }
        } else {
            int middleNum = 50;
            if (currentIndex < middleNum) {
                for (Channel channel : channels.subList(0, 100)) {
                    ids.add(channel.getId());
                }
            } else if (currentIndex + middleNum < channels.size()) {
                int preFrom = currentIndex - middleNum;
                int nextTo = currentIndex + middleNum;
                for (Channel channel : channels.subList(preFrom, nextTo)) {
                    ids.add(channel.getId());
                }
            } else {
                for (Channel channel : channels.subList(channels.size() - 100, channels.size())) {
                    ids.add(channel.getId());
                }
            }
        }
        return ids;
    }

    public final void updateChannelInfo(int from, @NotNull List<RoomTabItem> curChannels) {
        Intrinsics.checkParameterIsNotNull(curChannels, (String)"curChannels");
        if (from == 19) {
            this.updateChannelInfo(mSubjectChannelDataList, curChannels);
        } else {
            this.updateChannelInfo(mChannelDataList, curChannels);
        }
        WeakReference<OnSwipeDataChangeListener> weakReference = mListenerRef;
        if (weakReference != null) {
            WeakReference<OnSwipeDataChangeListener> weakReference2 = weakReference;
            boolean bl = false;
            boolean bl2 = false;
            WeakReference<OnSwipeDataChangeListener> ref = weakReference2;
            boolean bl3 = false;
            OnSwipeDataChangeListener onSwipeDataChangeListener = (OnSwipeDataChangeListener)ref.get();
            if (onSwipeDataChangeListener != null) {
                onSwipeDataChangeListener.onChange();
            }
        }
        mLastCheckChannelLiveStatusTime = System.currentTimeMillis();
    }

    private final void updateChannelInfo(List<Channel> lastChannels, List<RoomTabItem> curChannels) {
        for (Channel channel : lastChannels) {
            if (!this.isRequestChannelId(mCacheRequestIds, channel.getId())) continue;
            RoomTabItem remoteInfo = this.getChannelById(channel.getId(), curChannels);
            if (remoteInfo != null) {
                Integer n = remoteInfo.plugin_type;
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"remoteInfo.plugin_type");
                channel.setPluginType(n.intValue());
                Boolean bl = remoteInfo.video;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"remoteInfo.video");
                channel.setVideo(bl.booleanValue());
                continue;
            }
            channel.setVideo(false);
        }
    }

    private final boolean isRequestChannelId(List<String> ids, String channelId) {
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it, (Object)channelId)) continue;
            return true;
        }
        return false;
    }

    private final RoomTabItem getChannelById(String id2, List<RoomTabItem> channels) {
        for (RoomTabItem channel : channels) {
            if (!swipeData.supportRoomTabItem(channel) || !Intrinsics.areEqual((Object)channel.id, (Object)id2)) continue;
            return channel;
        }
        return null;
    }

    public final void setOnSwipeDataChangeListener(@NotNull OnSwipeDataChangeListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        mListenerRef = new WeakReference<OnSwipeDataChangeListener>(listener);
    }

    public final boolean isSupportSubjectCollection(@Nullable Group group) {
        if (group == null) {
            return false;
        }
        return CollectionsKt.firstOrNull((List)group.getChannels()) instanceof RadioLiveChannel || group instanceof Nation;
    }

    public final boolean isNeedCheckChannelLiveStatus(long curTime) {
        return curTime > 0L && mLastCheckChannelLiveStatusTime > 0L && curTime - mLastCheckChannelLiveStatusTime > (long)60000;
    }

    public final void setSwipeData(@NotNull ISwipeData swipeData) {
        Intrinsics.checkParameterIsNotNull((Object)swipeData, (String)"swipeData");
        SwipeDataManager.swipeData = swipeData;
    }

    private SwipeDataManager() {
    }

    static {
        SwipeDataManager swipeDataManager;
        INSTANCE = swipeDataManager = new SwipeDataManager();
        boolean bl = false;
        mChannelDataList = new ArrayList();
        mCurrentTabId = -1L;
        bl = false;
        mSubjectChannelDataList = new ArrayList();
        bl = false;
        mCurrentDataList = new ArrayList();
        bl = false;
        mCacheRequestIds = new ArrayList();
        swipeData = new LiveSwipeData();
    }

    public static final /* synthetic */ int access$getCurrentIndex$p(SwipeDataManager $this) {
        SwipeDataManager swipeDataManager = $this;
        return currentIndex;
    }

    public static final /* synthetic */ void access$setCurrentIndex$p(SwipeDataManager $this, int n) {
        SwipeDataManager swipeDataManager = $this;
        currentIndex = n;
    }

    public static final /* synthetic */ List access$getMCurrentDataList$p(SwipeDataManager $this) {
        SwipeDataManager swipeDataManager = $this;
        return mCurrentDataList;
    }

    public static final /* synthetic */ int access$getMJoinChannelFrom$p(SwipeDataManager $this) {
        SwipeDataManager swipeDataManager = $this;
        return mJoinChannelFrom;
    }

    public static final /* synthetic */ void access$setMJoinChannelFrom$p(SwipeDataManager $this, int n) {
        SwipeDataManager swipeDataManager = $this;
        mJoinChannelFrom = n;
    }

    public static final /* synthetic */ long access$getMCurrentTabId$p(SwipeDataManager $this) {
        SwipeDataManager swipeDataManager = $this;
        return mCurrentTabId;
    }

    public static final /* synthetic */ void access$setMCurrentTabId$p(SwipeDataManager $this, long l) {
        SwipeDataManager swipeDataManager = $this;
        mCurrentTabId = l;
    }
}

