/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.bottombar.v2.add.privilege;

import android.content.Context;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.appbase.service.IHomePlanService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.bean.ChannelTagItem;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.channelhiido.ChannelTrack;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.component.bottombar.BottomPresenter;
import com.yy.hiyo.channel.component.bottombar.v2.add.privilege.PrivilegeMvp;
import com.yy.hiyo.channel.component.play.RoomGameAndActivityListPresenter;
import com.yy.hiyo.channel.component.play.activity.OnRoomActivityItemClick;
import com.yy.hiyo.channel.component.play.activity.RoomActivityListMvp;
import com.yy.hiyo.wallet.base.IActivityService;
import com.yy.hiyo.wallet.base.action.ActionManager;
import com.yy.hiyo.wallet.base.action.ActivityAction;
import com.yy.hiyo.wallet.base.action.ActivityActionList;
import com.yy.hiyo.wallet.base.action.ActivityTagInfo;
import com.yy.hiyo.wallet.base.action.PrivilegeAction;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.ihago.money.api.appconfigcenter.PluginSubType;
import org.jetbrains.annotations.NotNull;

public class PrivilegePresenter
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>>
implements PrivilegeMvp.IPresenter,
OnRoomActivityItemClick {
    private static final String TAG = "PrivilegePresenter";
    private static final String TURN_PANEL_LINK_URL = "dazhuanpan";
    private static final int ROOM_PRIVILEGE_CENTER_LOCATION = 7;
    private List<ActivityAction> mPrivilegeActionList;
    private final PrivilegeActivityCallback myPrivilegeCallback = new PrivilegeActivityCallback(this);
    private PrivilegeMvp.IView iView;
    private RoomActivityListMvp.IPresenter.OnActivityListHideListener mOnActivityListHideListener;

    public void onInit(@Nonnull IChannelPageContext mvpContext) {
        super.onInit(mvpContext);
        this.requestPrivilegeCenters();
    }

    public void onMyRoleChanged(String channelId, int newRoleType) {
        this.requestPrivilegeCenters();
    }

    private void requestPrivilegeCenters() {
        ActivityTagInfo tag = this.getRoomTag();
        ((IActivityService)((IChannelPageContext)this.getMvpContext()).getServiceManager().getService(IActivityService.class)).fetchActivityBannerInfo(this.getChannel().getChannelId(), tag, 7, (Callback)this.myPrivilegeCallback, true);
    }

    @NotNull
    private ActivityTagInfo getRoomTag() {
        ChannelTagItem tag = this.getChannelDetailInfo().baseInfo.tag.getFirstTag();
        ActivityTagInfo info = new ActivityTagInfo("" + tag.getTagId(), tag.getName(), this.getChannel().getSeatService().getSeatIndex(AccountUtil.getUid()));
        info.setPluginType(this.getChannel().getPluginService().getCurPluginData().getMode());
        info.setPluginSubType(this.getChannel().getPluginService().getCurPluginData().isVideoMode() ? PluginSubType.PluginSubTypeVideo.getValue() : PluginSubType.PluginSubTypeAudio.getValue());
        info.setChannelRole(this.getChannel().getRoleService().getMyRoleCache());
        return info;
    }

    @Override
    public void setView(@NotNull PrivilegeMvp.IView iView) {
        this.iView = iView;
        this.iView.setOnItemClick(this);
    }

    public void setHideListener(RoomActivityListMvp.IPresenter.OnActivityListHideListener listener) {
        this.mOnActivityListHideListener = listener;
    }

    private static void filterMinorDisabled(List<ActivityAction> actionList) {
        IHomePlanService homePlanService;
        if (!FP.empty(actionList) && (homePlanService = (IHomePlanService)ServiceManagerProxy.getServiceManager().getService(IHomePlanService.class)).isMyselfMinorProtect()) {
            Iterator<ActivityAction> it = actionList.iterator();
            while (it.hasNext()) {
                ActivityAction action = it.next();
                if (!homePlanService.isHideActivity(String.valueOf(action.id))) continue;
                it.remove();
            }
        }
    }

    private void reportHiido(List<ActivityAction> actionList, String actId, String functionId) {
        if (StringUtils.isNotEmpty((String)this.getChannel().getChannelId()) && !FP.empty(actionList)) {
            StringBuilder builder = new StringBuilder();
            for (ActivityAction action : actionList) {
                if (action == null) continue;
                ChannelTrack.INSTANCE.reportRevenueActPanelShow("" + action.id, functionId, actId, action.linkUrl);
            }
        }
    }

    @Override
    public void onClick(@Nullable ActivityAction action) {
        if (action == null || action.linkType == null) {
            return;
        }
        if (!NetworkUtils.isNetworkAvailable((Context)((IChannelPageContext)this.getMvpContext()).getContext())) {
            ToastUtils.showToast((Context)((IChannelPageContext)this.getMvpContext()).getContext(), (int)R.string.check_network_and_retry);
            return;
        }
        this.hidePanel();
        String id2 = "privilege_id";
        String functionId = "privilege_pannel_click";
        ChannelTrack.INSTANCE.reportRevenueActPanelClick(String.valueOf(action.id), id2, functionId, action.linkUrl);
        action.hasRead = true;
        ActionManager.obtain().onAction(action);
        ((RoomGameAndActivityListPresenter)this.getPresenter(RoomGameAndActivityListPresenter.class)).checkRoomActivityReadStatus();
        ((BottomPresenter)this.getPresenter(BottomPresenter.class)).checkPluginShow();
    }

    public void hidePanel() {
        if (this.mOnActivityListHideListener != null) {
            this.mOnActivityListHideListener.onHide();
        }
        this.mOnActivityListHideListener = null;
    }

    private static class PrivilegeActivityCallback
    implements Callback<ActivityActionList> {
        private final WeakReference<PrivilegePresenter> ref;

        PrivilegeActivityCallback(PrivilegePresenter presenter) {
            this.ref = new WeakReference<PrivilegePresenter>(presenter);
        }

        public void onResponse(ActivityActionList data) {
            PrivilegePresenter presenter = (PrivilegePresenter)this.ref.get();
            if (presenter == null) {
                return;
            }
            if (presenter.isDestroyed()) {
                return;
            }
            if (data == null || FP.empty((Collection)data.list)) {
                return;
            }
            ArrayList<PrivilegeAction> list2 = new ArrayList<PrivilegeAction>();
            for (ActivityAction action : data.list) {
                list2.add(new PrivilegeAction(action));
            }
            presenter.mPrivilegeActionList = list2;
            PrivilegePresenter.filterMinorDisabled(presenter.mPrivilegeActionList);
            if (presenter.iView != null) {
                presenter.iView.setActivityList(presenter.mPrivilegeActionList);
                presenter.reportHiido(presenter.mPrivilegeActionList, "privilege_id", "privilege_pannel_show");
            }
        }
    }
}

