/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.bottombar.quickanswer.ui;

import android.view.View;
import com.yy.hiyo.channel.component.bottombar.quickanswer.ui.FlowLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class LabelAdapter<T> {
    private List<T> mLabelDatas;
    private OnDataChangedListener mOnDataChangedListener;
    private List<T> mSelectedList = new ArrayList<T>();
    private int leftCount;

    public LabelAdapter(List<T> datas) {
        this.mLabelDatas = datas;
    }

    public LabelAdapter(T[] datas) {
        this.mLabelDatas = new ArrayList<T>(Arrays.asList(datas));
    }

    void setOnDataChangedListener(OnDataChangedListener listener) {
        this.mOnDataChangedListener = listener;
    }

    public int getCount() {
        return this.mLabelDatas == null ? 0 : this.mLabelDatas.size();
    }

    public void notifyDataChanged() {
        this.mOnDataChangedListener.onChanged();
    }

    public T getItem(int position) {
        return this.mLabelDatas.get(position);
    }

    public abstract View getView(FlowLayout var1, int var2, T var3);

    public void onSelected(int position, View view) {
        T t = this.mLabelDatas.get(position);
        if (!this.mSelectedList.contains(t)) {
            this.mSelectedList.add(t);
        }
    }

    public void unSelected(int position, View view) {
        T t = this.mLabelDatas.get(position);
        this.mSelectedList.remove(t);
    }

    public void onSelected(T t) {
        if (!this.mSelectedList.contains(t)) {
            this.mSelectedList.add(t);
        }
    }

    public void unSelected(T t) {
        this.mSelectedList.remove(t);
    }

    public boolean setSelected(int position, T t) {
        return false;
    }

    public void setSelectedList(List<T> list2) {
        if (list2 == null || list2.size() == 0) {
            return;
        }
        this.mSelectedList.clear();
        this.mSelectedList.addAll(list2);
        this.notifyDataChanged();
    }

    public List<T> getSelectedList() {
        return this.mSelectedList;
    }

    public void setLeftCount(int leftCount) {
        this.leftCount = leftCount;
    }

    public int getLeftCount() {
        return this.leftCount;
    }

    static interface OnDataChangedListener {
        public void onChanged();
    }
}

